/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.ENotifySubject;
import net.sf.eBus.client.ERequestSubject;
import net.sf.eBus.client.sysmessages.AdMessage;
import net.sf.eBus.messages.EMessageHeader;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.util.TernarySearchTree;
import net.sf.eBus.util.logging.StatusReporter;
import net.sf.eBus.util.regex.Pattern;

abstract class ESubject
implements Comparable<ESubject> {
    protected final EMessageKey mKey;
    protected static final TernarySearchTree<ESubject> sSubjects = new TernarySearchTree();

    protected ESubject(EMessageKey key) {
        this.mKey = key;
    }

    abstract EMessageHeader localAd(AdMessage.AdStatus var1);

    @Override
    public int compareTo(ESubject subject) {
        return this.mKey.compareTo(subject.mKey);
    }

    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof ESubject) {
            retcode = this.mKey.equals(((ESubject)o).mKey);
        }
        return retcode;
    }

    public int hashCode() {
        return this.mKey.hashCode();
    }

    public String toString() {
        return this.mKey.toString();
    }

    public final EMessageKey key() {
        return this.mKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<EMessageKey> findKeys() {
        Collection subjects;
        LinkedList<EMessageKey> retval = new LinkedList<EMessageKey>();
        TernarySearchTree<ESubject> ternarySearchTree = sSubjects;
        synchronized (ternarySearchTree) {
            subjects = sSubjects.values();
        }
        subjects.forEach(subject -> retval.add(subject.key()));
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<EMessageKey> findKeys(Pattern query) {
        Collection subjects;
        LinkedList<EMessageKey> retval = new LinkedList<EMessageKey>();
        TernarySearchTree<ESubject> ternarySearchTree = sSubjects;
        synchronized (ternarySearchTree) {
            subjects = sSubjects.values(query);
        }
        subjects.forEach(subject -> retval.add(subject.key()));
        return retval;
    }

    static List<EMessageHeader> localAds(AdMessage.AdStatus adStatus) {
        LinkedList<EMessageHeader> retval = new LinkedList<EMessageHeader>();
        for (ESubject subject : sSubjects.values()) {
            EMessageHeader msg = subject.localAd(adStatus);
            if (msg == null) continue;
            retval.add(msg);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addSubject(EMessageKey key) {
        String keyString = key.keyString();
        TernarySearchTree<ESubject> ternarySearchTree = sSubjects;
        synchronized (ternarySearchTree) {
            if (!sSubjects.containsKey((Object)keyString)) {
                if (key.isNotification()) {
                    sSubjects.put((CharSequence)keyString, (Object)new ENotifySubject(key));
                } else {
                    sSubjects.put((CharSequence)keyString, (Object)new ERequestSubject(key));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addAllSubjects(Collection<EMessageKey> keys) {
        TernarySearchTree<ESubject> ternarySearchTree = sSubjects;
        synchronized (ternarySearchTree) {
            keys.forEach(key -> {
                String keyString = key.keyString();
                if (!sSubjects.containsKey((Object)keyString)) {
                    if (key.isNotification()) {
                        sSubjects.put((CharSequence)keyString, (Object)new ENotifySubject((EMessageKey)key));
                    } else {
                        sSubjects.put((CharSequence)keyString, (Object)new ERequestSubject((EMessageKey)key));
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void storeKeys(ObjectOutputStream oos) throws IOException {
        Collection keys;
        TernarySearchTree<ESubject> ternarySearchTree = sSubjects;
        synchronized (ternarySearchTree) {
            keys = sSubjects.values();
        }
        ESubject.storeKeys(keys, oos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void storeKeys(Pattern query, ObjectOutputStream oos) throws IOException {
        Collection keys;
        TernarySearchTree<ESubject> ternarySearchTree = sSubjects;
        synchronized (ternarySearchTree) {
            keys = sSubjects.values(query);
        }
        ESubject.storeKeys(keys, oos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadKeys(ObjectInputStream ois) throws IOException {
        int numKeys = ois.readInt();
        TernarySearchTree<ESubject> ternarySearchTree = sSubjects;
        synchronized (ternarySearchTree) {
            for (int i = 0; i < numKeys; ++i) {
                try {
                    EMessageKey key = (EMessageKey)ois.readObject();
                    String keyString = key.keyString();
                    if (sSubjects.containsKey((Object)keyString)) continue;
                    if (key.isNotification()) {
                        sSubjects.put((CharSequence)keyString, (Object)new ENotifySubject(key));
                        continue;
                    }
                    sSubjects.put((CharSequence)keyString, (Object)new ERequestSubject(key));
                    continue;
                }
                catch (ClassNotFoundException classex) {
                    throw new IOException("ois contains a non-EMessageKey object", classex);
                }
            }
        }
    }

    private static void storeKeys(Collection<ESubject> subjects, ObjectOutputStream oos) throws IOException {
        oos.writeInt(subjects.size());
        for (ESubject subject : subjects) {
            oos.writeObject(subject.key());
        }
    }

    private static final class SubjectStatusReporter
    implements StatusReporter {
        public void reportStatus(PrintWriter report) {
            int clientCount = EClient.clientCount();
            int subjectCount = sSubjects.size();
            report.println();
            report.println("EClient:");
            report.format("    clients: %,d%n", clientCount);
            report.println();
            report.println("eBus Subject:");
            report.format("       subjects: %,d%n", subjectCount);
        }
    }
}

