/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.LinkedList;
import java.util.List;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.ESubject;
import net.sf.eBus.messages.EMessageKey;

abstract class ESingleFeed
extends EFeed {
    protected static final List<EFeed> mAdvertisers = new LinkedList<EFeed>();
    protected final FeedType mFeedType;
    protected final ESubject mSubject;
    protected int mActivationCount;
    private int mFeedIndex;

    protected ESingleFeed(EClient client, EFeed.FeedScope feedScope, FeedType feedType, ESubject subject) {
        super(client, feedScope);
        this.mFeedType = feedType;
        this.mSubject = subject;
        this.mFeedIndex = -1;
        this.mActivationCount = 0;
    }

    abstract int updateActivation(EClient.ClientLocation var1, EFeedState var2);

    @Override
    public String toString() {
        return String.format("%s %s %s", new Object[]{this.mSubject.key(), this.mFeedType, super.toString()});
    }

    @Override
    public final EMessageKey key() {
        return this.mSubject.key();
    }

    public final String messageSubject() {
        return this.mSubject.key().subject();
    }

    final int feedIndex() {
        return this.mFeedIndex;
    }

    public final int activationCount() {
        return this.mActivationCount;
    }

    final void feedIndex(int index) {
        this.mFeedIndex = index;
    }

    protected static enum FeedType {
        PUBLISH_FEED,
        SUBSCRIBE_FEED,
        REQUEST_FEED,
        REPLY_FEED;

    }
}

