/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.EPublishFeed;
import net.sf.eBus.client.EPublisher;
import net.sf.eBus.client.ERemoteApp;
import net.sf.eBus.client.IEPublishFeed;
import net.sf.eBus.client.ServerMessage;
import net.sf.eBus.config.AddressFilter;
import net.sf.eBus.config.EConfigure;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.net.AsyncServerSocket;
import net.sf.eBus.net.ServerSocketListener;
import net.sf.eBus.util.logging.StatusReport;
import net.sf.eBus.util.logging.StatusReporter;

public final class EServer
implements ServerSocketListener,
EPublisher,
StatusReporter {
    public static final int MIN_PORT = 1;
    public static final int MAX_PORT = 65535;
    public static final EMessageKey NEW_CONNECTION_KEY = new EMessageKey(ServerMessage.class, "/eBus");
    private static final ConcurrentMap<Integer, EServer> sServers = new ConcurrentHashMap<Integer, EServer>();
    private static final Logger sLogger = Logger.getLogger(EServer.class.getName());
    private int mPort = -1;
    private final AddressFilter mPositiveFilter;
    private final EConfigure.Service mConfiguration;
    private boolean mIsOpen;
    private AsyncServerSocket mAsyncServer;
    private final Date mCreated;
    private int mAcceptCount;
    private IEPublishFeed mNewConnectionFeed;

    private EServer(EConfigure.Service config) {
        this.mPositiveFilter = config.addressFilter();
        this.mConfiguration = config;
        this.mIsOpen = false;
        this.mAsyncServer = null;
        this.mCreated = new Date();
        this.mAcceptCount = 0;
    }

    public void handleAccept(SocketChannel socket, AsyncServerSocket aserver) {
        InetSocketAddress iAddress = (InetSocketAddress)socket.socket().getRemoteSocketAddress();
        ++this.mAcceptCount;
        if (this.mPositiveFilter != null && !this.mPositiveFilter.passes(iAddress)) {
            sLogger.info(String.format("Accepted unknown client connection %s; disconnecting.", iAddress));
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        } else {
            sLogger.info(String.format("Accepted client from %s.", iAddress));
            if (this.mNewConnectionFeed.isFeedUp()) {
                this.mNewConnectionFeed.publish((ENotificationMessage)((ServerMessage.Builder)((ServerMessage.Builder)ServerMessage.builder().remoteAddress(iAddress)).serverPort(this.mPort)).build());
            }
            ERemoteApp.openConnection(this.mPort, socket, this.mConfiguration);
        }
    }

    public void handleClose(Throwable jex, AsyncServerSocket aserver) {
        String message = jex.getMessage();
        this.mAsyncServer = null;
        this.mIsOpen = false;
        this.mNewConnectionFeed.close();
        sLogger.log(Level.WARNING, String.format("Service on port %d unexpectedly closed, %s.", this.mPort, message == null || message.length() == 0 ? "no reason given." : message), jex);
    }

    public void reportStatus(PrintWriter report) {
        int acceptCount = this.mAcceptCount;
        this.mAcceptCount = 0;
        report.format("The eBus service is open on port %d.%n", this.mPort);
        report.format("      created on %1$tY-%1$tm-%1$td @ %1$tH:%1$tM:%1$tS.%1$tL%n", this.mCreated);
        report.format("      accepted %,d %s.%n", acceptCount, acceptCount == 1 ? "connection" : "connections");
    }

    @Override
    public void publishStatus(EFeedState pubState, IEPublishFeed feed) {
    }

    public int port() {
        return this.mPort;
    }

    public EConfigure.Service configuration() {
        return this.mConfiguration;
    }

    public boolean isOpen() {
        return this.mIsOpen;
    }

    public static boolean isServiceOpen(int port) {
        EServer server = (EServer)sServers.get(port);
        return server != null && server.mIsOpen;
    }

    public static int serviceCount() {
        return sServers.size();
    }

    public static Collection<Integer> services() {
        ArrayList<Integer> retval = new ArrayList<Integer>();
        retval.addAll(sServers.keySet());
        return retval;
    }

    public static EServer server(int port) {
        return (EServer)sServers.get(port);
    }

    public static EServer openServer(EConfigure.Service config) {
        Objects.requireNonNull(config, "config is null");
        int port = config.port();
        if (sServers.containsKey(port)) {
            throw new IllegalStateException("service already open");
        }
        EServer retval = new EServer(config);
        sServers.put(port, retval);
        StatusReport.getInstance().register((StatusReporter)retval);
        if (!retval.open(port)) {
            retval.close();
            throw new IllegalStateException("service failed to open");
        }
        return retval;
    }

    public static void closeServer(int port) {
        if (sServers.containsKey(port)) {
            EServer server = (EServer)sServers.remove(port);
            StatusReport.getInstance().deregister((StatusReporter)server);
            server.close();
        }
    }

    public static void closeAllServers() {
        StatusReport report = StatusReport.getInstance();
        sServers.values().stream().map(server -> {
            report.deregister((StatusReporter)server);
            return server;
        }).forEachOrdered(server -> server.close());
        sServers.clear();
    }

    public static void configure(EConfigure config) throws IOException {
        config.services().values().forEach(EServer::openServer);
    }

    private boolean open(int port) {
        if (this.mAsyncServer == null || !this.mAsyncServer.isOpen()) {
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.fine(String.format("Opening service on port %d.", port));
            }
            try {
                if (this.mAsyncServer == null) {
                    AsyncServerSocket.ServerBuilder builder = AsyncServerSocket.builder();
                    this.mAsyncServer = builder.selector(this.mConfiguration.serviceSelector()).listener((ServerSocketListener)this).build();
                }
                this.mAsyncServer.open(port);
                this.mPort = port;
                this.mIsOpen = true;
                if (sLogger.isLoggable(Level.INFO)) {
                    sLogger.info(String.format("Service open on port %d.", port));
                }
                this.mNewConnectionFeed = EPublishFeed.open(this, NEW_CONNECTION_KEY, EFeed.FeedScope.LOCAL_ONLY);
                this.mNewConnectionFeed.advertise();
                this.mNewConnectionFeed.updateFeedState(EFeedState.UP);
            }
            catch (IOException ioex) {
                String message = ioex.getMessage();
                sLogger.log(Level.WARNING, String.format("Failed to open eBus service on port %d, %s.", port, message == null || message.length() == 0 ? "no reason given." : message), ioex);
            }
        }
        return this.mIsOpen;
    }

    private void close() {
        AsyncServerSocket asyncServer = this.mAsyncServer;
        if (this.mIsOpen && asyncServer != null && asyncServer.isOpen()) {
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.fine(String.format("Closing service on port %d.", this.mPort));
            }
            this.mIsOpen = false;
            this.mAsyncServer = null;
            asyncServer.close();
            this.mNewConnectionFeed.close();
            if (sLogger.isLoggable(Level.INFO)) {
                sLogger.info(String.format("Service closed on port %d.", this.mPort));
            }
        }
    }
}

