/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedList;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.ERemoteApp;
import net.sf.eBus.client.EReplyFeed;
import net.sf.eBus.client.ERequestFeed;
import net.sf.eBus.client.ESubject;
import net.sf.eBus.client.sysmessages.AdMessage;
import net.sf.eBus.client.sysmessages.FeedStatusMessage;
import net.sf.eBus.client.sysmessages.SystemMessageType;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageHeader;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.util.TernarySearchTree;

final class ERequestSubject
extends ESubject {
    private final EFeedList<ERequestFeed> mRequestors = new EFeedList();
    private final EFeedList<EReplyFeed> mRepliers = new EFeedList();
    private EFeedState mRemoteFeedState = EFeedState.DOWN;
    private static final Logger sLogger = Logger.getLogger(ERequestSubject.class.getName());

    ERequestSubject(EMessageKey key) {
        super(key);
    }

    @Override
    EMessageHeader localAd(AdMessage.AdStatus adStatus) {
        EMessageHeader retval = null;
        if (this.mRepliers.supports(EClient.ClientLocation.REMOTE) > 0) {
            retval = new EMessageHeader(SystemMessageType.AD.keyId(), -1, -1, (EMessage)((AdMessage.Builder)AdMessage.builder().messageKey(this.mKey)).adStatus(adStatus).adMessageType(EMessage.MessageType.REPLY).feedState(this.mRemoteFeedState).build());
        }
        return retval;
    }

    synchronized void subscribe(ERequestFeed feed) {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: adding %s/%s requestor %d, feed %d.", new Object[]{this.mKey, feed.location(), feed.scope(), feed.clientId(), feed.feedId()}));
        }
        this.mRequestors.add(feed);
        Iterator<EReplyFeed> rit = this.mRepliers.iterator(feed.scope());
        while (rit.hasNext()) {
            EReplyFeed replier = rit.next();
            feed.addReplier(replier.location(), replier);
        }
    }

    synchronized void unsubscribe(ERequestFeed feed) {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: removing %s/%s requestor %d, feed %d.", new Object[]{this.mKey, feed.location(), feed.scope(), feed.clientId(), feed.feedId()}));
        }
        this.mRequestors.remove(feed);
    }

    synchronized void advertise(EReplyFeed feed) {
        EClient.ClientLocation location = feed.location();
        EFeed.FeedScope scope = feed.scope();
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: adding %s/%s replier %d, feed %d.", new Object[]{this.mKey, location, scope, feed.clientId(), feed.feedId()}));
        }
        this.mRepliers.add(feed);
        if (location == EClient.ClientLocation.REMOTE || scope != EFeed.FeedScope.REMOTE_ONLY) {
            Iterator<ERequestFeed> qit = this.mRequestors.iterator(EFeed.FeedScope.LOCAL_AND_REMOTE);
            while (qit.hasNext()) {
                qit.next().addReplier(location, feed);
            }
        }
        if (location == EClient.ClientLocation.LOCAL && (scope == EFeed.FeedScope.LOCAL_AND_REMOTE || scope == EFeed.FeedScope.REMOTE_ONLY) && this.mRepliers.supports(EFeed.FeedScope.REMOTE_ONLY) == 1) {
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.fine(String.format("%s: forward ad to remote applications.", this.mKey));
            }
            ERemoteApp.forwardAll(new EMessageHeader(SystemMessageType.AD.keyId(), -1, -1, (EMessage)((AdMessage.Builder)AdMessage.builder().messageKey(this.mKey)).adStatus(AdMessage.AdStatus.ADD).adMessageType(EMessage.MessageType.REQUEST).feedState(this.mRemoteFeedState).build()));
        }
    }

    synchronized void unadvertise(EReplyFeed feed) {
        EClient.ClientLocation location = feed.location();
        EFeed.FeedScope scope = feed.scope();
        int feedCount = this.mRepliers.remove(feed);
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: removing %s/%s replier %d, feed %d.", new Object[]{this.mKey, location, scope, feed.clientId(), feed.feedId()}));
        }
        if (location == EClient.ClientLocation.LOCAL && scope != EFeed.FeedScope.REMOTE_ONLY) {
            Iterator<ERequestFeed> qit = this.mRequestors.iterator(EFeed.FeedScope.LOCAL_AND_REMOTE);
            while (qit.hasNext()) {
                qit.next().removeReplier(feed);
            }
        }
        if (location == EClient.ClientLocation.LOCAL && (scope == EFeed.FeedScope.LOCAL_AND_REMOTE || scope == EFeed.FeedScope.REMOTE_ONLY) && feedCount == 0) {
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.fine(String.format("%s: forward ad retraction to remote applications (feed count=%d)", this.mKey, feedCount));
            }
            ERemoteApp.forwardAll(new EMessageHeader(SystemMessageType.AD.keyId(), -1, -1, (EMessage)((AdMessage.Builder)AdMessage.builder().messageKey(this.mKey)).adStatus(AdMessage.AdStatus.REMOVE).adMessageType(EMessage.MessageType.REQUEST).feedState(EFeedState.DOWN).build()));
        }
    }

    synchronized void updateFeedState(EReplyFeed feed) {
        EClient.ClientLocation location = feed.location();
        EFeed.FeedScope scope = feed.scope();
        EFeedState oldState = this.mRemoteFeedState;
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: updating %s replier %d %s to %s (scope: %s).", new Object[]{this.mKey, feed.location(), feed.clientId(), feed.key(), feed.feedState(), scope}));
        }
        this.mRequestors.updateCount(feed, feed.feedState());
        if (location == EClient.ClientLocation.LOCAL && (scope == EFeed.FeedScope.LOCAL_AND_REMOTE || scope == EFeed.FeedScope.REMOTE_ONLY) && (this.mRemoteFeedState = this.mRepliers.feedState(EClient.ClientLocation.REMOTE)) != oldState) {
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.fine(String.format("%s: forward %s feed state to remote applications.", new Object[]{this.mKey, this.mRemoteFeedState}));
            }
            ERemoteApp.forwardAll(new EMessageHeader(SystemMessageType.FEED_STATUS.keyId(), -1, -1, (EMessage)FeedStatusMessage.builder().feedState(this.mRemoteFeedState).build()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ERequestSubject findOrCreate(EMessageKey key) {
        ERequestSubject retval;
        TernarySearchTree ternarySearchTree = sSubjects;
        synchronized (ternarySearchTree) {
            String keyString = key.keyString();
            retval = (ERequestSubject)sSubjects.get((Object)keyString);
            if (retval == null) {
                retval = new ERequestSubject(key);
                sSubjects.put((CharSequence)keyString, (Object)retval);
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.finest(String.format("%s: created request subject.", key));
                }
            }
        }
        return retval;
    }
}

