/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.EObject;
import net.sf.eBus.client.EReplyFeed;
import net.sf.eBus.client.ERequestSubject;
import net.sf.eBus.client.ERequestor;
import net.sf.eBus.client.ESingleFeed;
import net.sf.eBus.client.FeedStatusCallback;
import net.sf.eBus.client.IERequestFeed;
import net.sf.eBus.client.ReplyCallback;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.ERequestMessage;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class ERequestFeed
extends ESingleFeed
implements IERequestFeed {
    public static final String FEED_STATUS_METHOD = "feedStatus";
    public static final String REPLY_METHOD = "reply";
    private static final Logger sLogger = Logger.getLogger(ERequestFeed.class.getName());
    private final List<EReplyFeed> mRepliers = new ArrayList<EReplyFeed>();
    private FeedStatusCallback<ERequestFeed> mStatusCallback = null;
    private final Map<Class<? extends EMessage>, ReplyCallback> mReplyCallbacks;

    private ERequestFeed(EClient client, EFeed.FeedScope scope, ERequestSubject subject, Map<Class<? extends EMessage>, ReplyCallback> cbs) {
        super(client, scope, ESingleFeed.FeedType.REQUEST_FEED, subject);
        this.mReplyCallbacks = cbs;
    }

    @Override
    protected synchronized void inactivate() {
        ((ERequestSubject)this.mSubject).unsubscribe(this);
    }

    @Override
    int updateActivation(EClient.ClientLocation loc, EFeedState fs) {
        int retval = 0;
        if (this.mScope.supports(loc)) {
            boolean updateFlag = false;
            if (fs == EFeedState.UP) {
                ++this.mActivationCount;
                retval = 1;
                updateFlag = this.mActivationCount == 1;
            } else if (this.mActivationCount > 0) {
                --this.mActivationCount;
                retval = -1;
                boolean bl = updateFlag = this.mActivationCount == 0;
            }
            if (updateFlag) {
                this.mFeedState = fs;
                if (sLogger.isLoggable(Level.FINER)) {
                    sLogger.finer(String.format("%s requestor %d, feed %d: setting %s feed state to %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.key(), fs, this.mScope}));
                }
                this.mEClient.dispatch(new FeedStatusTask(fs, this, this.mStatusCallback));
            }
        }
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s requestor %d, feed %d: %s feed state=%s, activation count=%d (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.key(), fs, this.mActivationCount, this.mScope}));
        }
        return retval;
    }

    @Override
    public void statusCallback(FeedStatusCallback<ERequestFeed> cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("subscription in place");
        }
        this.mStatusCallback = cb;
    }

    @Override
    public void replyCallback(ReplyCallback cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("subscription in place");
        }
        this.mReplyCallbacks.entrySet().forEach(entry -> entry.setValue(cb));
    }

    @Override
    public void replyCallback(Class<? extends EReplyMessage> mc, ReplyCallback cb) {
        Objects.requireNonNull(mc, "mc is null");
        if (!this.mReplyCallbacks.containsKey(mc)) {
            throw new IllegalArgumentException(mc.getSimpleName() + " is not a " + this.mSubject.key() + " reply");
        }
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("subscription in place");
        }
        this.mReplyCallbacks.put(mc, cb);
    }

    void replyCallbacks(Map<Class<? extends EMessage>, ReplyCallback> cbs) {
        this.mReplyCallbacks.putAll(cbs);
    }

    public static ERequestFeed open(ERequestor client, EMessageKey key, EFeed.FeedScope scope) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(scope, "scope is null");
        if (!key.isRequest()) {
            throw new IllegalArgumentException(String.format("%s is not a request message", key));
        }
        ERequestFeed.checkScopes(key, scope);
        return ERequestFeed.open(client, key, scope, EClient.ClientLocation.LOCAL, false);
    }

    @Override
    public void subscribe() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            boolean replyOverride = this.isOverridden(REPLY_METHOD, Integer.TYPE, EReplyMessage.class, ERequest.class);
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s requestor %d, feed %d: subscribing to %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.mSubject.key(), this.mScope}));
            }
            if (this.mStatusCallback == null) {
                if (!this.isOverridden(FEED_STATUS_METHOD, EFeedState.class, ERequestFeed.class)) {
                    throw new IllegalStateException("feedStatus not overridden and statusCallback not set");
                }
                this.mStatusCallback = ((ERequestor)this.mEClient.target())::feedStatus;
            }
            this.mReplyCallbacks.entrySet().stream().filter(entry -> entry.getValue() == null).forEachOrdered(entry -> {
                if (!replyOverride) {
                    throw new IllegalStateException("reply not overridden and replyCallback not set");
                }
                entry.setValue(((ERequestor)this.mEClient.target())::reply);
            });
            ((ERequestSubject)this.mSubject).subscribe(this);
            this.mInPlace = true;
        }
    }

    @Override
    public void unsubscribe() {
        if (this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s requestor %d, feed %d: unsubscribing from %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.mSubject.key(), this.mScope}));
            }
            ((ERequestSubject)this.mSubject).unsubscribe(this);
            this.mInPlace = false;
            this.mActivationCount = 0;
            this.mFeedState = EFeedState.DOWN;
        }
    }

    public ERequest request(ERequestMessage msg) {
        Objects.requireNonNull(msg, "msg is null");
        if (!msg.key().equals(this.mSubject.key())) {
            throw new IllegalArgumentException(String.format("received msg key %s, expected %s", msg.key(), this.mSubject.key()));
        }
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is closed");
        }
        if (!this.mInPlace) {
            throw new IllegalStateException("not subscribed");
        }
        return this.doRequest(msg);
    }

    ERequest doRequest(ERequestMessage msg) {
        if (this.mActivationCount == 0) {
            throw new IllegalStateException("no repliers for request");
        }
        HashMap<EReplyFeed, EReplyFeed.ERequest> repliers = new HashMap<EReplyFeed, EReplyFeed.ERequest>(this.mRepliers.size());
        int replierCount = 0;
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s request %d: forwarding request to %,d repliers.", new Object[]{this.mEClient.location(), this.mFeedId, this.mRepliers.size()}));
        }
        ERequest retval = new ERequest(this, this.mReplyCallbacks);
        for (EReplyFeed replier : this.mRepliers) {
            EReplyFeed.ERequest replyRequest = replier.request(retval, msg);
            if (replyRequest == null) continue;
            replierCount += replyRequest.remaining();
            repliers.put(replier, replyRequest);
        }
        if (replierCount <= 0) {
            retval.close();
            throw new IllegalStateException("no repliers for request");
        }
        retval.repliers(replierCount, repliers.values());
        repliers.entrySet().stream().forEach(entry -> ((EReplyFeed)entry.getKey()).dispatch((EReplyFeed.ERequest)entry.getValue()));
        return retval;
    }

    synchronized void addReplier(EClient.ClientLocation location, EReplyFeed feed) {
        if (this.mScope == EFeed.FeedScope.LOCAL_ONLY && location == EClient.ClientLocation.LOCAL || this.mScope == EFeed.FeedScope.LOCAL_AND_REMOTE || this.mScope == EFeed.FeedScope.REMOTE_ONLY && location == EClient.ClientLocation.REMOTE) {
            this.mRepliers.add(feed);
            if (feed.feedState() == EFeedState.UP) {
                ++this.mActivationCount;
                if (this.mActivationCount == 1) {
                    this.mFeedState = EFeedState.UP;
                    this.mEClient.dispatch(new FeedStatusTask(this.mFeedState, this, this.mStatusCallback));
                }
            }
        }
    }

    synchronized void removeReplier(EReplyFeed feed) {
        if (this.mRepliers.remove(feed) && feed.feedState() == EFeedState.UP && this.mActivationCount > 0) {
            --this.mActivationCount;
            if (this.mActivationCount == 0) {
                this.mFeedState = EFeedState.DOWN;
                this.mEClient.dispatch(new FeedStatusTask(this.mFeedState, this, this.mStatusCallback));
            }
        }
    }

    public static ERequestFeed open(ERequestor cl, EMessageKey key, EFeed.FeedScope scope, EClient.ClientLocation l, boolean isMulti) {
        Map<Class<? extends EMessage>, ReplyCallback> cbs = ERequestFeed.createReplyCallbacks(key.messageClass());
        EClient eClient = EClient.findOrCreateClient(cl, l);
        ERequestSubject subject = ERequestSubject.findOrCreate(key);
        ERequestFeed retval = new ERequestFeed(eClient, scope, subject, cbs);
        if (!isMulti) {
            eClient.addFeed(retval);
        }
        return retval;
    }

    static Map<Class<? extends EMessage>, ReplyCallback> createReplyCallbacks(Class<? extends EMessage> mc) {
        MessageType mt = (MessageType)DataType.findType(mc);
        List<Class<? extends EReplyMessage>> replyClasses = mt.replyTypes();
        HashMap<Class<? extends EMessage>, ReplyCallback> retval = new HashMap<Class<? extends EMessage>, ReplyCallback>(replyClasses.size());
        replyClasses.forEach(clazz -> {
            ReplyCallback cfr_ignored_0 = retval.put((Class<? extends EMessage>)clazz, (ReplyCallback)null);
        });
        return retval;
    }

    public static enum RequestState {
        NOT_PLACED,
        ACTIVE,
        DONE,
        CANCELED;

    }

    private static final class ReplyTask
    extends EFeed.AbstractClientTask {
        private final int mRemaining;
        private final EReplyMessage mMessage;
        private final ERequest mRequest;
        private final ReplyCallback mCallback;

        private ReplyTask(int remaining, EReplyMessage msg, ERequest request, ReplyCallback cb) {
            super(request);
            this.mRemaining = remaining;
            this.mMessage = msg;
            this.mRequest = request;
            this.mCallback = cb;
        }

        @Override
        public void run() {
            EObject target = this.mFeed.eClient().target();
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.toString());
            }
            if (target != null) {
                try {
                    this.mCallback.call(this.mRemaining, this.mMessage, this.mRequest);
                }
                catch (Throwable tex) {
                    String reason = String.format("ReplyTask[%s, ] exception", target.getClass().getName(), this.mMessage.key());
                    if (sLogger.isLoggable(Level.FINE)) {
                        sLogger.log(Level.WARNING, reason, tex);
                    }
                    sLogger.log(Level.WARNING, reason);
                }
            }
            if (this.mRequest.requestState() == RequestState.DONE || this.mRequest.requestState() == RequestState.CANCELED) {
                this.mRequest.close();
            }
        }

        public String toString() {
            return String.format("ReplyTask[remaining=%d, key=%s]", this.mRemaining, this.mMessage.key());
        }
    }

    private static final class FeedStatusTask
    extends EFeed.AbstractClientTask {
        private final EFeedState mFeedState;
        private final FeedStatusCallback<ERequestFeed> mCallback;

        private FeedStatusTask(EFeedState feedState, ERequestFeed feed, FeedStatusCallback<ERequestFeed> cb) {
            super(feed);
            this.mFeedState = feedState;
            this.mCallback = cb;
        }

        @Override
        public void run() {
            EObject target = this.mFeed.eClient().target();
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.toString());
            }
            if (target != null) {
                try {
                    this.mCallback.call(this.mFeedState, (ERequestFeed)this.mFeed);
                }
                catch (Throwable tex) {
                    String reason = String.format("%s exception", target.getClass().getName());
                    if (sLogger.isLoggable(Level.FINE)) {
                        sLogger.log(Level.WARNING, reason, tex);
                    }
                    sLogger.log(Level.WARNING, reason);
                }
            }
        }

        public String toString() {
            return String.format("FeedStatusTask [feed=%s, state=%s]", new Object[]{this.mFeed, this.mFeedState});
        }
    }

    public static final class ERequest
    extends ESingleFeed {
        private final List<EReplyFeed.ERequest> mRepliers = new ArrayList<EReplyFeed.ERequest>();
        private final Map<Class<? extends EMessage>, ReplyCallback> mReplyCallbacks;
        private int mRemaining = 0;
        private RequestState mRequestState = RequestState.NOT_PLACED;

        private ERequest(ERequestFeed feed, Map<Class<? extends EMessage>, ReplyCallback> cbs) {
            super(feed.mEClient, feed.mScope, feed.mFeedType, feed.mSubject);
            this.mReplyCallbacks = cbs;
        }

        @Override
        protected synchronized void inactivate() {
            if (this.mRequestState == RequestState.ACTIVE) {
                this.mRepliers.stream().forEach(replier -> replier.close());
                this.mRepliers.clear();
                this.setState(RequestState.CANCELED);
            }
        }

        @Override
        int updateActivation(EClient.ClientLocation loc, EFeedState fs) {
            return 0;
        }

        @Override
        public String toString() {
            return String.format("%s request %d", new Object[]{this.mEClient.location(), this.mFeedId});
        }

        public RequestState requestState() {
            return this.mRequestState;
        }

        public int repliersRemaining() {
            return this.mRemaining;
        }

        void repliers(int count, Collection<EReplyFeed.ERequest> repliers) {
            this.mRepliers.addAll(repliers);
            this.mRemaining = count;
            this.setState(RequestState.ACTIVE);
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s: %d remaining (active=%b, state=%s)", new Object[]{this, this.mRemaining, this.mIsActive.get(), this.mRequestState}));
            }
        }

        void reply(int remaining, EReplyMessage msg, EReplyFeed.ERequest replier) {
            boolean isActive = this.mIsActive.get();
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s: %s reply, %s final, %d remaining (active=%b, state=%s)", new Object[]{this, replier.location(), msg.isFinal() ? "is" : "is not", remaining, isActive, this.mRequestState}));
            }
            if (isActive && this.mRequestState == RequestState.ACTIVE) {
                if (msg.isFinal()) {
                    this.mRepliers.remove(replier);
                    if (replier.location() == EClient.ClientLocation.LOCAL) {
                        --this.mRemaining;
                    }
                    if (this.mRemaining == 0) {
                        this.setState(RequestState.DONE);
                    }
                }
                this.mEClient.dispatch(new ReplyTask(this.mRemaining, msg, this, this.mReplyCallbacks.get(msg.key().messageClass())));
            }
        }

        void updateRemaining(int previous, int next) {
            this.mRemaining += next - previous;
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s: %d remaining (active=%b, state=%s)", new Object[]{this, this.mRemaining, this.mIsActive.get(), this.mRequestState}));
            }
        }

        private void setState(RequestState nextState) {
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(String.format("%s: %s -> %s.", new Object[]{this, this.mRequestState, nextState}));
            }
            this.mRequestState = nextState;
        }
    }
}

