/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.CancelRequestCallback;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.ECondition;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.EObject;
import net.sf.eBus.client.EReplier;
import net.sf.eBus.client.ERequestFeed;
import net.sf.eBus.client.ERequestSubject;
import net.sf.eBus.client.ESingleFeed;
import net.sf.eBus.client.IEReplyFeed;
import net.sf.eBus.client.RequestCallback;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.ERequestMessage;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class EReplyFeed
extends ESingleFeed
implements IEReplyFeed {
    static final String REQUEST_METHOD = "request";
    static final String CANCEL_METHOD = "cancelRequest";
    private static final Logger sLogger = Logger.getLogger(EReplyFeed.class.getName());
    private final ECondition mCondition;
    private final List<ERequest> mRequests;
    private final MessageType mDataType;
    private RequestCallback mRequestCallback;
    private CancelRequestCallback mCancelCallback;

    private EReplyFeed(EClient client, EFeed.FeedScope scope, ECondition condition, MessageType dataType, ERequestSubject subject) {
        super(client, scope, ESingleFeed.FeedType.REPLY_FEED, subject);
        this.mCondition = condition;
        this.mRequests = new ArrayList<ERequest>();
        this.mDataType = dataType;
        this.mRequestCallback = null;
        this.mCancelCallback = null;
    }

    @Override
    protected void inactivate() {
        if (this.mInPlace) {
            ((ERequestSubject)this.mSubject).unadvertise(this);
            this.mInPlace = false;
            this.failRequests("replier closed");
        }
        if (this.mEClient.isLocal() && (this.mScope == EFeed.FeedScope.LOCAL_AND_REMOTE || this.mScope == EFeed.FeedScope.REMOTE_ONLY)) {
            mAdvertisers.remove(this);
        }
    }

    @Override
    int updateActivation(EClient.ClientLocation loc, EFeedState fs) {
        return 0;
    }

    @Override
    public boolean isAdvertised() {
        return this.mIsActive.get() && this.mInPlace;
    }

    boolean isValidReply(EMessageKey repKey) {
        return this.mDataType.isValidReply(repKey.messageClass());
    }

    @Override
    public void requestCallback(RequestCallback cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("advertisement in place");
        }
        this.mRequestCallback = cb;
    }

    @Override
    public void cancelRequestCallback(CancelRequestCallback cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("advertisement in place");
        }
        this.mCancelCallback = cb;
    }

    @Override
    public void updateFeedState(EFeedState update) {
        Objects.requireNonNull(update, "update is null");
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            throw new IllegalStateException("feed not advertised");
        }
        if (update != this.mFeedState) {
            this.mFeedState = update;
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s replier %d, feed %d: setting %s feed state to %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.key(), update, this.mScope}));
            }
            ((ERequestSubject)this.mSubject).updateFeedState(this);
        }
    }

    boolean checkRequest(ERequestMessage msg, EClient.ClientLocation loc) {
        return this.mIsActive.get() && this.mCondition.test(msg) && this.mScope.supports(loc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ERequest request(ERequestFeed.ERequest request, ERequestMessage message) {
        ERequest retval;
        if (!this.mIsActive.get() || this.mFeedState == EFeedState.DOWN) {
            retval = null;
        } else {
            retval = new ERequest(request, this, message, this.mCancelCallback);
            List<ERequest> list = this.mRequests;
            synchronized (list) {
                this.mRequests.add(retval);
            }
        }
        return retval;
    }

    public static EReplyFeed open(EReplier client, EMessageKey key, EFeed.FeedScope scope, ECondition condition) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(scope, "scope is null");
        if (!key.isRequest()) {
            throw new IllegalArgumentException(String.format("%s is not a request message", key));
        }
        EReplyFeed.checkScopes(key, scope);
        MessageType dataType = (MessageType)DataType.findType(key.messageClass());
        return EReplyFeed.open(client, key, scope, condition, EClient.ClientLocation.LOCAL, dataType, false);
    }

    public static EReplyFeed open(EReplier client, EMessageKey key, EFeed.FeedScope scope, ECondition condition, EClient.ClientLocation l, MessageType dataType, boolean isMulti) {
        ECondition replyCondition = condition == null ? NO_CONDITION : condition;
        EClient eClient = EClient.findOrCreateClient(client, l);
        ERequestSubject subject = ERequestSubject.findOrCreate(key);
        EReplyFeed retval = new EReplyFeed(eClient, scope, replyCondition, dataType, subject);
        if (!isMulti) {
            eClient.addFeed(retval);
        }
        if (eClient.isLocal() && (scope == EFeed.FeedScope.LOCAL_AND_REMOTE || scope == EFeed.FeedScope.REMOTE_ONLY)) {
            mAdvertisers.add(retval);
        }
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("%s replier %d, Feed %d: opened %s (%s).", new Object[]{l, eClient.clientId(), retval.feedId(), key, scope}));
        }
        return retval;
    }

    @Override
    public void advertise() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            if (this.mRequestCallback == null) {
                if (!this.isOverridden(REQUEST_METHOD, ERequest.class)) {
                    throw new IllegalStateException("request not overridden and requestCallback not set");
                }
                this.mRequestCallback = ((EReplier)this.mEClient.target())::request;
            }
            if (this.mCancelCallback == null) {
                if (!this.isOverridden(CANCEL_METHOD, ERequest.class)) {
                    throw new IllegalStateException("cancelRequest not overridden and cancelRequestCallback not set");
                }
                this.mCancelCallback = ((EReplier)this.mEClient.target())::cancelRequest;
            }
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s replier %d, Feed %d: advertising %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.mSubject.key(), this.mScope}));
            }
            ((ERequestSubject)this.mSubject).advertise(this);
            this.mInPlace = true;
        }
    }

    @Override
    public void unadvertise() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s replier %d, Feed %d: unadvertising (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.mScope}));
            }
            ((ERequestSubject)this.mSubject).unadvertise(this);
            this.mInPlace = false;
            this.mActivationCount = 0;
            this.mFeedState = EFeedState.DOWN;
            this.failRequests("replier unadvertised");
        }
    }

    void dispatch(ERequest request) {
        this.mEClient.dispatch(new RequestTask(request, this.mRequestCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestDone(ERequest request) {
        List<ERequest> list = this.mRequests;
        synchronized (list) {
            this.mRequests.remove(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failRequests(String reason) {
        ArrayList requests = new ArrayList();
        List<ERequest> list = this.mRequests;
        synchronized (list) {
            requests.addAll(requests);
            this.mRequests.clear();
        }
        requests.forEach(request -> request.reply(new EReplyMessage(request.key().subject(), EReplyMessage.ReplyStatus.ERROR, reason)));
    }

    private static final class CancelRequestTask
    extends EFeed.AbstractClientTask {
        private final ERequest mRequest;
        private final CancelRequestCallback mCallback;

        private CancelRequestTask(ERequest request, EReplyFeed feed, CancelRequestCallback cb) {
            super(feed);
            this.mRequest = request;
            this.mCallback = cb;
        }

        @Override
        public void run() {
            EObject target = this.mFeed.eClient().target();
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.toString());
            }
            if (target != null) {
                try {
                    this.mCallback.call(this.mRequest);
                }
                catch (Throwable tex) {
                    String reason = String.format("EReplier.cancelRequest(%s) exception", this.mFeed);
                    if (sLogger.isLoggable(Level.FINE)) {
                        sLogger.log(Level.WARNING, reason, tex);
                    }
                    sLogger.log(Level.WARNING, reason);
                }
            }
        }

        public String toString() {
            return "CancelRequestTask";
        }
    }

    private static final class RequestTask
    extends EFeed.AbstractClientTask {
        private final RequestCallback _callback;

        private RequestTask(ERequest request, RequestCallback cb) {
            super(request);
            this._callback = cb;
        }

        @Override
        public void run() {
            EObject target = this.mFeed.eClient().target();
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.toString());
            }
            if (target != null) {
                try {
                    this._callback.call((ERequest)this.mFeed);
                }
                catch (Throwable tex) {
                    String reason = String.format("RequestTask[%s, %s] exception", target.getClass().getName(), this.mFeed);
                    if (sLogger.isLoggable(Level.FINE)) {
                        sLogger.log(Level.WARNING, reason, tex);
                    }
                    sLogger.log(Level.WARNING, reason);
                }
            }
        }

        public String toString() {
            return String.format("RequestTask[%s]", this.mFeed);
        }
    }

    public static final class ERequest
    extends ESingleFeed {
        private final ERequestFeed.ERequest _requestor;
        private final EReplyFeed _replier;
        private final ERequestMessage _request;
        private final CancelRequestCallback _cancelCallback;
        private ERequestFeed.RequestState _requestState;
        private int _remaining;

        ERequest(ERequestFeed.ERequest reqFeed, EReplyFeed repFeed, ERequestMessage request, CancelRequestCallback cb) {
            super(repFeed.mEClient, repFeed.mScope, repFeed.mFeedType, repFeed.mSubject);
            this._requestor = reqFeed;
            this._replier = repFeed;
            this._request = request;
            this._cancelCallback = cb;
            this._requestState = ERequestFeed.RequestState.ACTIVE;
            this._remaining = 1;
        }

        @Override
        protected void inactivate() {
            if (this._requestState == ERequestFeed.RequestState.ACTIVE) {
                this.state(ERequestFeed.RequestState.CANCELED);
                this._replier.mEClient.dispatch(new CancelRequestTask(this, this._replier, this._cancelCallback));
            }
        }

        @Override
        int updateActivation(EClient.ClientLocation loc, EFeedState fs) {
            return 0;
        }

        @Override
        public String toString() {
            return this._request.key().toString();
        }

        public ERequestMessage request() {
            return this._request;
        }

        public ERequestFeed.RequestState state() {
            return this._requestState;
        }

        public EReplyFeed replier() {
            return this._replier;
        }

        ERequestFeed.ERequest requestor() {
            return this._requestor;
        }

        int remaining() {
            return this._remaining;
        }

        void state(ERequestFeed.RequestState state) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("Reply %d.%d: setting state to %s.", new Object[]{this._replier.feedId(), this.mFeedId, state}));
            }
            this._requestState = state;
            if (state == ERequestFeed.RequestState.DONE || state == ERequestFeed.RequestState.CANCELED) {
                this._replier.requestDone(this);
                this.close();
            }
        }

        void remoteRemaining(int n) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("Reply %d.%d: number of %s repliers remaining is %,d.", new Object[]{this._replier.feedId(), this.mFeedId, this._replier.location(), n}));
            }
            this._requestor.updateRemaining(this._remaining, n);
            this._remaining = n;
        }

        public void reply(EReplyMessage msg) throws IllegalArgumentException, IllegalStateException {
            if (msg == null) {
                throw new IllegalArgumentException("msg is null");
            }
            if (!this._replier.isValidReply(msg.key())) {
                throw new IllegalArgumentException(msg.key().className() + " is not a valid reply message class for " + this._request.key().className());
            }
            if (!msg.key().subject().equals(this.mSubject.key().subject())) {
                throw new IllegalArgumentException("reply subject \"" + msg.key().subject() + "\" does not match request message subject \"" + this.mSubject.key().subject() + "\"");
            }
            if (this._requestState == ERequestFeed.RequestState.DONE) {
                throw new IllegalStateException("request is done");
            }
            if (msg.isFinal() && this._remaining - 1 == 0) {
                --this._remaining;
                this.state(ERequestFeed.RequestState.DONE);
            }
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(String.format("Reply %d.%d: forwarding reply message:%n%s", this._replier.feedId(), this.mFeedId, msg));
            } else if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("Reply %d.%d: forwarding reply message %s.", this._replier.feedId(), this.mFeedId, msg.key()));
            }
            this._requestor.reply(this._remaining, msg, this);
        }

        void remoteReply(EReplyMessage msg) {
            if (this._remaining == 0) {
                this.state(ERequestFeed.RequestState.DONE);
            }
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(String.format("Reply %d.%d: forwarding reply message:%n%s", this._replier.feedId(), this.mFeedId, msg));
            } else if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("Reply %d.%d: forwarding %s.", this._replier.feedId(), this.mFeedId, msg.key()));
            }
            this._requestor.reply(this._remaining, msg, this);
        }
    }
}

