/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.util.logging.Level;
import net.sf.eBus.client.ERemoteApp;
import net.sf.eBus.client.sysmessages.AdMessage;
import net.sf.eBus.client.sysmessages.LogoffMessage;
import net.sf.eBus.client.sysmessages.LogonCompleteMessage;
import net.sf.eBus.client.sysmessages.LogonMessage;
import net.sf.eBus.client.sysmessages.LogonReply;
import net.sf.eBus.client.sysmessages.PauseReply;
import net.sf.eBus.client.sysmessages.PauseRequest;
import net.sf.eBus.client.sysmessages.ResumeReply;
import net.sf.eBus.client.sysmessages.ResumeRequest;
import net.sf.eBus.config.EConfigure;
import net.sf.eBus.messages.EReplyMessage;
import statemap.FSMContext7;
import statemap.State7;
import statemap.TransitionHandle;

public class ERemoteAppContext
extends FSMContext7 {
    private transient ERemoteApp ctxt;
    private static final long serialVersionUID = 1L;
    public static final int ConnectionMap_Start_STATE_ID = 0;
    public static final int ConnectionMap_Opening_STATE_ID = 1;
    public static final int ConnectionMap_LoggingOn_STATE_ID = 2;
    public static final int ConnectionMap_WaitingForLogon_STATE_ID = 3;
    public static final int ConnectionMap_Advertising_STATE_ID = 4;
    public static final int ConnectionMap_Opened_STATE_ID = 5;
    public static final int ConnectionMap_Pausing_STATE_ID = 6;
    public static final int ConnectionMap_WaitingForPause_STATE_ID = 7;
    public static final int ConnectionMap_Paused_STATE_ID = 8;
    public static final int ConnectionMap_WaitingForResume_STATE_ID = 9;
    public static final int ConnectionMap_Resuming_STATE_ID = 10;
    public static final int ConnectionMap_Reconnecting_STATE_ID = 11;
    public static final int ConnectionMap_Closing_STATE_ID = 12;
    public static final int ConnectionMap_Closed_STATE_ID = 13;
    public static final int ConnectionMap_Resumed_STATE_ID = 14;
    private static final int STATE_COUNT = 15;
    private static final int adMessage9_TRANSITION_ID = 1;
    private static final int close3_TRANSITION_ID = 2;
    private static final int connected4_TRANSITION_ID = 3;
    private static final int disconnected6_TRANSITION_ID = 4;
    private static final int logoff17_TRANSITION_ID = 5;
    private static final int logon7_TRANSITION_ID = 6;
    private static final int logonComplete10_TRANSITION_ID = 7;
    private static final int logonReply5_TRANSITION_ID = 8;
    private static final int open1_TRANSITION_ID = 9;
    private static final int open2_TRANSITION_ID = 10;
    private static final int pause11_TRANSITION_ID = 11;
    private static final int pause12_TRANSITION_ID = 12;
    private static final int pauseReply13_TRANSITION_ID = 13;
    private static final int resume8_TRANSITION_ID = 14;
    private static final int resumeReply15_TRANSITION_ID = 15;
    private static final int resumed14_TRANSITION_ID = 16;
    private static final int TRANSITION_COUNT = 17;
    private static final MethodType[] TRANSITION_TYPES = new MethodType[]{NO_ARGS_TYPE, MethodType.methodType(Void.TYPE, AdMessage.class), NO_ARGS_TYPE, NO_ARGS_TYPE, NO_ARGS_TYPE, MethodType.methodType(Void.TYPE, LogoffMessage.class), MethodType.methodType(Void.TYPE, LogonMessage.class), MethodType.methodType(Void.TYPE, LogonCompleteMessage.class), MethodType.methodType(Void.TYPE, LogonReply.class), MethodType.methodType(Void.TYPE, EConfigure.RemoteConnection.class), MethodType.methodType(Void.TYPE, InetSocketAddress.class, Integer.TYPE, SelectableChannel.class, EConfigure.Service.class), NO_ARGS_TYPE, MethodType.methodType(Void.TYPE, PauseRequest.class), MethodType.methodType(Void.TYPE, PauseReply.class), MethodType.methodType(Void.TYPE, ResumeRequest.class), MethodType.methodType(Void.TYPE, ResumeReply.class), MethodType.methodType(Void.TYPE, ResumeRequest.class)};
    private static final String[] MAP_NAMES = new String[]{"ConnectionMap"};
    private static final String[][] STATE_NAMES = new String[][]{{"Start", "Opening", "LoggingOn", "WaitingForLogon", "Advertising", "Opened", "Pausing", "WaitingForPause", "Paused", "WaitingForResume", "Resuming", "Reconnecting", "Closing", "Closed", "Resumed"}};
    private static String[][] STATE_TRANSITIONS = new String[][]{{"close", "open", "open"}, {"close", "connected"}, {"close", "disconnected", "logonReply"}, {"close", "disconnected", "logon", "resume"}, {"adMessage", "close", "disconnected", "logonComplete"}, {"adMessage", "close", "disconnected", "pause", "pause"}, {"pauseReply"}, {"disconnected"}, {"close", "connected"}, {"disconnected", "resumed"}, {"close", "disconnected", "resumeReply"}, {"close", "connected"}, {"close", "disconnected"}, {"close"}, {"Default"}};
    private static final String[] TRANSITION_NAMES = new String[]{"Default", "adMessage", "close", "connected", "disconnected", "logoff", "logon", "logonComplete", "logonReply", "open", "open", "pause", "pause", "pauseReply", "resume", "resumeReply", "resumed"};
    private static final State7[] _States = new State7[15];

    public ERemoteAppContext(ERemoteApp owner) {
        this(owner, _States[0]);
    }

    public ERemoteAppContext(ERemoteApp owner, int initStateId) {
        this(owner, _States[initStateId]);
    }

    public ERemoteAppContext(ERemoteApp owner, State7 initState) {
        super(initState);
        this.ctxt = owner;
    }

    protected void executeAction(MethodHandle mh) {
        block2: {
            try {
                mh.invokeExact(this);
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block2;
                tex.printStackTrace(this._debugStream);
            }
        }
    }

    public void adMessage(AdMessage msg) {
        block4: {
            this._transition = "adMessage";
            try {
                TransitionHandle th = this.getState().transition(1);
                if (th.isDefault()) {
                    th.handle().invokeExact(this);
                } else {
                    th.handle().invokeExact(this, msg);
                }
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block4;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void close() {
        block2: {
            this._transition = "close";
            try {
                TransitionHandle th = this.getState().transition(2);
                th.handle().invokeExact(this);
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block2;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void connected() {
        block2: {
            this._transition = "connected";
            try {
                TransitionHandle th = this.getState().transition(3);
                th.handle().invokeExact(this);
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block2;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void disconnected() {
        block2: {
            this._transition = "disconnected";
            try {
                TransitionHandle th = this.getState().transition(4);
                th.handle().invokeExact(this);
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block2;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void logoff(LogoffMessage msg) {
        block4: {
            this._transition = "logoff";
            try {
                TransitionHandle th = this.getState().transition(5);
                if (th.isDefault()) {
                    th.handle().invokeExact(this);
                } else {
                    th.handle().invokeExact(this, msg);
                }
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block4;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void logon(LogonMessage msg) {
        block4: {
            this._transition = "logon";
            try {
                TransitionHandle th = this.getState().transition(6);
                if (th.isDefault()) {
                    th.handle().invokeExact(this);
                } else {
                    th.handle().invokeExact(this, msg);
                }
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block4;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void logonComplete(LogonCompleteMessage msg) {
        block4: {
            this._transition = "logonComplete";
            try {
                TransitionHandle th = this.getState().transition(7);
                if (th.isDefault()) {
                    th.handle().invokeExact(this);
                } else {
                    th.handle().invokeExact(this, msg);
                }
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block4;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void logonReply(LogonReply msg) {
        block4: {
            this._transition = "logonReply";
            try {
                TransitionHandle th = this.getState().transition(8);
                if (th.isDefault()) {
                    th.handle().invokeExact(this);
                } else {
                    th.handle().invokeExact(this, msg);
                }
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block4;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void open(EConfigure.RemoteConnection config) {
        block4: {
            this._transition = "open";
            try {
                TransitionHandle th = this.getState().transition(9);
                if (th.isDefault()) {
                    th.handle().invokeExact(this);
                } else {
                    th.handle().invokeExact(this, config);
                }
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block4;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void open(InetSocketAddress address, int serverPort, SelectableChannel socket, EConfigure.Service config) {
        block4: {
            this._transition = "open";
            try {
                TransitionHandle th = this.getState().transition(10);
                if (th.isDefault()) {
                    th.handle().invokeExact(this);
                } else {
                    th.handle().invokeExact(this, address, serverPort, socket, config);
                }
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block4;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void pause() {
        block2: {
            this._transition = "pause";
            try {
                TransitionHandle th = this.getState().transition(11);
                th.handle().invokeExact(this);
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block2;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void pause(PauseRequest msg) {
        block4: {
            this._transition = "pause";
            try {
                TransitionHandle th = this.getState().transition(12);
                if (th.isDefault()) {
                    th.handle().invokeExact(this);
                } else {
                    th.handle().invokeExact(this, msg);
                }
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block4;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void pauseReply(PauseReply msg) {
        block4: {
            this._transition = "pauseReply";
            try {
                TransitionHandle th = this.getState().transition(13);
                if (th.isDefault()) {
                    th.handle().invokeExact(this);
                } else {
                    th.handle().invokeExact(this, msg);
                }
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block4;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void resume(ResumeRequest msg) {
        block4: {
            this._transition = "resume";
            try {
                TransitionHandle th = this.getState().transition(14);
                if (th.isDefault()) {
                    th.handle().invokeExact(this);
                } else {
                    th.handle().invokeExact(this, msg);
                }
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block4;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void resumeReply(ResumeReply msg) {
        block4: {
            this._transition = "resumeReply";
            try {
                TransitionHandle th = this.getState().transition(15);
                if (th.isDefault()) {
                    th.handle().invokeExact(this);
                } else {
                    th.handle().invokeExact(this, msg);
                }
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block4;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    public void resumed(ResumeRequest msg) {
        block4: {
            this._transition = "resumed";
            try {
                TransitionHandle th = this.getState().transition(16);
                if (th.isDefault()) {
                    th.handle().invokeExact(this);
                } else {
                    th.handle().invokeExact(this, msg);
                }
            }
            catch (Throwable tex) {
                if (!this._debugFlag) break block4;
                tex.printStackTrace(this._debugStream);
            }
        }
        this._transition = "";
    }

    private void ConnectionMap_Default_logoff(LogoffMessage msg) {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.disconnect();
        }
        finally {
            this.setState(_States[13]);
        }
        this.enterState();
    }

    private void ConnectionMap_Default_logon(LogonMessage msg) {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.disconnect();
        }
        finally {
            this.setState(_States[12]);
        }
        this.enterState();
    }

    private void ConnectionMap_Default_logonReply(LogonReply msg) {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.disconnect();
        }
        finally {
            this.setState(_States[12]);
        }
        this.enterState();
    }

    private void ConnectionMap_Default_Default() {
        int stateId = this._state.getId();
    }

    private void ConnectionMap_Start_close() {
        int stateId = this._state.getId();
        this.exitState();
        this.setState(_States[13]);
        this.enterState();
    }

    private void ConnectionMap_Start_open(EConfigure.RemoteConnection config) {
        int stateId = this._state.getId();
        if (this.ctxt.connect(config) == 1) {
            this.exitState();
            this.setState(_States[2]);
            this.enterState();
        } else if (this.ctxt.connectStatus() == 3 && !config.reconnectFlag()) {
            this.exitState();
            this.setState(_States[13]);
            this.enterState();
        } else if (this.ctxt.connectStatus() == 3 && config.reconnectFlag()) {
            this.exitState();
            this.setState(_States[11]);
            this.enterState();
        } else {
            this.exitState();
            this.setState(_States[1]);
            this.enterState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ConnectionMap_Start_open(InetSocketAddress address, int serverPort, SelectableChannel socket, EConfigure.Service config) {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.connect(address, serverPort, socket, config);
        }
        finally {
            this.setState(_States[3]);
        }
        this.enterState();
    }

    private void ConnectionMap_Opening_close() {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.disconnect();
        }
        finally {
            this.setState(_States[12]);
        }
        this.enterState();
    }

    private void ConnectionMap_Opening_connected() {
        int stateId = this._state.getId();
        this.exitState();
        this.setState(_States[2]);
        this.enterState();
    }

    private void ConnectionMap_LoggingOn__Entry_() {
        this.ctxt.logon();
    }

    private void ConnectionMap_LoggingOn_close() {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.disconnect();
        }
        finally {
            this.setState(_States[12]);
        }
        this.enterState();
    }

    private void ConnectionMap_LoggingOn_disconnected() {
        int stateId = this._state.getId();
        if (this.ctxt.willReconnect()) {
            this.exitState();
            this.setState(_States[11]);
            this.enterState();
        } else {
            this.exitState();
            this.setState(_States[13]);
            this.enterState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ConnectionMap_LoggingOn_logonReply(LogonReply msg) {
        int stateId = this._state.getId();
        if (msg.logonStatus == EReplyMessage.ReplyStatus.ERROR) {
            this.exitState();
            try {
                this.clearState();
                this.ctxt.disconnect();
            }
            finally {
                this.setState(_States[13]);
            }
            this.enterState();
        } else {
            this.exitState();
            try {
                this.clearState();
                this.ctxt.storeRemoteId(msg.eid);
            }
            finally {
                this.setState(_States[4]);
            }
            this.enterState();
        }
    }

    private void ConnectionMap_WaitingForLogon_close() {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.disconnect();
        }
        finally {
            this.setState(_States[12]);
        }
        this.enterState();
    }

    private void ConnectionMap_WaitingForLogon_disconnected() {
        int stateId = this._state.getId();
        this.exitState();
        this.setState(_States[13]);
        this.enterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ConnectionMap_WaitingForLogon_logon(LogonMessage msg) {
        int stateId = this._state.getId();
        if (this.ctxt.isLoggedOn(msg.eid)) {
            this.exitState();
            try {
                this.clearState();
                this.ctxt.logonReply(EReplyMessage.ReplyStatus.ERROR, "duplicate connection");
            }
            finally {
                this.setState(_States[12]);
            }
            this.enterState();
        } else {
            this.exitState();
            try {
                this.clearState();
                this.ctxt.storeRemoteId(msg.eid);
                this.ctxt.logonReply(EReplyMessage.ReplyStatus.OK_FINAL, null);
            }
            finally {
                this.setState(_States[4]);
            }
            this.enterState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ConnectionMap_WaitingForLogon_resume(ResumeRequest msg) {
        int stateId = this._state.getId();
        if (!this.ctxt.isPausedConnection(msg.eid)) {
            this.exitState();
            try {
                this.clearState();
                this.ctxt.resumeReply(msg.eid, EReplyMessage.ReplyStatus.ERROR, "unknown paused connection");
            }
            finally {
                this.setState(_States[12]);
            }
            this.enterState();
        } else {
            this.exitState();
            try {
                this.clearState();
                this.ctxt.resumeConnection(msg);
            }
            finally {
                this.setState(_States[14]);
            }
            this.enterState();
        }
    }

    private void ConnectionMap_Advertising__Entry_() {
        this.ctxt.sendAds();
        this.ctxt.sendLogonComplete();
    }

    private void ConnectionMap_Advertising_adMessage(AdMessage msg) {
        int stateId = this._state.getId();
        try {
            this.clearState();
            this.ctxt.storeAd(msg);
        }
        finally {
            this.setState(_States[stateId]);
        }
    }

    private void ConnectionMap_Advertising_close() {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.logoff();
        }
        finally {
            this.setState(_States[12]);
        }
        this.enterState();
    }

    private void ConnectionMap_Advertising_disconnected() {
        int stateId = this._state.getId();
        if (this.ctxt.willReconnect()) {
            this.exitState();
            this.setState(_States[11]);
            this.enterState();
        } else {
            this.exitState();
            this.setState(_States[13]);
            this.enterState();
        }
    }

    private void ConnectionMap_Advertising_logonComplete(LogonCompleteMessage msg) {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.remoteConnect();
            this.ctxt.processLogonAds();
        }
        finally {
            this.setState(_States[5]);
        }
        this.enterState();
    }

    private void ConnectionMap_Opened__Entry_() {
        this.ctxt.startPauseTimer();
        this.ctxt.startIdleTimer();
    }

    private void ConnectionMap_Opened__Exit_() {
        this.ctxt.stopPauseTimer();
        this.ctxt.stopIdleTimer();
    }

    private void ConnectionMap_Opened_adMessage(AdMessage msg) {
        int stateId = this._state.getId();
        try {
            this.clearState();
            this.ctxt.processAd(msg);
        }
        finally {
            this.setState(_States[stateId]);
        }
    }

    private void ConnectionMap_Opened_close() {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.remoteDisconnect();
            this.ctxt.logoff();
        }
        finally {
            this.setState(_States[12]);
        }
        this.enterState();
    }

    private void ConnectionMap_Opened_disconnected() {
        int stateId = this._state.getId();
        if (this.ctxt.willReconnect()) {
            this.exitState();
            try {
                this.clearState();
                this.ctxt.remoteDisconnect();
            }
            finally {
                this.setState(_States[11]);
            }
            this.enterState();
        } else {
            this.exitState();
            try {
                this.clearState();
                this.ctxt.remoteDisconnect();
            }
            finally {
                this.setState(_States[13]);
            }
            this.enterState();
        }
    }

    private void ConnectionMap_Opened_pause() {
        int stateId = this._state.getId();
        if (this.ctxt.isAcceptor() || !this.ctxt.canPause()) {
            try {
                this.clearState();
                this.ctxt.log(Level.WARNING, "cannot pause this connection");
            }
            finally {
                this.setState(_States[stateId]);
            }
        }
        this.exitState();
        try {
            this.clearState();
            this.ctxt.pause();
        }
        finally {
            this.setState(_States[6]);
        }
        this.enterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ConnectionMap_Opened_pause(PauseRequest msg) {
        int stateId = this._state.getId();
        if (this.ctxt.isInitiator() || !this.ctxt.canPause()) {
            try {
                this.clearState();
                this.ctxt.pauseReply(EReplyMessage.ReplyStatus.ERROR, "pause not supported", msg);
            }
            finally {
                this.setState(_States[stateId]);
            }
        }
        this.exitState();
        try {
            this.clearState();
            this.ctxt.pauseReply(EReplyMessage.ReplyStatus.OK_FINAL, "", msg);
        }
        finally {
            this.setState(_States[7]);
        }
        this.enterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ConnectionMap_Pausing_pauseReply(PauseReply msg) {
        int stateId = this._state.getId();
        if (msg.replyStatus == EReplyMessage.ReplyStatus.ERROR && this.ctxt.willReconnect()) {
            this.exitState();
            try {
                this.clearState();
                this.ctxt.closeAndReconnect();
            }
            finally {
                this.setState(_States[11]);
            }
            this.enterState();
        } else if (msg.replyStatus == EReplyMessage.ReplyStatus.ERROR) {
            this.exitState();
            try {
                this.clearState();
                this.ctxt.remoteDisconnect();
                this.ctxt.logoff();
            }
            finally {
                this.setState(_States[12]);
            }
            this.enterState();
        } else {
            this.exitState();
            try {
                this.clearState();
                this.ctxt.closeAndPause(msg);
            }
            finally {
                this.setState(_States[8]);
            }
            this.enterState();
        }
    }

    private void ConnectionMap_WaitingForPause_disconnected() {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.pauseConnection();
        }
        finally {
            this.setState(_States[9]);
        }
        this.enterState();
    }

    private void ConnectionMap_Paused_close() {
        int stateId = this._state.getId();
        this.exitState();
        this.setState(_States[13]);
        this.enterState();
    }

    private void ConnectionMap_Paused_connected() {
        int stateId = this._state.getId();
        this.exitState();
        this.setState(_States[10]);
        this.enterState();
    }

    private void ConnectionMap_WaitingForResume__Entry_() {
        this.ctxt.startResumeTimer();
    }

    private void ConnectionMap_WaitingForResume__Exit_() {
        this.ctxt.stopResumeTimer();
    }

    private void ConnectionMap_WaitingForResume_disconnected() {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.clearPendingMessages();
            this.ctxt.remoteDisconnect();
        }
        finally {
            this.setState(_States[13]);
        }
        this.enterState();
    }

    private void ConnectionMap_WaitingForResume_resumed(ResumeRequest msg) {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.resumeReply(msg.eid, EReplyMessage.ReplyStatus.OK_FINAL, "");
            this.ctxt.connectionResumed();
        }
        finally {
            this.setState(_States[5]);
        }
        this.enterState();
    }

    private void ConnectionMap_Resuming__Entry_() {
        this.ctxt.resume();
    }

    private void ConnectionMap_Resuming_close() {
        int stateId = this._state.getId();
        this.exitState();
        try {
            this.clearState();
            this.ctxt.disconnect();
        }
        finally {
            this.setState(_States[12]);
        }
        this.enterState();
    }

    private void ConnectionMap_Resuming_disconnected() {
        int stateId = this._state.getId();
        if (this.ctxt.willReconnect()) {
            this.exitState();
            this.setState(_States[11]);
            this.enterState();
        } else {
            this.exitState();
            this.setState(_States[13]);
            this.enterState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ConnectionMap_Resuming_resumeReply(ResumeReply msg) {
        int stateId = this._state.getId();
        if (msg.replyStatus == EReplyMessage.ReplyStatus.ERROR && this.ctxt.willReconnect()) {
            this.exitState();
            this.setState(_States[11]);
            this.enterState();
        } else if (msg.replyStatus == EReplyMessage.ReplyStatus.ERROR) {
            this.exitState();
            try {
                this.clearState();
                this.ctxt.clearPendingMessages();
                this.ctxt.disconnect();
            }
            finally {
                this.setState(_States[12]);
            }
            this.enterState();
        } else {
            this.exitState();
            try {
                this.clearState();
                this.ctxt.connectionResumed();
            }
            finally {
                this.setState(_States[5]);
            }
            this.enterState();
        }
    }

    private void ConnectionMap_Reconnecting_close() {
        int stateId = this._state.getId();
        this.exitState();
        this.setState(_States[13]);
        this.enterState();
    }

    private void ConnectionMap_Reconnecting_connected() {
        int stateId = this._state.getId();
        this.exitState();
        this.setState(_States[2]);
        this.enterState();
    }

    private void ConnectionMap_Closing_close() {
        int stateId = this._state.getId();
    }

    private void ConnectionMap_Closing_disconnected() {
        int stateId = this._state.getId();
        this.exitState();
        this.setState(_States[13]);
        this.enterState();
    }

    private void ConnectionMap_Closed__Entry_() {
        this.ctxt.doShutdown();
        this.ctxt.removeConnection();
    }

    private void ConnectionMap_Closed_close() {
        int stateId = this._state.getId();
    }

    private void ConnectionMap_Resumed_Default() {
        int stateId = this._state.getId();
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class<ERemoteAppContext> clazz = ERemoteAppContext.class;
        int mapSize = MAP_NAMES.length;
        int stateId = 0;
        for (int mapIndex = 0; mapIndex < mapSize; ++mapIndex) {
            String mapName = MAP_NAMES[mapIndex];
            int stateSize = STATE_NAMES[mapIndex].length;
            int stateIndex = 0;
            while (stateIndex < stateSize) {
                String stateName = STATE_NAMES[mapIndex][stateIndex];
                TransitionHandle[] transitions = new TransitionHandle[17];
                String methodName = String.format("%s_%s__Entry_", mapName, stateName);
                MethodHandle entryHandle = ERemoteAppContext.lookupMethod((MethodHandles.Lookup)lookup, clazz, (String)methodName, (MethodType)NO_ARGS_TYPE);
                methodName = String.format("%s_%s__Exit_", mapName, stateName);
                MethodHandle exitHandle = ERemoteAppContext.lookupMethod((MethodHandles.Lookup)lookup, clazz, (String)methodName, (MethodType)NO_ARGS_TYPE);
                for (int transIndex = 1; transIndex < 17; ++transIndex) {
                    String transName = TRANSITION_NAMES[transIndex];
                    MethodType transType = TRANSITION_TYPES[transIndex];
                    transitions[transIndex] = ERemoteAppContext.lookupTransition((MethodHandles.Lookup)lookup, clazz, (String)mapName, (String)stateName, (String)transName, (MethodType)transType);
                }
                ERemoteAppContext._States[stateId] = new State7(String.format("%s_%s", mapName, stateName), stateId, entryHandle, exitHandle, transitions, STATE_TRANSITIONS[stateId]);
                ++stateIndex;
                ++stateId;
            }
        }
    }
}

