/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.ConnectionMessage;
import net.sf.eBus.client.EAbstractConnection;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.EPublishFeed;
import net.sf.eBus.client.EPublisher;
import net.sf.eBus.client.ERemoteAppContext;
import net.sf.eBus.client.EReplier;
import net.sf.eBus.client.EReplyFeed;
import net.sf.eBus.client.ERequestFeed;
import net.sf.eBus.client.ERequestor;
import net.sf.eBus.client.ESingleFeed;
import net.sf.eBus.client.ESubject;
import net.sf.eBus.client.ESubscribeFeed;
import net.sf.eBus.client.ESubscriber;
import net.sf.eBus.client.ETCPConnection;
import net.sf.eBus.client.IEPublishFeed;
import net.sf.eBus.client.IEReplyFeed;
import net.sf.eBus.client.IESubscribeFeed;
import net.sf.eBus.client.MessageKeyStore;
import net.sf.eBus.client.sysmessages.AdMessage;
import net.sf.eBus.client.sysmessages.CancelRequest;
import net.sf.eBus.client.sysmessages.FeedStatusMessage;
import net.sf.eBus.client.sysmessages.KeyMessage;
import net.sf.eBus.client.sysmessages.LogoffMessage;
import net.sf.eBus.client.sysmessages.LogonCompleteMessage;
import net.sf.eBus.client.sysmessages.LogonMessage;
import net.sf.eBus.client.sysmessages.LogonReply;
import net.sf.eBus.client.sysmessages.PauseReply;
import net.sf.eBus.client.sysmessages.PauseRequest;
import net.sf.eBus.client.sysmessages.RemoteAck;
import net.sf.eBus.client.sysmessages.ResumeReply;
import net.sf.eBus.client.sysmessages.ResumeRequest;
import net.sf.eBus.client.sysmessages.SubscribeMessage;
import net.sf.eBus.client.sysmessages.SystemMessageType;
import net.sf.eBus.config.EConfigure;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageHeader;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.ERequestMessage;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;
import net.sf.eBus.util.TimerTask;
import net.sf.eBus.util.logging.StatusReport;
import net.sf.eBus.util.logging.StatusReporter;

public final class ERemoteApp
implements EPublisher,
ESubscriber,
EReplier,
ERequestor {
    public static final int NO_ID = -1;
    public static final EMessageKey CONNECTION_UPDATE_KEY = ConnectionMessage.MESSAGE_KEY;
    public static final String NORMAL_LOGOFF = "logged off";
    static final int CONNECT_DOWN = 0;
    static final int CONNECT_COMPLETE = 1;
    static final int CONNECT_INCOMPLETE = 2;
    static final int CONNECT_FAILED = 3;
    private static final Duration RESUME_OFFSET = Duration.ofMillis(500L);
    private static final Map<InetSocketAddress, ERemoteApp> sConnections = new ConcurrentHashMap<InetSocketAddress, ERemoteApp>();
    private static final Map<String, ERemoteApp> sPausedConnections = new ConcurrentHashMap<String, ERemoteApp>();
    private static final Set<String> sLogonIds = new TreeSet<String>();
    private static final Lock sConnectionMutex = new ReentrantLock(true);
    private static final ConnectionPublisher sConnPublisher;
    private static final String sJvmId;
    private static final Logger sLogger;
    private static final Timer mTimer;
    private final ERemoteAppContext mFSM;
    private EClient mEClient;
    private EConfigure.ConnectionRole mRole;
    private InetSocketAddress mAddress = null;
    private int mServerPort = 0;
    private EAbstractConnection mConnection = null;
    private int mConnectStatus = 0;
    private volatile boolean mLoggedOn = false;
    private final Date mCreated = new Date();
    private String mRemoteId = null;
    private Throwable mLogoffException;
    private final Map<EMessageKey, EFeed> mKeys;
    private final Map<Integer, EFeed> mFeeds;
    private final Map<Integer, EReplyFeed.ERequest> mLocalRequests;
    private final Map<EMessageKey, ERequestFeed> mRequestFeeds;
    private final Map<Integer, ERequestFeed.ERequest> mRemoteRequests;
    private final Map<Integer, Integer> mToFromMap;
    private final MessageKeyStore mKeyStore;
    private List<AdMessage> mLogonAds;
    private boolean mCanPause = false;
    private EConfigure.PauseConfig mPauseConfig = null;
    private Duration mPauseDelay;
    private int mMaxBacklogSize;
    private EConfigure.DiscardPolicy mDiscardPolicy;
    private TimerTask mPauseTimer;
    private TimerTask mIdleTimer;
    private Instant mBusyTimestamp;
    private volatile boolean mIsPaused;
    private Map<Integer, EAbstractConnection.MessageReader> mPausedReaders;
    private List<EMessageHeader> mPendingMessages;
    private int mPendingMessageCount;
    private int mPendingQueueLimit = 0;
    private int mSubCount;
    private int mPubCount;
    private int mReplierCount;
    private int mRequestorCount;

    private ERemoteApp() {
        this.mFSM = new ERemoteAppContext(this);
        this.mFeeds = new HashMap<Integer, EFeed>();
        this.mKeys = new HashMap<EMessageKey, EFeed>();
        this.mLocalRequests = new HashMap<Integer, EReplyFeed.ERequest>();
        this.mRequestFeeds = new HashMap<EMessageKey, ERequestFeed>();
        this.mRemoteRequests = new HashMap<Integer, ERequestFeed.ERequest>();
        this.mToFromMap = new HashMap<Integer, Integer>();
        this.mKeyStore = new MessageKeyStore(this);
        this.mPendingMessages = Collections.emptyList();
        this.mFSM.setDebugFlag(sLogger.isLoggable(Level.FINEST));
    }

    void handleOpen(EAbstractConnection c) {
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("%s: connected to remote eBus.", this.mAddress));
        }
        this.mEClient.dispatch(this.mFSM::connected);
    }

    void handleClose(EAbstractConnection c) {
        sLogger.info(String.format("%s: disconnected.", this.mAddress));
        this.mEClient.dispatch(this.mFSM::disconnected);
    }

    @Override
    public void publishStatus(EFeedState feedState, IEPublishFeed feed) {
        int toFeedId;
        int fromFeedId = feed.feedId();
        int n = toFeedId = this.mToFromMap.get(fromFeedId) == null ? -1 : this.mToFromMap.get(fromFeedId);
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: %s publish status is %s.", new Object[]{this.mAddress, feed, feedState}));
        }
        if (this.mFeeds.containsKey(fromFeedId) && (feedState == EFeedState.UP && toFeedId == -1 || feedState == EFeedState.DOWN && toFeedId != -1)) {
            if (feedState == EFeedState.DOWN) {
                ((EPublishFeed)feed).clearFeedState();
                this.mToFromMap.remove(fromFeedId);
            }
            this.send(new EMessageHeader(SystemMessageType.SUBSCRIBE.keyId(), fromFeedId, toFeedId, (EMessage)((SubscribeMessage.Builder)SubscribeMessage.builder().messageKey(feed.key())).feedState(feedState).build()));
        }
    }

    @Override
    public void feedStatus(EFeedState feedState, IESubscribeFeed feed) {
        int feedId = feed.feedId();
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: %s feed status is %s.", new Object[]{this.mAddress, feed, feedState}));
        }
        if (this.mFeeds.containsKey(feedId)) {
            this.send(new EMessageHeader(SystemMessageType.FEED_STATUS.keyId(), feedId, this.mToFromMap.get(feedId), (EMessage)FeedStatusMessage.builder().feedState(feedState).build()));
        }
    }

    @Override
    public void notify(ENotificationMessage msg, IESubscribeFeed feed) {
        int feedId = feed.feedId();
        if (this.mFeeds.containsKey(feedId)) {
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(String.format("%s: forwarding message%n%s", this.mAddress, msg));
            }
            this.send(new EMessageHeader(this.mKeyStore.findOrCreate(msg.key()), feedId, this.mToFromMap.get(feedId), msg));
        }
    }

    @Override
    public void request(EReplyFeed.ERequest request) {
        ERequestMessage msg = request.request();
        int keyId = this.mKeyStore.findOrCreate(msg.key());
        int requestId = request.feedId();
        this.mLocalRequests.put(requestId, request);
        this.send(new EMessageHeader(keyId, requestId, -1, msg));
    }

    @Override
    public void cancelRequest(EReplyFeed.ERequest request) {
        int feedId = request.feedId();
        if (this.mToFromMap.containsKey(feedId)) {
            this.send(new EMessageHeader(SystemMessageType.CANCEL_REQUEST.keyId(), feedId, this.mToFromMap.get(feedId), (EMessage)CancelRequest.builder().build()));
            this.mLocalRequests.remove(feedId);
        }
    }

    @Override
    public void feedStatus(EFeedState feedState, ERequestFeed feed) {
    }

    @Override
    public synchronized void reply(int remaining, EReplyMessage reply, ERequestFeed.ERequest request) {
        int fromFeedId = request.feedId();
        if (this.mToFromMap.containsKey(fromFeedId)) {
            int toFeedId = this.mToFromMap.get(fromFeedId);
            if (reply.isFinal()) {
                if (sLogger.isLoggable(Level.FINER)) {
                    sLogger.finer(String.format("%s: request step 4: %d -> %d has %d remaining replies.", this.mAddress, fromFeedId, toFeedId, remaining));
                }
                this.send(new EMessageHeader(SystemMessageType.REMOTE_ACK.keyId(), fromFeedId, toFeedId, (EMessage)RemoteAck.builder().remaining(remaining).build()));
            }
            this.send(new EMessageHeader(this.mKeyStore.findOrCreate(reply.key()), fromFeedId, toFeedId, reply));
            if (remaining == 0) {
                this.mToFromMap.remove(fromFeedId);
                this.mRemoteRequests.remove(request.feedId());
            }
        }
    }

    public String toString() {
        return "ERemoteApp " + this.mAddress;
    }

    static void forwardAll(EMessageHeader h) {
        sConnections.values().stream().forEach(conn -> conn.mEClient.dispatch(() -> conn.send(h)));
    }

    void remoteLogon(EMessageHeader header) {
        this.mEClient.dispatch(() -> this.mFSM.logon((LogonMessage)header.message()));
    }

    void remoteLogonReply(EMessageHeader header) {
        this.mEClient.dispatch(() -> this.mFSM.logonReply((LogonReply)header.message()));
    }

    void remoteLogonComplete(EMessageHeader header) {
        this.mBusyTimestamp = Instant.now();
        this.mEClient.dispatch(() -> this.mFSM.logonComplete((LogonCompleteMessage)header.message()));
    }

    void remoteLogoff(EMessageHeader header) {
        this.mEClient.dispatch(() -> this.mFSM.logoff((LogoffMessage)header.message()));
    }

    void remotePauseRequest(EMessageHeader header) {
        this.mEClient.dispatch(() -> this.mFSM.pause((PauseRequest)header.message()));
    }

    void remotePauseReply(EMessageHeader header) {
        this.mEClient.dispatch(() -> this.mFSM.pauseReply((PauseReply)header.message()));
    }

    void remoteResumeRequest(EMessageHeader header) {
        this.mEClient.dispatch(() -> this.mFSM.resume((ResumeRequest)header.message()));
    }

    void remoteResumeReply(EMessageHeader header) {
        this.mEClient.dispatch(() -> this.mFSM.resumeReply((ResumeReply)header.message()));
    }

    void remoteClassUpdate(EMessageHeader header) {
        this.mBusyTimestamp = Instant.now();
        this.mConnection.keyUpdate((KeyMessage)header.message());
    }

    void remoteAd(EMessageHeader header) {
        this.mBusyTimestamp = Instant.now();
        this.mEClient.dispatch(() -> this.mFSM.adMessage((AdMessage)header.message()));
    }

    void remoteSubscribe(EMessageHeader header) {
        SubscribeMessage subMsg = (SubscribeMessage)header.message();
        this.mBusyTimestamp = Instant.now();
        try {
            Class<?> mc = Class.forName(subMsg.messageClass);
            EMessageKey key = new EMessageKey(mc, subMsg.messageSubject);
            int toFeedId = header.toFeedId();
            if (subMsg.feedState == EFeedState.UP) {
                ESubscribeFeed feed = ESubscribeFeed.open(this, key, EFeed.FeedScope.LOCAL_ONLY, null, EClient.ClientLocation.REMOTE, false);
                toFeedId = feed.feedId();
                this.mKeys.put(key, feed);
                this.mFeeds.put(toFeedId, feed);
                this.mToFromMap.put(toFeedId, header.fromFeedId());
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.fine(String.format("%s: subscribing to feed %s.", this.mAddress, feed));
                }
                feed.subscribe();
            } else {
                ESubscribeFeed feed = (ESubscribeFeed)this.findFeed(toFeedId, key);
                if (feed != null) {
                    feed.unsubscribe();
                    this.mKeys.remove(key);
                    this.mFeeds.remove(toFeedId);
                    this.mToFromMap.remove(toFeedId);
                    if (sLogger.isLoggable(Level.FINE)) {
                        sLogger.fine(String.format("%s: unsubscribing from feed %s.", this.mAddress, feed));
                    }
                }
            }
        }
        catch (ClassNotFoundException classex) {
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(String.format("%s: subscribe message %s unknown class %s, ignored.", new Object[]{this.mAddress, subMsg.feedState, subMsg.messageClass}));
            }
        }
        catch (IllegalArgumentException jex) {
            sLogger.log(Level.WARNING, String.format("%s: ad message to %s %s:%s failed.", new Object[]{this.mAddress, subMsg.feedState, subMsg.messageClass, subMsg.messageSubject}), jex);
        }
    }

    void remoteFeedStatus(EMessageHeader header) {
        int toFeedId = header.toFeedId();
        int fromFeedId = header.fromFeedId();
        FeedStatusMessage fsMsg = (FeedStatusMessage)header.message();
        EFeed feed = this.mFeeds.get(toFeedId);
        this.mBusyTimestamp = Instant.now();
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: from=%d, to=%d, status=%s, feed=%s.", new Object[]{this.mAddress, fromFeedId, toFeedId, fsMsg.feedState, feed == null ? "(unknown)" : feed}));
        }
        if (feed != null && feed.isActive()) {
            if (feed instanceof EPublishFeed) {
                ((IEPublishFeed)((Object)feed)).updateFeedState(fsMsg.feedState);
            } else {
                ((IEReplyFeed)((Object)feed)).updateFeedState(fsMsg.feedState);
            }
            this.mToFromMap.put(toFeedId, fromFeedId);
        }
    }

    void remoteNotify(EMessageHeader header) {
        int toFeedId = header.toFeedId();
        EPublishFeed feed = (EPublishFeed)this.mFeeds.get(toFeedId);
        ENotificationMessage message = (ENotificationMessage)header.message();
        this.mBusyTimestamp = Instant.now();
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: feed %s (from=%d, to=%d) received message:%n%s", this.mAddress, feed, header.fromFeedId(), toFeedId, message));
        }
        try {
            feed.publish(message);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
    }

    synchronized void remoteRequest(EMessageHeader header) {
        int fromFeedId = header.fromFeedId();
        ERequestMessage reqMsg = (ERequestMessage)header.message();
        EMessageKey key = reqMsg.key();
        ERequestFeed reqFeed = this.findRequestFeed(key);
        ERequestFeed.ERequest request = reqFeed.request(reqMsg);
        int toFeedId = request.feedId();
        this.mBusyTimestamp = Instant.now();
        try {
            this.mRemoteRequests.put(fromFeedId, request);
            this.mToFromMap.put(toFeedId, fromFeedId);
            this.mFeeds.put(toFeedId, request);
            this.mEClient.dispatch(() -> this.send(new EMessageHeader(SystemMessageType.REMOTE_ACK.keyId(), toFeedId, fromFeedId, (EMessage)RemoteAck.builder().remaining(request.repliersRemaining()).build())));
        }
        catch (IllegalArgumentException | IllegalStateException jex) {
            EMessageKey replyKey = new EMessageKey(EReplyMessage.class, key.subject());
            int keyId = this.mKeyStore.findOrCreate(replyKey);
            EReplyMessage.ConcreteBuilder replyBuilder = (EReplyMessage.ConcreteBuilder)EReplyMessage.builder();
            request.close();
            this.mToFromMap.remove(toFeedId);
            this.mFeeds.remove(toFeedId);
            this.mEClient.dispatch(() -> this.send(new EMessageHeader(keyId, toFeedId, fromFeedId, (EMessage)((EReplyMessage.ConcreteBuilder)((EReplyMessage.ConcreteBuilder)((EReplyMessage.ConcreteBuilder)replyBuilder.subject(key.subject())).replyStatus(EReplyMessage.ReplyStatus.ERROR)).replyReason(jex.getMessage())).build())));
            this.mEClient.dispatch(() -> this.send(new EMessageHeader(SystemMessageType.REMOTE_ACK.keyId(), toFeedId, fromFeedId, (EMessage)RemoteAck.builder().remaining(0).build())));
        }
    }

    void remoteCancelRequest(EMessageHeader header) {
        int toFeedId = header.toFeedId();
        ERequestFeed.ERequest request = (ERequestFeed.ERequest)this.mFeeds.get(toFeedId);
        this.mBusyTimestamp = Instant.now();
        if (sLogger.isLoggable(Level.FINER)) {
            Formatter output = new Formatter();
            output.format("%s: feed %d remote cancel: ", this.mAddress, toFeedId);
            if (request == null) {
                output.format("unknown request feed", new Object[0]);
            } else {
                output.format("%s is %s.", new Object[]{request.key(), request.requestState()});
            }
            sLogger.finer(output.toString());
        }
        if (request != null && request.requestState() == ERequestFeed.RequestState.ACTIVE) {
            request.close();
            this.mToFromMap.remove(toFeedId);
            this.mRemoteRequests.remove(toFeedId);
        }
    }

    void remoteRequestAck(EMessageHeader header) {
        int fromFeedId = header.fromFeedId();
        int toFeedId = header.toFeedId();
        RemoteAck msg = (RemoteAck)header.message();
        EReplyFeed.ERequest request = this.mLocalRequests.get(toFeedId);
        ERequestFeed.RequestState reqState = request.state();
        this.mBusyTimestamp = Instant.now();
        if (!this.mToFromMap.containsKey(toFeedId)) {
            this.mToFromMap.put(toFeedId, fromFeedId);
        }
        request.remoteRemaining(msg.remaining);
        if (reqState == ERequestFeed.RequestState.CANCELED) {
            this.send(new EMessageHeader(SystemMessageType.CANCEL_REQUEST.keyId(), toFeedId, fromFeedId, (EMessage)CancelRequest.builder().build()));
            this.mLocalRequests.remove(toFeedId);
        }
    }

    void remoteReply(EMessageHeader header) {
        int toFeedId = header.toFeedId();
        int fromFeedId = header.fromFeedId();
        EReplyFeed.ERequest request = this.mLocalRequests.get(toFeedId);
        this.mBusyTimestamp = Instant.now();
        if (request != null) {
            if (request.state() == ERequestFeed.RequestState.CANCELED) {
                this.send(new EMessageHeader(SystemMessageType.CANCEL_REQUEST.keyId(), fromFeedId, toFeedId, (EMessage)CancelRequest.builder().build()));
                this.mLocalRequests.remove(toFeedId);
            } else {
                EReplyMessage replyMsg = (EReplyMessage)header.message();
                ERequestFeed.RequestState reqState = request.state();
                this.mToFromMap.put(toFeedId, fromFeedId);
                request.remoteReply(replyMsg);
                if (reqState == ERequestFeed.RequestState.CANCELED) {
                    this.send(new EMessageHeader(SystemMessageType.CANCEL_REQUEST.keyId(), fromFeedId, toFeedId, (EMessage)CancelRequest.builder().build()));
                }
            }
        }
    }

    public InetSocketAddress address() {
        return this.mAddress;
    }

    public boolean willReconnect() {
        return this.mConnection.willReconnect();
    }

    public boolean isConnected() {
        return this.mLoggedOn;
    }

    int connectStatus() {
        return this.mConnectStatus;
    }

    Duration pauseDelay() {
        return this.mPauseConfig.duration();
    }

    public static int connectionCount() {
        return sConnections.size();
    }

    public static Collection<InetSocketAddress> connections() {
        ArrayList<InetSocketAddress> retval = new ArrayList<InetSocketAddress>();
        retval.addAll(sConnections.keySet());
        return retval;
    }

    public static boolean isConnected(InetSocketAddress a) {
        ERemoteApp remote = sConnections.get(a);
        return remote == null ? false : remote.isConnected();
    }

    static ERemoteApp connection(InetSocketAddress a) {
        return sConnections.get(a);
    }

    private ERequestFeed findRequestFeed(EMessageKey key) {
        ERequestFeed retval = this.mRequestFeeds.get(key);
        if (retval == null) {
            retval = ERequestFeed.open(this, key, EFeed.FeedScope.LOCAL_ONLY, EClient.ClientLocation.REMOTE, false);
            retval.subscribe();
            this.mRequestFeeds.put(key, retval);
        }
        return retval;
    }

    public static ERemoteApp openConnection(EConfigure.RemoteConnection config) {
        InetSocketAddress inetAddress = config.address();
        Objects.requireNonNull(config, "config is null");
        ERemoteApp retval = new ERemoteApp();
        if (sConnections.putIfAbsent(inetAddress, retval) != null) {
            throw new IllegalStateException(String.format("already connected to %s", inetAddress));
        }
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("Opening connection to %s:%n%s", inetAddress, config));
        }
        retval.open(config);
        return retval;
    }

    public static void closeConnection(InetSocketAddress address) {
        ERemoteApp connection = sConnections.remove(address);
        if (connection != null) {
            connection.close();
        }
    }

    public static void closeAllConnections() {
        sConnections.values().stream().forEach(conn -> conn.close());
    }

    public static void configure(EConfigure config) {
        config.remoteConnections().values().forEach(ERemoteApp::openConnection);
    }

    static ERemoteApp openConnection(int serverPort, SelectableChannel channel, EConfigure.Service config) {
        SocketChannel socket = (SocketChannel)channel;
        InetSocketAddress address = (InetSocketAddress)socket.socket().getRemoteSocketAddress();
        ERemoteApp retval = new ERemoteApp();
        sConnections.put(address, retval);
        retval.open(address, serverPort, channel, config);
        return retval;
    }

    private void open(EConfigure.RemoteConnection config) {
        this.mAddress = config.address();
        this.mRole = EConfigure.ConnectionRole.INITIATOR;
        this.mEClient = EClient.findOrCreateClient(this, EClient.ClientLocation.REMOTE);
        this.mEClient.dispatch(() -> this.mFSM.open(config));
    }

    private void open(InetSocketAddress addr, int serverPort, SelectableChannel channel, EConfigure.Service config) {
        this.mAddress = addr;
        this.mRole = EConfigure.ConnectionRole.ACCEPTOR;
        this.mEClient = EClient.findOrCreateClient(this, EClient.ClientLocation.REMOTE);
        this.mEClient.dispatch(() -> this.mFSM.open(addr, serverPort, channel, config));
    }

    private void close() {
        this.mEClient.dispatch(this.mFSM::close);
    }

    private EFeed findFeed(int feedId, EMessageKey key) {
        EFeed retval = this.mFeeds.get(feedId);
        if (retval == null) {
            retval = this.mKeys.get(key);
        }
        return retval;
    }

    boolean isLoggedOn(String logonId) {
        boolean retcode = false;
        sConnectionMutex.lock();
        try {
            retcode = sLogonIds.contains(logonId);
        }
        finally {
            sConnectionMutex.unlock();
        }
        return retcode;
    }

    boolean isInitiator() {
        return this.mRole == EConfigure.ConnectionRole.INITIATOR;
    }

    boolean isAcceptor() {
        return this.mRole == EConfigure.ConnectionRole.ACCEPTOR;
    }

    boolean canPause() {
        return this.mCanPause;
    }

    boolean isPausedConnection(String eid) {
        return sPausedConnections.containsKey(eid);
    }

    int connect(EConfigure.RemoteConnection config) {
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("%s: connecting to remote eBus.", config.address()));
        }
        this.mConnection = ETCPConnection.create(config, this);
        this.mCanPause = config.canPause() && this.mConnection.willPause();
        this.mPauseConfig = config.pauseConfiguration();
        if (this.mCanPause) {
            this.mPendingMessages = new ArrayList<EMessageHeader>(this.mPauseConfig.maxBacklogSize());
            this.mPendingQueueLimit = this.mPauseConfig.resumeOnQueueLimit();
        }
        try {
            this.mConnectStatus = this.mConnection.open(config) ? 1 : 2;
        }
        catch (IOException ioex) {
            this.mConnectStatus = 3;
            sLogger.log(Level.WARNING, String.format("%s: connect failed.", config.address()), ioex);
        }
        return this.mConnectStatus;
    }

    void connect(InetSocketAddress address, int bindPort, SelectableChannel channel, EConfigure.Service config) {
        this.mAddress = address;
        this.mServerPort = bindPort;
        this.mConnection = ETCPConnection.create(config, this);
        this.mCanPause = config.canPause() && this.mConnection.willPause();
        this.mPauseConfig = config.pauseConfiguration();
        ArrayList arrayList = this.mPendingMessages = this.mCanPause ? new ArrayList(this.mPauseConfig.maxBacklogSize()) : Collections.emptyList();
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("%s: remote eBus connected, max queue size: %,d, current queue size: %,d.", this.mAddress, this.mConnection.maxMessageQueueSize(), this.mConnection.messageQueueSize()));
        }
        try {
            this.mConnection.open(channel, config);
        }
        catch (IOException ioex) {
            sLogger.log(Level.WARNING, String.format("%s: connection open failed.", address), ioex);
        }
    }

    void disconnect() {
        if (this.mConnection != null && this.mConnection.isOpen()) {
            this.mConnection.closeNow();
        }
    }

    void logon() {
        EMessage logon = (EMessage)((LogonMessage.Builder)LogonMessage.builder().eid(sJvmId)).build();
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: sending logon:%n%s", this.mAddress, logon));
        }
        this.send(new EMessageHeader(SystemMessageType.LOGON.keyId(), -1, -1, logon));
    }

    void logonReply(EReplyMessage.ReplyStatus status, String reason) {
        EMessage reply = (EMessage)((LogonReply.Builder)LogonReply.builder().eid(sJvmId)).logonStatus(status).reason(reason).build();
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: sending logon reply:%n%s", this.mAddress, reply));
        }
        this.send(new EMessageHeader(SystemMessageType.LOGON_REPLY.keyId(), -1, -1, reply));
    }

    void logoff() {
        EMessage logoff = (EMessage)((LogoffMessage.Builder)LogoffMessage.builder().eid(sJvmId)).build();
        sLogger.info(String.format("%s: logging off from remote eBus.", this.mAddress));
        this.send(new EMessageHeader(SystemMessageType.LOGOFF.keyId(), -1, -1, logoff));
    }

    void startPauseTimer() {
        if (this.mRole == EConfigure.ConnectionRole.INITIATOR && this.mCanPause) {
            long connectTime = this.mPauseConfig.maxConnectTime().toMillis();
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(String.format("%s: starting pause timer for %s millis.", this.mAddress, connectTime));
            }
            this.mPauseTimer = new TimerTask(task -> this.maxConnectTimer(this.mPauseTimer));
            mTimer.schedule((java.util.TimerTask)this.mPauseTimer, connectTime);
        }
    }

    void stopPauseTimer() {
        if (this.mPauseTimer != null) {
            this.mPauseTimer.cancel();
            this.mPauseTimer = null;
        }
    }

    void startIdleTimer() {
        if (this.mRole == EConfigure.ConnectionRole.INITIATOR && this.mCanPause) {
            long idleTime = this.mPauseConfig.idleTime().toMillis() / 2L;
            this.mIdleTimer = new TimerTask(task -> this.idleTimer(this.mIdleTimer));
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(String.format("%s: starting idle timer for %s millis.", this.mAddress, idleTime));
            }
            mTimer.schedule((java.util.TimerTask)this.mIdleTimer, idleTime);
        }
    }

    void stopIdleTimer() {
        if (this.mIdleTimer != null) {
            this.mIdleTimer.cancel();
            this.mIdleTimer = null;
        }
    }

    void startResumeTimer() {
        long resumeTime = this.mPauseDelay.plus(RESUME_OFFSET).toMillis();
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: starting resume timer for %s millis.", this.mAddress, resumeTime));
        }
        this.mPauseTimer = new TimerTask(task -> this.resumeTimer(this.mPauseTimer));
        mTimer.schedule((java.util.TimerTask)this.mPauseTimer, resumeTime);
    }

    void stopResumeTimer() {
        if (this.mPauseTimer != null) {
            this.mPauseTimer.cancel();
            this.mPauseTimer = null;
        }
    }

    void pause() {
        EMessage pause = (EMessage)((PauseRequest.Builder)PauseRequest.builder().eid(sJvmId)).pauseTime(this.mPauseConfig.duration()).maximumBacklogSize(this.mPauseConfig.maxBacklogSize()).discardPolicy(this.mPauseConfig.discardPolicy()).build();
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: sending pause:%n%s", this.mAddress, pause));
        }
        this.send(new EMessageHeader(SystemMessageType.PAUSE_REQUEST.keyId(), -1, -1, pause));
    }

    void pauseReply(EReplyMessage.ReplyStatus status, String reason, PauseRequest request) {
        if (status == EReplyMessage.ReplyStatus.OK_FINAL) {
            this.mPauseDelay = this.mPauseConfig.duration().compareTo(request.pauseTime) < 0 ? this.mPauseConfig.duration() : request.pauseTime;
            this.mMaxBacklogSize = this.mPauseConfig.maxBacklogSize() < request.maximumBacklogSize ? this.mPauseConfig.maxBacklogSize() : request.maximumBacklogSize;
            this.mDiscardPolicy = request.discardPolicy;
        } else {
            this.mPauseDelay = Duration.ZERO;
            this.mMaxBacklogSize = 0;
            this.mDiscardPolicy = null;
        }
        PauseReply reply = (PauseReply)((PauseReply.Builder)PauseReply.builder().eid(sJvmId)).replyStatus(status).replyReason(reason).pauseTime(this.mPauseDelay).maximumBacklogSize(this.mMaxBacklogSize).build();
        this.send(new EMessageHeader(SystemMessageType.PAUSE_REPLY.keyId(), -1, -1, reply));
    }

    void closeAndPause(PauseReply reply) {
        this.mIsPaused = true;
        this.mMaxBacklogSize = reply.maximumBacklogSize;
        this.mConnection.closeAndPause(reply.pauseTime);
        ERemoteApp.sConnPublisher.publish(this.mAddress, this.mServerPort, ConnectionMessage.ConnectionState.PAUSED, null);
    }

    void pauseConnection() {
        this.mIsPaused = true;
        this.mPausedReaders = this.mConnection.readers();
        sConnections.remove(this.mAddress);
        sPausedConnections.put(this.mRemoteId, this);
        ERemoteApp.sConnPublisher.publish(this.mAddress, this.mServerPort, ConnectionMessage.ConnectionState.PAUSED, null);
    }

    void resumeConnection(ResumeRequest msg) {
        ERemoteApp connection = sPausedConnections.remove(msg.eid);
        connection.mAddress = this.mAddress;
        connection.mConnection = this.mConnection;
        connection.mConnectStatus = this.mConnectStatus;
        connection.mLoggedOn = true;
        this.mConnection.resumeConnection(connection, connection.mPausedReaders);
        this.mPausedReaders = null;
        sConnections.replace(this.mAddress, this, connection);
        connection.mEClient.dispatch(() -> connection.mFSM.resumed(msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionResumed() {
        List<EMessageHeader> list = this.mPendingMessages;
        synchronized (list) {
            this.mIsPaused = false;
            ERemoteApp.sConnPublisher.publish(this.mAddress, this.mServerPort, ConnectionMessage.ConnectionState.RESUMED, null);
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s: posting %,d pending messages.", this.mAddress, this.mPendingMessages.size()));
            }
            this.mPendingMessages.forEach(this::doSend);
            this.mPendingMessages.clear();
        }
    }

    void resumeReply(String eid, EReplyMessage.ReplyStatus status, String msg) {
        EMessage reply = (EMessage)((ResumeReply.Builder)ResumeReply.builder().eid(eid)).replyStatus(status).replyReason(msg).build();
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: sending resume reply:%n%s", this.mAddress, reply));
        }
        this.send(new EMessageHeader(SystemMessageType.RESUME_REPLY.keyId(), -1, -1, reply));
    }

    void resume() {
        EMessage resume = (EMessage)((ResumeRequest.Builder)ResumeRequest.builder().eid(sJvmId)).build();
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: sending resume request:%n%s", this.mAddress, resume));
        }
        this.send(new EMessageHeader(SystemMessageType.RESUME_REQUEST.keyId(), -1, -1, resume));
    }

    void closeAndReconnect() {
        this.mConnection.closeAndReconnect();
    }

    void clearPendingMessages() {
        this.mPendingMessages.clear();
    }

    void storeRemoteId(String id) {
        this.mRemoteId = id;
        sConnectionMutex.lock();
        try {
            sLogonIds.add(id);
        }
        finally {
            sConnectionMutex.unlock();
        }
    }

    void storeAd(AdMessage msg) {
        this.mLogonAds.add(msg);
    }

    void removeConnection() {
        sConnections.remove(this.mAddress);
    }

    void sendAds() {
        this.mLogonAds = new LinkedList<AdMessage>();
        this.mEClient.dispatch(() -> ESubject.localAds(AdMessage.AdStatus.ADD).stream().forEach(msg -> {
            try {
                this.mConnection.send((EMessageHeader)msg);
            }
            catch (IOException ioex) {
                sLogger.log(Level.WARNING, "Failed to send advertisement", ioex);
            }
        }));
    }

    void sendLogonComplete() {
        this.mEClient.dispatch(() -> {
            LogonCompleteMessage logonMsg = (LogonCompleteMessage)((LogonCompleteMessage.Builder)LogonCompleteMessage.builder().eid(sJvmId)).build();
            this.mLoggedOn = true;
            this.send(new EMessageHeader(SystemMessageType.LOGON_COMPLETE.keyId(), -1, -1, logonMsg));
        });
    }

    void remoteConnect() {
        ERemoteApp.sConnPublisher.publish(this.mAddress, this.mServerPort, ConnectionMessage.ConnectionState.LOGGED_ON, null);
    }

    void processLogonAds() {
        this.mLogonAds.forEach(msg -> this.processAd((AdMessage)msg));
        this.mLogonAds.clear();
        this.mLogonAds = null;
    }

    void processAd(AdMessage adMsg) {
        try {
            Class<?> mc = Class.forName(adMsg.messageClass);
            EMessageKey key = new EMessageKey(mc, adMsg.messageSubject);
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(String.format("%s: received ad message:%n%s", this.mAddress, adMsg));
            }
            if (adMsg.adStatus == AdMessage.AdStatus.ADD) {
                ESingleFeed feed;
                if (key.isNotification()) {
                    feed = EPublishFeed.open(this, key, EFeed.FeedScope.LOCAL_ONLY, EClient.ClientLocation.REMOTE, false);
                    ++this.mPubCount;
                } else {
                    MessageType dataType = (MessageType)DataType.findType(key.messageClass());
                    feed = EReplyFeed.open(this, key, EFeed.FeedScope.LOCAL_ONLY, null, EClient.ClientLocation.REMOTE, dataType, false);
                    ++this.mReplierCount;
                }
                this.mKeys.put(key, feed);
                this.mFeeds.put(feed.feedId(), feed);
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.fine(String.format("%s: added %s feed %s (state: %s).", new Object[]{this.mAddress, key.isNotification() ? "publish" : "reply", key, adMsg.feedState}));
                }
                if (key.isNotification()) {
                    ((IEPublishFeed)((Object)feed)).advertise();
                    ((IEPublishFeed)((Object)feed)).updateFeedState(adMsg.feedState);
                } else {
                    ((IEReplyFeed)((Object)feed)).advertise();
                    ((IEReplyFeed)((Object)feed)).updateFeedState(adMsg.feedState);
                }
            } else {
                EFeed feed = this.mKeys.remove(key);
                if (feed != null) {
                    this.mFeeds.remove(feed.feedId());
                    if (key.isNotification()) {
                        ((IEPublishFeed)((Object)feed)).unadvertise();
                        --this.mPubCount;
                    } else {
                        ((IEReplyFeed)((Object)feed)).unadvertise();
                        --this.mReplierCount;
                    }
                    if (sLogger.isLoggable(Level.FINE)) {
                        sLogger.fine(String.format("%s: removed %s feed %s.", this.mAddress, key.isNotification() ? "publish" : "reply", key));
                    }
                }
            }
        }
        catch (ClassNotFoundException classex) {
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(String.format("%s: ad message to %s unknown class %s, ignored.", new Object[]{this.mAddress, adMsg.adStatus, adMsg.messageClass}));
            }
        }
        catch (IllegalArgumentException | IllegalStateException jex) {
            sLogger.log(Level.WARNING, String.format("%s: ad message to %s %s:%s failed.", new Object[]{this.mAddress, adMsg.adStatus, adMsg.messageClass, adMsg.messageSubject}), jex);
        }
    }

    void remoteDisconnect() {
        if (this.mLoggedOn) {
            String reason;
            this.mLoggedOn = false;
            sConnectionMutex.lock();
            try {
                sLogonIds.remove(this.mRemoteId);
            }
            finally {
                sConnectionMutex.unlock();
            }
            this.mRemoteId = null;
            this.mFeeds.values().stream().filter(feed -> feed.inPlace()).forEach(feed -> feed.close());
            this.mRemoteRequests.values().stream().forEach(request -> request.close());
            this.mKeys.clear();
            this.mFeeds.clear();
            this.mLocalRequests.clear();
            this.mRemoteRequests.clear();
            this.mToFromMap.clear();
            if (this.mLogoffException == null) {
                reason = NORMAL_LOGOFF;
            } else {
                reason = this.mLogoffException.getLocalizedMessage();
                if (reason == null || reason.isEmpty()) {
                    reason = this.mLogoffException.getClass().getName();
                }
            }
            ERemoteApp.sConnPublisher.publish(this.mAddress, this.mServerPort, ConnectionMessage.ConnectionState.LOGGED_OFF, reason);
            this.mLogoffException = null;
        }
    }

    void doShutdown() {
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("%s: shutting down.", this.mAddress));
        }
    }

    void log(Level level, String msg) {
        sLogger.log(level, String.format("%s: %s", this.mAddress, msg));
    }

    void send(EMessageHeader header) {
        Class<? extends EMessage> mc = header.messageClass();
        if (this.mIsPaused && !mc.equals(ResumeRequest.class) && !mc.equals(ResumeReply.class) && this.storePending(header)) {
            if (this.mRole == EConfigure.ConnectionRole.INITIATOR && !header.isSystemMessage() && this.mPendingQueueLimit > 0 && this.mPendingMessageCount >= this.mPendingQueueLimit && !this.mConnection.isConnecting()) {
                sLogger.fine(String.format("%s: pending message queue at limit (%,d); resuming connection.", this.mAddress, this.mPendingQueueLimit));
                this.mConnection.resumeNow();
            }
        } else {
            this.doSend(header);
        }
    }

    private void maxConnectTimer(TimerTask task) {
        this.mPauseTimer = null;
        this.mEClient.dispatch(this.mFSM::pause);
    }

    private void idleTimer(TimerTask task) {
        Duration idleTime = Duration.between(this.mBusyTimestamp, Instant.now());
        Duration maxIdleTime = this.mPauseConfig.idleTime();
        this.mIdleTimer = null;
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: idle time is %s, max is %s.", this.mAddress, idleTime, maxIdleTime));
        }
        if (idleTime.compareTo(maxIdleTime) >= 0) {
            this.mEClient.dispatch(this.mFSM::pause);
        } else {
            this.startIdleTimer();
        }
    }

    private void resumeTimer(TimerTask task) {
        this.mPauseTimer = null;
        this.mEClient.dispatch(this.mFSM::disconnected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storePending(EMessageHeader header) {
        boolean dropFlag = true;
        List<EMessageHeader> list = this.mPendingMessages;
        synchronized (list) {
            boolean systemFlag = header.isSystemMessage();
            if (this.mIsPaused) {
                if (systemFlag || this.mMaxBacklogSize == 0 || this.mPendingMessageCount < this.mMaxBacklogSize) {
                    dropFlag = false;
                    this.mPendingMessages.add(header);
                    if (!systemFlag) {
                        ++this.mPendingMessageCount;
                    }
                } else if (this.mDiscardPolicy == EConfigure.DiscardPolicy.OLDEST_FIRST) {
                    Iterator<EMessageHeader> mIt = this.mPendingMessages.iterator();
                    boolean flag = false;
                    while (!flag && mIt.hasNext()) {
                        flag = !mIt.next().isSystemMessage();
                        if (!flag) continue;
                        mIt.remove();
                    }
                    this.mPendingMessages.add(header);
                }
            }
        }
        if (dropFlag && sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: paused connection transmit queue at maximum (%d); application message dropped.", this.mAddress, this.mMaxBacklogSize));
        }
        return this.mIsPaused;
    }

    private void doSend(EMessageHeader header) {
        try {
            this.mConnection.send(header);
            this.mBusyTimestamp = Instant.now();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException | BufferOverflowException jex) {
            sLogger.log(Level.WARNING, String.format("%s: failed to send %s, disconnecting", this.mAddress, header.messageClass().getName()), jex);
            this.mLogoffException = jex;
            this.mFSM.disconnected();
        }
    }

    private void reportStatus(PrintWriter report, int index) {
        report.format("  [%,d] address: %s%n", index, this.mAddress);
        report.format("      created on %1$tY-%1$tm-%1$td @ %1$tH:%1$tM:%1$tS.%1$tL%n", this.mCreated);
        report.format("      logged in: %b%n", this.mLoggedOn);
        report.format("    subscribers: %,d%n", this.mSubCount);
        report.format("     publishers: %,d%n", this.mPubCount);
        report.format("       repliers: %,d%n", this.mReplierCount);
        report.format("     requestors: %,d%n", this.mRequestorCount);
    }

    static {
        sLogger = Logger.getLogger(ERemoteApp.class.getName());
        mTimer = new Timer("PauseTimer", true);
        sJvmId = ManagementFactory.getRuntimeMXBean().getName();
        sLogonIds.add(sJvmId);
        DataType.findType(AdMessage.class);
        DataType.findType(CancelRequest.class);
        DataType.findType(FeedStatusMessage.class);
        DataType.findType(KeyMessage.class);
        DataType.findType(LogoffMessage.class);
        DataType.findType(LogonMessage.class);
        DataType.findType(LogonMessage.class);
        DataType.findType(LogonReply.class);
        DataType.findType(PauseReply.class);
        DataType.findType(PauseRequest.class);
        DataType.findType(ResumeReply.class);
        DataType.findType(ResumeRequest.class);
        DataType.findType(SubscribeMessage.class);
        StatusReport.getInstance().register((StatusReporter)new ERemoteStatusReporter());
        sConnPublisher = new ConnectionPublisher();
        EFeed.register(sConnPublisher);
        EFeed.startup(sConnPublisher);
    }

    private static final class ConnectionPublisher
    implements EPublisher {
        private EPublishFeed mStateFeed = null;

        ConnectionPublisher() {
        }

        @Override
        public void startup() {
            this.mStateFeed = EPublishFeed.open(this, CONNECTION_UPDATE_KEY, EFeed.FeedScope.LOCAL_ONLY);
            this.mStateFeed.advertise();
            this.mStateFeed.updateFeedState(EFeedState.UP);
        }

        @Override
        public void publishStatus(EFeedState feedState, IEPublishFeed feed) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s feed is %s.", new Object[]{feed.key(), feedState}));
            }
            if (feedState == EFeedState.UP) {
                ConnectionMessage.Builder builder = ConnectionMessage.builder();
                sConnections.values().forEach(conn -> this.mStateFeed.publish((ENotificationMessage)((ConnectionMessage.Builder)((ConnectionMessage.Builder)builder.remoteAddress(((ERemoteApp)conn).mAddress)).serverPort(((ERemoteApp)conn).mServerPort)).state(((ERemoteApp)conn).mLoggedOn ? ConnectionMessage.ConnectionState.LOGGED_ON : ConnectionMessage.ConnectionState.LOGGED_OFF).build()));
            }
        }

        private void publish(InetSocketAddress address, int serverPort, ConnectionMessage.ConnectionState state, String reason) {
            if (this.mStateFeed.isFeedUp()) {
                ConnectionMessage.Builder builder = ConnectionMessage.builder();
                this.mStateFeed.publish((ENotificationMessage)((ConnectionMessage.Builder)((ConnectionMessage.Builder)builder.remoteAddress(address)).serverPort(serverPort)).state(state).reason(reason).build());
            }
        }
    }

    private static final class ERemoteStatusReporter
    implements StatusReporter {
        public void reportStatus(PrintWriter report) {
            int appCount = sConnections.size();
            report.print("ERemote: ");
            if (appCount == 0) {
                report.println("there are no remote connections.");
            } else {
                ArrayList apps = new ArrayList(sConnections.values());
                int index = 0;
                report.format("there %s %,d remote application %s.%n", appCount == 1 ? "is" : "are", appCount, appCount == 1 ? "connection" : "connections");
                for (ERemoteApp remoteApp : apps) {
                    remoteApp.reportStatus(report, index);
                    report.println();
                    ++index;
                }
                apps.clear();
            }
        }
    }
}

