/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.ENotifyFeed;
import net.sf.eBus.client.ENotifySubject;
import net.sf.eBus.client.EPublisher;
import net.sf.eBus.client.ESingleFeed;
import net.sf.eBus.client.FeedStatusCallback;
import net.sf.eBus.client.IEPublishFeed;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;

public final class EPublishFeed
extends ENotifyFeed
implements IEPublishFeed {
    static final String PUB_STATUS_METHOD = "publishStatus";
    private static final Logger sLogger = Logger.getLogger(EPublishFeed.class.getName());
    private EFeedState mPublishState = EFeedState.UNKNOWN;
    private FeedStatusCallback<IEPublishFeed> mStatusCallback = null;

    private EPublishFeed(EClient client, EFeed.FeedScope scope, ENotifySubject subject) {
        super(client, scope, ESingleFeed.FeedType.PUBLISH_FEED, subject);
    }

    @Override
    int updateActivation(EClient.ClientLocation loc, EFeedState fs) {
        boolean updateFlag = false;
        int retval = 0;
        if (this.mScope.supports(loc)) {
            if (fs == EFeedState.UP) {
                ++this.mActivationCount;
                retval = this.mPublishState == EFeedState.UP ? 1 : 0;
                updateFlag = this.mActivationCount == 1;
            } else if (this.mActivationCount > 0) {
                --this.mActivationCount;
                retval = -1;
                boolean bl = updateFlag = this.mActivationCount == 0;
            }
            if (updateFlag) {
                this.update(fs);
            }
        }
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s client %d, feed %d: %s feed state=%s, activation count=%d (%s), update?=%b -> %d.", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.key(), fs, this.mActivationCount, this.mScope, updateFlag, retval}));
        }
        return retval;
    }

    @Override
    void update(EFeedState feedState) {
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s publisher %d: %s subscriber feed state is %s.", new Object[]{this.mEClient.location(), this.mFeedId, this.key(), feedState}));
        }
        this.mFeedState = feedState;
        this.mEClient.dispatch(new EFeed.StatusTask<IEPublishFeed>(feedState, this, this.mStatusCallback));
    }

    @Override
    protected void inactivate() {
        if (this.mInPlace) {
            ((ENotifySubject)this.mSubject).unadvertise(this);
            if (this.mEClient.isLocal() && (this.mScope == EFeed.FeedScope.LOCAL_AND_REMOTE || this.mScope == EFeed.FeedScope.REMOTE_ONLY)) {
                mAdvertisers.remove(this);
            }
        }
    }

    @Override
    public boolean isAdvertised() {
        return this.mIsActive.get() && this.mInPlace;
    }

    @Override
    public EFeedState publishState() {
        return this.mPublishState;
    }

    @Override
    public boolean isFeedUp() {
        return this.mPublishState == EFeedState.UP && this.mFeedState == EFeedState.UP;
    }

    @Override
    public boolean isFeedUp(String subject) {
        Objects.requireNonNull(subject, "subject is null");
        if (subject.isEmpty()) {
            throw new IllegalArgumentException("subject is an empty string");
        }
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        return subject.equals(this.mSubject.key().subject()) && this.isFeedUp();
    }

    public static EPublishFeed open(EPublisher client, EMessageKey key, EFeed.FeedScope scope) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(scope, "scope is null");
        if (!key.isNotification()) {
            throw new IllegalArgumentException(String.format("%s is not a notification message", key));
        }
        EPublishFeed.checkScopes(key, scope);
        return EPublishFeed.open(client, key, scope, EClient.ClientLocation.LOCAL, false);
    }

    @Override
    public void statusCallback(FeedStatusCallback<IEPublishFeed> cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("advertisement in place");
        }
        this.mStatusCallback = cb;
    }

    @Override
    public void advertise() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s publisher %d, feed %d: advertising %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.mSubject.key(), this.mScope}));
            }
            if (this.mStatusCallback == null) {
                if (!this.isOverridden(PUB_STATUS_METHOD, EFeedState.class, IEPublishFeed.class)) {
                    throw new IllegalStateException("publishStatus not overridden and statusCallback not set");
                }
                this.mStatusCallback = ((EPublisher)this.mEClient.target())::publishStatus;
            }
            this.mFeedState = ((ENotifySubject)this.mSubject).advertise(this);
            if (this.mEClient.isLocal() && (this.mScope == EFeed.FeedScope.LOCAL_AND_REMOTE || this.mScope == EFeed.FeedScope.REMOTE_ONLY)) {
                mAdvertisers.add(this);
            }
            this.mInPlace = true;
        }
    }

    @Override
    public void unadvertise() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s publisher %d, feed %d: unadvertising %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.mSubject.key(), this.mScope}));
            }
            ((ENotifySubject)this.mSubject).unadvertise(this);
            if (this.mEClient.isLocal() && (this.mScope == EFeed.FeedScope.LOCAL_AND_REMOTE || this.mScope == EFeed.FeedScope.REMOTE_ONLY)) {
                mAdvertisers.remove(this);
            }
            this.mPublishState = EFeedState.UNKNOWN;
            this.mInPlace = false;
            this.mActivationCount = 0;
            this.mFeedState = EFeedState.DOWN;
        }
    }

    @Override
    public void updateFeedState(EFeedState update) {
        Objects.requireNonNull(update, "update is null");
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            throw new IllegalStateException("feed not advertised");
        }
        if (update != this.mPublishState) {
            this.mPublishState = update;
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s publisher %d, feed %d: setting %s feed state to %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.key(), update, this.mScope}));
            }
            ((ENotifySubject)this.mSubject).updateFeedState(this);
        }
    }

    @Override
    public void publish(ENotificationMessage msg) {
        Objects.requireNonNull(msg, "msg is null");
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!msg.key().equals(this.mSubject.key())) {
            throw new IllegalArgumentException(String.format("received msg key %s, expected %s", msg.key(), this.mSubject.key()));
        }
        if (!this.mInPlace) {
            throw new IllegalStateException("feed not advertised");
        }
        if (this.mPublishState != EFeedState.UP) {
            throw new IllegalStateException("publish state is down");
        }
        this.doPublish(msg);
    }

    public static EPublishFeed open(EPublisher cl, EMessageKey key, EFeed.FeedScope scope, EClient.ClientLocation l, boolean isMulti) {
        EClient eClient = EClient.findOrCreateClient(cl, l);
        ENotifySubject subject = ENotifySubject.findOrCreate(key);
        EPublishFeed retval = new EPublishFeed(eClient, scope, subject);
        if (!isMulti) {
            eClient.addFeed(retval);
        }
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("%s publisher %d, feed %d: opened %s (%s).", new Object[]{eClient.location(), eClient.clientId(), retval.feedId(), key, scope}));
        }
        return retval;
    }

    void clearFeedState() {
        if (this.mFeedState != EFeedState.DOWN) {
            this.mFeedState = EFeedState.DOWN;
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s publisher %d, feed %d: setting %s feed state to %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.key(), this.mFeedState, this.mScope}));
            }
        }
    }

    void doPublish(ENotificationMessage msg) {
        if (this.mFeedState == EFeedState.DOWN) {
            sLogger.info(String.format("%s publisher %d, feed %d: unable to publish %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.key(), this.mScope}));
        } else {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s publisher %d, feed %d: publishing %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.key(), this.mScope}));
            }
            ((ENotifySubject)this.mSubject).publish(msg, this);
        }
    }
}

