/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedList;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.EPublishFeed;
import net.sf.eBus.client.ERemoteApp;
import net.sf.eBus.client.ESubject;
import net.sf.eBus.client.ESubscribeFeed;
import net.sf.eBus.client.sysmessages.AdMessage;
import net.sf.eBus.client.sysmessages.SystemMessageType;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageHeader;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.util.TernarySearchTree;

final class ENotifySubject
extends ESubject {
    private static final Logger sLogger = Logger.getLogger(ENotifySubject.class.getName());
    private final EFeedList<EPublishFeed> mAdvertisers = new EFeedList();
    private final EFeedList<ESubscribeFeed> mSubscribers = new EFeedList();

    ENotifySubject(EMessageKey key) {
        super(key);
    }

    @Override
    EMessageHeader localAd(AdMessage.AdStatus adStatus) {
        EMessageHeader retval = null;
        if (this.mAdvertisers.supports(EClient.ClientLocation.REMOTE) > 0) {
            EFeedState fs = this.mAdvertisers.feedState(EClient.ClientLocation.REMOTE);
            retval = new EMessageHeader(SystemMessageType.AD.keyId(), -1, -1, (EMessage)((AdMessage.Builder)AdMessage.builder().messageKey(this.mKey)).adStatus(adStatus).adMessageType(EMessage.MessageType.NOTIFICATION).feedState(fs).build());
        }
        return retval;
    }

    synchronized EFeedState advertise(EPublishFeed feed) {
        EClient.ClientLocation location = feed.location();
        EFeed.FeedScope scope = feed.scope();
        int activationCount = this.mSubscribers.isSupportedBy(scope);
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: adding %s client/%s scope advertiser %d, feed %d.", new Object[]{this.mKey, location, scope, feed.clientId(), feed.feedId()}));
        }
        this.mAdvertisers.add(feed);
        if (location == EClient.ClientLocation.LOCAL && (scope == EFeed.FeedScope.LOCAL_AND_REMOTE || scope == EFeed.FeedScope.REMOTE_ONLY) && this.mAdvertisers.supports(EFeed.FeedScope.REMOTE_ONLY) == 1) {
            EFeedState fs = this.mAdvertisers.feedState(EClient.ClientLocation.REMOTE);
            ERemoteApp.forwardAll(new EMessageHeader(SystemMessageType.AD.keyId(), -1, -1, (EMessage)((AdMessage.Builder)AdMessage.builder().messageKey(this.mKey)).adStatus(AdMessage.AdStatus.ADD).adMessageType(EMessage.MessageType.NOTIFICATION).feedState(fs).build()));
        }
        return feed.updateActivate(activationCount);
    }

    synchronized void unadvertise(EPublishFeed feed) {
        EClient.ClientLocation location = feed.location();
        EFeed.FeedScope scope = feed.scope();
        int feedCount = this.mAdvertisers.remove(feed);
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: removing %s client/%s scope advertiser %d, feed %d.", new Object[]{this.mKey, location, scope, feed.clientId(), feed.feedId()}));
        }
        if (feed.feedState() == EFeedState.UP) {
            this.mSubscribers.updateCount(feed, EFeedState.DOWN);
        }
        if (location == EClient.ClientLocation.LOCAL && (scope == EFeed.FeedScope.LOCAL_AND_REMOTE || scope == EFeed.FeedScope.REMOTE_ONLY) && feedCount == 0) {
            ERemoteApp.forwardAll(new EMessageHeader(SystemMessageType.AD.keyId(), -1, -1, (EMessage)((AdMessage.Builder)AdMessage.builder().messageKey(this.mKey)).adStatus(AdMessage.AdStatus.REMOVE).adMessageType(EMessage.MessageType.NOTIFICATION).feedState(EFeedState.DOWN).build()));
        }
    }

    synchronized void updateFeedState(EPublishFeed feed) {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: updating %s publisher %d %s to %s.", new Object[]{this.mKey, feed.location(), feed.clientId(), feed.key(), feed.publishState()}));
        }
        this.mSubscribers.updateCount(feed, feed.publishState());
    }

    synchronized void publish(ENotificationMessage msg, EPublishFeed feed) {
        EClient.ClientLocation location = feed.location();
        EFeed.FeedScope scope = feed.scope();
        Iterator<ESubscribeFeed> fit = this.mSubscribers.iterator(scope);
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: %s/%s publisher %d, feed %d message:%n%s", new Object[]{this.mKey, location, scope, feed.clientId(), feed.feedId(), feed.feedState(), msg}));
        } else if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("%s: %s/%s publisher %d, feed %d message.", new Object[]{this.mKey, location, scope, feed.clientId(), feed.feedId(), feed.feedState()}));
        }
        while (fit.hasNext()) {
            fit.next().notify(msg);
        }
    }

    synchronized void subscribe(ESubscribeFeed f) {
        EClient.ClientLocation location = f.location();
        EFeed.FeedScope scope = f.scope();
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: adding %s/%s subscriber %d, feed %d.", new Object[]{this.mKey, location, scope, f.clientId(), f.feedId()}));
        }
        this.mSubscribers.add(f);
        f.updateActivate(this.mAdvertisers.updateCount(f, EFeedState.UP));
    }

    synchronized void unsubscribe(ESubscribeFeed feed) {
        EClient.ClientLocation location = feed.location();
        EFeed.FeedScope scope = feed.scope();
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: removing %s/%s subscriber %d, feed %d.", new Object[]{this.mKey, location, scope, feed.clientId(), feed.feedId()}));
        }
        this.mSubscribers.remove(feed);
        this.mAdvertisers.updateCount(feed, EFeedState.DOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ENotifySubject findOrCreate(EMessageKey key) {
        ENotifySubject retval;
        TernarySearchTree ternarySearchTree = sSubjects;
        synchronized (ternarySearchTree) {
            String keyString = key.keyString();
            retval = (ENotifySubject)sSubjects.get((Object)keyString);
            if (retval == null) {
                retval = new ENotifySubject(key);
                sSubjects.put((CharSequence)keyString, (Object)retval);
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.finest(String.format("%s: created notification subject.", key));
                }
            }
        }
        return retval;
    }
}

