/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.ESingleFeed;
import net.sf.eBus.client.ESubject;

public abstract class ENotifyFeed
extends ESingleFeed {
    private static final Logger sLogger = Logger.getLogger(ENotifyFeed.class.getName());

    protected ENotifyFeed(EClient client, EFeed.FeedScope scope, ESingleFeed.FeedType feedType, ESubject subject) {
        super(client, scope, feedType, subject);
    }

    abstract void update(EFeedState var1);

    EFeedState updateActivate(int actCount) {
        EFeedState retval;
        this.mActivationCount += actCount;
        if (this.mActivationCount < 0) {
            sLogger.warning(String.format("%s client %d, feed %d: negative activation count (%d), setting to zero (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.key(), this.mActivationCount, this.mScope}));
            this.mActivationCount = 0;
        }
        EFeedState eFeedState = retval = this.mActivationCount == 0 ? EFeedState.DOWN : EFeedState.UP;
        if (retval != this.mFeedState) {
            this.update(retval);
        }
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s client %d, feed %d: %s feed state=%s, activation count=%d (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.key(), retval, this.mActivationCount, this.mScope}));
        }
        return retval;
    }
}

