/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.ECondition;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EMultiFeed;
import net.sf.eBus.client.ESubscribeFeed;
import net.sf.eBus.client.ESubscriber;
import net.sf.eBus.client.FeedStatusCallback;
import net.sf.eBus.client.IESubscribeFeed;
import net.sf.eBus.client.NotifyCallback;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.util.regex.Pattern;

public final class EMultiSubscribeFeed
extends EMultiFeed<ENotificationMessage, ESubscribeFeed>
implements IESubscribeFeed {
    private static final EMultiFeed.SubordinateFeedFactory<ESubscriber, ESubscribeFeed> sSubFactory = (cl, key, sc, cond, loc) -> ESubscribeFeed.open(cl, key, sc, cond, loc, true);
    private static final EMultiFeed.MultiFeedFactory<EMultiSubscribeFeed, ENotificationMessage, ESubscribeFeed> sMultiFactory = (cl, mc, sc, cond, feeds) -> new EMultiSubscribeFeed(cl, mc, sc, cond, feeds);
    private FeedStatusCallback<IESubscribeFeed> mStatusCallback = null;
    private NotifyCallback mNotifyCallback = null;

    private EMultiSubscribeFeed(EClient client, Class<? extends ENotificationMessage> mc, EFeed.FeedScope scope, ECondition condition, Map<CharSequence, ESubscribeFeed> feeds) {
        super(client, mc, scope, condition, feeds);
    }

    @Override
    public void statusCallback(FeedStatusCallback<IESubscribeFeed> cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("subscription in place");
        }
        this.mStatusCallback = cb;
    }

    @Override
    public void notifyCallback(NotifyCallback cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("subscription in place");
        }
        this.mNotifyCallback = cb;
    }

    @Override
    public void subscribe() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s multi-key subscriber %d: subscribing (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mScope}));
            }
            this.mFeeds.values().stream().map(feed -> {
                feed.statusCallback(this.mStatusCallback);
                feed.notifyCallback(this.mNotifyCallback);
                return feed;
            }).forEachOrdered(ESubscribeFeed::subscribe);
            this.mInPlace = true;
        }
    }

    @Override
    public void unsubscribe() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s multi-key subscriber %d: unsubscribing (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mScope}));
            }
            this.mFeeds.values().stream().forEachOrdered(ESubscribeFeed::unsubscribe);
            this.mInPlace = false;
        }
    }

    @Override
    protected ESubscribeFeed createFeed(EMessageKey key) {
        ESubscriber subscriber = (ESubscriber)this.mEClient.target();
        return ESubscribeFeed.open(subscriber, key, this.mScope, this.mCondition, EClient.ClientLocation.LOCAL, true);
    }

    @Override
    protected void putFeedInPlace(ESubscribeFeed feed) {
        feed.statusCallback(this.mStatusCallback);
        feed.notifyCallback(this.mNotifyCallback);
        feed.subscribe();
    }

    public static EMultiSubscribeFeed open(ESubscriber client, Class<? extends ENotificationMessage> mc, List<String> subjects, EFeed.FeedScope scope, ECondition condition) {
        return EMultiSubscribeFeed.openList(client, mc, subjects, scope, condition, sSubFactory, sMultiFactory);
    }

    public static EMultiSubscribeFeed open(ESubscriber client, Class<? extends ENotificationMessage> mc, Pattern query, EFeed.FeedScope scope, ECondition condition) {
        return EMultiSubscribeFeed.openQuery(client, mc, query, scope, condition, sSubFactory, sMultiFactory);
    }
}

