/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EMultiFeed;
import net.sf.eBus.client.ERequestFeed;
import net.sf.eBus.client.ERequestor;
import net.sf.eBus.client.FeedStatusCallback;
import net.sf.eBus.client.IERequestFeed;
import net.sf.eBus.client.ReplyCallback;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.ERequestMessage;
import net.sf.eBus.util.regex.Pattern;

public final class EMultiRequestFeed
extends EMultiFeed<ERequestMessage, ERequestFeed>
implements IERequestFeed {
    private static final EMultiFeed.SubordinateFeedFactory<ERequestor, ERequestFeed> sSubFactory = (cl, key, sc, cond, loc) -> ERequestFeed.open(cl, key, sc, loc, true);
    private static final EMultiFeed.MultiFeedFactory<EMultiRequestFeed, ERequestMessage, ERequestFeed> sMultiFactory = (cl, mc, sc, cond, feeds) -> {
        Map<Class<? extends EMessage>, ReplyCallback> cbs = ERequestFeed.createReplyCallbacks(mc);
        return new EMultiRequestFeed(cl, mc, sc, feeds, cbs);
    };
    private FeedStatusCallback<ERequestFeed> mStatusCallback = null;
    private final Map<Class<? extends EMessage>, ReplyCallback> mReplyCallbacks;

    private EMultiRequestFeed(EClient client, Class<? extends ERequestMessage> mc, EFeed.FeedScope scope, Map<CharSequence, ERequestFeed> feeds, Map<Class<? extends EMessage>, ReplyCallback> cbs) {
        super(client, mc, scope, null, feeds);
        this.mReplyCallbacks = cbs;
    }

    @Override
    public void statusCallback(FeedStatusCallback<ERequestFeed> cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("subscription in place");
        }
        this.mStatusCallback = cb;
    }

    @Override
    public void replyCallback(ReplyCallback cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("subscription in place");
        }
        this.mReplyCallbacks.entrySet().forEach(entry -> entry.setValue(cb));
    }

    @Override
    public void replyCallback(Class<? extends EReplyMessage> mc, ReplyCallback cb) {
        Objects.requireNonNull(mc, "mc is null");
        if (!this.mReplyCallbacks.containsKey(mc)) {
            throw new IllegalArgumentException(mc.getSimpleName() + " is not a " + this.mMsgClass.getSimpleName() + " reply");
        }
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("subscription in place");
        }
        this.mReplyCallbacks.put(mc, cb);
    }

    @Override
    protected ERequestFeed createFeed(EMessageKey key) {
        ERequestor requestor = (ERequestor)this.mEClient.target();
        return ERequestFeed.open(requestor, key, this.mScope, EClient.ClientLocation.LOCAL, true);
    }

    @Override
    protected void putFeedInPlace(ERequestFeed feed) {
        feed.statusCallback(this.mStatusCallback);
        feed.replyCallbacks(this.mReplyCallbacks);
        feed.subscribe();
    }

    public static EMultiRequestFeed open(ERequestor client, Class<? extends ERequestMessage> mc, List<String> subjects, EFeed.FeedScope scope) {
        return EMultiRequestFeed.openList(client, mc, subjects, scope, null, sSubFactory, sMultiFactory);
    }

    public static EMultiRequestFeed open(ERequestor client, Class<? extends ERequestMessage> mc, Pattern query, EFeed.FeedScope scope) {
        return EMultiRequestFeed.openQuery(client, mc, query, scope, null, sSubFactory, sMultiFactory);
    }

    @Override
    public void subscribe() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s multi-key requestor %d: subscribing (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mScope}));
            }
            this.mFeeds.values().stream().map(feed -> {
                feed.statusCallback(this.mStatusCallback);
                feed.replyCallbacks(this.mReplyCallbacks);
                return feed;
            }).forEachOrdered(ERequestFeed::subscribe);
            this.mInPlace = true;
        }
    }

    @Override
    public void unsubscribe() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s multi-key requestor %d: unsubscribing (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mScope}));
            }
            this.mFeeds.values().stream().forEachOrdered(ERequestFeed::unsubscribe);
            this.mInPlace = false;
        }
    }

    public ERequestFeed.ERequest request(ERequestMessage msg) {
        Objects.requireNonNull(msg, "msg is null");
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            throw new IllegalStateException("feed not subscribed");
        }
        String subject = msg.key().subject();
        if (!this.mFeeds.containsKey(subject)) {
            throw new IllegalArgumentException(subject + " is an unknown feed");
        }
        return ((ERequestFeed)this.mFeeds.get(subject)).doRequest(msg);
    }
}

