/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import net.sf.eBus.client.CancelRequestCallback;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.ECondition;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.EMultiFeed;
import net.sf.eBus.client.EReplier;
import net.sf.eBus.client.EReplyFeed;
import net.sf.eBus.client.IEReplyFeed;
import net.sf.eBus.client.RequestCallback;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ERequestMessage;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;
import net.sf.eBus.util.regex.Pattern;

public final class EMultiReplyFeed
extends EMultiFeed<ERequestMessage, EReplyFeed>
implements IEReplyFeed {
    private static final EMultiFeed.SubordinateFeedFactory<EReplier, EReplyFeed> sSubFactory = (cl, key, sc, cond, loc) -> {
        MessageType mt = (MessageType)DataType.findType(key.messageClass());
        return EReplyFeed.open(cl, key, sc, cond, loc, mt, true);
    };
    private static final EMultiFeed.MultiFeedFactory<EMultiReplyFeed, ERequestMessage, EReplyFeed> sMultiFactory = (cl, mc, sc, cond, feeds) -> {
        MessageType mt = (MessageType)DataType.findType(mc);
        return new EMultiReplyFeed(cl, mc, sc, cond, feeds, mt);
    };
    private EFeedState mReplyState;
    private final MessageType mDataType;
    private RequestCallback mRequestCallback;
    private CancelRequestCallback mCancelCallback;

    private EMultiReplyFeed(EClient client, Class<? extends ERequestMessage> mc, EFeed.FeedScope scope, ECondition condition, Map<CharSequence, EReplyFeed> feeds, MessageType dataType) {
        super(client, mc, scope, condition, feeds);
        this.mDataType = dataType;
        this.mReplyState = EFeedState.UNKNOWN;
        this.mRequestCallback = null;
        this.mCancelCallback = null;
    }

    @Override
    public boolean isAdvertised() {
        return this.mIsActive.get() && this.mInPlace;
    }

    @Override
    public void requestCallback(RequestCallback cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("advertisement in place");
        }
        this.mRequestCallback = cb;
    }

    @Override
    public void cancelRequestCallback(CancelRequestCallback cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("advertisement in place");
        }
        this.mCancelCallback = cb;
    }

    @Override
    public void advertise() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s multi-key replier %d: advertising (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mScope}));
            }
            this.mFeeds.values().stream().map(feed -> {
                feed.requestCallback(this.mRequestCallback);
                feed.cancelRequestCallback(this.mCancelCallback);
                return feed;
            }).forEachOrdered(EReplyFeed::advertise);
            this.mInPlace = true;
        }
    }

    @Override
    public void unadvertise() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s multi-key replier %d: unadvertising (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mScope}));
            }
            this.mFeeds.values().stream().forEachOrdered(EReplyFeed::unadvertise);
            this.mReplyState = EFeedState.UNKNOWN;
            this.mInPlace = false;
        }
    }

    @Override
    public void updateFeedState(EFeedState update) {
        Objects.requireNonNull(update, "update is null");
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            throw new IllegalStateException("feed not advertised");
        }
        if (update != this.mReplyState) {
            this.mReplyState = update;
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s multi-key replier %d: setting feed state to %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), update, this.mScope}));
            }
            this.mFeeds.values().forEach(feed -> feed.updateFeedState(update));
        }
    }

    @Override
    protected EReplyFeed createFeed(EMessageKey key) {
        EReplier replier = (EReplier)this.mEClient.target();
        return EReplyFeed.open(replier, key, this.mScope, this.mCondition, EClient.ClientLocation.LOCAL, this.mDataType, true);
    }

    @Override
    protected void putFeedInPlace(EReplyFeed feed) {
        feed.cancelRequestCallback(this.mCancelCallback);
        feed.requestCallback(this.mRequestCallback);
        feed.advertise();
        feed.updateFeedState(this.mReplyState);
    }

    public EFeedState replyState() {
        return this.mReplyState;
    }

    public static EMultiReplyFeed open(EReplier client, Class<? extends ERequestMessage> mc, List<String> subjects, EFeed.FeedScope scope, ECondition condition) {
        return EMultiReplyFeed.openList(client, mc, subjects, scope, condition, sSubFactory, sMultiFactory);
    }

    public static EMultiReplyFeed open(EReplier client, Class<? extends ERequestMessage> mc, Pattern query, EFeed.FeedScope scope, ECondition condition) {
        return EMultiReplyFeed.openQuery(client, mc, query, scope, condition, sSubFactory, sMultiFactory);
    }
}

