/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.EMultiFeed;
import net.sf.eBus.client.EPublishFeed;
import net.sf.eBus.client.EPublisher;
import net.sf.eBus.client.FeedStatusCallback;
import net.sf.eBus.client.IEPublishFeed;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.util.regex.Pattern;

public final class EMultiPublishFeed
extends EMultiFeed<ENotificationMessage, EPublishFeed>
implements IEPublishFeed {
    private static final EMultiFeed.SubordinateFeedFactory<EPublisher, EPublishFeed> sSubFactory = (cl, key, sc, cond, loc) -> EPublishFeed.open(cl, key, sc, loc, true);
    private static final EMultiFeed.MultiFeedFactory<EMultiPublishFeed, ENotificationMessage, EPublishFeed> sMultiFactory = (cl, mc, sc, cond, feeds) -> new EMultiPublishFeed(cl, mc, sc, feeds);
    private EFeedState mPublishState = EFeedState.UNKNOWN;
    private FeedStatusCallback<IEPublishFeed> mStatusCallback = null;

    private EMultiPublishFeed(EClient client, Class<? extends ENotificationMessage> mc, EFeed.FeedScope scope, Map<CharSequence, EPublishFeed> feeds) {
        super(client, mc, scope, null, feeds);
    }

    @Override
    public boolean isAdvertised() {
        return this.mIsActive.get() && this.mInPlace;
    }

    @Override
    public EFeedState publishState() {
        return this.mPublishState;
    }

    @Override
    public boolean isFeedUp(String subject) {
        Objects.requireNonNull(subject, "subject is null");
        if (subject.isEmpty()) {
            throw new IllegalArgumentException("subject is an empty string");
        }
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        EPublishFeed feed = (EPublishFeed)this.mFeeds.get(subject);
        return feed != null && feed.isFeedUp();
    }

    @Override
    public void statusCallback(FeedStatusCallback<IEPublishFeed> cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("advertisement in place");
        }
        this.mStatusCallback = cb;
    }

    @Override
    public void advertise() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s multi-key publisher %d: advertising (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mScope}));
            }
            this.mFeeds.values().stream().map(feed -> {
                feed.statusCallback(this.mStatusCallback);
                return feed;
            }).forEachOrdered(EPublishFeed::advertise);
            this.mInPlace = true;
        }
    }

    @Override
    public void unadvertise() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s multi-key publisher %d: unadvertising (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mScope}));
            }
            this.mFeeds.values().stream().forEachOrdered(EPublishFeed::unadvertise);
            this.mPublishState = EFeedState.UNKNOWN;
            this.mInPlace = false;
        }
    }

    @Override
    public void updateFeedState(EFeedState update) {
        Objects.requireNonNull(update, "update is null");
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            throw new IllegalStateException("feed not advertised");
        }
        if (update != this.mPublishState) {
            this.mPublishState = update;
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s multi-key publisher %d: setting feed state to %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), update, this.mScope}));
            }
            this.mFeeds.values().forEach(feed -> feed.updateFeedState(update));
        }
    }

    @Override
    public void publish(ENotificationMessage msg) {
        Objects.requireNonNull(msg, "msg is null");
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            throw new IllegalStateException("feed not advertised");
        }
        if (this.mPublishState != EFeedState.UP) {
            throw new IllegalStateException("publish state is down");
        }
        String subject = msg.key().subject();
        if (!this.mFeeds.containsKey(subject)) {
            throw new IllegalArgumentException(subject + " is an unknown feed");
        }
        ((EPublishFeed)this.mFeeds.get(subject)).doPublish(msg);
    }

    @Override
    protected EPublishFeed createFeed(EMessageKey key) {
        EPublisher publisher = (EPublisher)this.mEClient.target();
        return EPublishFeed.open(publisher, key, this.mScope, EClient.ClientLocation.LOCAL, true);
    }

    @Override
    protected void putFeedInPlace(EPublishFeed feed) {
        feed.statusCallback(this.mStatusCallback);
        feed.advertise();
        feed.updateFeedState(this.mPublishState);
    }

    public static EMultiPublishFeed open(EPublisher client, Class<? extends ENotificationMessage> mc, List<String> subjects, EFeed.FeedScope scope) {
        return EMultiPublishFeed.openList(client, mc, subjects, scope, null, sSubFactory, sMultiFactory);
    }

    public static EMultiPublishFeed open(EPublisher client, Class<? extends ENotificationMessage> mc, Pattern query, EFeed.FeedScope scope) {
        return EMultiPublishFeed.openQuery(client, mc, query, scope, null, sSubFactory, sMultiFactory);
    }
}

