/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.ECondition;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.EObject;
import net.sf.eBus.client.ESingleFeed;
import net.sf.eBus.client.ESubject;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.util.TernarySearchTree;
import net.sf.eBus.util.regex.Pattern;

public abstract class EMultiFeed<C extends EMessage, F extends ESingleFeed>
extends EFeed {
    public static final String MULTIFEED_SUBJECT = "__MULTIFEED__";
    protected static final Logger sLogger = Logger.getLogger(EFeed.class.getName());
    protected final Class<? extends C> mMsgClass;
    protected final ECondition mCondition;
    protected final Map<CharSequence, F> mFeeds;

    protected EMultiFeed(EClient client, Class<? extends C> msgClass, EFeed.FeedScope scope, ECondition condition, Map<CharSequence, F> feeds) {
        super(client, scope);
        this.mMsgClass = msgClass;
        this.mFeeds = feeds;
        this.mCondition = condition;
    }

    protected abstract F createFeed(EMessageKey var1);

    protected abstract void putFeedInPlace(F var1);

    @Override
    protected final void inactivate() {
        this.mFeeds.values().forEach(EFeed::close);
        this.mFeeds.clear();
    }

    public final Class<? extends C> messageClass() {
        return this.mMsgClass;
    }

    @Override
    public final boolean isFeedUp() {
        Iterator<F> fit = this.mFeeds.values().iterator();
        boolean retcode = true;
        while (fit.hasNext() && retcode) {
            retcode = ((ESingleFeed)fit.next()).isFeedUp();
        }
        return retcode;
    }

    @Override
    public final EMessageKey key() {
        return new EMessageKey(this.mMsgClass, MULTIFEED_SUBJECT);
    }

    public final EFeedState feedState(String subject) {
        Objects.requireNonNull(subject, "subject is null");
        if (subject.isEmpty()) {
            throw new IllegalArgumentException("subject is an empty string");
        }
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        ESingleFeed feed = (ESingleFeed)this.mFeeds.get(subject);
        return feed == null ? EFeedState.UNKNOWN : feed.feedState();
    }

    public final List<String> subjects() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        ArrayList<String> retval = new ArrayList<String>(this.mFeeds.size());
        this.mFeeds.values().forEach(feed -> retval.add(feed.key().subject()));
        return retval;
    }

    public final List<EMessageKey> keys() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        ArrayList<EMessageKey> retval = new ArrayList<EMessageKey>(this.mFeeds.size());
        this.mFeeds.values().forEach(feed -> retval.add(feed.key()));
        return retval;
    }

    public final void addFeed(String subject) {
        Objects.requireNonNull(subject, "subject is null");
        if (subject.isEmpty()) {
            throw new IllegalArgumentException("subject is an empty string");
        }
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mFeeds.containsKey(subject)) {
            F feed = this.createFeed(new EMessageKey(this.mMsgClass, subject));
            this.mFeeds.put(subject, feed);
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.fine(String.format("%s multi-key feed %d (%s): adding feed %s.", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mScope, subject}));
            }
            if (this.mInPlace) {
                this.putFeedInPlace(feed);
            }
        }
    }

    public final void addAllFeeds(List<String> subjects) {
        Objects.requireNonNull(subjects, "subjects is null");
        if (subjects.contains(null)) {
            throw new NullPointerException("subjects contains a null value");
        }
        if (subjects.contains("")) {
            throw new IllegalArgumentException("subjects contains an empty string");
        }
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        this.addFeeds(subjects);
    }

    public final void addAllFeeds(Pattern query) {
        Objects.requireNonNull(query, "query is null");
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        Pattern keyPattern = Pattern.compile((String)(this.mMsgClass.getName() + '/' + query.pattern()));
        ArrayList<String> subjects = new ArrayList<String>();
        ESubject.findKeys(keyPattern).forEach(key -> subjects.add(key.subject()));
        this.addFeeds(subjects);
    }

    public final void closeFeed(String subject) {
        Objects.requireNonNull(subject, "subject is null");
        if (subject.isEmpty()) {
            throw new IllegalArgumentException("subject is an empty string");
        }
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mFeeds.containsKey(subject)) {
            ((ESingleFeed)this.mFeeds.remove(subject)).close();
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.fine(String.format("%s multi-key feed %d (%s): removed feed %s.", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mScope, subject}));
            }
        }
    }

    protected static <R extends EObject, C extends EMessage, F extends ESingleFeed, M extends EMultiFeed<C, F>> M openList(R client, Class<? extends C> mc, List<String> subjects, EFeed.FeedScope scope, ECondition condition, SubordinateFeedFactory<R, F> subFactory, MultiFeedFactory<M, C, F> multiFactory) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(mc, "mc is null");
        Objects.requireNonNull(subjects, "subjects is null");
        Objects.requireNonNull(scope, "scope is null");
        if (subjects.contains(null)) {
            throw new NullPointerException("subjects contains a null value");
        }
        if (subjects.contains("")) {
            throw new IllegalArgumentException("subjects contains an empty string");
        }
        return EMultiFeed.openMultiFeed(client, mc, subjects, scope, condition, subFactory, multiFactory);
    }

    protected static <R extends EObject, C extends EMessage, F extends ESingleFeed, M extends EMultiFeed<C, F>> M openQuery(R client, Class<? extends C> mc, Pattern query, EFeed.FeedScope scope, ECondition condition, SubordinateFeedFactory<R, F> subFactory, MultiFeedFactory<M, C, F> multiFactory) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(mc, "mc is null");
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(scope, "scope is null");
        Pattern keyPattern = Pattern.compile((String)(mc.getName() + '/' + query.pattern()));
        ArrayList<String> subjects = new ArrayList<String>();
        ESubject.findKeys(keyPattern).forEach(key -> subjects.add(key.subject()));
        return EMultiFeed.openMultiFeed(client, mc, subjects, scope, condition, subFactory, multiFactory);
    }

    private static <R extends EObject, C extends EMessage, F extends ESingleFeed, M extends EMultiFeed<C, F>> M openMultiFeed(R client, Class<? extends C> mc, List<String> subjects, EFeed.FeedScope scope, ECondition condition, SubordinateFeedFactory<R, F> subFactory, MultiFeedFactory<M, C, F> multiFactory) {
        EClient.ClientLocation loc = EClient.ClientLocation.LOCAL;
        EClient eClient = EClient.findOrCreateClient(client, loc);
        TernarySearchTree feeds = new TernarySearchTree();
        subjects.forEach(arg_0 -> EMultiFeed.lambda$openMultiFeed$4((Map)feeds, subFactory, client, mc, scope, condition, loc, arg_0));
        M retval = multiFactory.newFeed(eClient, mc, scope, condition, (Map<CharSequence, F>)feeds);
        eClient.addFeed((EFeed)retval);
        return retval;
    }

    private void addFeeds(List<String> subjects) {
        subjects.stream().filter(s -> !this.mFeeds.containsKey(s)).forEachOrdered(s -> {
            F feed = this.createFeed(new EMessageKey((Class<? extends EMessage>)this.mMsgClass, (String)s));
            this.mFeeds.put((CharSequence)s, feed);
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.fine(String.format("%s multi-key feed %d (%s): adding feed %s.", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mScope, s}));
            }
            if (this.mInPlace) {
                this.putFeedInPlace(feed);
            }
        });
    }

    private static /* synthetic */ void lambda$openMultiFeed$4(Map feeds, SubordinateFeedFactory subFactory, EObject client, Class mc, EFeed.FeedScope scope, ECondition condition, EClient.ClientLocation loc, String subject) {
        ESingleFeed cfr_ignored_0 = (ESingleFeed)feeds.put(subject, subFactory.newFeed(client, new EMessageKey(mc, subject), scope, condition, loc));
    }

    @FunctionalInterface
    protected static interface MultiFeedFactory<M extends EMultiFeed, C extends EMessage, F extends EFeed> {
        public M newFeed(EClient var1, Class<? extends C> var2, EFeed.FeedScope var3, ECondition var4, Map<CharSequence, F> var5);
    }

    @FunctionalInterface
    protected static interface SubordinateFeedFactory<R extends EObject, F extends ESingleFeed> {
        public F newFeed(R var1, EMessageKey var2, EFeed.FeedScope var3, ECondition var4, EClient.ClientLocation var5);
    }
}

