/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.ESingleFeed;

class EFeedList<T extends ESingleFeed> {
    private static final int ZONE_COUNT = EClient.ClientLocation.values().length;
    private static final int FEED_LIST_INITIAL_CAPACITY = 64;
    private static final Logger _logger = Logger.getLogger(EFeedList.class.getName());
    private final List<T> _feeds = new ArrayList<T>(64);
    private final ListZone<T>[] _zones = new ListZone[ZONE_COUNT];

    EFeedList() {
        EClient.ClientLocation[] zones = EClient.ClientLocation.values();
        for (int index = 0; index < ZONE_COUNT; ++index) {
            this._zones[index] = new ListZone(zones[index], this._feeds);
        }
    }

    T feed(int index) {
        return (T)((ESingleFeed)this._feeds.get(index));
    }

    int activationCount(EClient.ClientLocation loc) {
        return this._zones[loc.ordinal()].activationCount();
    }

    int supports(EFeed.FeedScope scope) {
        return (int)this._feeds.stream().filter(feed -> feed.scope() == EFeed.FeedScope.LOCAL_AND_REMOTE || feed.scope() == EFeed.FeedScope.REMOTE_ONLY).count();
    }

    int supports(EClient.ClientLocation location) {
        return (int)this._feeds.stream().filter(feed -> feed.scope().supports(location)).count();
    }

    int isSupportedBy(EFeed.FeedScope scope) {
        List<EClient.ClientLocation> locations = scope.locations();
        int beginIndex = this._zones[locations.get(0).ordinal()].beginIndex();
        int endIndex = this._zones[locations.get(locations.size() - 1).ordinal()].endIndex();
        return endIndex - beginIndex;
    }

    EFeedState feedState(EClient.ClientLocation loc) {
        Iterator<T> fit = this._feeds.iterator();
        EFeedState retval = EFeedState.DOWN;
        while (fit.hasNext() && retval == EFeedState.DOWN) {
            ESingleFeed feed = (ESingleFeed)fit.next();
            if (!feed.scope().supports(loc)) continue;
            retval = feed.feedState();
        }
        return retval;
    }

    Iterator<T> iterator(EFeed.FeedScope scope) {
        List<EClient.ClientLocation> locations = scope.locations();
        int beginIndex = this._zones[locations.get(0).ordinal()].beginIndex();
        int endIndex = this._zones[locations.get(locations.size() - 1).ordinal()].endIndex();
        ListIterator<T> lit = this._feeds.listIterator(beginIndex);
        int size = endIndex - beginIndex;
        return new EFeedListIterator(lit, size);
    }

    int add(T feed) {
        int zoneIndex = ((EFeed)feed).location().ordinal();
        int retval = ((ListZone)this._zones[zoneIndex]).add(feed);
        ++zoneIndex;
        while (zoneIndex < ZONE_COUNT) {
            ((ListZone)this._zones[zoneIndex]).shift(1);
            ++zoneIndex;
        }
        return retval;
    }

    int remove(T feed) {
        int zoneIndex = ((EFeed)feed).location().ordinal();
        int retval = ((ListZone)this._zones[zoneIndex]).remove(feed);
        ++zoneIndex;
        while (zoneIndex < ZONE_COUNT) {
            ((ListZone)this._zones[zoneIndex]).shift(-1);
            ++zoneIndex;
        }
        return retval;
    }

    int updateCount(ESingleFeed feed, EFeedState fs) {
        Iterator<T> fit = this.iterator(feed.scope());
        EClient.ClientLocation location = feed.location();
        int retval = 0;
        while (fit.hasNext()) {
            retval += ((ESingleFeed)fit.next()).updateActivation(location, fs);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(String.format("FeedList.updateCount([id=%d, key=%s, location=%s, scope=%s], %s) -> %d", new Object[]{feed.feedId(), feed.key(), location, feed.scope(), fs, retval}));
        }
        return retval;
    }

    public static final class EFeedListIterator<T extends ESingleFeed>
    implements Iterator<T> {
        private final ListIterator<T> mIterator;
        private int mRemaining;

        private EFeedListIterator(ListIterator<T> lit, int feedCount) {
            this.mIterator = lit;
            this.mRemaining = feedCount;
        }

        @Override
        public boolean hasNext() {
            return this.mRemaining > 0;
        }

        @Override
        public T next() throws NoSuchElementException {
            if (this.mRemaining == 0) {
                throw new NoSuchElementException();
            }
            --this.mRemaining;
            return (T)((ESingleFeed)this.mIterator.next());
        }
    }

    private static final class ListZone<T extends ESingleFeed> {
        private final EClient.ClientLocation mLocation;
        private final List<T> mFeeds;
        private int mBeginIndex;
        private int mEndIndex;

        private ListZone(EClient.ClientLocation location, List<T> feeds) {
            this.mLocation = location;
            this.mFeeds = feeds;
            this.mBeginIndex = 0;
            this.mEndIndex = 0;
        }

        public EClient.ClientLocation location() {
            return this.mLocation;
        }

        public boolean isEmpty() {
            return this.mEndIndex == this.mBeginIndex;
        }

        public int beginIndex() {
            return this.mBeginIndex;
        }

        public int endIndex() {
            return this.mEndIndex;
        }

        public int activationCount() {
            int retval = 0;
            for (int i = this.mBeginIndex; i < this.mEndIndex; ++i) {
                retval += ((ESingleFeed)this.mFeeds.get(i)).activationCount();
            }
            return retval;
        }

        private int add(T feed) {
            this.mFeeds.add(this.mEndIndex, feed);
            ((ESingleFeed)feed).feedIndex(this.mEndIndex);
            ++this.mEndIndex;
            return this.mEndIndex - this.mBeginIndex;
        }

        private int remove(T feed) {
            int index = ((ESingleFeed)feed).feedIndex();
            if (index >= 0 && index < this.mFeeds.size()) {
                this.mFeeds.remove(index);
                --this.mEndIndex;
                while (index < this.mEndIndex) {
                    ((ESingleFeed)this.mFeeds.get(index)).feedIndex(index);
                    ++index;
                }
            }
            return this.mEndIndex - this.mBeginIndex;
        }

        private void shift(int increment) {
            this.mBeginIndex += increment;
            this.mEndIndex += increment;
            for (int index = this.mBeginIndex; index < this.mEndIndex; ++index) {
                ((ESingleFeed)this.mFeeds.get(index)).feedIndex(index);
            }
        }
    }
}

