/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.ECondition;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.EObject;
import net.sf.eBus.client.ESubject;
import net.sf.eBus.client.FeedStatusCallback;
import net.sf.eBus.client.IEFeed;
import net.sf.eBus.client.IESubscribeFeed;
import net.sf.eBus.client.NotifyCallback;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.ERequestMessage;
import net.sf.eBus.messages.ESystemMessage;
import net.sf.eBus.util.regex.Pattern;

public abstract class EFeed
implements IEFeed {
    public static final ECondition NO_CONDITION = msg -> true;
    protected static final String NOTIFY_METHOD = "notify";
    private static final Pattern ALL_SUBJECTS = Pattern.compile((String)".+");
    private static final Logger sLogger = Logger.getLogger(EFeed.class.getName());
    protected final EClient mEClient;
    protected final FeedScope mScope;
    protected final AtomicBoolean mIsActive;
    protected boolean mInPlace;
    protected final int mFeedId;
    protected EFeedState mFeedState;

    protected EFeed(EClient client, FeedScope feedScope) {
        this.mEClient = client;
        this.mScope = feedScope;
        this.mFeedId = client.nextFeedId();
        this.mIsActive = new AtomicBoolean(true);
        this.mInPlace = false;
        this.mFeedState = EFeedState.UNKNOWN;
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("Client %d, Feed %d: opening.", client.clientId(), this.mFeedId));
        }
    }

    protected abstract void inactivate();

    @Override
    public final int feedId() {
        return this.mFeedId;
    }

    @Override
    public final FeedScope scope() {
        return this.mScope;
    }

    @Override
    public final EClient eClient() {
        return this.mEClient;
    }

    @Override
    public final boolean isActive() {
        return this.mIsActive.get();
    }

    @Override
    public final boolean inPlace() {
        return this.mInPlace;
    }

    @Override
    public boolean isFeedUp() {
        return this.mFeedState == EFeedState.UP;
    }

    @Override
    public void close() {
        if (this.mIsActive.getAndSet(false)) {
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.fine(String.format("Client %d, Feed %d: closing.", this.mEClient.clientId(), this.mFeedId));
            }
            this.inactivate();
            this.mEClient.returnFeedId(this.mFeedId);
            this.mEClient.removeFeed(this);
        }
    }

    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof EFeed) {
            EFeed feed = (EFeed)o;
            retcode = this.mEClient.clientId() == feed.mEClient.clientId() && this.mFeedId == feed.mFeedId;
        }
        return retcode;
    }

    public int hashCode() {
        return Objects.hash(this.mEClient.clientId(), this.mFeedId);
    }

    public String toString() {
        return String.format("[%s active=%b, in place=%b, id=%d, state=%s]", new Object[]{this.mScope, this.mIsActive.get(), this.mInPlace, this.mFeedId, this.mFeedState});
    }

    public final int clientId() {
        return this.mEClient.clientId();
    }

    public final EClient.ClientLocation location() {
        return this.mEClient.location();
    }

    public final EFeedState feedState() {
        return this.mFeedState;
    }

    public static String defaultDispatcher() {
        return EClient.defaultDispatcher();
    }

    public static List<EMessageKey> findKeys() {
        return ESubject.findKeys();
    }

    public static List<EMessageKey> findKeys(Class<? extends EMessage> mc) {
        return EFeed.findKeys(mc, ALL_SUBJECTS);
    }

    public static List<EMessageKey> findKeys(Class<? extends EMessage> mc, Pattern query) {
        List<EMessageKey> retval;
        Objects.requireNonNull(mc, "mc is null");
        Objects.requireNonNull(query, "query is null");
        if (ESystemMessage.class.isAssignableFrom(mc) || EReplyMessage.class.isAssignableFrom(mc)) {
            retval = Collections.EMPTY_LIST;
        } else {
            Pattern keyPattern = Pattern.compile((String)(mc.getName() + '/' + query.pattern()));
            retval = ESubject.findKeys(keyPattern);
        }
        return retval;
    }

    public static void addKey(EMessageKey key) {
        Objects.requireNonNull(key, "key is null");
        if (key.isSystem() || key.isReply()) {
            throw new IllegalArgumentException(String.format("%s is not a notification or request", key.className()));
        }
        ESubject.addSubject(key);
    }

    public static void addAllKeys(Collection<EMessageKey> keys) {
        Objects.requireNonNull(keys, "keys is null");
        keys.forEach(key -> {
            Objects.requireNonNull(key, "contains null key");
            if (key.isSystem() || key.isReply()) {
                throw new IllegalArgumentException(String.format("%s is not a notification or request", key.className()));
            }
        });
        ESubject.addAllSubjects(keys);
    }

    public static void register(EObject client) {
        Objects.requireNonNull(client, "client is null");
        EClient.DispatcherInfo dispatcher = EClient.findDispatcher(client);
        EFeed.register(client, dispatcher.name(), client::startup, client::shutdown);
    }

    public static void register(EObject client, String dispatcherName) {
        EFeed.register(client, dispatcherName, client::startup, client::shutdown);
    }

    public static void register(EObject client, String dispatcherName, Runnable startCb, Runnable shutdownCb) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(dispatcherName, "dispatcherName is null");
        Objects.requireNonNull(startCb, "startCb is null");
        Objects.requireNonNull(shutdownCb, "shutdownCb is null");
        if (dispatcherName.isEmpty()) {
            throw new IllegalArgumentException("dispatcherName is empty");
        }
        EClient.DispatcherInfo info = EClient.findDispatcher(dispatcherName);
        if (info == null) {
            throw new IllegalArgumentException(dispatcherName + " is an unknown dispatcher");
        }
        EClient.addClient(client, EClient.ClientLocation.LOCAL, info, startCb, shutdownCb);
    }

    public static void startup(EObject client) {
        Objects.requireNonNull(client, "client is null");
        EClient eClient = EClient.findClient(client);
        if (eClient == null) {
            throw new IllegalStateException("client not registered with eBus");
        }
        ArrayList<EClient> clients = new ArrayList<EClient>();
        clients.add(eClient);
        EClient.startup(clients);
    }

    public static void startup(List<? extends EObject> clients) {
        Objects.requireNonNull(clients, "clients is null");
        ArrayList<EClient> eClients = new ArrayList<EClient>();
        for (EObject eObject : clients) {
            Objects.requireNonNull(eObject, "clients contains a null entry");
            EClient eClient = EClient.findClient(eObject);
            if (eClient == null) {
                throw new IllegalStateException("clients contains an unregistered object");
            }
            eClients.add(eClient);
        }
        EClient.startup(eClients);
    }

    public static void startupAll() {
        EClient.startup(EClient.getClients());
    }

    public static void shutdown(EObject client) {
        Objects.requireNonNull(client, "client is null");
        EClient eClient = EClient.findClient(client);
        if (eClient == null) {
            throw new IllegalStateException("client not registered with eBus");
        }
        ArrayList<EClient> clients = new ArrayList<EClient>();
        clients.add(eClient);
        EClient.shutdown(clients);
    }

    public static void shutdown(List<? extends EObject> clients) {
        Objects.requireNonNull(clients, "clients is null");
        ArrayList<EClient> eClients = new ArrayList<EClient>();
        for (EObject eObject : clients) {
            Objects.requireNonNull(eObject, "clients contains a null entry");
            EClient eClient = EClient.findClient(eObject);
            if (eClient == null) {
                throw new IllegalStateException("clients contains an unregistered object");
            }
            eClients.add(eClient);
        }
        EClient.shutdown(eClients);
    }

    public static void shutdownAll() {
        EClient.shutdown(EClient.getClients());
    }

    public static void storeKeys(ObjectOutputStream oos) throws IOException {
        Objects.requireNonNull(oos, "oos is null");
        ESubject.storeKeys(oos);
    }

    public static void storeKeys(Class<? extends EMessage> mc, ObjectOutputStream oos) throws IOException {
        EFeed.storeKeys(mc, ALL_SUBJECTS, oos);
    }

    public static void storeKeys(Class<? extends EMessage> mc, Pattern query, ObjectOutputStream oos) throws IOException {
        Objects.requireNonNull(mc, "mc is null");
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(oos, "oos is null");
        if (ENotificationMessage.class.isAssignableFrom(mc) || ERequestMessage.class.isAssignableFrom(mc)) {
            Pattern keyPattern = Pattern.compile((String)(mc.getName() + '/' + query.pattern()));
            ESubject.storeKeys(keyPattern, oos);
        }
    }

    public static void loadKeys(ObjectInputStream ois) throws IOException {
        Objects.requireNonNull(ois, "ois is null");
        ESubject.loadKeys(ois);
    }

    protected final boolean isOverridden(String methodName, Class<?> ... params) {
        boolean retcode = false;
        try {
            Method method = this.mEClient.targetClass().getMethod(methodName, params);
            retcode = !method.isDefault();
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return retcode;
    }

    protected static void checkScopes(EMessageKey key, FeedScope scope) {
        if (key.isLocalOnly() && scope != FeedScope.LOCAL_ONLY) {
            throw new IllegalArgumentException(String.format("%s is local-only but feed scope is %s", new Object[]{key, scope}));
        }
    }

    public static enum FeedScope {
        LOCAL_ONLY(EClient.ClientLocation.LOCAL.mask, new EClient.ClientLocation[]{EClient.ClientLocation.LOCAL}, "local only"),
        LOCAL_AND_REMOTE(EClient.ClientLocation.LOCAL.mask | EClient.ClientLocation.REMOTE.mask, new EClient.ClientLocation[]{EClient.ClientLocation.LOCAL, EClient.ClientLocation.REMOTE}, "local & remote"),
        REMOTE_ONLY(EClient.ClientLocation.REMOTE.mask, new EClient.ClientLocation[]{EClient.ClientLocation.REMOTE}, "remote only");

        private final int _locationMask;
        private final List<EClient.ClientLocation> _locations;
        private final String _description;

        private FeedScope(int locationMask, EClient.ClientLocation[] locations, String text) {
            this._locationMask = locationMask;
            this._locations = Collections.unmodifiableList(Arrays.asList(locations));
            this._description = text;
        }

        public boolean supports(EClient.ClientLocation loc) {
            return (this._locationMask & loc.mask) != 0;
        }

        List<EClient.ClientLocation> locations() {
            return this._locations;
        }

        public String toString() {
            return this._description;
        }
    }

    protected final class NotifyTask
    extends AbstractClientTask {
        private final ENotificationMessage mMessage;
        private final ECondition mCondition;
        private final NotifyCallback mCallback;

        public NotifyTask(ENotificationMessage message, ECondition condition, IESubscribeFeed feed, NotifyCallback cb) {
            super(feed);
            this.mMessage = message;
            this.mCondition = condition;
            this.mCallback = cb;
        }

        @Override
        public void run() {
            EObject target = EFeed.this.mEClient.target();
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.toString());
            }
            if (target != null) {
                try {
                    if (this.mCondition.test(this.mMessage)) {
                        this.mCallback.call(this.mMessage, (IESubscribeFeed)this.mFeed);
                    }
                }
                catch (Throwable tex) {
                    String reason = String.format("NotifyTask[%s, %s] exception", target.getClass().getName(), this.mMessage.key());
                    if (sLogger.isLoggable(Level.FINE)) {
                        sLogger.log(Level.WARNING, reason, tex);
                    }
                    sLogger.log(Level.WARNING, reason);
                }
            }
        }

        public String toString() {
            return String.format("NotifyTask[key=%s]", this.mMessage.key());
        }
    }

    protected final class StatusTask<T extends IEFeed>
    extends AbstractClientTask {
        private final EFeedState mFeedState;
        private final FeedStatusCallback<T> mCallback;

        public StatusTask(EFeedState feedState, EFeed feed, FeedStatusCallback<T> cb) {
            super(feed);
            this.mFeedState = feedState;
            this.mCallback = cb;
        }

        @Override
        public void run() {
            EObject target = EFeed.this.mEClient.target();
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(this.toString());
            }
            if (target != null) {
                try {
                    this.mCallback.call(this.mFeedState, this.mFeed);
                }
                catch (Throwable tex) {
                    String reason = String.format("%s publish status callback exception", target.getClass().getName());
                    if (sLogger.isLoggable(Level.FINE)) {
                        sLogger.log(Level.WARNING, reason, tex);
                    }
                    sLogger.log(Level.WARNING, reason);
                }
            }
        }
    }

    protected static abstract class AbstractClientTask
    implements Runnable {
        protected final IEFeed mFeed;

        protected AbstractClientTask(IEFeed feed) {
            this.mFeed = feed;
        }
    }
}

