/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import com.google.common.base.Strings;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EObject;
import net.sf.eBus.client.ERemoteApp;
import net.sf.eBus.client.EServer;
import net.sf.eBus.config.EConfigure;
import net.sf.eBus.config.ENetConfigure;
import net.sf.eBus.config.ThreadType;
import net.sf.eBus.util.IndexPool;

public final class EClient
extends WeakReference<EObject>
implements Comparable<EClient> {
    private static final String DEFAULT_DISPATCHER = "__DEFAULT__";
    private static final String EBUS_THREAD_NAME_PREFIX = "eBus:dispatcher-";
    private static final IndexPool sClientPool;
    private static final List<EClient> sClients;
    private static final ReferenceQueue<? super EObject> sGcQueue;
    private static final Thread sGcThread;
    private static final Map<String, DispatcherInfo> sRunQueues;
    private static final Map<Class<?>, DispatcherInfo> sDispatchers;
    private static DispatcherInfo sDefaultDispatcher;
    private static final Logger sLogger;
    private final Class<?> mTargetClass;
    private final int mClientId;
    private final ClientLocation mLocation;
    private final IndexPool mFeedIdPool;
    private final List<EFeed> mFeeds;
    private final Runnable mStartupCallback;
    private final Runnable mShutdownCallback;
    private final Queue<EClient> mRunQueue;
    private final long mMaxQuantum;
    private long mQuantum;
    private final Queue<Runnable> mTasks;
    private final Consumer<Runnable> mDispatchHandle;
    private RunState mRunState;
    private ClientState mClientState;

    private EClient(EObject target, int clientId, ClientLocation location, Runnable startCb, Runnable shutdownCb, Queue<EClient> runQueue, Consumer<Runnable> handle, long maxQuantum, ClientState initialState) {
        super(target, sGcQueue);
        this.mTargetClass = target.getClass();
        this.mClientId = clientId;
        this.mLocation = location;
        this.mStartupCallback = startCb;
        this.mShutdownCallback = shutdownCb;
        this.mRunQueue = runQueue;
        this.mDispatchHandle = runQueue != null ? this::doDispatch : handle;
        this.mMaxQuantum = maxQuantum;
        this.mQuantum = maxQuantum;
        this.mFeedIdPool = new IndexPool();
        this.mFeeds = new ArrayList<EFeed>();
        this.mTasks = new ArrayDeque<Runnable>();
        this.mRunState = RunState.IDLE;
        this.mClientState = initialState;
    }

    @Override
    public int compareTo(EClient client) {
        return this.mClientId - client.clientId();
    }

    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof EClient) {
            retcode = this.mClientId == ((EClient)o).clientId();
        }
        return retcode;
    }

    public int hashCode() {
        return this.mClientId;
    }

    public String toString() {
        return "Client-" + this.mClientId;
    }

    public EObject target() {
        return (EObject)this.get();
    }

    public int clientId() {
        return this.mClientId;
    }

    public ClientLocation location() {
        return this.mLocation;
    }

    Class<?> targetClass() {
        return this.mTargetClass;
    }

    boolean isLocal() {
        return this.mLocation == ClientLocation.LOCAL;
    }

    int nextFeedId() {
        return this.mFeedIdPool.nextIndex();
    }

    void returnFeedId(int feedId) {
        this.mFeedIdPool.returnIndex(feedId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasClient(EObject client) {
        boolean retcode = false;
        List<EClient> list = sClients;
        synchronized (list) {
            Iterator<EClient> cit = sClients.iterator();
            while (cit.hasNext() && !retcode) {
                retcode = client == cit.next().get();
            }
        }
        return retcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EClient findClient(EObject client) {
        EClient retval = null;
        List<EClient> list = sClients;
        synchronized (list) {
            Iterator<EClient> cit = sClients.iterator();
            while (cit.hasNext() && retval == null) {
                retval = cit.next();
                if (client == retval.get()) continue;
                retval = null;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<EClient> getClients() {
        ArrayList<EClient> retval;
        List<EClient> list = sClients;
        synchronized (list) {
            retval = new ArrayList<EClient>(sClients);
        }
        return retval;
    }

    static int clientCount() {
        return sClients.size();
    }

    static String defaultDispatcher() {
        return sDefaultDispatcher.name();
    }

    synchronized void addFeed(EFeed feed) {
        this.mFeeds.add(feed);
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: reference count %,d.", this.mTargetClass.getName(), this.mFeeds.size()));
        }
    }

    synchronized void removeFeed(EFeed feed) {
        this.mFeeds.remove(feed);
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: reference count %,d.", this.mTargetClass.getName(), this.mFeeds.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EClient findOrCreateClient(EObject client, ClientLocation location) {
        EClient retval;
        List<EClient> list = sClients;
        synchronized (list) {
            retval = EClient.findClient(client);
            if (retval == null) {
                DispatcherInfo info = EClient.findDispatcher(client);
                retval = new EClient(client, sClientPool.nextIndex(), location, client::startup, client::shutdown, info.runQueue(), info.dispatchHandle(), info.maxQuantum(), ClientState.STARTED);
                sClients.add(retval);
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.fine(String.format("EClient: created client %d -> %s", retval.clientId(), client));
                }
            }
        }
        return retval;
    }

    public static void dispatch(Runnable task, EObject client) {
        Objects.requireNonNull(task, "task is null");
        Objects.requireNonNull(client, "client is null");
        EClient eClient = EClient.findOrCreateClient(client, ClientLocation.LOCAL);
        eClient.dispatch(task);
    }

    synchronized void dispatch(Runnable task) {
        this.mDispatchHandle.accept(task);
    }

    private void doDispatch(Runnable task) {
        if (!this.mTasks.offer(task)) {
            sLogger.warning(String.format("client %d: failed to add %s to task queue.", this.mClientId, task.getClass().getName()));
        } else if (this.mRunState == RunState.IDLE) {
            this.setState(RunState.READY);
            this.mRunQueue.offer(this);
        }
    }

    private synchronized Runnable nextTask(long timeUsed) {
        Runnable retval = null;
        this.mQuantum -= timeUsed;
        if (this.mRunState != RunState.DEFUNCT) {
            if (this.mTasks.isEmpty()) {
                this.setState(RunState.IDLE);
                this.mQuantum = this.mMaxQuantum;
            } else if (this.mQuantum <= 0L) {
                this.setState(RunState.READY);
                this.mQuantum = this.mMaxQuantum;
                this.mRunQueue.offer(this);
            } else {
                this.setState(RunState.RUNNING);
                retval = this.mTasks.poll();
            }
        }
        return retval;
    }

    private void setState(RunState nextState) {
        this.mRunState = nextState;
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("client %d: run state %s.", new Object[]{this.mClientId, this.mRunState}));
        }
    }

    static DispatcherInfo findDispatcher(EObject client) {
        Class<?> clazz = client.getClass();
        return sDispatchers.containsKey(clazz) ? sDispatchers.get(clazz) : sDefaultDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EClient addClient(EObject client, ClientLocation location, DispatcherInfo info, Runnable startupCb, Runnable shutdownCb) throws IllegalStateException {
        EClient retval;
        List<EClient> list = sClients;
        synchronized (list) {
            if (EClient.findClient(client) != null) {
                throw new IllegalStateException("client already registered with eBus");
            }
            retval = new EClient(client, sClientPool.nextIndex(), location, startupCb, shutdownCb, info.runQueue(), info.dispatchHandle(), info.maxQuantum(), ClientState.NOT_STARTED);
            sClients.add(retval);
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.fine(String.format("EClient: created client %d -> %s", retval.clientId(), client));
            }
        }
        return retval;
    }

    static DispatcherInfo findDispatcher(String name) {
        return sRunQueues.get(name);
    }

    static void startup(List<EClient> clients) {
        clients.forEach(client -> client.dispatch(new StartStopTask((EClient)client, client.mStartupCallback, ClientState.NOT_STARTED, ClientState.STARTING, ClientState.STARTED)));
    }

    static void shutdown(List<EClient> clients) {
        clients.forEach(client -> client.dispatch(new StartStopTask((EClient)client, client.mShutdownCallback, ClientState.STARTED, ClientState.SHUTTING_DOWN, ClientState.NOT_STARTED)));
    }

    private synchronized void cleanUp() {
        this.mFeeds.stream().forEach(feed -> feed.close());
        this.mFeeds.clear();
        this.mTasks.clear();
        this.setState(RunState.DEFUNCT);
    }

    private static Queue<EClient> runQueue(EConfigure.Dispatcher config) {
        EConfigure.DispatcherType dType = config.dispatchType();
        AbstractQueue retval = dType == EConfigure.DispatcherType.EBUS ? (config.runQueueType() == ThreadType.BLOCKING ? new LinkedBlockingQueue() : new ConcurrentLinkedQueue()) : null;
        return retval;
    }

    private static boolean containsDefault(Collection<EConfigure.Dispatcher> dispatchers) {
        Iterator<EConfigure.Dispatcher> dit = dispatchers.iterator();
        boolean retcode = false;
        while (dit.hasNext() && !retcode) {
            retcode = dit.next().isDefault();
        }
        return retcode;
    }

    private static EConfigure loadConfigFile(String configFile) throws IOException {
        net.sf.eBus.util.Properties props = net.sf.eBus.util.Properties.loadProperties((String)configFile);
        ENetConfigure.load((net.sf.eBus.util.Properties)props);
        return EConfigure.load((Properties)props);
    }

    private static EConfigure loadJsonFile(String jsonFileName) {
        File jsonFile = new File(jsonFileName);
        Config eBusConfig = ConfigFactory.parseFile((File)jsonFile);
        return EConfigure.load((Config)eBusConfig);
    }

    static /* synthetic */ Runnable access$700(EClient x0, long x1) {
        return x0.nextTask(x1);
    }

    static {
        String configFile = System.getProperty("net.sf.eBus.config.file");
        String jsonFile = System.getProperty("net.sf.eBus.config.jsonFile");
        EConfigure eConfig = null;
        HashMap<String, EConfigure.Dispatcher> dispatchers = Collections.emptyMap();
        if (!Strings.isNullOrEmpty((String)configFile) && !Strings.isNullOrEmpty((String)jsonFile)) {
            throw new IllegalStateException(String.format("both %s and %s defined; only one is allowed", "net.sf.eBus.config.file", "net.sf.eBus.config.jsonFile"));
        }
        sClientPool = new IndexPool();
        sClients = new ArrayList<EClient>();
        sGcQueue = new ReferenceQueue();
        sGcThread = new Thread("eBus:finalizeThread"){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            EClient proxy = (EClient)sGcQueue.remove();
                            if (sLogger.isLoggable(Level.FINER)) {
                                sLogger.finer(String.format("EClient: removing eBus client %d.", proxy.clientId()));
                            }
                            proxy.cleanUp();
                            sClients.remove(proxy);
                            sClientPool.returnIndex(proxy.clientId());
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        sGcThread.start();
        sLogger = Logger.getLogger(EClient.class.getName());
        if (!Strings.isNullOrEmpty((String)configFile)) {
            try {
                eConfig = EClient.loadConfigFile(configFile);
                dispatchers = eConfig.dispatchers();
            }
            catch (IOException ioex) {
                sLogger.log(Level.SEVERE, "eBus properties " + configFile + " load failed", ioex);
            }
        } else if (!Strings.isNullOrEmpty((String)jsonFile)) {
            eConfig = EClient.loadJsonFile(jsonFile);
            dispatchers = eConfig.dispatchers();
        }
        sRunQueues = new HashMap<String, DispatcherInfo>();
        sDispatchers = new HashMap();
        if (!EClient.containsDefault(dispatchers.values())) {
            int numProcs = Runtime.getRuntime().availableProcessors();
            EConfigure.DispatcherBuilder builder = EConfigure.dispatcherBuilder();
            dispatchers = new HashMap<String, EConfigure.Dispatcher>();
            dispatchers.put(DEFAULT_DISPATCHER, builder.name(DEFAULT_DISPATCHER).dispatcherType(EConfigure.DispatcherType.EBUS).threadType(ThreadType.BLOCKING).spinLimit(0L).parkTime(0L).priority(5).quantum(500000L).numberThreads(numProcs).isDefault(true).build());
        }
        for (EConfigure.Dispatcher dispatcher : dispatchers.values()) {
            DispatcherInfo info = new DispatcherInfo(dispatcher);
            sRunQueues.put(dispatcher.name(), info);
            if (dispatcher.isDefault()) {
                sDefaultDispatcher = info;
            } else {
                for (Class clazz : dispatcher.classes()) {
                    sDispatchers.put(clazz, info);
                }
            }
            for (int index = 0; index < dispatcher.numberThreads(); ++index) {
                String name = EBUS_THREAD_NAME_PREFIX + dispatcher.name() + "-" + index;
                new RQThread(name, info.runQueue(), dispatcher).start();
            }
        }
        if (eConfig != null) {
            try {
                EServer.configure(eConfig);
                ERemoteApp.configure(eConfig);
            }
            catch (IOException ioex) {
                sLogger.log(Level.WARNING, "Failure to open eBus remote connections:", ioex);
            }
        }
    }

    @FunctionalInterface
    private static interface PollInterface<T> {
        public T poll();
    }

    private static final class StartStopTask
    implements Runnable {
        private final EClient mClient;
        private final Runnable mTask;
        private final ClientState mInitialState;
        private final ClientState mIntermediateState;
        private final ClientState mFinalState;

        private StartStopTask(EClient client, Runnable task, ClientState initState, ClientState betweenState, ClientState finalState) {
            this.mClient = client;
            this.mTask = task;
            this.mInitialState = initState;
            this.mIntermediateState = betweenState;
            this.mFinalState = finalState;
        }

        @Override
        public void run() {
            EObject target = (EObject)this.mClient.get();
            if (target != null && this.mClient.mClientState == this.mInitialState) {
                this.mClient.mClientState = this.mIntermediateState;
                try {
                    this.mTask.run();
                }
                catch (Exception jex) {
                    sLogger.log(Level.WARNING, "start-up/shutdown exception:", jex);
                }
                this.mClient.mClientState = this.mFinalState;
            }
        }
    }

    static final class DispatcherInfo {
        private final String mName;
        private final Queue<EClient> mRunQueue;
        private final Consumer<Runnable> mDispatchHandle;
        private final long mMaxQuantum;

        private DispatcherInfo(EConfigure.Dispatcher config) {
            this.mName = config.name();
            this.mRunQueue = EClient.runQueue(config);
            this.mDispatchHandle = config.dispatchType().dispatchHandle();
            this.mMaxQuantum = config.quantum();
        }

        public String name() {
            return this.mName;
        }

        public Queue<EClient> runQueue() {
            return this.mRunQueue;
        }

        public Consumer<Runnable> dispatchHandle() {
            return this.mDispatchHandle;
        }

        public long maxQuantum() {
            return this.mMaxQuantum;
        }
    }

    private static final class RQThread
    extends Thread {
        private final Queue<EClient> mRunQueue;
        private final PollInterface<EClient> mPollMethod;
        private final long mSpinLimit;
        private final long mParkTime;

        private RQThread(String name, Queue<EClient> runQueue, EConfigure.Dispatcher config) {
            super(name);
            this.mRunQueue = runQueue;
            this.mSpinLimit = config.spinLimit();
            this.mParkTime = config.parkTime();
            switch (config.runQueueType()) {
                case BLOCKING: {
                    this.mPollMethod = this::blockingPoll;
                    break;
                }
                case SPINNING: {
                    this.mPollMethod = this::spinningPoll;
                    break;
                }
                case SPINPARK: {
                    this.mPollMethod = this::spinSleepPoll;
                    break;
                }
                default: {
                    this.mPollMethod = this::yieldingPoll;
                }
            }
            this.setDaemon(true);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (EClient.access$100().isLoggable(Level.FINER)) {
                EClient.access$100().finer(String.format("%s: running.", new Object[]{this.getName()}));
            }
            if (EClient.access$100().isLoggable(Level.FINEST)) {
                EClient.access$100().finest(String.format("%s: polling run queue %s.", new Object[]{this.getName(), this.mRunQueue}));
            }
            block0: while (true) {
                if ((client = this.mPollMethod.poll()) == null) {
                    continue;
                }
                timeUsed = 0L;
                while (true) {
                    if ((task = EClient.access$700(client, timeUsed)) != null) ** break;
                    continue block0;
                    if (EClient.access$100().isLoggable(Level.FINEST)) {
                        EClient.access$100().finest(String.format("%s: executing client %d, %s.", new Object[]{this.getName(), client.clientId(), task.getClass().getName()}));
                    }
                    startTime = System.nanoTime();
                    task.run();
                    timeUsed = System.nanoTime() - startTime;
                }
                break;
            }
        }

        private EClient blockingPoll() {
            EClient retval = null;
            while (retval == null) {
                try {
                    retval = (EClient)((LinkedBlockingQueue)this.mRunQueue).take();
                }
                catch (InterruptedException interruptedException) {}
            }
            return retval;
        }

        public EClient spinningPoll() {
            EClient retval = null;
            while (retval == null) {
                retval = this.mRunQueue.poll();
            }
            return retval;
        }

        public EClient spinSleepPoll() {
            long counter = this.mSpinLimit;
            EClient retval = null;
            while (retval == null) {
                if (counter == 0L) {
                    LockSupport.parkNanos(this.mParkTime);
                    counter = this.mSpinLimit;
                }
                retval = this.mRunQueue.poll();
            }
            return retval;
        }

        public EClient yieldingPoll() {
            long counter = this.mSpinLimit;
            EClient retval = null;
            while (retval == null) {
                if (counter == 0L) {
                    LockSupport.park();
                    counter = this.mSpinLimit;
                }
                retval = this.mRunQueue.poll();
            }
            return retval;
        }
    }

    private static enum RunState {
        IDLE,
        READY,
        RUNNING,
        DEFUNCT;

    }

    private static enum ClientState {
        NOT_STARTED,
        STARTING,
        STARTED,
        SHUTTING_DOWN;

    }

    public static enum ClientLocation {
        LOCAL(1, "local"),
        REMOTE(2, "remote");

        public final int mask;
        private final String _description;

        private ClientLocation(int mask, String text) {
            this.mask = mask;
            this._description = text;
        }

        public String toString() {
            return this._description;
        }
    }
}

