/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.ERemoteApp;
import net.sf.eBus.client.sysmessages.KeyMessage;
import net.sf.eBus.client.sysmessages.SystemMessageType;
import net.sf.eBus.config.EConfigure;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageHeader;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.InvalidMessageException;
import net.sf.eBus.messages.UnknownMessageException;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;
import net.sf.eBus.net.AsyncChannel;
import net.sf.eBus.util.logging.StatusReport;
import net.sf.eBus.util.logging.StatusReporter;

abstract class EAbstractConnection {
    public static final int DEFAULT_QUEUE_SIZE = 0;
    public static final int MAX_MESSAGE_SIZE = Short.MAX_VALUE;
    protected static final int MESSAGE_SIZE_SIZE = 4;
    protected static final int MESSAGE_HEADER_SIZE = 16;
    protected static final int HEARTBEAT = -15000;
    protected static final int HEARTBEAT_REPLY = -8000;
    protected static final byte[] HEARTBEAT_DATA;
    protected static final byte[] HEARTBEAT_REPLY_DATA;
    private static final String[] CB_METHOD_NAMES;
    protected static final int NOTIFY_CB = 14;
    protected static final int REQUEST_CB = 15;
    protected static final int REPLY_CB = 16;
    protected static final MethodHandle[] MESSAGE_CB;
    protected static final int OPEN_CB = 0;
    protected static final int CLOSE_CB = 1;
    protected static final String[] CONN_CB_METHOD_NAMES;
    protected static final MethodHandle[] CONN_CB;
    protected static final DataType MESSAGE_TYPE;
    protected static final Map<InetSocketAddress, EAbstractConnection> sConnections;
    protected static final Timer sTimer;
    private static final Logger sLogger;
    protected static int sTotalInCount;
    protected static int sTotalOutCount;
    protected ERemoteApp mRemoteApp;
    protected AsyncChannel mAsocket;
    protected int mBindPort;
    protected final Map<Integer, MessageReader> mInputReaders;
    protected AbstractMessageWriter mOutputWriter;
    protected int mMsgInCount;
    protected int mMsgOutCount;

    protected EAbstractConnection(ERemoteApp remoteApp) {
        if (remoteApp == null) {
            throw new IllegalArgumentException("remoteApp is null");
        }
        this.mRemoteApp = remoteApp;
        this.mAsocket = null;
        this.mInputReaders = new HashMap<Integer, MessageReader>();
        this.mOutputWriter = null;
        this.mBindPort = -1;
    }

    public abstract boolean willReconnect();

    public abstract boolean willPause();

    abstract boolean isConnecting();

    abstract void close();

    abstract void closeNow();

    abstract void closeAndReconnect();

    abstract void closeAndPause(Duration var1);

    abstract boolean open(EConfigure.RemoteConnection var1) throws IOException;

    abstract void open(SelectableChannel var1, EConfigure.Service var2) throws IOException;

    abstract void resumeNow();

    abstract void send(EMessageHeader var1) throws IOException;

    public final boolean isOpen() {
        return this.mAsocket.isOpen();
    }

    public final SocketAddress remoteSocketAddress() {
        return this.mAsocket.remoteSocketAddress();
    }

    public final SocketAddress localSocketAddress() {
        return this.mAsocket.localSocketAddress();
    }

    public final int inputBufferSize() {
        return this.mAsocket.inputBufferSize();
    }

    public final int outputBufferSize() {
        return this.mAsocket.outputBufferSize();
    }

    public final int maxMessageQueueSize() {
        return this.mOutputWriter.maximumSize();
    }

    public final int messageQueueSize() {
        return this.mOutputWriter.transmitQueueSize();
    }

    final Map<Integer, MessageReader> readers() {
        return new HashMap<Integer, MessageReader>(this.mInputReaders);
    }

    final void resumeConnection(ERemoteApp app, Map<Integer, MessageReader> readers) {
        this.mRemoteApp = app;
        this.mInputReaders.clear();
        this.mInputReaders.putAll(readers);
    }

    final void keyUpdate(KeyMessage msg) {
        int keyId = msg.keyId;
        MessageReader reader = null;
        try {
            String mn;
            MethodHandle mh;
            Class<?> mc = Class.forName(msg.keyClass);
            String subject = msg.keySubject;
            MessageType mt = (MessageType)DataType.findType(mc);
            if (ENotificationMessage.class.isAssignableFrom(mc)) {
                mh = MESSAGE_CB[14];
                mn = CB_METHOD_NAMES[14];
            } else if (EReplyMessage.class.isAssignableFrom(mc)) {
                mh = MESSAGE_CB[16];
                mn = CB_METHOD_NAMES[16];
            } else {
                mh = MESSAGE_CB[15];
                mn = CB_METHOD_NAMES[15];
            }
            reader = new MessageReader(keyId, subject, mt, mh, mn);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.mInputReaders.put(keyId, reader);
    }

    protected final void initialize() {
        SystemMessageType[] types = SystemMessageType.values();
        int size = types.length;
        for (int index = 0; index < size; ++index) {
            int keyId = types[index].keyId();
            MessageType mt = (MessageType)DataType.findType(types[index].messageClass());
            this.mInputReaders.put(keyId, new MessageReader(keyId, "/eBus", mt, MESSAGE_CB[index], CB_METHOD_NAMES[index]));
        }
    }

    private void reportStatus(PrintWriter report, int index, int period) {
        int msgInCount = this.mMsgInCount;
        int msgOutCount = this.mMsgOutCount;
        int rateIn = msgInCount / period;
        int rateOut = msgOutCount / period;
        this.mMsgInCount = 0;
        this.mMsgOutCount = 0;
        report.format("  [%,d] address: %s%n", index, this.mAsocket.localSocketAddress());
        report.format("      %,d messages received @ %,d msgs/sec.%n", msgInCount, rateIn);
        report.format("      %,d messages sent @ %,d msgs/sec.%n", msgOutCount, rateOut);
    }

    static {
        MethodType mt;
        CB_METHOD_NAMES = new String[]{"remoteAd", "remoteCancelRequest", "remoteClassUpdate", "remoteFeedStatus", "remoteLogoff", "remoteLogonComplete", "remoteLogon", "remoteLogonReply", "remoteRequestAck", "remoteSubscribe", "remotePauseRequest", "remotePauseReply", "remoteResumeRequest", "remoteResumeReply", "remoteNotify", "remoteRequest", "remoteReply"};
        CONN_CB_METHOD_NAMES = new String[]{"handleOpen", "handleClose"};
        MESSAGE_TYPE = DataType.findType(EMessage.class);
        sConnections = new ConcurrentHashMap<InetSocketAddress, EAbstractConnection>();
        sTimer = new Timer("ConnTimer", true);
        sLogger = Logger.getLogger(EAbstractConnection.class.getName());
        sTotalInCount = 0;
        sTotalOutCount = 0;
        ByteBuffer buffer = ByteBuffer.allocate(4);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        int index = 0;
        HEARTBEAT_DATA = new byte[2];
        HEARTBEAT_REPLY_DATA = new byte[2];
        buffer.putInt(-15000);
        buffer.flip();
        buffer.get(HEARTBEAT_DATA);
        buffer.clear();
        buffer.putInt(-8000);
        buffer.flip();
        buffer.get(HEARTBEAT_REPLY_DATA);
        buffer.clear();
        int size = CB_METHOD_NAMES.length;
        MESSAGE_CB = new MethodHandle[size];
        try {
            mt = MethodType.methodType(Void.TYPE, EMessageHeader.class);
            for (index = 0; index < size; ++index) {
                EAbstractConnection.MESSAGE_CB[index] = lookup.findVirtual(ERemoteApp.class, CB_METHOD_NAMES[index], mt);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException jex) {
            sLogger.log(Level.SEVERE, CB_METHOD_NAMES[index] + " lookup failed", jex);
        }
        size = CONN_CB_METHOD_NAMES.length;
        CONN_CB = new MethodHandle[size];
        try {
            mt = MethodType.methodType(Void.TYPE, EAbstractConnection.class);
            for (index = 0; index < size; ++index) {
                EAbstractConnection.CONN_CB[index] = lookup.findVirtual(ERemoteApp.class, CONN_CB_METHOD_NAMES[index], mt);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException jex) {
            sLogger.log(Level.SEVERE, CONN_CB_METHOD_NAMES[index] + " lookup failed", jex);
        }
        StatusReport.getInstance().register((StatusReporter)new EConnectionStatusReporter());
    }

    private static final class EConnectionStatusReporter
    implements StatusReporter {
        public void reportStatus(PrintWriter report) {
            int period = (int)(StatusReport.getInstance().getReportFrequency().getFrequency() / 1000L);
            int appCount = sConnections.size();
            int totalInCount = sTotalInCount;
            int totalOutCount = sTotalOutCount;
            int totalInRate = totalInCount / period;
            int totalOutRate = totalOutCount / period;
            sTotalInCount = 0;
            sTotalOutCount = 0;
            report.print("ERemote: ");
            if (appCount == 0) {
                report.println("there are no remote connections.");
            } else {
                ArrayList<EAbstractConnection> apps = new ArrayList<EAbstractConnection>(sConnections.values());
                int index = 0;
                report.format("there is %,d remote application %s.%n", appCount, appCount == 1 ? "connection" : "connections");
                for (EAbstractConnection connection : apps) {
                    connection.reportStatus(report, index, period);
                    report.println();
                    ++index;
                }
                report.format("    %,d total messages received @ %,d msgs/sec.%n", totalInCount, totalInRate);
                report.format("    %,d total messages sent @ %,d msgs/sec.", totalOutCount, totalOutRate);
                apps.clear();
            }
        }
    }

    protected static abstract class AbstractMessageWriter {
        protected final EAbstractConnection _connection;
        protected final int _maxSize;
        protected final Queue<EMessageHeader> _transmitQueue;
        protected final AtomicInteger _transmitQueueSize;
        protected volatile boolean _closingFlag;
        protected int _transmitCount;
        protected int _discardCount;
        private static final Logger _sublogger = Logger.getLogger(AbstractMessageWriter.class.getName());

        protected AbstractMessageWriter(int maxSize, EAbstractConnection conn) {
            this._connection = conn;
            this._maxSize = maxSize;
            this._transmitQueue = new ConcurrentLinkedQueue<EMessageHeader>();
            this._transmitQueueSize = new AtomicInteger();
            this._closingFlag = false;
            this._transmitCount = 0;
            this._discardCount = 0;
        }

        public final int maximumSize() {
            return this._maxSize;
        }

        public final int transmitCount() {
            return this._transmitCount;
        }

        public final int discardCount() {
            return this._discardCount;
        }

        public final int transmitQueueSize() {
            return this._transmitQueueSize.get();
        }

        public final boolean hasMessages() {
            return !this._transmitQueue.isEmpty();
        }

        public final boolean post(EMessageHeader h) throws BufferOverflowException {
            int queueSize;
            EMessage.MessageType msgType = h.messageType();
            int n = queueSize = msgType == EMessage.MessageType.SYSTEM ? this._transmitQueueSize.get() + 1 : this._transmitQueueSize.incrementAndGet();
            if (this._maxSize > 0 && queueSize >= this._maxSize) {
                BufferOverflowException bufex = new BufferOverflowException();
                IllegalStateException statex = new IllegalStateException(String.format("message queue maximum reached (%,d)", this._maxSize));
                bufex.initCause(statex);
                if (_sublogger.isLoggable(Level.FINE)) {
                    _sublogger.fine(String.format("%s queue: queue maximum reached (%,d).", this._connection.remoteSocketAddress(), this._maxSize));
                }
                ++this._discardCount;
                throw bufex;
            }
            this._transmitQueue.offer(h);
            if (_sublogger.isLoggable(Level.FINER)) {
                _sublogger.finer(String.format("%s queue: added message (size=%,d, transmited=%,d, discarded=%,d).", this._connection.remoteSocketAddress(), queueSize, this._transmitCount, this._discardCount));
            }
            return queueSize == 1;
        }

        protected final void setClosing() {
            this._closingFlag = true;
        }

        protected final void closed() {
            this._transmitQueue.clear();
            this._transmitQueueSize.set(0);
        }
    }

    protected final class MessageReader {
        private final int mKeyId;
        private final String mSubject;
        private final MessageType mMessageType;
        private final MethodHandle mCallback;
        private final String mMethodName;

        private MessageReader(int keyId, String subject, MessageType mt, MethodHandle mh, String mn) {
            this.mKeyId = keyId;
            this.mSubject = subject;
            this.mMessageType = mt;
            this.mCallback = mh;
            this.mMethodName = mn;
        }

        public int keyId() {
            return this.mKeyId;
        }

        public EMessageHeader extractMessage(ByteBuffer buffer, SocketAddress address) throws BufferUnderflowException, UnknownMessageException, InvalidMessageException {
            int fromFeedId = buffer.getInt();
            int toFeedId = buffer.getInt();
            this.mMessageType.subject(this.mSubject);
            EMessage msg = (EMessage)this.mMessageType.deserialize(buffer);
            EMessageHeader retval = new EMessageHeader(this.mKeyId, fromFeedId, toFeedId, address, msg);
            ++EAbstractConnection.this.mMsgInCount;
            ++sTotalInCount;
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest(String.format("%s: handling %s message:%n  From ID: %d%n    To ID: %d%n%s", EAbstractConnection.this.mAsocket.remoteSocketAddress(), retval.messageClass(), retval.fromFeedId(), retval.toFeedId(), msg));
            } else if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s: handling %s message (from=%d, to=%d).", EAbstractConnection.this.mAsocket.remoteSocketAddress(), retval.messageClass(), retval.fromFeedId(), retval.toFeedId()));
            }
            return retval;
        }

        public void forwardMessage(EMessageHeader header, ERemoteApp target) {
            try {
                if (sLogger.isLoggable(Level.FINEST)) {
                    Formatter output = new Formatter();
                    MethodType mt = this.mCallback.type();
                    Class<?>[] parms = mt.parameterArray();
                    int nParms = parms.length;
                    output.format("%s: forward %s to %s %s.%s", EAbstractConnection.this.mAsocket.remoteSocketAddress(), header.messageKey(), ((Class)mt.returnType()).getName(), parms[0].getName(), this.mMethodName);
                    String sep = "(";
                    for (int index = 1; index < nParms; ++index) {
                        output.format("%s%s", sep, parms[index].getName());
                        sep = ", ";
                    }
                    output.format(")", new Object[0]);
                    sLogger.finest(output.toString());
                }
                this.mCallback.invokeExact(target, header);
            }
            catch (Throwable tex) {
                sLogger.log(Level.WARNING, "Error processing message header.", tex);
            }
        }
    }
}

