/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Formatter;
import java.util.List;
import java.util.Objects;
import net.sf.eBus.client.AbstractEBusMessage;
import net.sf.eBus.messages.EMessageKey;

public final class ConnectionMessage
extends AbstractEBusMessage
implements Serializable {
    public static final EMessageKey MESSAGE_KEY = new EMessageKey(ConnectionMessage.class, "/eBus");
    private static final long serialVersionUID = 328192L;
    public final ConnectionState state;
    public final String reason;

    @Deprecated
    public ConnectionMessage(InetSocketAddress addr, int serverPort, ConnectionState state) {
        super(addr, serverPort);
        Objects.requireNonNull(state, "null state");
        this.state = state;
        this.reason = null;
    }

    @Deprecated
    public ConnectionMessage(InetSocketAddress addr, int serverPort, ConnectionState state, String reason) {
        super(addr, serverPort);
        Objects.requireNonNull(state, "null state");
        this.state = state;
        this.reason = reason;
    }

    @Deprecated
    public ConnectionMessage(String subject, long timestamp, InetSocketAddress addr, int serverPort, ConnectionState state, String reason) {
        super(subject, timestamp, addr, serverPort);
        Objects.requireNonNull(state, "null state");
        this.state = state;
        this.reason = reason;
    }

    private ConnectionMessage(Builder builder) {
        super(builder);
        this.state = builder.mConnectionState;
        this.reason = builder.mReason;
    }

    @Override
    public String toString() {
        Formatter retval = new Formatter();
        retval.format("%s%n", super.toString());
        retval.format("       connection state: %s%n", new Object[]{this.state});
        retval.format("                 reason: %s", this.reason == null || this.reason.isEmpty() ? "(not set)" : this.reason);
        return retval.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractEBusMessage.Builder<ConnectionMessage, Builder> {
        private ConnectionState mConnectionState;
        private String mReason;

        private Builder() {
            super(ConnectionMessage.class);
        }

        @Override
        protected ConnectionMessage buildImpl() {
            return new ConnectionMessage(this);
        }

        @Override
        protected void validate(List<String> problems) {
            super.validate(problems);
            if (this.mConnectionState == null) {
                problems.add("connection state not state");
            }
        }

        public Builder state(ConnectionState state) {
            if (state == null) {
                throw new IllegalArgumentException();
            }
            this.mConnectionState = state;
            return this;
        }

        public Builder reason(String reason) {
            this.mReason = reason;
            return this;
        }
    }

    public static enum ConnectionState {
        LOGGED_ON,
        LOGGED_OFF,
        PAUSED,
        RESUMED;

    }
}

