/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;
import net.sf.eBus.messages.EMessageObject;
import net.sf.eBus.messages.ENotificationMessage;

public abstract class AbstractEBusMessage
extends ENotificationMessage
implements Serializable {
    public static final String EBUS_SUBJECT = "/eBus";
    private static final long serialVersionUID = 328192L;
    public final InetSocketAddress remoteAddress;
    public final int serverPort;

    protected AbstractEBusMessage(InetSocketAddress addr, int serverPort) {
        this(EBUS_SUBJECT, System.currentTimeMillis(), addr, serverPort);
    }

    protected AbstractEBusMessage(long timestamp, InetSocketAddress addr, int serverPort) {
        this(EBUS_SUBJECT, timestamp, addr, serverPort);
    }

    protected AbstractEBusMessage(String subject, long timestamp, InetSocketAddress addr, int serverPort) {
        super(subject, timestamp);
        Objects.requireNonNull(addr, "null addr");
        this.remoteAddress = addr;
        this.serverPort = serverPort;
    }

    protected AbstractEBusMessage(Builder builder) {
        super(builder);
        this.remoteAddress = builder.mRemoteAddress;
        this.serverPort = builder.mServerPort;
    }

    @Override
    public String toString() {
        return String.format("%s%n                address: %s%n                   port: %d%n             server port: %d", super.toString(), this.remoteAddress.getHostName(), this.remoteAddress.getPort(), this.serverPort);
    }

    public static abstract class Builder<M extends AbstractEBusMessage, B extends Builder<M, ?>>
    extends ENotificationMessage.Builder<M, B> {
        private InetSocketAddress mRemoteAddress;
        private int mServerPort = -1;

        protected Builder(Class<? extends EMessageObject> targetClass) {
            super(targetClass, AbstractEBusMessage.EBUS_SUBJECT);
        }

        @Override
        protected void validate(List<String> problems) {
            super.validate(problems);
            if (this.mRemoteAddress == null) {
                problems.add("remote address not set");
            }
            if (this.mServerPort < 0) {
                problems.add("server port not set");
            }
        }

        public final B remoteAddress(InetSocketAddress address) {
            this.mRemoteAddress = address;
            return (B)this;
        }

        public final B serverPort(int serverPort) {
            this.mServerPort = serverPort;
            return (B)this;
        }
    }
}

