/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA
 * 02111-1307 USA
 *
 * The Initial Developer of the Original Code is Charles W. Rapp.
 * Portions created by Charles W. Rapp are
 * Copyright 2012. Charles W. Rapp
 * All Rights Reserved.
 */

/**
 * Provides classes for translating Java built-in types to and
 * from binary encoding. These classes are used for eBus message
 * transmission.
 * <p>
 * The {@link net.sf.eBus.messages.type.DataType} class
 * maintains a mapping from Java class type to the DataType
 * subclass responsible for the class serialization. Thus only
 * one instance type instance exists for each serialized class
 * type.
 * <p>
 * User-defined classes used as message fields must extend the
 * {@link net.sf.eBus.messages.EField} class.
 * {@link net.sf.eBus.messages.type.MessageType} tracks the
 * {@code EField} sub-class layout and performs the
 * serialization/de-serialization. There is one
 * {@code MessageType} instance for each
 * {@code EField} sub-class and these {@code MessageType}
 * instances are created only as needed.
 */

package net.sf.eBus.messages.type;
