/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA
 * 02111-1307 USA
 *
 * The Initial Developer of the Original Code is Charles W. Rapp.
 * Portions created by Charles W. Rapp are
 * Copyright 2012. Charles W. Rapp
 * All Rights Reserved.
 */

/**
 * Messages are the heart of eBus. The {@code net.sf.eBus.client}
 * API is about sending and receiving messages. This package
 * defines the eBus classes used to implement messages. This
 * includes the abstract
 * {@link net.sf.eBus.messages.EMessageObject},
 * {@link net.sf.eBus.messages.EMessageHeader},
 * {@link net.sf.eBus.messages.EMessage}, and
 * {@link net.sf.eBus.messages.EField}
 * classes combined with the
 * {@link net.sf.eBus.messages.EReplyInfo} annotation used to
 * define messages allowed to reply to a request message..
 * {@link net.sf.eBus.messages.EMessage EMessage} is the abstract
 * base class for all actual messages. eBus messages are defined
 * by:
 * <ol>
 *   <li>
 *     extending {@code ENotifyMessage}, {@code ERequestMessage},
 *     or {@code EReplyMessage}
 *   </li>
 *   <li>
 *     defining the message fields as {@code public final} data
 *     members,
 *   </li>
 *   <li>
 *     supplying the required builder inner class.
 *   </li>
 * </ol>
 * The data member types are limited to Java primitives or the
 * equivalent classes
 * ({@code boolean}/{@code Boolean}, {@code char}
 * {@code Character}, {@code int}/{@code Integer}, etc.),
 * supported Java classes ({@link java.lang.String},
 * {@link java.util.Date}, {@link java.math.BigDecimal}, etc.) or
 * a class which extends the
 * {@link net.sf.eBus.messages.EField EField} class.
 * <p>
 * All user-defined message and {@code EField} subclasses must
 * provide a builder inner class. This builder is used to
 * re-create the message from its serialized format. See
 * {@link net.sf.eBus.messages.EMessageObject} for detailed
 * examples explaining this "de-serialization" builder.
 * </p>
 * <p>
 * User-defined fields are classes which extend
 * {@link net.sf.eBus.messages.EField EField} class. Fields have
 * the same requirements as an eBus message: {@code public final}
 * fields with an eBus-supported data type, and a
 * {@code public static} de-serialization inner class.
 * </p>
 */

package net.sf.eBus.messages;
