//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2001 - 2008, 2012. Charles W. Rapp.
// All Rights Reserved.
//

package net.sf.eBus.messages;

/**
 * This exception is thrown when an unknown message field is
 * referenced.
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public final class UnknownFieldException
    extends RuntimeException
{
//---------------------------------------------------------------
// Member data.
//

    //-----------------------------------------------------------
    // Constants.
    //

    /**
     * This is eBus version 2.1.0.
     */
    private static final long serialVersionUID = 0x050200L;

    //-----------------------------------------------------------
    // Locals.
    //

    /**
     * The message class name.
     */
    private final String mMessageName;

    /**
     * The unknown message field.
     */
    private  final String mField;

//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    /**
     * Constructs an exception for the given message name and
     * field name.
     * @param msgName message name.
     * @param field the unknown field.
     */
    public UnknownFieldException(final String msgName,
                                 final String field)
    {
        super (String.format("%s field %s unknown",
                            msgName,
                            field));

        mMessageName = msgName;
        mField = field;
    } // end of UnknownFieldExceptin(String, String)

    //
    // end of Constructors.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Get methods.
    //

    /**
     * Returns the message class name.
     * @return the message class name.
     */
    public String messageName()
    {
        return (mMessageName);
    } // end of messageName()

    /**
     * Returns the unknown field name.
     * @return the field name.
     */
    public String field()
    {
        return (mField);
    } // end of field()

    //
    // end of Get methods.
    //-----------------------------------------------------------
} // end of class UnknownFieldException
