/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA
 * 02111-1307 USA
 *
 * The Initial Developer of the Original Code is Charles W. Rapp.
 * Portions created by Charles W. Rapp are
 * Copyright 2018. Charles W. Rapp
 * All Rights Reserved.
 */

package net.sf.eBus.messages;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This field-level annotation is used to denote that an eBus
 * message field is optional and may be set to {@code null}.
 * An eBus message field is assumed required unless this
 * annotation is applied to the field declaration.
 * <p>
 * This annotation has no data members.
 * </p>
 *
 * @see net.sf.eBus.messages.type.MessageType.MessageField
 * @deprecated Use {@link javax.annotation.Nullable} instead.
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Documented
@Deprecated
public @interface Optional
{}
