/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA
 * 02111-1307 USA
 *
 * The Initial Developer of the Original Code is Charles W. Rapp.
 * Portions created by Charles W. Rapp are
 * Copyright 2019. Charles W. Rapp
 * All Rights Reserved.
 */

package net.sf.eBus.messages;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.Charset;

/**
 * This field-level, run-time annotation is used to define the
 * {@link Charset} used to serialize/de-serialize the associated
 * {@code String} field. If this annotation is not defined for
 * a string type, then
 * {@link net.sf.eBus.messages.type.DataType#CHARSET} is used.
 * <p>
 * This annotation is ignored if applied to a non-{@code String}
 * field.
 * </p>
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Documented
public @interface EStringInfo
{
    /**
     * Returns the name of the character set used to
     * serialize/de-serialize the {@code String} field. This
     * name must satisfy {@link Charset#forName(String)} and
     * return a character set instance. If this does not happen,
     * then {@link net.sf.eBus.messages.type.DataType#CHARSET}
     * is used.
     * @return character set name.
     */
    String charset();
} // end of annotation EStringInfo
