/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA
 * 02111-1307 USA
 *
 * The Initial Developer of the Original Code is Charles W. Rapp.
 * Portions created by Charles W. Rapp are
 * Copyright 2015, 2016, 2019. Charles W. Rapp
 * All Rights Reserved.
 */

package net.sf.eBus.messages;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This class-level annotation is required for all classes
 * extending {@link ERequestMessage}. This annotation contains
 * the {@link EReplyMessage} classes which may be sent in reply
 * to this request. The class {@code EReplyMessage} does not
 * need to be listed since it that message is allowed for all
 * request messages.
 * <p>
 * This annotation is cumulative from {@link ERequestMessage}
 * down through extending request message classes. Since
 * {@code ERequestMessage} defines {@code EReplyInfo} to allow
 * {@code EReplyMessage} as a reply. This means
 * {@code EReplyMessage} may be sent in reply to any request.
 * </p>
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface EReplyInfo
{
    /**
     * Returns the message classes which may be sent in reply
     * to a request message.
     * @return reply message classes.
     */
    Class<? extends EReplyMessage>[] replyMessageClasses();
} // end of annotation EReplyInfo
