/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA
 * 02111-1307 USA
 *
 * The Initial Developer of the Original Code is Charles W. Rapp.
 * Portions created by Charles W. Rapp are
 * Copyright 2011, 2013. Charles W. Rapp
 * All Rights Reserved.
 */

package net.sf.eBus.messages;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This class-level annotation is required for all classes
 * extending {@link EMessage EMessage} and {@link EField}. This
 * annotation contains the names of the serialized fields. The
 * field list defines the order in which fields are serialized
 * and de-serialized. The named fields are required to be both
 * public and final. The EField subclass also requires a
 * constructor with an argument list that matches the listed
 * fields both in order and data type.
 * <p>
 * The reason for this annotation is due to the fact that
 * {@link java.lang.Class#getFields()} returns an array which
 * is neither sorted nor in any particular order. The annotation
 * defines a field order which is necessary for remote eBus
 * applications to successfully serialize and de-serialize
 * eBus messages.
 * </p>
 * <p>
 * For more information about message objects and their
 * requirements, see {@link EMessageObject}.
 * </p>
 *
 * @deprecated this annotation is no longer used by eBus and
 * ignored if it appears in a class declaration.
 *
 * @see EMessageObject
 * @see EMessage
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Deprecated
public @interface EFieldInfo
{
    /**
     * Returns the field names. The order of the message fields
     * in this array is used to define field serialization,
     * de-serialization order, and constructor argument order.
     * @return the message field names.
     */
    String[] fields();
} // end of annotation EFieldInfo
