//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright 2015, 2016. Charles W. Rapp
// All Rights Reserved.
//

package net.sf.eBus.client.sysmessages;

import net.sf.eBus.messages.ESystemMessage;

/**
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

public enum SystemMessageType
{
    AD (-1, AdMessage.class),
    CANCEL_REQUEST (-2, CancelRequest.class),
    KEY_UPDATE (-3, KeyMessage.class),
    FEED_STATUS (-4, FeedStatusMessage.class),
    LOGOFF (-5, LogoffMessage.class),
    LOGON_COMPLETE (-6, LogonCompleteMessage.class),
    LOGON (-7, LogonMessage.class),
    LOGON_REPLY (-8, LogonReply.class),
    REMOTE_ACK (-9, RemoteAck.class),
    SUBSCRIBE (-10, SubscribeMessage.class),
    PAUSE_REQUEST (-11, PauseRequest.class),
    PAUSE_REPLY (-12, PauseReply.class),
    RESUME_REQUEST (-13, ResumeRequest.class),
    RESUME_REPLY (-14, ResumeReply.class);

    //-----------------------------------------------------------
    // Constructors.
    //

    /**
     * Creates a new system message type instance for the given
     * well-defined class identifier.
     * @param keyId unique class identifier.
     * @param mc message class.
     */
    private SystemMessageType(final int keyId,
                              final Class<? extends ESystemMessage> mc)
    {
        _keyId = keyId;
        _class = mc;
    } // end of SystemMessageType(int, Class)

    //
    // end of Constructors.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Get methods
    //

    /**
     * Returns the unique message key identifier.
     * @return message key identifier.
     */
    public int keyId()
    {
        return (_keyId);
    } // end of keyId()

    public Class<? extends ESystemMessage> messageClass()
    {
        return (_class);
    } // end of messageClass()

    //
    // end of Get methods.
    //-----------------------------------------------------------

//---------------------------------------------------------------
// Member data.
//

    /**
     * The system message class identifier. Used to map a message
     * class to its message reader.
     */
    private final int _keyId;

    /**
     * The unique identifier is for this class.
     */
    private final Class<? extends ESystemMessage> _class;
} // end of enum SystemMessageType
