//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright 2012, 2013, 2016, 2019. Charles W. Rapp
// All Rights Reserved.
//

package net.sf.eBus.client.sysmessages;

import java.io.Serializable;

/**
 * This message is sent to logon to a remote eBus application.
 * The subject contains this application Java VM identifier.
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public final class LogonMessage
    extends AbstractLogonMessage
    implements Serializable
{
//---------------------------------------------------------------
// Member data.
//

    //-----------------------------------------------------------
    // Constants.
    //

    /**
     * Serialization version identifier.
     */
    private static final long serialVersionUID = 0x050200L;

//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    /**
     * Creates a new logon message from the given message
     * builder.
     * @param builder logon message builder.
     */
    private LogonMessage(final Builder builder)
    {
        super (builder);
    } // end of LogonMessage(Builder)

    //
    // end of Constructors.
    //-----------------------------------------------------------

    /**
     * Returns a new instance of the {@code LogonMessage}
     * builder.
     * @return message builder instance.
     */
    public static Builder builder()
    {
        return (new Builder());
    } // end of builder()

//---------------------------------------------------------------
// Inner classes.
//

    /**
     * Class used to create {@link LogonMessage} instances. Used
     * by eBus to de-serialize an encoded message.
     */
    public static final class Builder
        extends AbstractLogonMessage.Builder<LogonMessage, Builder>
    {
    //-----------------------------------------------------------
    // Member data.
    //

    //-----------------------------------------------------------
    // Member methods.
    //

        //-------------------------------------------------------
        // Constructors.
        //

        private Builder()
        {
            super (LogonMessage.class);
        } // end of Builder()

        //
        // end of Constructors.
        //-------------------------------------------------------

        //-------------------------------------------------------
        // Builder Method Overrides.
        //

        /**
         * Returns the newly instantiated {@code LogonMessage}
         * based on this builder configuration.
         * @return target message instance.
         */
        @Override
        protected LogonMessage buildImpl()
        {
            return (new LogonMessage(this));
        } // end of buildImpl()

        //
        // end of Builder Method Overrides.
        //-------------------------------------------------------
    } // end of class Builder
} // end of class LogonMessage
