//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright 2014, 2016, 2019. Charles W. Rapp
// All Rights Reserved.
//

package net.sf.eBus.client.sysmessages;

import java.io.Serializable;

/**
 * This message is sent by both {@code ERemoteApp} peers to
 * signal that all initial advertisements are sent, completing
 * the logon process. When received, the
 * {@link net.sf.eBus.client.ConnectionMessage eBus connection}
 * subscribers are informed that this eBus is now successfully
 * logged on to the remote eBus application.
 * <p>
 * This message has no fields of its own.
 *
 * @see LogonMessage
 * @see LogonReply
 * @see AbstractLogonMessage
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

public final class LogonCompleteMessage
    extends AbstractLogonMessage
    implements Serializable
{
//---------------------------------------------------------------
// Member data.
//

    //-----------------------------------------------------------
    // Constants.
    //

    /**
     * Serialization version identifier.
     */
    private static final long serialVersionUID = 0x050200L;

//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    /**
     * Creates a new LogonCompleteMessage instance from the given
     * message builder.
     * @param builder message builder.
     */
    private LogonCompleteMessage(final Builder builder)
    {
        super (builder);
    } // end of LogonCompleteMessage(Builder)

    //
    // end of Constructors.
    //-----------------------------------------------------------

    /**
     * Returns a new instance of the {@code LogonCompleteMessage}
     * builder.
     * @return message builder instance.
     */
    public static Builder builder()
    {
        return (new Builder());
    } // end of builder()

//---------------------------------------------------------------
// Inner classes.
//

    /**
     * Class used to create {@link LogonCompleteMessage}
     * instances. Used by eBus to de-serialize an encoded
     * message.
     */
    public static final class Builder
        extends AbstractLogonMessage.Builder<LogonCompleteMessage, Builder>
    {
    //-----------------------------------------------------------
    // Member data.
    //

    //-----------------------------------------------------------
    // Member methods.
    //

        //-------------------------------------------------------
        // Constructors.
        //

        private Builder()
        {
            super (LogonCompleteMessage.class);
        } // end of Builder()

        //
        // end of Constructors.
        //-------------------------------------------------------

        //-------------------------------------------------------
        // Builder Method Overrides.
        //

        /**
         * Returns the newly instantiated
         * {@code LogonCompleteMessage} based on this builder
         * configuration.
         * @return target message instance.
         */
        @Override
        protected LogonCompleteMessage buildImpl()
        {
            return (new LogonCompleteMessage(this));
        } // end of buildImpl()

        //
        // end of Builder Method Overrides.
        //-------------------------------------------------------
    } // end of class Builder
} // end of class LogonCompleteMessage
