//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright 2012, 2014 - 2016, 2018. Charles W. Rapp
// All Rights Reserved.
//

/**
 * This package contains the top-level eBus API which
 * applications use to interact with eBus. This interaction is
 * done through {@link net.sf.eBus.client.EFeed} objects. All
 * feed objects are associated with a unique type+topic
 * {@link net.sf.eBus.messages.EMessageKey message key}.
 * <h1>Message Key Dictionary</h1>
 * <p>
 * eBus v. 4.5.0 added the ability to directly add messages keys
 * to the eBus message key dictionary and retrieve keys from said
 * dictionary. Prior to this version, message keys were
 * indirectly added to the dictionary when opening feeds. This
 * feature added to support the new
 * <a href="#MultiKeyFeed">multikey</a> feeds. Multi-key feeds
 * may use a {@link net.sf.eBus.util.regex.Pattern query} to
 * match a variable number of keys. This is why
 * {@link EFeed#addKey(net.sf.eBus.messages.EMessageKey)},
 * {@link EFeed#addAllKeys(java.util.Collection)} and
 * {@link EFeed#loadKeys(java.io.ObjectInputStream)} methods are
 * provided: unless the message key dictionary is populated with
 * keys prior to creating a multi-key query feed, the query would
 * find no matching keys.
 * </p>
 * <h1>Simple Feeds</h1>
 * <p>
 * A simple feed is associated with a single message key and
 * messages are sent to or received from the feed only after the
 * feed is opened and advertised/subscribed. Simple feeds provide
 * no value added capabilities beyond this.
 * </p>
 * <ol>
 *   <li>
 *     <b>{@link net.sf.eBus.client.EPublishFeed}</b>: Publishers
 *     advertise and publish
 *     {@link net.sf.eBus.messages.ENotificationMessage notification messages}
 *     via a publish feed instance.
 *   </li>
 *   <li>
 *     <b>{@link net.sf.eBus.client.ESubscribeFeed}</b>:
 *     Subscribers hook into this feed to receive notification
 *     messages.
 *   </li>
 *   <li>
 *     <b>{@link net.sf.eBus.client.EReplyFeed}</b>: Repliers
 *     advertise their ability to send
 *     {@link net.sf.eBus.messages.EReplyMessage reply messages}
 *     in response to a
 *     {@link net.sf.eBus.messages.ERequestMessage request messages}.
 *     <br>
 *     Note that replies are sent back using a
 *     {@link net.sf.eBus.client.EReplyFeed.ERequest} and not the
 *     {@code EReplyFeed}.
 *   </li>
 *   <li>
 *     <b>{@link net.sf.eBus.client.ERequestFeed}</b>: Requestors
 *     place request messages and receive replies using the
 *     request feed.
 *   </li>
 * </ol>
 * <h1><a id="MultiKeyFeed">Multi-Key Feeds</a></h1>
 * eBus v. 4.5.0 introduced multi-key feeds, one for each of the
 * above four simple feeds. A multi-key feed is not a true
 * {@link net.sf.eBus.client.EFeed} subclass but acts as a proxy
 * between an application object and multiple subordinate feeds.
 * The multi-key feed is responsible for keeping the subordinate
 * feeds in the same state (opened, advertised/subscribed,
 * un-advertised/un-subscribed, closed), configuring the
 * subordinate feeds with the same callbacks.
 * <p>
 * A multi-key feed is configured to work with a single
 * notification/request message class and multiple message
 * subjects. An application object needing a multi-key feed for
 * multiple message classes must open a different multi-key feed
 * for each message class.
 * </p>
 * The supported multi-key feeds are:
 * <ol>
 *   <li>
 *     <strong>{@link net.sf.eBus.client.EMultiPublishFeed}</strong>:
 *     uses {@code EPublishFeed} subordinate feeds.
 *   </li>
 *   <li>
 *     <strong>{@link net.sf.eBus.client.EMultiSubscribeFeed}</strong>:
 *     uses {@code ESubscribeFeed} subordinate feeds.
 *   </li>
 *   <li>
 *     <strong>{@link net.sf.eBus.client.EMultiRequestFeed}</strong>:
 *     uses {@code ERequestFeed} subordinate feeds.
 *   </li>
 *   <li>
 *     <strong>{@link net.sf.eBus.client.EMultiReplyFeed}</strong>:
 *     uses {@code EReplyFeed} subordinate feeds.
 *   </li>
 * </ol>
 * <h1>Roles</h1>
 * Each of the above feeds has a matching interface which an
 * application class must implement if it is to work with that
 * feed type:
 * <ul>
 *   <li>
 *     <b>{@link net.sf.eBus.client.EPublisher}</b>: Required
 *     interface for
 *     {@link net.sf.eBus.client.EPublishFeed#publish(net.sf.eBus.messages.ENotificationMessage) publishing}
 *     notification messages.
 *   </li>
 *   <li>
 *     <b>{@link net.sf.eBus.client.ESubscriber}</b>: Required
 *     interface for
 *     {@link net.sf.eBus.client.ESubscribeFeed#subscribe() subscribing}
 *     to notification messages.
 *   </li>
 *   <li>
 *     <b>{@link net.sf.eBus.client.EReplier}</b>: Required
 *     interface for
 *     {@link net.sf.eBus.client.EReplyFeed.ERequest#reply(net.sf.eBus.messages.EReplyMessage) replying}
 *     to requests.
 *   </li>
 *   <li>
 *     <b>{@link net.sf.eBus.client.ERequestor}</b>: Required
 *     interface for
 *     {@link net.sf.eBus.client.ERequestFeed#request(net.sf.eBus.messages.ERequestMessage) posting requests}.
 *   </li>
 * </ul>
 * <p>
 * eBus v. 4.2.0 added support for using Java lambda expressions
 * as a callback target. An application still must implement the
 * matching role interface for a given feed but is not required
 * to override interface methods. Instead, an application uses
 * Java lambda expressions to define the callback target. See
 * {@link net.sf.eBus.client.FeedStatusCallback},
 * {@link net.sf.eBus.client.NotifyCallback},
 * {@link net.sf.eBus.client.ReplyCallback}, and
 * {@link net.sf.eBus.client.RequestCallback} for more
 * information.
 * </p>
 * <h1>Remote Communication</h1>
 * eBus applications may communicate with one another by
 * establishing TCP connections between them. This is done by
 * having one eBus application open a
 * {@link net.sf.eBus.client.EServer} on a configurable port and
 * the other eBus application open a
 * {@link net.sf.eBus.client.ERemoteApp} to the first
 * application's host address and server port. Note that only
 * one connection is allowed between eBus applications. eBus
 * applications are not allowed to both open server ports and
 * both establish a remote connection to the other.
 * <p>
 * (Note that all eBus applications are allowed to open an
 * {@code EServer} port. But if an eBus application attempts to
 * connect to another application
 * <em>and a connection already exists</em>, then the second
 * connection will be automatically closed.)
 * </p>
 * <p>
 * An application can monitor eBus connections by creating an
 * {@link net.sf.eBus.client.ESubscriber} which subscribes to
 * {@link net.sf.eBus.client.ServerMessage#MESSAGE_KEY} for
 * {@code EServer}
 * {@link net.sf.eBus.client.ServerMessage events} and
 * {@link net.sf.eBus.client.ConnectionMessage#MESSAGE_KEY} for
 * {@code ERemoteApp}
 * {@link net.sf.eBus.client.ConnectionMessage events}.
 * </p>
 * <p>
 * Applications may configure eBus server and remote connections
 * by using either a properties file, user preferences or
 * programmatically with
 * {@link net.sf.eBus.config.EConfigure.ServerBuilder} and
 * {@link net.sf.eBus.config.EConfigure.ConnectionBuilder}
 * classes. See {@link net.sf.eBus.config.EConfigure} document
 * for a detailed explanation of connection properties. The
 * builders are covered under a their respective documents.
 * </p>
 */

package net.sf.eBus.client;
