/*
 * ex: set ro:
 * DO NOT EDIT.
 * generated by smc (http://smc.sourceforge.net/)
 * from file : TestSubscriber.sm.sm
 */


//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2009 - 2011, 2015. Charles W. Rapp.
// All Rights Reserved.
//


package net.sf.eBus.client;

import net.sf.eBus.messages.ENotificationMessage;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.lang.invoke.MethodType;
import statemap.FSMContext7;
import statemap.State7;
import statemap.TransitionHandle;

public class TestSubscriberContext
    extends FSMContext7
{
//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    public TestSubscriberContext(final TestSubscriber owner)
    {
        this (owner, _States[Unsubscribe_TestStart_STATE_ID]);
    }

    public TestSubscriberContext(final TestSubscriber owner, final int initStateId)
    {
        this (owner, _States[initStateId]);    }

    public TestSubscriberContext(final TestSubscriber owner, final State7 initState)
    {
        super (initState);

        ctxt = owner;
    }

    //
    // end of Constructors.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FSMContext7 Abstract Method Override.
    //

    @Override
    protected void executeAction(final MethodHandle mh)
    {
        try
        {
            mh.invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }

        return;
    }

    //
    // end of FSMContext7 Abstract Method Override.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Transitions.
    //

    public void feedStatus(final EFeedState feedState)
    {
        _transition = "feedStatus";
        try
        {
            final TransitionHandle th =
                getState().transition(feedStatus1_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, feedState);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void notify(final ENotificationMessage msg)
    {
        _transition = "notify";
        try
        {
            final TransitionHandle th =
                getState().transition(notify2_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void testError()
    {
        _transition = "testError";
        try
        {
            final TransitionHandle th =
                getState().transition(testError3_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    //
    // end of Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NoTest.TestDone State Entry/Exit Actions.
    //

    private void NoTest_TestDone__Entry_()
    {
        ctxt.unsubscribe();
        ctxt.signalDone();
    }

    //
    // end of NoTest.TestDone State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NoTest.TestDone State Transitions.
    //

    private void NoTest_TestDone_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void NoTest_TestDone_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void NoTest_TestDone_notify(final ENotificationMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void NoTest_TestDone_testError()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of NoTest.TestDone State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Unsubscribe.TestStart State Entry/Exit Actions.
    //

    private void Unsubscribe_TestStart__Entry_()
    {
        ctxt.subscribe();
    }

    //
    // end of Unsubscribe.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Unsubscribe.TestStart State Transitions.
    //

    private void Unsubscribe_TestStart_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalStateException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Unsubscribe_TestStart_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.unsubscribe();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Unsubscribe_TestStart_testError()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of Unsubscribe.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UnsubscribeAll.TestStart State Entry/Exit Actions.
    //

    private void UnsubscribeAll_TestStart__Entry_()
    {
        ctxt.subscribe();
    }

    //
    // end of UnsubscribeAll.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UnsubscribeAll.TestStart State Transitions.
    //

    private void UnsubscribeAll_TestStart_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalStateException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void UnsubscribeAll_TestStart_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.unsubscribe();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void UnsubscribeAll_TestStart_testError()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of UnsubscribeAll.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NoFeeds.TestStart State Entry/Exit Actions.
    //

    private void NoFeeds_TestStart__Entry_()
    {
        ctxt.subscribe();
    }

    //
    // end of NoFeeds.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NoFeeds.TestStart State Transitions.
    //

    private void NoFeeds_TestStart_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalStateException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void NoFeeds_TestStart_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        if (feedState == EFeedState.UP)
        {
            exitState();

            try
            {
                clearState();
                ctxt.storeException(new IllegalStateException(
                    "unexpected feed"));
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void NoFeeds_TestStart_testError()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of NoFeeds.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FeedUp.Default State Transitions.
    //

    private void FeedUp_Default_testError()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void FeedUp_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalStateException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of FeedUp.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FeedUp.TestStart State Entry/Exit Actions.
    //

    private void FeedUp_TestStart__Entry_()
    {
        ctxt.subscribe();
    }

    //
    // end of FeedUp.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FeedUp.TestStart State Transitions.
    //

    private void FeedUp_TestStart_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        if (feedState == EFeedState.UP)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[FeedUp_FeedUp_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
            }
            finally
            {
            }

        }

        return;
    }


    //
    // end of FeedUp.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FeedUp.FeedUp State Transitions.
    //

    private void FeedUp_FeedUp_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        if (feedState == EFeedState.DOWN)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
            }
            finally
            {
            }

        }

        return;
    }


    private void FeedUp_FeedUp_notify(final ENotificationMessage msg)
    {
        final int stateId = _state.getId();

        if (ctxt.incrementReceivedCount() >= ctxt.receiveCount())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
            }
            finally
            {
            }

        }

        return;
    }


    //
    // end of FeedUp.FeedUp State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MultiFeed.Default State Transitions.
    //

    private void MultiFeed_Default_testError()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void MultiFeed_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalStateException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of MultiFeed.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MultiFeed.TestStart State Entry/Exit Actions.
    //

    private void MultiFeed_TestStart__Entry_()
    {
        ctxt.subscribe();
    }

    //
    // end of MultiFeed.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MultiFeed.TestStart State Transitions.
    //

    private void MultiFeed_TestStart_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        if (feedState == EFeedState.DOWN)
        {
            try
            {
                // No actions.
            }
            finally
            {
            }

        }
        else
        {
            exitState();

            try
            {
            }
            finally
            {
                setState(_States[MultiFeed_FeedUp_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of MultiFeed.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MultiFeed.FeedUp State Transitions.
    //

    private void MultiFeed_FeedUp_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void MultiFeed_FeedUp_notify(final ENotificationMessage msg)
    {
        final int stateId = _state.getId();

        if (ctxt.incrementReceivedCount() >= ctxt.receiveCount())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
            }
            finally
            {
            }

        }

        return;
    }


    //
    // end of MultiFeed.FeedUp State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UpAndDown.Default State Transitions.
    //

    private void UpAndDown_Default_testError()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void UpAndDown_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalStateException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of UpAndDown.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UpAndDown.TestStart State Entry/Exit Actions.
    //

    private void UpAndDown_TestStart__Entry_()
    {
        ctxt.subscribe();
    }

    //
    // end of UpAndDown.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UpAndDown.TestStart State Transitions.
    //

    private void UpAndDown_TestStart_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        if (feedState == EFeedState.UP)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[UpAndDown_FeedUp_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
            }
            finally
            {
            }

        }

        return;
    }


    //
    // end of UpAndDown.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UpAndDown.FeedUp State Transitions.
    //

    private void UpAndDown_FeedUp_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        if (feedState == EFeedState.DOWN)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[UpAndDown_FeedDown_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
            }
            finally
            {
            }

        }

        return;
    }


    private void UpAndDown_FeedUp_notify(final ENotificationMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.incrementReceivedCount();
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    //
    // end of UpAndDown.FeedUp State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UpAndDown.FeedDown State Transitions.
    //

    private void UpAndDown_FeedDown_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        if (feedState == EFeedState.UP)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[UpAndDown_FeedUpAgain_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
            }
            finally
            {
            }

        }

        return;
    }


    private void UpAndDown_FeedDown_notify(final ENotificationMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.incrementReceivedCount();
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    //
    // end of UpAndDown.FeedDown State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // UpAndDown.FeedUpAgain State Transitions.
    //

    private void UpAndDown_FeedUpAgain_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        if (feedState == EFeedState.DOWN)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
            }
            finally
            {
            }

        }

        return;
    }


    private void UpAndDown_FeedUpAgain_notify(final ENotificationMessage msg)
    {
        final int stateId = _state.getId();

        if (ctxt.incrementReceivedCount() >= ctxt.receiveCount())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
            }
            finally
            {
            }

        }

        return;
    }


    //
    // end of UpAndDown.FeedUpAgain State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Resubscribe.Default State Transitions.
    //

    private void Resubscribe_Default_notify(final ENotificationMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void Resubscribe_Default_testError()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Resubscribe_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalStateException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of Resubscribe.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Resubscribe.TestStart State Entry/Exit Actions.
    //

    private void Resubscribe_TestStart__Entry_()
    {
        ctxt.subscribe();
    }

    //
    // end of Resubscribe.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Resubscribe.TestStart State Transitions.
    //

    private void Resubscribe_TestStart_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        if (feedState == EFeedState.UP)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[Resubscribe_FeedUp_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
            }
            finally
            {
            }

        }

        return;
    }


    //
    // end of Resubscribe.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Resubscribe.FeedUp State Entry/Exit Actions.
    //

    private void Resubscribe_FeedUp__Entry_()
    {
        ctxt.unsubscribe();
        ctxt.resubscribe();
    }

    //
    // end of Resubscribe.FeedUp State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Resubscribe.FeedUp State Transitions.
    //

    private void Resubscribe_FeedUp_feedStatus(final EFeedState feedState)
    {
        final int stateId = _state.getId();

        if (feedState == EFeedState.UP)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
            }
            finally
            {
            }

        }

        return;
    }


    //
    // end of Resubscribe.FeedUp State Transitions.
    //-----------------------------------------------------------

//---------------------------------------------------------------
// Member data.
//

    transient private TestSubscriber ctxt;

    //-----------------------------------------------------------
    // Constants.
    //

    private static final long serialVersionUID = 1L;

    public static final int NoTest_TestDone_STATE_ID = 0;

    public static final int Unsubscribe_TestStart_STATE_ID = 1;

    public static final int UnsubscribeAll_TestStart_STATE_ID = 2;

    public static final int NoFeeds_TestStart_STATE_ID = 3;

    public static final int FeedUp_TestStart_STATE_ID = 4;
    public static final int FeedUp_FeedUp_STATE_ID = 5;

    public static final int MultiFeed_TestStart_STATE_ID = 6;
    public static final int MultiFeed_FeedUp_STATE_ID = 7;

    public static final int UpAndDown_TestStart_STATE_ID = 8;
    public static final int UpAndDown_FeedUp_STATE_ID = 9;
    public static final int UpAndDown_FeedDown_STATE_ID = 10;
    public static final int UpAndDown_FeedUpAgain_STATE_ID = 11;

    public static final int Resubscribe_TestStart_STATE_ID = 12;
    public static final int Resubscribe_FeedUp_STATE_ID = 13;

    private static final int STATE_COUNT = 14;

    private static final int feedStatus1_TRANSITION_ID = 1;
    private static final int notify2_TRANSITION_ID = 2;
    private static final int testError3_TRANSITION_ID = 3;

    private static final int TRANSITION_COUNT = 4;

    private static final MethodType[] TRANSITION_TYPES =
    {
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, EFeedState.class),
        MethodType.methodType(void.class, ENotificationMessage.class),
        NO_ARGS_TYPE
    };

    private static final String[] MAP_NAMES =
    {
        "NoTest",
        "Unsubscribe",
        "UnsubscribeAll",
        "NoFeeds",
        "FeedUp",
        "MultiFeed",
        "UpAndDown",
        "Resubscribe"
    };

    private static final String[][] STATE_NAMES =
    {
        new String[]
        {
            "TestDone"
        },

        new String[]
        {
            "TestStart"
        },

        new String[]
        {
            "TestStart"
        },

        new String[]
        {
            "TestStart"
        },

        new String[]
        {
            "TestStart",
            "FeedUp"
        },

        new String[]
        {
            "TestStart",
            "FeedUp"
        },

        new String[]
        {
            "TestStart",
            "FeedUp",
            "FeedDown",
            "FeedUpAgain"
        },

        new String[]
        {
            "TestStart",
            "FeedUp"
        }
    };

    private static String[][] STATE_TRANSITIONS =
    {
        new String[]
        {
            "Default",
            "feedStatus",
            "notify",
            "testError"
        },

        new String[]
        {
            "Default",
            "feedStatus",
            "testError"
        },

        new String[]
        {
            "Default",
            "feedStatus",
            "testError"
        },

        new String[]
        {
            "Default",
            "feedStatus",
            "testError"
        },

        new String[]
        {
            "feedStatus"
        },

        new String[]
        {
            "feedStatus",
            "notify"
        },

        new String[]
        {
            "feedStatus"
        },

        new String[]
        {
            "feedStatus",
            "notify"
        },

        new String[]
        {
            "feedStatus"
        },

        new String[]
        {
            "feedStatus",
            "notify"
        },

        new String[]
        {
            "feedStatus",
            "notify"
        },

        new String[]
        {
            "feedStatus",
            "notify"
        },

        new String[]
        {
            "feedStatus"
        },

        new String[]
        {
            "feedStatus"
        }
    };

    private static final String[] TRANSITION_NAMES =
    {
        "Default",
        "feedStatus",
        "notify",
        "testError"
    };

    private static final State7[] _States = new State7[STATE_COUNT];

    static
    {
        final Lookup lookup = MethodHandles.lookup();
        final Class<?> clazz = TestSubscriberContext.class;
        final int mapSize = MAP_NAMES.length;
        int stateSize;
        int mapIndex;
        int stateIndex;
        int transIndex;
        int stateId = 0;
        String mapName;
        String stateName;
        String transName;
        String methodName;
        MethodType transType;
        MethodHandle entryHandle;
        MethodHandle exitHandle;
        TransitionHandle[] transitions;

        for (mapIndex = 0; mapIndex < mapSize; ++mapIndex)
        {
            mapName = MAP_NAMES[mapIndex];
            stateSize = STATE_NAMES[mapIndex].length;

            for (stateIndex = 0; stateIndex < stateSize; ++stateIndex, ++stateId)
            {
                stateName = STATE_NAMES[mapIndex][stateIndex];
                transitions = new TransitionHandle[TRANSITION_COUNT];

                methodName = String.format(ENTRY_NAME, mapName, stateName);
                entryHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);
                methodName = String.format(EXIT_NAME, mapName, stateName);
                exitHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);

                for (transIndex = 1; transIndex < TRANSITION_COUNT; ++transIndex)
                {
                    transName = TRANSITION_NAMES[transIndex];
                    transType = TRANSITION_TYPES[transIndex];
                    transitions[transIndex] =
                        lookupTransition(lookup, clazz, mapName, stateName, transName, transType);
                }

                _States[stateId] =
                    new State7(
                        String.format(STATE_NAME_FORMAT, mapName, stateName),
                        stateId,
                        entryHandle,
                        exitHandle,
                        transitions,
                        STATE_TRANSITIONS[stateId]);

            }
        }
    }
}

/*
 * Local variables:
 *  buffer-read-only: t
 * End:
 */
