/*
 * ex: set ro:
 * DO NOT EDIT.
 * generated by smc (http://smc.sourceforge.net/)
 * from file : TestRequestor.sm.sm
 */


//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2009 - 2011, 2015. Charles W. Rapp.
// All Rights Reserved.
//


package net.sf.eBus.client;

import static net.sf.eBus.client.ERequestFeed.RequestState;
import net.sf.eBus.messages.EReplyMessage;
import static net.sf.eBus.messages.EReplyMessage.ReplyStatus;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.lang.invoke.MethodType;
import statemap.FSMContext7;
import statemap.State7;
import statemap.TransitionHandle;

public class TestRequestorContext
    extends FSMContext7
{
//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    public TestRequestorContext(final TestRequestor owner)
    {
        this (owner, _States[NoReplier_TestStart_STATE_ID]);
    }

    public TestRequestorContext(final TestRequestor owner, final int initStateId)
    {
        this (owner, _States[initStateId]);    }

    public TestRequestorContext(final TestRequestor owner, final State7 initState)
    {
        super (initState);

        ctxt = owner;
    }

    //
    // end of Constructors.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FSMContext7 Abstract Method Override.
    //

    @Override
    protected void executeAction(final MethodHandle mh)
    {
        try
        {
            mh.invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }

        return;
    }

    //
    // end of FSMContext7 Abstract Method Override.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Transitions.
    //

    public void cancelOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        _transition = "cancelOrderReply";
        try
        {
            final TransitionHandle th =
                getState().transition(cancelOrderReply6_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, status, reason, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void cancelReply(final RequestState reqState)
    {
        _transition = "cancelReply";
        try
        {
            final TransitionHandle th =
                getState().transition(cancelReply9_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, reqState);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void modifyOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        _transition = "modifyOrderReply";
        try
        {
            final TransitionHandle th =
                getState().transition(modifyOrderReply5_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, status, reason, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void newOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        _transition = "newOrderReply";
        try
        {
            final TransitionHandle th =
                getState().transition(newOrderReply4_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, status, reason, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void noMoreReplies()
    {
        _transition = "noMoreReplies";
        try
        {
            final TransitionHandle th =
                getState().transition(noMoreReplies3_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void sendRequest(final Side side, final int qty)
    {
        _transition = "sendRequest";
        try
        {
            final TransitionHandle th =
                getState().transition(sendRequest2_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, side, qty);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void testError(final Throwable t)
    {
        _transition = "testError";
        try
        {
            final TransitionHandle th =
                getState().transition(testError8_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, t);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void unknownRequest()
    {
        _transition = "unknownRequest";
        try
        {
            final TransitionHandle th =
                getState().transition(unknownRequest7_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    //
    // end of Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NoTest.TestDone State Entry/Exit Actions.
    //

    private void NoTest_TestDone__Entry_()
    {
        ctxt.signalDone();
    }

    //
    // end of NoTest.TestDone State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NoTest.TestDone State Transitions.
    //

    private void NoTest_TestDone_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of NoTest.TestDone State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // DoNothing.TestStart State Transitions.
    //

    private void DoNothing_TestStart_Default()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of DoNothing.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NoReplier.Default State Transitions.
    //

    private void NoReplier_Default_noMoreReplies()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void NoReplier_Default_newOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected new reply");
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void NoReplier_Default_modifyOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected modify reply");
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void NoReplier_Default_cancelOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected cancel reply");
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void NoReplier_Default_unknownRequest()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("reply to unknown request");
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void NoReplier_Default_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
            ctxt.storeException(t);
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void NoReplier_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of NoReplier.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NoReplier.TestStart State Transitions.
    //

    private void NoReplier_TestStart_sendRequest(final Side side, final int qty)
    {
        final int stateId = _state.getId();

        if (ctxt.marketOrder(side, qty) == false)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearRequests();
                ctxt.failed("request sent");
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of NoReplier.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ErrorReply.Default State Transitions.
    //

    private void ErrorReply_Default_noMoreReplies()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ErrorReply_Default_modifyOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected modify reply");
        }
        finally
        {
            setState(_States[ErrorReply_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ErrorReply_Default_cancelOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected cancel reply");
        }
        finally
        {
            setState(_States[ErrorReply_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ErrorReply_Default_unknownRequest()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("reply to unknown request");
        }
        finally
        {
            setState(_States[ErrorReply_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ErrorReply_Default_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
            ctxt.storeException(t);
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ErrorReply_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of ErrorReply.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ErrorReply.TestStart State Transitions.
    //

    private void ErrorReply_TestStart_sendRequest(final Side side, final int qty)
    {
        final int stateId = _state.getId();

        if (ctxt.marketOrder(side, qty) == false)
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearRequests();
                ctxt.failed("no repliers");
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
            }
            finally
            {
                setState(_States[ErrorReply_WaitForReply_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of ErrorReply.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ErrorReply.WaitForReply State Transitions.
    //

    private void ErrorReply_WaitForReply_newOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        if (status == EReplyMessage.ReplyStatus.ERROR)
        {
            try
            {
                // No actions.
            }
            finally
            {
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.failed("unexpected success");
            }
            finally
            {
                setState(_States[ErrorReply_Failed_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of ErrorReply.WaitForReply State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ErrorReply.Failed State Transitions.
    //

    private void ErrorReply_Failed_cancelOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void ErrorReply_Failed_modifyOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void ErrorReply_Failed_newOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void ErrorReply_Failed_unknownRequest()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of ErrorReply.Failed State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // RejectReply.Default State Transitions.
    //

    private void RejectReply_Default_noMoreReplies()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void RejectReply_Default_modifyOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected modify reply");
        }
        finally
        {
            setState(_States[RejectReply_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void RejectReply_Default_cancelOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected cancel reply");
        }
        finally
        {
            setState(_States[RejectReply_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void RejectReply_Default_unknownRequest()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("reply to unknown request");
        }
        finally
        {
            setState(_States[RejectReply_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void RejectReply_Default_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
            ctxt.storeException(t);
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void RejectReply_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of RejectReply.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // RejectReply.TestStart State Transitions.
    //

    private void RejectReply_TestStart_sendRequest(final Side side, final int qty)
    {
        final int stateId = _state.getId();

        if (ctxt.marketOrder(side, qty) == false)
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearRequests();
                ctxt.failed("no repliers");
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
            }
            finally
            {
                setState(_States[RejectReply_WaitForReply_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of RejectReply.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // RejectReply.WaitForReply State Transitions.
    //

    private void RejectReply_WaitForReply_newOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        if (status == ReplyStatus.ERROR)
        {
            try
            {
                // No actions.
            }
            finally
            {
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.failed("unexpected success");
            }
            finally
            {
                setState(_States[RejectReply_Failed_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of RejectReply.WaitForReply State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // RejectReply.Failed State Transitions.
    //

    private void RejectReply_Failed_cancelOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void RejectReply_Failed_modifyOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void RejectReply_Failed_newOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void RejectReply_Failed_unknownRequest()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of RejectReply.Failed State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // OKReply.Default State Transitions.
    //

    private void OKReply_Default_noMoreReplies()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OKReply_Default_modifyOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected modify reply");
        }
        finally
        {
            setState(_States[OKReply_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OKReply_Default_cancelOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected cancel order reply");
        }
        finally
        {
            setState(_States[OKReply_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OKReply_Default_cancelReply(final RequestState reqState)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected cancel reply");
        }
        finally
        {
            setState(_States[OKReply_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OKReply_Default_unknownRequest()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("reply to unknown request");
        }
        finally
        {
            setState(_States[OKReply_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OKReply_Default_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
            ctxt.storeException(t);
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OKReply_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of OKReply.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // OKReply.TestStart State Transitions.
    //

    private void OKReply_TestStart_sendRequest(final Side side, final int qty)
    {
        final int stateId = _state.getId();

        if (ctxt.marketOrder(side, qty) == false)
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearRequests();
                ctxt.failed("no repliers");
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
            }
            finally
            {
                setState(_States[OKReply_WaitForReply_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of OKReply.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // OKReply.WaitForReply State Transitions.
    //

    private void OKReply_WaitForReply_newOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        if (status == ReplyStatus.ERROR)
        {
            exitState();

            try
            {
                clearState();
                ctxt.failed(reason);
            }
            finally
            {
                setState(_States[OKReply_Failed_STATE_ID]);
            }

            enterState();
        }
        else
        {
            try
            {
            }
            finally
            {
            }

        }

        return;
    }


    //
    // end of OKReply.WaitForReply State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // OKReply.Failed State Transitions.
    //

    private void OKReply_Failed_cancelOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void OKReply_Failed_modifyOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void OKReply_Failed_newOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void OKReply_Failed_unknownRequest()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of OKReply.Failed State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Cancel.Default State Transitions.
    //

    private void Cancel_Default_noMoreReplies()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Cancel_Default_newOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("request not canceled");
        }
        finally
        {
            setState(_States[Cancel_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Cancel_Default_modifyOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected modify reply");
        }
        finally
        {
            setState(_States[Cancel_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Cancel_Default_cancelOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected cancel order reply");
        }
        finally
        {
            setState(_States[Cancel_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Cancel_Default_cancelReply(final RequestState reqState)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected cancel reply");
        }
        finally
        {
            setState(_States[Cancel_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Cancel_Default_unknownRequest()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("reply to unknown request");
        }
        finally
        {
            setState(_States[Cancel_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Cancel_Default_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
            ctxt.storeException(t);
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Cancel_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of Cancel.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Cancel.TestStart State Transitions.
    //

    private void Cancel_TestStart_sendRequest(final Side side, final int qty)
    {
        final int stateId = _state.getId();

        if (ctxt.marketOrder(side, qty) == false)
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearRequests();
                ctxt.failed("no repliers");
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else if (ctxt.unrequest() == false)
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearRequests();
                ctxt.failed("unrequest failed");
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearRequests();
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of Cancel.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Cancel.Failed State Transitions.
    //

    private void Cancel_Failed_cancelOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void Cancel_Failed_modifyOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void Cancel_Failed_newOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void Cancel_Failed_unknownRequest()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of Cancel.Failed State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Close.Default State Transitions.
    //

    private void Close_Default_noMoreReplies()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Close_Default_newOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("request not canceled");
        }
        finally
        {
            setState(_States[Close_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Close_Default_modifyOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected modify reply");
        }
        finally
        {
            setState(_States[Close_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Close_Default_cancelOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected cancel order reply");
        }
        finally
        {
            setState(_States[Close_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Close_Default_cancelReply(final RequestState reqState)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("unexpected cancel reply");
        }
        finally
        {
            setState(_States[Close_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Close_Default_unknownRequest()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("reply to unknown request");
        }
        finally
        {
            setState(_States[Close_Failed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Close_Default_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
            ctxt.storeException(t);
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Close_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequests();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of Close.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Close.TestStart State Transitions.
    //

    private void Close_TestStart_sendRequest(final Side side, final int qty)
    {
        final int stateId = _state.getId();

        if (ctxt.marketOrder(side, qty) == false)
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearRequests();
                ctxt.failed("no repliers");
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else if (ctxt.closeRequest() == false)
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearRequests();
                ctxt.failed("unrequest failed");
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearRequests();
            }
            finally
            {
                setState(_States[NoTest_TestDone_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of Close.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Close.Failed State Transitions.
    //

    private void Close_Failed_cancelOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void Close_Failed_modifyOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void Close_Failed_newOrderReply(final ReplyStatus status, final String reason, final EReplyMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void Close_Failed_unknownRequest()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of Close.Failed State Transitions.
    //-----------------------------------------------------------

//---------------------------------------------------------------
// Member data.
//

    transient private TestRequestor ctxt;

    //-----------------------------------------------------------
    // Constants.
    //

    private static final long serialVersionUID = 1L;

    public static final int NoTest_TestDone_STATE_ID = 0;

    public static final int DoNothing_TestStart_STATE_ID = 1;

    public static final int NoReplier_TestStart_STATE_ID = 2;

    public static final int ErrorReply_TestStart_STATE_ID = 3;
    public static final int ErrorReply_WaitForReply_STATE_ID = 4;
    public static final int ErrorReply_Failed_STATE_ID = 5;

    public static final int RejectReply_TestStart_STATE_ID = 6;
    public static final int RejectReply_WaitForReply_STATE_ID = 7;
    public static final int RejectReply_Failed_STATE_ID = 8;

    public static final int OKReply_TestStart_STATE_ID = 9;
    public static final int OKReply_WaitForReply_STATE_ID = 10;
    public static final int OKReply_Failed_STATE_ID = 11;

    public static final int Cancel_TestStart_STATE_ID = 12;
    public static final int Cancel_Failed_STATE_ID = 13;

    public static final int Close_TestStart_STATE_ID = 14;
    public static final int Close_Failed_STATE_ID = 15;

    private static final int STATE_COUNT = 16;

    private static final int cancelOrderReply6_TRANSITION_ID = 1;
    private static final int cancelReply9_TRANSITION_ID = 2;
    private static final int modifyOrderReply5_TRANSITION_ID = 3;
    private static final int newOrderReply4_TRANSITION_ID = 4;
    private static final int noMoreReplies3_TRANSITION_ID = 5;
    private static final int sendRequest2_TRANSITION_ID = 6;
    private static final int testError8_TRANSITION_ID = 7;
    private static final int unknownRequest7_TRANSITION_ID = 8;

    private static final int TRANSITION_COUNT = 9;

    private static final MethodType[] TRANSITION_TYPES =
    {
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, ReplyStatus.class, String.class, EReplyMessage.class),
        MethodType.methodType(void.class, RequestState.class),
        MethodType.methodType(void.class, ReplyStatus.class, String.class, EReplyMessage.class),
        MethodType.methodType(void.class, ReplyStatus.class, String.class, EReplyMessage.class),
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, Side.class, int.class),
        MethodType.methodType(void.class, Throwable.class),
        NO_ARGS_TYPE
    };

    private static final String[] MAP_NAMES =
    {
        "NoTest",
        "DoNothing",
        "NoReplier",
        "ErrorReply",
        "RejectReply",
        "OKReply",
        "Cancel",
        "Close"
    };

    private static final String[][] STATE_NAMES =
    {
        new String[]
        {
            "TestDone"
        },

        new String[]
        {
            "TestStart"
        },

        new String[]
        {
            "TestStart"
        },

        new String[]
        {
            "TestStart",
            "WaitForReply",
            "Failed"
        },

        new String[]
        {
            "TestStart",
            "WaitForReply",
            "Failed"
        },

        new String[]
        {
            "TestStart",
            "WaitForReply",
            "Failed"
        },

        new String[]
        {
            "TestStart",
            "Failed"
        },

        new String[]
        {
            "TestStart",
            "Failed"
        }
    };

    private static String[][] STATE_TRANSITIONS =
    {
        new String[]
        {
            "Default"
        },

        new String[]
        {
            "Default"
        },

        new String[]
        {
            "sendRequest"
        },

        new String[]
        {
            "sendRequest"
        },

        new String[]
        {
            "newOrderReply"
        },

        new String[]
        {
            "cancelOrderReply",
            "modifyOrderReply",
            "newOrderReply",
            "unknownRequest"
        },

        new String[]
        {
            "sendRequest"
        },

        new String[]
        {
            "newOrderReply"
        },

        new String[]
        {
            "cancelOrderReply",
            "modifyOrderReply",
            "newOrderReply",
            "unknownRequest"
        },

        new String[]
        {
            "sendRequest"
        },

        new String[]
        {
            "newOrderReply"
        },

        new String[]
        {
            "cancelOrderReply",
            "modifyOrderReply",
            "newOrderReply",
            "unknownRequest"
        },

        new String[]
        {
            "sendRequest"
        },

        new String[]
        {
            "cancelOrderReply",
            "modifyOrderReply",
            "newOrderReply",
            "unknownRequest"
        },

        new String[]
        {
            "sendRequest"
        },

        new String[]
        {
            "cancelOrderReply",
            "modifyOrderReply",
            "newOrderReply",
            "unknownRequest"
        }
    };

    private static final String[] TRANSITION_NAMES =
    {
        "Default",
        "cancelOrderReply",
        "cancelReply",
        "modifyOrderReply",
        "newOrderReply",
        "noMoreReplies",
        "sendRequest",
        "testError",
        "unknownRequest"
    };

    private static final State7[] _States = new State7[STATE_COUNT];

    static
    {
        final Lookup lookup = MethodHandles.lookup();
        final Class<?> clazz = TestRequestorContext.class;
        final int mapSize = MAP_NAMES.length;
        int stateSize;
        int mapIndex;
        int stateIndex;
        int transIndex;
        int stateId = 0;
        String mapName;
        String stateName;
        String transName;
        String methodName;
        MethodType transType;
        MethodHandle entryHandle;
        MethodHandle exitHandle;
        TransitionHandle[] transitions;

        for (mapIndex = 0; mapIndex < mapSize; ++mapIndex)
        {
            mapName = MAP_NAMES[mapIndex];
            stateSize = STATE_NAMES[mapIndex].length;

            for (stateIndex = 0; stateIndex < stateSize; ++stateIndex, ++stateId)
            {
                stateName = STATE_NAMES[mapIndex][stateIndex];
                transitions = new TransitionHandle[TRANSITION_COUNT];

                methodName = String.format(ENTRY_NAME, mapName, stateName);
                entryHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);
                methodName = String.format(EXIT_NAME, mapName, stateName);
                exitHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);

                for (transIndex = 1; transIndex < TRANSITION_COUNT; ++transIndex)
                {
                    transName = TRANSITION_NAMES[transIndex];
                    transType = TRANSITION_TYPES[transIndex];
                    transitions[transIndex] =
                        lookupTransition(lookup, clazz, mapName, stateName, transName, transType);
                }

                _States[stateId] =
                    new State7(
                        String.format(STATE_NAME_FORMAT, mapName, stateName),
                        stateId,
                        entryHandle,
                        exitHandle,
                        transitions,
                        STATE_TRANSITIONS[stateId]);

            }
        }
    }
}

/*
 * Local variables:
 *  buffer-read-only: t
 * End:
 */
