/*
 * ex: set ro:
 * DO NOT EDIT.
 * generated by smc (http://smc.sourceforge.net/)
 * from file : TestReplier.sm.sm
 */


//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2009 - 2011, 2013, 2105. Charles W. Rapp.
// All Rights Reserved.
//


package net.sf.eBus.client;

import net.sf.eBus.client.EReplyFeed.ERequest;
import static net.sf.eBus.messages.EReplyMessage.ReplyStatus;
import net.sf.eBus.messages.ERequestMessage;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.lang.invoke.MethodType;
import statemap.FSMContext7;
import statemap.State7;
import statemap.TransitionHandle;

public class TestReplierContext
    extends FSMContext7
{
//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    public TestReplierContext(final TestReplier owner)
    {
        this (owner, _States[ErrorReply_TestStart_STATE_ID]);
    }

    public TestReplierContext(final TestReplier owner, final int initStateId)
    {
        this (owner, _States[initStateId]);    }

    public TestReplierContext(final TestReplier owner, final State7 initState)
    {
        super (initState);

        ctxt = owner;
    }

    //
    // end of Constructors.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FSMContext7 Abstract Method Override.
    //

    @Override
    protected void executeAction(final MethodHandle mh)
    {
        try
        {
            mh.invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }

        return;
    }

    //
    // end of FSMContext7 Abstract Method Override.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Transitions.
    //

    public void cancelRequest()
    {
        _transition = "cancelRequest";
        try
        {
            final TransitionHandle th =
                getState().transition(cancelRequest4_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void request(final ERequest request, final String subject, final ERequestMessage msg)
    {
        _transition = "request";
        try
        {
            final TransitionHandle th =
                getState().transition(request3_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, request, subject, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void testError(final Throwable t)
    {
        _transition = "testError";
        try
        {
            final TransitionHandle th =
                getState().transition(testError1_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, t);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void timeout()
    {
        _transition = "timeout";
        try
        {
            final TransitionHandle th =
                getState().transition(timeout5_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    //
    // end of Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NoTest.TestDone State Entry/Exit Actions.
    //

    private void NoTest_TestDone__Entry_()
    {
        ctxt.unadvertise();
        ctxt.signalDone();
    }

    //
    // end of NoTest.TestDone State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // NoTest.TestDone State Transitions.
    //

    private void NoTest_TestDone_Default()
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void NoTest_TestDone_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.storeException(t);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    //
    // end of NoTest.TestDone State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ErrorReply.Default State Transitions.
    //

    private void ErrorReply_Default_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(t);
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ErrorReply_Default_cancelRequest()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void ErrorReply_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of ErrorReply.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ErrorReply.TestStart State Entry/Exit Actions.
    //

    private void ErrorReply_TestStart__Entry_()
    {
        ctxt.advertise(TestReplier.NEW_ORDER_KEY);
        ctxt.sendFeedStatus(EFeedState.UP);
    }

    //
    // end of ErrorReply.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ErrorReply.TestStart State Transitions.
    //

    private void ErrorReply_TestStart_request(final ERequest request, final String subject, final ERequestMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.reply(request, subject, msg, ReplyStatus.ERROR, "exchange closed");
            ctxt.unadvertise();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of ErrorReply.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FeedDown.Default State Transitions.
    //

    private void FeedDown_Default_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(t);
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void FeedDown_Default_cancelRequest()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void FeedDown_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of FeedDown.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FeedDown.TestStart State Entry/Exit Actions.
    //

    private void FeedDown_TestStart__Entry_()
    {
        ctxt.advertise(TestReplier.NEW_ORDER_KEY);
        ctxt.sendFeedStatus(EFeedState.DOWN);
    }

    private void FeedDown_TestStart__Exit_()
    {
        ctxt.unadvertise();
    }

    //
    // end of FeedDown.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FeedDown.TestStart State Transitions.
    //

    private void FeedDown_TestStart_request(final ERequest request, final String subject, final ERequestMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.reply(request, subject, msg, ReplyStatus.ERROR, "exchange closed");
            ctxt.unadvertise();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of FeedDown.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // RejectReply.Default State Transitions.
    //

    private void RejectReply_Default_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(t);
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void RejectReply_Default_cancelRequest()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void RejectReply_Default_timeout()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void RejectReply_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of RejectReply.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // RejectReply.TestStart State Entry/Exit Actions.
    //

    private void RejectReply_TestStart__Entry_()
    {
        ctxt.advertise(TestReplier.NEW_ORDER_KEY);
        ctxt.sendFeedStatus(EFeedState.UP);
    }

    //
    // end of RejectReply.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // RejectReply.TestStart State Transitions.
    //

    private void RejectReply_TestStart_request(final ERequest request, final String subject, final ERequestMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeRequest(request, msg);
        }
        finally
        {
            setState(_States[RejectReply_NewPending_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of RejectReply.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // RejectReply.NewPending State Entry/Exit Actions.
    //

    private void RejectReply_NewPending__Entry_()
    {
        ctxt.startTimer(5L);
    }

    private void RejectReply_NewPending__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of RejectReply.NewPending State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // RejectReply.NewPending State Transitions.
    //

    private void RejectReply_NewPending_timeout()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.reply(ctxt.request(), ctxt.subject(), ctxt.message(), ReplyStatus.ERROR, "invalid order");
            ctxt.clearRequest();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of RejectReply.NewPending State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // OKReply.Default State Transitions.
    //

    private void OKReply_Default_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(t);
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OKReply_Default_cancelRequest()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void OKReply_Default_timeout()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void OKReply_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of OKReply.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // OKReply.TestStart State Entry/Exit Actions.
    //

    private void OKReply_TestStart__Entry_()
    {
        ctxt.advertise(TestReplier.NEW_ORDER_KEY);
        ctxt.sendFeedStatus(EFeedState.UP);
    }

    //
    // end of OKReply.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // OKReply.TestStart State Transitions.
    //

    private void OKReply_TestStart_request(final ERequest request, final String subject, final ERequestMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeRequest(request, msg);
        }
        finally
        {
            setState(_States[OKReply_NewPending_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of OKReply.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // OKReply.NewPending State Entry/Exit Actions.
    //

    private void OKReply_NewPending__Entry_()
    {
        ctxt.startTimer(5L);
    }

    private void OKReply_NewPending__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of OKReply.NewPending State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // OKReply.NewPending State Transitions.
    //

    private void OKReply_NewPending_cancelRequest()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequest();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void OKReply_NewPending_timeout()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.reply(ctxt.request(), ctxt.subject(), ctxt.message(), ReplyStatus.OK_FINAL, null);
            ctxt.clearRequest();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of OKReply.NewPending State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MultiReply.Default State Transitions.
    //

    private void MultiReply_Default_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(t);
            ctxt.stopTimer();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void MultiReply_Default_cancelRequest()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void MultiReply_Default_timeout()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void MultiReply_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
            ctxt.stopTimer();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of MultiReply.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MultiReply.TestStart State Entry/Exit Actions.
    //

    private void MultiReply_TestStart__Entry_()
    {
        ctxt.advertise(TestReplier.NEW_ORDER_KEY);
        ctxt.sendFeedStatus(EFeedState.UP);
    }

    //
    // end of MultiReply.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MultiReply.TestStart State Transitions.
    //

    private void MultiReply_TestStart_request(final ERequest request, final String subject, final ERequestMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeRequest(request, msg);
        }
        finally
        {
            setState(_States[MultiReply_NewPending_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of MultiReply.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MultiReply.NewPending State Entry/Exit Actions.
    //

    private void MultiReply_NewPending__Entry_()
    {
        ctxt.startTimer(5L);
    }

    //
    // end of MultiReply.NewPending State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MultiReply.NewPending State Transitions.
    //

    private void MultiReply_NewPending_cancelRequest()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequest();
            ctxt.stopTimer();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void MultiReply_NewPending_timeout()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.reply(ctxt.request(), ctxt.subject(), ctxt.message(), ReplyStatus.OK_CONTINUING, null);
        }
        finally
        {
            setState(_States[MultiReply_Booked_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of MultiReply.NewPending State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MultiReply.Booked State Entry/Exit Actions.
    //

    private void MultiReply_Booked__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of MultiReply.Booked State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MultiReply.Booked State Transitions.
    //

    private void MultiReply_Booked_cancelRequest()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequest();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void MultiReply_Booked_timeout()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.reply(ctxt.request(), ctxt.subject(), ctxt.message(), ReplyStatus.OK_FINAL, null);
            ctxt.clearRequest();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of MultiReply.Booked State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Cancel.Default State Transitions.
    //

    private void Cancel_Default_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(t);
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Cancel_Default_cancelRequest()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void Cancel_Default_timeout()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void Cancel_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of Cancel.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Cancel.TestStart State Entry/Exit Actions.
    //

    private void Cancel_TestStart__Entry_()
    {
        ctxt.advertise(TestReplier.NEW_ORDER_KEY);
        ctxt.sendFeedStatus(EFeedState.UP);
    }

    //
    // end of Cancel.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Cancel.TestStart State Transitions.
    //

    private void Cancel_TestStart_request(final ERequest request, final String subject, final ERequestMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeRequest(request, msg);
        }
        finally
        {
            setState(_States[Cancel_NewPending_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of Cancel.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Cancel.NewPending State Entry/Exit Actions.
    //

    private void Cancel_NewPending__Entry_()
    {
        ctxt.startTimer(100L);
    }

    private void Cancel_NewPending__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of Cancel.NewPending State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Cancel.NewPending State Transitions.
    //

    private void Cancel_NewPending_cancelRequest()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequest();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Cancel_NewPending_timeout()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("request not canceled");
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of Cancel.NewPending State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Close.Default State Transitions.
    //

    private void Close_Default_testError(final Throwable t)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(t);
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Close_Default_cancelRequest()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void Close_Default_timeout()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void Close_Default_Default()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeException(new IllegalArgumentException(
                    "invalid transition"));
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of Close.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Close.TestStart State Entry/Exit Actions.
    //

    private void Close_TestStart__Entry_()
    {
        ctxt.advertise(TestReplier.NEW_ORDER_KEY);
        ctxt.sendFeedStatus(EFeedState.UP);
    }

    //
    // end of Close.TestStart State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Close.TestStart State Transitions.
    //

    private void Close_TestStart_request(final ERequest request, final String subject, final ERequestMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.storeRequest(request, msg);
        }
        finally
        {
            setState(_States[Close_NewPending_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of Close.TestStart State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Close.NewPending State Entry/Exit Actions.
    //

    private void Close_NewPending__Entry_()
    {
        ctxt.startTimer(100L);
    }

    private void Close_NewPending__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of Close.NewPending State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Close.NewPending State Transitions.
    //

    private void Close_NewPending_cancelRequest()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearRequest();
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    private void Close_NewPending_timeout()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.failed("request not canceled");
        }
        finally
        {
            setState(_States[NoTest_TestDone_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of Close.NewPending State Transitions.
    //-----------------------------------------------------------

//---------------------------------------------------------------
// Member data.
//

    transient private TestReplier ctxt;

    //-----------------------------------------------------------
    // Constants.
    //

    private static final long serialVersionUID = 1L;

    public static final int NoTest_TestDone_STATE_ID = 0;

    public static final int ErrorReply_TestStart_STATE_ID = 1;

    public static final int FeedDown_TestStart_STATE_ID = 2;

    public static final int RejectReply_TestStart_STATE_ID = 3;
    public static final int RejectReply_NewPending_STATE_ID = 4;

    public static final int OKReply_TestStart_STATE_ID = 5;
    public static final int OKReply_NewPending_STATE_ID = 6;

    public static final int MultiReply_TestStart_STATE_ID = 7;
    public static final int MultiReply_NewPending_STATE_ID = 8;
    public static final int MultiReply_Booked_STATE_ID = 9;

    public static final int Cancel_TestStart_STATE_ID = 10;
    public static final int Cancel_NewPending_STATE_ID = 11;

    public static final int Close_TestStart_STATE_ID = 12;
    public static final int Close_NewPending_STATE_ID = 13;

    private static final int STATE_COUNT = 14;

    private static final int cancelRequest4_TRANSITION_ID = 1;
    private static final int request3_TRANSITION_ID = 2;
    private static final int testError1_TRANSITION_ID = 3;
    private static final int timeout5_TRANSITION_ID = 4;

    private static final int TRANSITION_COUNT = 5;

    private static final MethodType[] TRANSITION_TYPES =
    {
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, ERequest.class, String.class, ERequestMessage.class),
        MethodType.methodType(void.class, Throwable.class),
        NO_ARGS_TYPE
    };

    private static final String[] MAP_NAMES =
    {
        "NoTest",
        "ErrorReply",
        "FeedDown",
        "RejectReply",
        "OKReply",
        "MultiReply",
        "Cancel",
        "Close"
    };

    private static final String[][] STATE_NAMES =
    {
        new String[]
        {
            "TestDone"
        },

        new String[]
        {
            "TestStart"
        },

        new String[]
        {
            "TestStart"
        },

        new String[]
        {
            "TestStart",
            "NewPending"
        },

        new String[]
        {
            "TestStart",
            "NewPending"
        },

        new String[]
        {
            "TestStart",
            "NewPending",
            "Booked"
        },

        new String[]
        {
            "TestStart",
            "NewPending"
        },

        new String[]
        {
            "TestStart",
            "NewPending"
        }
    };

    private static String[][] STATE_TRANSITIONS =
    {
        new String[]
        {
            "Default",
            "testError"
        },

        new String[]
        {
            "request"
        },

        new String[]
        {
            "request"
        },

        new String[]
        {
            "request"
        },

        new String[]
        {
            "timeout"
        },

        new String[]
        {
            "request"
        },

        new String[]
        {
            "cancelRequest",
            "timeout"
        },

        new String[]
        {
            "request"
        },

        new String[]
        {
            "cancelRequest",
            "timeout"
        },

        new String[]
        {
            "cancelRequest",
            "timeout"
        },

        new String[]
        {
            "request"
        },

        new String[]
        {
            "cancelRequest",
            "timeout"
        },

        new String[]
        {
            "request"
        },

        new String[]
        {
            "cancelRequest",
            "timeout"
        }
    };

    private static final String[] TRANSITION_NAMES =
    {
        "Default",
        "cancelRequest",
        "request",
        "testError",
        "timeout"
    };

    private static final State7[] _States = new State7[STATE_COUNT];

    static
    {
        final Lookup lookup = MethodHandles.lookup();
        final Class<?> clazz = TestReplierContext.class;
        final int mapSize = MAP_NAMES.length;
        int stateSize;
        int mapIndex;
        int stateIndex;
        int transIndex;
        int stateId = 0;
        String mapName;
        String stateName;
        String transName;
        String methodName;
        MethodType transType;
        MethodHandle entryHandle;
        MethodHandle exitHandle;
        TransitionHandle[] transitions;

        for (mapIndex = 0; mapIndex < mapSize; ++mapIndex)
        {
            mapName = MAP_NAMES[mapIndex];
            stateSize = STATE_NAMES[mapIndex].length;

            for (stateIndex = 0; stateIndex < stateSize; ++stateIndex, ++stateId)
            {
                stateName = STATE_NAMES[mapIndex][stateIndex];
                transitions = new TransitionHandle[TRANSITION_COUNT];

                methodName = String.format(ENTRY_NAME, mapName, stateName);
                entryHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);
                methodName = String.format(EXIT_NAME, mapName, stateName);
                exitHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);

                for (transIndex = 1; transIndex < TRANSITION_COUNT; ++transIndex)
                {
                    transName = TRANSITION_NAMES[transIndex];
                    transType = TRANSITION_TYPES[transIndex];
                    transitions[transIndex] =
                        lookupTransition(lookup, clazz, mapName, stateName, transName, transType);
                }

                _States[stateId] =
                    new State7(
                        String.format(STATE_NAME_FORMAT, mapName, stateName),
                        stateId,
                        entryHandle,
                        exitHandle,
                        transitions,
                        STATE_TRANSITIONS[stateId]);

            }
        }
    }
}

/*
 * Local variables:
 *  buffer-read-only: t
 * End:
 */
