//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright 2016. Charles W. Rapp
// All Rights Reserved.
//

package net.sf.eBus.client;

/**
 * This functional interface may be used to handle request
 * delivery instead of
 * {@link EReplier#request(EReplyFeed.ERequest)}
 * by passing a {@code RequestCallback} instance to
 * {@link EReplyFeed#requestCallback(RequestCallback)}. This
 * allows a tighter coupling between a feed and the code for
 * processing the feed's requests.
 * <p>
 * Note: This must be done after opening a {@link EReplyFeed}
 * and before advertising.
 * </p>
 *
 * @see EReplyFeed#requestCallback(RequestCallback)
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

@FunctionalInterface
public interface RequestCallback
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * An incoming request. The replier may send a
     * {@link EReplyFeed.ERequest#reply(net.sf.eBus.messages.EReplyMessage) reply}
     * either from within this method call or asynchronously
     * after returning from this method. If the reply is sent
     * asynchronously, then the replier must store
     * {@code request} for later use. Replies are sent using
     * {@code ERequest} and not {@code EReplyFeed}.
     * <p>
     * The
     * {@link net.sf.eBus.messages.ERequestMessage request message}
     * is stored in {@code request} and can be retrieved by
     * calling {@link EReplyFeed.ERequest#request()}.
     * </p>
     * <p>
     * The {@link EReplyFeed.ERequest request} matches the
     * replier's open and advertised {@link EReplyFeed feed}. The
     * associated {@code EReplyFeed} may be retrieved by calling
     * {@link EReplyFeed.ERequest#replier()}.
     * </p>
     * @param request post replies to {@code msg} to this
     * request.
     */
    void call(EReplyFeed.ERequest request);
} // end of interface RequestCallback

