//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright 2016. Charles W. Rapp
// All Rights Reserved.
//

package net.sf.eBus.client;

import net.sf.eBus.messages.EReplyMessage;

/**
 * This functional interface may be used to handle reply message
 * delivery instead of
 * {@link ERequestor#reply(int, EReplyMessage, ERequestFeed.ERequest)}
 * by passing a {@code ReplyCallback} instance to
 * {@link ERequestFeed#replyCallback(ReplyCallback)}. This
 * allows a tighter coupling between a feed and the code for
 * processing the feed's reply messages.
 * <p>
 * Note: This must be done after opening a {@link ERequestFeed}
 * and before subscribing.
 * </p>
 *
 * @see ERequestFeed#replyCallback(ReplyCallback)
 * @see ERequestFeed#replyCallback(Class, ReplyCallback)
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

@FunctionalInterface
public interface ReplyCallback
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * One or more replies to an outstanding request. Because
     * this interface is used for both exclusive and inclusive
     * requests, replies are passed in a collection as an
     * inclusive request may have multiple repliers. There is
     * no guarantee all replies to an inclusive request have the
     * same status. Each reply must be examined on its own
     * merits.
     * @param remaining the number of replies yet to be received.
     * Zero means all replies received and no more will be
     * forthcoming.
     * @param reply the latest reply.
     * @param request the reply is for this request.
     */
    void call(int remaining,
              EReplyMessage reply,
              ERequestFeed.ERequest request);
} // end of interface ReplyCallback

