//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright 2016. Charles W. Rapp
// All Rights Reserved.
//

package net.sf.eBus.client;

import net.sf.eBus.messages.ENotificationMessage;

/**
 * This functional interface may be used to handle notification
 * message delivery instead of
 * {@link ESubscriber#notify(ENotificationMessage, IESubscribeFeed)}
 * by passing a {@code NotifyCallback} instance to
 * {@link ESubscribeFeed#notifyCallback(NotifyCallback)}. This
 * allows a tighter coupling between a feed and the code for
 * processing the feed's notification messages.
 * <p>
 * Note: This must be done after opening a {@link ESubscribeFeed}
 * and before subscribing.
 * </p>
 *
 * @see ESubscribeFeed#notifyCallback(NotifyCallback)
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

@FunctionalInterface
public interface NotifyCallback
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * An incoming notification message from {@code feed}.
     * @param msg eBus notification message.
     * @param feed the associated subscription feed.
     */
    void call(ENotificationMessage msg,
              IESubscribeFeed feed);
} // end of interface NotifyCallback

