//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright 2017, 2018. Charles W. Rapp
// All Rights Reserved.
//

package net.sf.eBus.client;

/**
 * Provides a common view of single- and multi-key subscription
 * feeds, allowing such feeds to be referenced in a common way.
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

public interface IESubscribeFeed
    extends IEFeed
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * Puts the feed status callback in place.
     * @param cb the feed status update callback. May be
     * {@code null}.
     */
    void statusCallback(FeedStatusCallback<IESubscribeFeed> cb);

    /**
     * Puts the notification message callback in place.
     * @param cb pass notification messages back to application
     * via this callback.
     */
    void notifyCallback(NotifyCallback cb);

    /**
     * Activates this notification subscription.
     */
    void subscribe();

    /**
     * De-activates this subscriber feed. Does nothing if this
     * feed if not currently subscribed.
     */
    void unsubscribe();
} // end of interface IESubscribeFeed

