/*
 * ex: set ro:
 * DO NOT EDIT.
 * generated by smc (http://smc.sourceforge.net/)
 * from file : ERemoteApp.sm.sm
 */


//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2011, 2014, 2019. Charles W. Rapp.
// All Rights Reserved.
//

/**
 * {@link ERemoteApp} finite state machine definition.
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */


package net.sf.eBus.client;

import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.util.logging.Level;
import net.sf.eBus.client.sysmessages.AdMessage;
import net.sf.eBus.client.sysmessages.LogoffMessage;
import net.sf.eBus.client.sysmessages.LogonCompleteMessage;
import net.sf.eBus.client.sysmessages.LogonMessage;
import net.sf.eBus.client.sysmessages.LogonReply;
import net.sf.eBus.client.sysmessages.PauseReply;
import net.sf.eBus.client.sysmessages.PauseRequest;
import net.sf.eBus.client.sysmessages.ResumeReply;
import net.sf.eBus.client.sysmessages.ResumeRequest;
import net.sf.eBus.config.EConfigure;
import static net.sf.eBus.messages.EReplyMessage.ReplyStatus;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.lang.invoke.MethodType;
import statemap.FSMContext7;
import statemap.State7;
import statemap.TransitionHandle;

public class ERemoteAppContext
    extends FSMContext7
{
//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    public ERemoteAppContext(final ERemoteApp owner)
    {
        this (owner, _States[ConnectionMap_Start_STATE_ID]);
    }

    public ERemoteAppContext(final ERemoteApp owner, final int initStateId)
    {
        this (owner, _States[initStateId]);    }

    public ERemoteAppContext(final ERemoteApp owner, final State7 initState)
    {
        super (initState);

        ctxt = owner;
    }

    //
    // end of Constructors.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FSMContext7 Abstract Method Override.
    //

    @Override
    protected void executeAction(final MethodHandle mh)
    {
        try
        {
            mh.invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }

        return;
    }

    //
    // end of FSMContext7 Abstract Method Override.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Transitions.
    //

    public void adMessage(final AdMessage msg)
    {
        _transition = "adMessage";
        try
        {
            final TransitionHandle th =
                getState().transition(adMessage9_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void close()
    {
        _transition = "close";
        try
        {
            final TransitionHandle th =
                getState().transition(close3_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void connected()
    {
        _transition = "connected";
        try
        {
            final TransitionHandle th =
                getState().transition(connected4_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void disconnected()
    {
        _transition = "disconnected";
        try
        {
            final TransitionHandle th =
                getState().transition(disconnected6_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void logoff(final LogoffMessage msg)
    {
        _transition = "logoff";
        try
        {
            final TransitionHandle th =
                getState().transition(logoff17_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void logon(final LogonMessage msg)
    {
        _transition = "logon";
        try
        {
            final TransitionHandle th =
                getState().transition(logon7_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void logonComplete(final LogonCompleteMessage msg)
    {
        _transition = "logonComplete";
        try
        {
            final TransitionHandle th =
                getState().transition(logonComplete10_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void logonReply(final LogonReply msg)
    {
        _transition = "logonReply";
        try
        {
            final TransitionHandle th =
                getState().transition(logonReply5_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void open(final EConfigure.RemoteConnection config)
    {
        _transition = "open";
        try
        {
            final TransitionHandle th =
                getState().transition(open1_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, config);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void open(final InetSocketAddress address, final int serverPort, final SelectableChannel socket, final EConfigure.Service config)
    {
        _transition = "open";
        try
        {
            final TransitionHandle th =
                getState().transition(open2_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, address, serverPort, socket, config);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void pause()
    {
        _transition = "pause";
        try
        {
            final TransitionHandle th =
                getState().transition(pause11_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void pause(final PauseRequest msg)
    {
        _transition = "pause";
        try
        {
            final TransitionHandle th =
                getState().transition(pause12_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void pauseReply(final PauseReply msg)
    {
        _transition = "pauseReply";
        try
        {
            final TransitionHandle th =
                getState().transition(pauseReply13_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void resume(final ResumeRequest msg)
    {
        _transition = "resume";
        try
        {
            final TransitionHandle th =
                getState().transition(resume8_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void resumeReply(final ResumeReply msg)
    {
        _transition = "resumeReply";
        try
        {
            final TransitionHandle th =
                getState().transition(resumeReply15_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    public void resumed(final ResumeRequest msg)
    {
        _transition = "resumed";
        try
        {
            final TransitionHandle th =
                getState().transition(resumed14_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, msg);
            }
        }
        catch (Throwable tex)
        {
            if (_debugFlag)
            {
                tex.printStackTrace(_debugStream);
            }
        }
        _transition = "";
        return;
    }

    //
    // end of Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Default State Transitions.
    //

    private void ConnectionMap_Default_logoff(final LogoffMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.disconnect();
        }
        finally
        {
            setState(_States[ConnectionMap_Closed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_Default_logon(final LogonMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.disconnect();
        }
        finally
        {
            setState(_States[ConnectionMap_Closing_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_Default_logonReply(final LogonReply msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.disconnect();
        }
        finally
        {
            setState(_States[ConnectionMap_Closing_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_Default_Default()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of ConnectionMap.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Start State Transitions.
    //

    private void ConnectionMap_Start_close()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[ConnectionMap_Closed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_Start_open(final EConfigure.RemoteConnection config)
    {
        final int stateId = _state.getId();

        if (ctxt.connect(config) == ERemoteApp.CONNECT_COMPLETE)
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[ConnectionMap_LoggingOn_STATE_ID]);
            }

            enterState();
        }
        else if (ctxt.connectStatus() == ERemoteApp.CONNECT_FAILED &&
        !(config.reconnectFlag()))
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[ConnectionMap_Closed_STATE_ID]);
            }

            enterState();
        }
        else if (ctxt.connectStatus() == ERemoteApp.CONNECT_FAILED &&
        config.reconnectFlag())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[ConnectionMap_Reconnecting_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
            }
            finally
            {
                setState(_States[ConnectionMap_Opening_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void ConnectionMap_Start_open(final InetSocketAddress address, final int serverPort, final SelectableChannel socket, final EConfigure.Service config)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.connect(address, serverPort, socket, config);
        }
        finally
        {
            setState(_States[ConnectionMap_WaitingForLogon_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of ConnectionMap.Start State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Opening State Transitions.
    //

    private void ConnectionMap_Opening_close()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.disconnect();
        }
        finally
        {
            setState(_States[ConnectionMap_Closing_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_Opening_connected()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[ConnectionMap_LoggingOn_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of ConnectionMap.Opening State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.LoggingOn State Entry/Exit Actions.
    //

    private void ConnectionMap_LoggingOn__Entry_()
    {
        ctxt.logon();
    }

    //
    // end of ConnectionMap.LoggingOn State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.LoggingOn State Transitions.
    //

    private void ConnectionMap_LoggingOn_close()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.disconnect();
        }
        finally
        {
            setState(_States[ConnectionMap_Closing_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_LoggingOn_disconnected()
    {
        final int stateId = _state.getId();

        if (ctxt.willReconnect())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[ConnectionMap_Reconnecting_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
            }
            finally
            {
                setState(_States[ConnectionMap_Closed_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void ConnectionMap_LoggingOn_logonReply(final LogonReply msg)
    {
        final int stateId = _state.getId();

        if (msg.logonStatus == ReplyStatus.ERROR)
        {
            exitState();

            try
            {
                clearState();
                ctxt.disconnect();
            }
            finally
            {
                setState(_States[ConnectionMap_Closed_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.storeRemoteId(msg.eid);
            }
            finally
            {
                setState(_States[ConnectionMap_Advertising_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of ConnectionMap.LoggingOn State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.WaitingForLogon State Transitions.
    //

    private void ConnectionMap_WaitingForLogon_close()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.disconnect();
        }
        finally
        {
            setState(_States[ConnectionMap_Closing_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_WaitingForLogon_disconnected()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[ConnectionMap_Closed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_WaitingForLogon_logon(final LogonMessage msg)
    {
        final int stateId = _state.getId();

        if (ctxt.isLoggedOn(msg.eid))
        {
            exitState();

            try
            {
                clearState();
                ctxt.logonReply(ReplyStatus.ERROR, "duplicate connection");
            }
            finally
            {
                setState(_States[ConnectionMap_Closing_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.storeRemoteId(msg.eid);
                ctxt.logonReply(ReplyStatus.OK_FINAL, null);
            }
            finally
            {
                setState(_States[ConnectionMap_Advertising_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void ConnectionMap_WaitingForLogon_resume(final ResumeRequest msg)
    {
        final int stateId = _state.getId();

        if (!ctxt.isPausedConnection(msg.eid))
        {
            exitState();

            try
            {
                clearState();
                ctxt.resumeReply(msg.eid, ReplyStatus.ERROR, "unknown paused connection");
            }
            finally
            {
                setState(_States[ConnectionMap_Closing_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.resumeConnection(msg);
            }
            finally
            {
                setState(_States[ConnectionMap_Resumed_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of ConnectionMap.WaitingForLogon State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Advertising State Entry/Exit Actions.
    //

    private void ConnectionMap_Advertising__Entry_()
    {
        ctxt.sendAds();
        ctxt.sendLogonComplete();
    }

    //
    // end of ConnectionMap.Advertising State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Advertising State Transitions.
    //

    private void ConnectionMap_Advertising_adMessage(final AdMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.storeAd(msg);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void ConnectionMap_Advertising_close()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.logoff();
        }
        finally
        {
            setState(_States[ConnectionMap_Closing_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_Advertising_disconnected()
    {
        final int stateId = _state.getId();

        if (ctxt.willReconnect())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[ConnectionMap_Reconnecting_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
            }
            finally
            {
                setState(_States[ConnectionMap_Closed_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void ConnectionMap_Advertising_logonComplete(final LogonCompleteMessage msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.remoteConnect();
            ctxt.processLogonAds();
        }
        finally
        {
            setState(_States[ConnectionMap_Opened_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of ConnectionMap.Advertising State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Opened State Entry/Exit Actions.
    //

    private void ConnectionMap_Opened__Entry_()
    {
        ctxt.startPauseTimer();
        ctxt.startIdleTimer();
    }

    private void ConnectionMap_Opened__Exit_()
    {
        ctxt.stopPauseTimer();
        ctxt.stopIdleTimer();
    }

    //
    // end of ConnectionMap.Opened State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Opened State Transitions.
    //

    private void ConnectionMap_Opened_adMessage(final AdMessage msg)
    {
        final int stateId = _state.getId();

        try
        {
            clearState();
            ctxt.processAd(msg);
        }
        finally
        {
            setState(_States[stateId]);
        }


        return;
    }


    private void ConnectionMap_Opened_close()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.remoteDisconnect();
            ctxt.logoff();
        }
        finally
        {
            setState(_States[ConnectionMap_Closing_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_Opened_disconnected()
    {
        final int stateId = _state.getId();

        if (ctxt.willReconnect())
        {
            exitState();

            try
            {
                clearState();
                ctxt.remoteDisconnect();
            }
            finally
            {
                setState(_States[ConnectionMap_Reconnecting_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.remoteDisconnect();
            }
            finally
            {
                setState(_States[ConnectionMap_Closed_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void ConnectionMap_Opened_pause()
    {
        final int stateId = _state.getId();

        if (ctxt.isAcceptor() || !ctxt.canPause())
        {
            try
            {
                clearState();
                ctxt.log(Level.WARNING, "cannot pause this connection");
            }
            finally
            {
                setState(_States[stateId]);
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.pause();
            }
            finally
            {
                setState(_States[ConnectionMap_Pausing_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void ConnectionMap_Opened_pause(final PauseRequest msg)
    {
        final int stateId = _state.getId();

        if (ctxt.isInitiator() || !ctxt.canPause())
        {
            try
            {
                clearState();
                ctxt.pauseReply(ReplyStatus.ERROR, "pause not supported", msg);
            }
            finally
            {
                setState(_States[stateId]);
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.pauseReply(ReplyStatus.OK_FINAL, "", msg);
            }
            finally
            {
                setState(_States[ConnectionMap_WaitingForPause_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of ConnectionMap.Opened State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Pausing State Transitions.
    //

    private void ConnectionMap_Pausing_pauseReply(final PauseReply msg)
    {
        final int stateId = _state.getId();

        if (msg.replyStatus == ReplyStatus.ERROR &&
       ctxt.willReconnect())
        {
            exitState();

            try
            {
                clearState();
                ctxt.closeAndReconnect();
            }
            finally
            {
                setState(_States[ConnectionMap_Reconnecting_STATE_ID]);
            }

            enterState();
        }
        else if (msg.replyStatus == ReplyStatus.ERROR)
        {
            exitState();

            try
            {
                clearState();
                ctxt.remoteDisconnect();
                ctxt.logoff();
            }
            finally
            {
                setState(_States[ConnectionMap_Closing_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.closeAndPause(msg);
            }
            finally
            {
                setState(_States[ConnectionMap_Paused_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of ConnectionMap.Pausing State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.WaitingForPause State Transitions.
    //

    private void ConnectionMap_WaitingForPause_disconnected()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.pauseConnection();
        }
        finally
        {
            setState(_States[ConnectionMap_WaitingForResume_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of ConnectionMap.WaitingForPause State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Paused State Transitions.
    //

    private void ConnectionMap_Paused_close()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[ConnectionMap_Closed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_Paused_connected()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[ConnectionMap_Resuming_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of ConnectionMap.Paused State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.WaitingForResume State Entry/Exit Actions.
    //

    private void ConnectionMap_WaitingForResume__Entry_()
    {
        ctxt.startResumeTimer();
    }

    private void ConnectionMap_WaitingForResume__Exit_()
    {
        ctxt.stopResumeTimer();
    }

    //
    // end of ConnectionMap.WaitingForResume State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.WaitingForResume State Transitions.
    //

    private void ConnectionMap_WaitingForResume_disconnected()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.clearPendingMessages();
            ctxt.remoteDisconnect();
        }
        finally
        {
            setState(_States[ConnectionMap_Closed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_WaitingForResume_resumed(final ResumeRequest msg)
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.resumeReply(msg.eid, ReplyStatus.OK_FINAL, "");
            ctxt.connectionResumed();
        }
        finally
        {
            setState(_States[ConnectionMap_Opened_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of ConnectionMap.WaitingForResume State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Resuming State Entry/Exit Actions.
    //

    private void ConnectionMap_Resuming__Entry_()
    {
        ctxt.resume();
    }

    //
    // end of ConnectionMap.Resuming State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Resuming State Transitions.
    //

    private void ConnectionMap_Resuming_close()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
            clearState();
            ctxt.disconnect();
        }
        finally
        {
            setState(_States[ConnectionMap_Closing_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_Resuming_disconnected()
    {
        final int stateId = _state.getId();

        if (ctxt.willReconnect())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[ConnectionMap_Reconnecting_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
            }
            finally
            {
                setState(_States[ConnectionMap_Closed_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    private void ConnectionMap_Resuming_resumeReply(final ResumeReply msg)
    {
        final int stateId = _state.getId();

        if (msg.replyStatus == ReplyStatus.ERROR &&
       ctxt.willReconnect())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(_States[ConnectionMap_Reconnecting_STATE_ID]);
            }

            enterState();
        }
        else if (msg.replyStatus == ReplyStatus.ERROR)
        {
            exitState();

            try
            {
                clearState();
                ctxt.clearPendingMessages();
                ctxt.disconnect();
            }
            finally
            {
                setState(_States[ConnectionMap_Closing_STATE_ID]);
            }

            enterState();
        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.connectionResumed();
            }
            finally
            {
                setState(_States[ConnectionMap_Opened_STATE_ID]);
            }

            enterState();
        }

        return;
    }


    //
    // end of ConnectionMap.Resuming State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Reconnecting State Transitions.
    //

    private void ConnectionMap_Reconnecting_close()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[ConnectionMap_Closed_STATE_ID]);
        }

        enterState();

        return;
    }


    private void ConnectionMap_Reconnecting_connected()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[ConnectionMap_LoggingOn_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of ConnectionMap.Reconnecting State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Closing State Transitions.
    //

    private void ConnectionMap_Closing_close()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    private void ConnectionMap_Closing_disconnected()
    {
        final int stateId = _state.getId();

        exitState();

        try
        {
        }
        finally
        {
            setState(_States[ConnectionMap_Closed_STATE_ID]);
        }

        enterState();

        return;
    }


    //
    // end of ConnectionMap.Closing State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Closed State Entry/Exit Actions.
    //

    private void ConnectionMap_Closed__Entry_()
    {
        ctxt.doShutdown();
        ctxt.removeConnection();
    }

    //
    // end of ConnectionMap.Closed State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Closed State Transitions.
    //

    private void ConnectionMap_Closed_close()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of ConnectionMap.Closed State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // ConnectionMap.Resumed State Transitions.
    //

    private void ConnectionMap_Resumed_Default()
    {
        final int stateId = _state.getId();

        try
        {
        }
        finally
        {
        }


        return;
    }


    //
    // end of ConnectionMap.Resumed State Transitions.
    //-----------------------------------------------------------

//---------------------------------------------------------------
// Member data.
//

    transient private ERemoteApp ctxt;

    //-----------------------------------------------------------
    // Constants.
    //

    private static final long serialVersionUID = 1L;

    public static final int ConnectionMap_Start_STATE_ID = 0;
    public static final int ConnectionMap_Opening_STATE_ID = 1;
    public static final int ConnectionMap_LoggingOn_STATE_ID = 2;
    public static final int ConnectionMap_WaitingForLogon_STATE_ID = 3;
    public static final int ConnectionMap_Advertising_STATE_ID = 4;
    public static final int ConnectionMap_Opened_STATE_ID = 5;
    public static final int ConnectionMap_Pausing_STATE_ID = 6;
    public static final int ConnectionMap_WaitingForPause_STATE_ID = 7;
    public static final int ConnectionMap_Paused_STATE_ID = 8;
    public static final int ConnectionMap_WaitingForResume_STATE_ID = 9;
    public static final int ConnectionMap_Resuming_STATE_ID = 10;
    public static final int ConnectionMap_Reconnecting_STATE_ID = 11;
    public static final int ConnectionMap_Closing_STATE_ID = 12;
    public static final int ConnectionMap_Closed_STATE_ID = 13;
    public static final int ConnectionMap_Resumed_STATE_ID = 14;

    private static final int STATE_COUNT = 15;

    private static final int adMessage9_TRANSITION_ID = 1;
    private static final int close3_TRANSITION_ID = 2;
    private static final int connected4_TRANSITION_ID = 3;
    private static final int disconnected6_TRANSITION_ID = 4;
    private static final int logoff17_TRANSITION_ID = 5;
    private static final int logon7_TRANSITION_ID = 6;
    private static final int logonComplete10_TRANSITION_ID = 7;
    private static final int logonReply5_TRANSITION_ID = 8;
    private static final int open1_TRANSITION_ID = 9;
    private static final int open2_TRANSITION_ID = 10;
    private static final int pause11_TRANSITION_ID = 11;
    private static final int pause12_TRANSITION_ID = 12;
    private static final int pauseReply13_TRANSITION_ID = 13;
    private static final int resume8_TRANSITION_ID = 14;
    private static final int resumeReply15_TRANSITION_ID = 15;
    private static final int resumed14_TRANSITION_ID = 16;

    private static final int TRANSITION_COUNT = 17;

    private static final MethodType[] TRANSITION_TYPES =
    {
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, AdMessage.class),
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, LogoffMessage.class),
        MethodType.methodType(void.class, LogonMessage.class),
        MethodType.methodType(void.class, LogonCompleteMessage.class),
        MethodType.methodType(void.class, LogonReply.class),
        MethodType.methodType(void.class, EConfigure.RemoteConnection.class),
        MethodType.methodType(void.class, InetSocketAddress.class, int.class, SelectableChannel.class, EConfigure.Service.class),
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, PauseRequest.class),
        MethodType.methodType(void.class, PauseReply.class),
        MethodType.methodType(void.class, ResumeRequest.class),
        MethodType.methodType(void.class, ResumeReply.class),
        MethodType.methodType(void.class, ResumeRequest.class)
    };

    private static final String[] MAP_NAMES =
    {
        "ConnectionMap"
    };

    private static final String[][] STATE_NAMES =
    {
        new String[]
        {
            "Start",
            "Opening",
            "LoggingOn",
            "WaitingForLogon",
            "Advertising",
            "Opened",
            "Pausing",
            "WaitingForPause",
            "Paused",
            "WaitingForResume",
            "Resuming",
            "Reconnecting",
            "Closing",
            "Closed",
            "Resumed"
        }
    };

    private static String[][] STATE_TRANSITIONS =
    {
        new String[]
        {
            "close",
            "open",
            "open"
        },

        new String[]
        {
            "close",
            "connected"
        },

        new String[]
        {
            "close",
            "disconnected",
            "logonReply"
        },

        new String[]
        {
            "close",
            "disconnected",
            "logon",
            "resume"
        },

        new String[]
        {
            "adMessage",
            "close",
            "disconnected",
            "logonComplete"
        },

        new String[]
        {
            "adMessage",
            "close",
            "disconnected",
            "pause",
            "pause"
        },

        new String[]
        {
            "pauseReply"
        },

        new String[]
        {
            "disconnected"
        },

        new String[]
        {
            "close",
            "connected"
        },

        new String[]
        {
            "disconnected",
            "resumed"
        },

        new String[]
        {
            "close",
            "disconnected",
            "resumeReply"
        },

        new String[]
        {
            "close",
            "connected"
        },

        new String[]
        {
            "close",
            "disconnected"
        },

        new String[]
        {
            "close"
        },

        new String[]
        {
            "Default"
        }
    };

    private static final String[] TRANSITION_NAMES =
    {
        "Default",
        "adMessage",
        "close",
        "connected",
        "disconnected",
        "logoff",
        "logon",
        "logonComplete",
        "logonReply",
        "open",
        "open",
        "pause",
        "pause",
        "pauseReply",
        "resume",
        "resumeReply",
        "resumed"
    };

    private static final State7[] _States = new State7[STATE_COUNT];

    static
    {
        final Lookup lookup = MethodHandles.lookup();
        final Class<?> clazz = ERemoteAppContext.class;
        final int mapSize = MAP_NAMES.length;
        int stateSize;
        int mapIndex;
        int stateIndex;
        int transIndex;
        int stateId = 0;
        String mapName;
        String stateName;
        String transName;
        String methodName;
        MethodType transType;
        MethodHandle entryHandle;
        MethodHandle exitHandle;
        TransitionHandle[] transitions;

        for (mapIndex = 0; mapIndex < mapSize; ++mapIndex)
        {
            mapName = MAP_NAMES[mapIndex];
            stateSize = STATE_NAMES[mapIndex].length;

            for (stateIndex = 0; stateIndex < stateSize; ++stateIndex, ++stateId)
            {
                stateName = STATE_NAMES[mapIndex][stateIndex];
                transitions = new TransitionHandle[TRANSITION_COUNT];

                methodName = String.format(ENTRY_NAME, mapName, stateName);
                entryHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);
                methodName = String.format(EXIT_NAME, mapName, stateName);
                exitHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);

                for (transIndex = 1; transIndex < TRANSITION_COUNT; ++transIndex)
                {
                    transName = TRANSITION_NAMES[transIndex];
                    transType = TRANSITION_TYPES[transIndex];
                    transitions[transIndex] =
                        lookupTransition(lookup, clazz, mapName, stateName, transName, transType);
                }

                _States[stateId] =
                    new State7(
                        String.format(STATE_NAME_FORMAT, mapName, stateName),
                        stateId,
                        entryHandle,
                        exitHandle,
                        transitions,
                        STATE_TRANSITIONS[stateId]);

            }
        }
    }
}

/*
 * Local variables:
 *  buffer-read-only: t
 * End:
 */
