//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright 2015. Charles W. Rapp
// All Rights Reserved.
//

package net.sf.eBus.client;

/**
 * Enumerates an eBus notification message feed state: either up
 * or down.
 */

public enum EFeedState
{
    /**
     * The message feed state is unknown due to the feed just
     * being constructed.
     */
    UNKNOWN (0, 0, false),

    /**
     * The message feed is down. Subscribers will not receive
     * messages on this feed until informed that the feed is up.
     * Decrement feed counts when this is the state. If the feed
     * count reaches zero as a result of the decrement, send a
     * feed down status update.
     */
    DOWN (-1, 0, false),

    /**
     * The message feed is up. Subscribers may expect to receive
     * messages on this feed <em>if and when</em> any such
     * messages are published. Increment feed counts with this
     * state. If the feed count reaches one as a result of the
     * increment, send a feed up status update.
     */
    UP (1, 1, true);

//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    private EFeedState(final int incr,
                       final int trigger,
                       final boolean flag)
    {
        this.increment = incr;
        this.trigger = trigger;
        this.flag = flag;
    } // end of EFeedState(int, int, boolean)

    //
    // end of Constructors.
    //-----------------------------------------------------------

//---------------------------------------------------------------
// Member data.
//

    /**
     * Increment feed counts by this value.
     */
    public final int increment;

    /**
     * After applying this feed state to a feed count, if the
     * feed count now equals this value, that triggers a feed
     * state update sent to the appropriate feeds.
     */
    public final int trigger;

    /**
     * {@code true} if the feed is up and {@code false} if down.
     */
    public final boolean flag;
} // end of enum EFeedState
