//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2009, 2011, 2015, 2016. Charles W. Rapp.
// All Rights Reserved.
//

package net.sf.eBus.client;

import net.sf.eBus.messages.EMessage;

/**
 * This interface allows {@link ESubscribeFeed} and
 * {@link EReplyFeed} to automatically test a message in order
 * to determine if it should be passed on to a client. If
 * {@link ECondition#test(EMessage) test} returns {@code true}
 * eBus forwards the message to the client. If {@code test}
 * returns {@code false} or throws an exception, then the message
 * is not forwarded.
 * <p>
 * In eBus v. 4.2.0, this interface is now marked as a
 * {@code @FunctionalInterface}, allowing this interface to be
 * defined using a Java lambda expression.
 * </p>
 *
 * @see ESubscribeFeed#open(ESubscriber, net.sf.eBus.messages.EMessageKey, EFeed.FeedScope, ECondition)
 * @see EReplyFeed#open(EReplier, net.sf.eBus.messages.EMessageKey, EFeed.FeedScope, ECondition)
 *
 * @author <a href="mailto:rapp@acm.org">Charles Rapp</a>
 */

@FunctionalInterface
public interface ECondition
{
//--------------------------------------------------------------
// Member methods.
//

    /**
     * Returns {@code true} if the message meets this condition
     * and so should be passed to the eBus client; {@code false}
     * if the message should not be passed on. If this method
     * throws an exception, it is treated the same as having
     * returned {@code false}.
     * @param msg The tested notification message.
     * @return {@code true} if the message meets this condition
     * and so should be passed to the eBus client.
     */
    boolean test(EMessage msg);
} // end of interface ECondition
