//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later
// version.
//
// This library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General
// Public License along with this library; if not, write to the
//
// Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330,
// Boston, MA
// 02111-1307 USA
//
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright 2016. Charles W. Rapp
// All Rights Reserved.
//

package net.sf.eBus.client;

/**
 * A class implementing {@code EReplier} is not required to
 * override {@link EReplier#cancelRequest(EReplyFeed.ERequest)}.
 * Instead, a Java lambda expression for
 * {@code CancelRequestCallback} may be passed to
 * {@link EReplyFeed#cancelRequestCallback(CancelRequestCallback)}
 * and the lambda expression code will be executed when a
 * request is canceled.
 *
 * @see EReplyFeed#cancelRequestCallback(CancelRequestCallback)
 *
 * @author <a href="mailto:rapp@acm.org">Charles W. Rapp</a>
 */

@FunctionalInterface
public interface CancelRequestCallback
{
//---------------------------------------------------------------
// Member methods.
//

    /**
     * The specified request is canceled by the
     * {@link ERequestor requestor}. The request is shut down and
     * no further replies will be accepted. However, in-flight
     * replies <em>may</em> still be delivered.
     * <p>
     * The {@link EReplyFeed.ERequest request} matches the
     * replier's open and advertised {@link EReplyFeed feed}. The
     * associated {@code EReplyFeed} may be retrieved by calling
     * {@link EReplyFeed.ERequest#replier()}.
     * </p>
     * @param request cancel this request.
     */
    void call(EReplyFeed.ERequest request);
} // end of interface CancelRequestCallback

