//
// Copyright 2019 Charles W. Rapp
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

/**
 * Provides classes needed to configure eBus network and eBus
 * core modules. This includes
 * {@link net.sf.eBus.config.EConfigure.Dispatcher dispatcher} and
 * {@link net.sf.eBus.config.EConfigure.PauseConfig pause configuration}.
 * <p>
 * This configuration package provides the utility classes:
 * </p>
 * <ol>
 *   <li>
 *     {@link net.sf.eBus.config.AddressFilter} : provides
 *     ability to positively filter accepted connections.
 *     "Positive" means that the accepted connection must be from
 *     a host or host and port that is in the filter.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.config.InetAddressComparator}: provides
 *     comparison between two {@code java.net.InetAddress}
 *     instances.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.config.InetSocketAddressComparator}:
 *     provides comparison between two
 *     {@code java.net.InetSocketAddress} instances.
 *   </li>
 * </ol>
 */

package net.sf.eBus.config;
