/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.config;

import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.util.List;
import java.util.Objects;
import net.openhft.affinity.AffinityStrategies;

public class ThreadAffinityConfigure {
    public static final String AFFINITY_TYPE_KEY = "affinityType";
    public static final String BIND_KEY = "bind";
    public static final String WHOLE_CORE_KEY = "wholeCore";
    public static final String CPU_OFFSET_KEY = "lastMinusOffset";
    public static final String CPU_ID_KEY = "cpuId";
    public static final String STRATEGIES_KEY = "cpuStrategies";
    private final AffinityType mAffinityType;
    private final boolean mBindFlag;
    private final boolean mWholeCore;
    private final int mCpuId;
    private final int mOffset;
    private final List<AffinityStrategies> mStrategies;

    private ThreadAffinityConfigure(Builder builder) {
        this.mAffinityType = builder.mAffinityType;
        this.mBindFlag = builder.mBindFlag;
        this.mWholeCore = builder.mWholeCore;
        this.mCpuId = builder.mCpuId;
        this.mOffset = builder.mOffset;
        this.mStrategies = builder.mStrategies;
    }

    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof ThreadAffinityConfigure) {
            ThreadAffinityConfigure tac = (ThreadAffinityConfigure)o;
            retcode = this.mAffinityType == tac.mAffinityType && this.mBindFlag == tac.mBindFlag && this.mWholeCore == tac.mWholeCore && this.mCpuId == tac.mCpuId && this.mOffset == tac.mOffset && Objects.equals(this.mStrategies, tac.mStrategies);
        }
        return retcode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mAffinityType, this.mBindFlag, this.mWholeCore, this.mCpuId, this.mOffset, this.mStrategies});
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        retval.append("[type=").append((Object)this.mAffinityType).append(", bind=").append(this.mBindFlag);
        if (this.mBindFlag) {
            retval.append(", core=").append(this.mWholeCore);
        }
        switch (this.mAffinityType) {
            case CPU_ID: {
                retval.append(", cpu ID=").append(this.mCpuId);
                break;
            }
            case CPU_LAST_MINUS: {
                retval.append(", offset=").append(this.mOffset);
                break;
            }
            case CPU_STRATEGIES: {
                String sep = "";
                retval.append(", strategies={");
                for (AffinityStrategies s : this.mStrategies) {
                    retval.append(sep).append(s);
                    sep = ",";
                }
                retval.append('}');
                break;
            }
        }
        retval.append(']');
        return retval.toString();
    }

    public AffinityType affinityType() {
        return this.mAffinityType;
    }

    public boolean bindFlag() {
        return this.mBindFlag;
    }

    public boolean wholeCoreFlag() {
        return this.mWholeCore;
    }

    public int cpuId() {
        return this.mCpuId;
    }

    public int cpuOffset() {
        return this.mOffset;
    }

    public List<AffinityStrategies> strategies() {
        return this.mStrategies;
    }

    public static ThreadAffinityConfigure loadAffinity(String key, Config config) {
        ThreadAffinityConfigure retval = null;
        if (config.hasPath(key)) {
            retval = ThreadAffinityConfigure.loadAffinityImpl(config.getConfig(key));
        }
        return retval;
    }

    public static List<ThreadAffinityConfigure> loadAffinities(String key, Config config) {
        ImmutableList.Builder retval = ImmutableList.builder();
        if (config.hasPath(key)) {
            config.getConfigList(key).forEach(c -> retval.add((Object)ThreadAffinityConfigure.loadAffinityImpl(c)));
        }
        return retval.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static ThreadAffinityConfigure loadAffinityImpl(Config config) {
        AffinityType type = (AffinityType)config.getEnum(AffinityType.class, AFFINITY_TYPE_KEY);
        Builder builder = new Builder();
        builder.affinityType(type);
        if (config.hasPath(BIND_KEY)) {
            builder.bind(config.getBoolean(BIND_KEY));
            if (config.hasPath(WHOLE_CORE_KEY)) {
                builder.wholeCore(config.getBoolean(WHOLE_CORE_KEY));
            }
        }
        switch (type) {
            case CPU_ID: {
                ThreadAffinityConfigure.setCpuId(builder, config);
                break;
            }
            case CPU_LAST_MINUS: {
                ThreadAffinityConfigure.setOffset(builder, config);
                break;
            }
            case CPU_STRATEGIES: {
                ThreadAffinityConfigure.setStrategies(builder, config);
                break;
            }
        }
        return builder.build();
    }

    private static void setCpuId(Builder builder, Config config) {
        try {
            builder.cpuId(config.getInt(CPU_ID_KEY));
        }
        catch (Exception jex) {
            throw new ConfigException.BadValue(CPU_ID_KEY, jex.getMessage());
        }
    }

    private static void setOffset(Builder builder, Config config) {
        try {
            builder.lastMinusOffset(config.getInt(CPU_OFFSET_KEY));
        }
        catch (Exception jex) {
            throw new ConfigException.BadValue(CPU_OFFSET_KEY, jex.getMessage());
        }
    }

    private static void setStrategies(Builder builder, Config config) {
        try {
            builder.strategies(config.getEnumList(AffinityStrategies.class, STRATEGIES_KEY));
        }
        catch (Exception jex) {
            throw new ConfigException.BadValue(STRATEGIES_KEY, jex.getMessage());
        }
    }

    public static final class Builder {
        private AffinityType mAffinityType = AffinityType.ANY_CPU;
        private boolean mBindFlag = false;
        private boolean mWholeCore = false;
        private int mCpuId = -1;
        private int mOffset = 0;
        private List<AffinityStrategies> mStrategies = null;

        private Builder() {
        }

        public Builder affinityType(AffinityType type) {
            this.mAffinityType = Objects.requireNonNull(type, "type is null");
            return this;
        }

        public Builder bind(boolean flag) {
            this.mBindFlag = flag;
            return this;
        }

        public Builder wholeCore(boolean flag) {
            this.mWholeCore = flag;
            return this;
        }

        public Builder cpuId(int id) {
            if (id < 0) {
                throw new IllegalArgumentException("id < zero");
            }
            this.mCpuId = id;
            return this;
        }

        public Builder lastMinusOffset(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("n <= zero");
            }
            this.mOffset = n;
            return this;
        }

        public Builder strategies(AffinityStrategies ... strategies) {
            if (strategies.length == 0) {
                throw new IllegalArgumentException("strategies is empty");
            }
            AffinityStrategies last = strategies[strategies.length - 1];
            if (last != AffinityStrategies.ANY) {
                throw new IllegalArgumentException("final strategy is not ANY");
            }
            this.mStrategies = ImmutableList.copyOf((Object[])strategies);
            return this;
        }

        public Builder strategies(List<AffinityStrategies> strategies) {
            if (Objects.requireNonNull(strategies, "strategies is null").isEmpty()) {
                throw new IllegalArgumentException("strategies is empty");
            }
            AffinityStrategies last = strategies.get(strategies.size() - 1);
            if (last != AffinityStrategies.ANY) {
                throw new IllegalArgumentException("final strategy is not ANY");
            }
            this.mStrategies = ImmutableList.copyOf(strategies);
            return this;
        }

        public ThreadAffinityConfigure build() {
            this.validate();
            return new ThreadAffinityConfigure(this);
        }

        private void validate() {
            if (this.mAffinityType == AffinityType.CPU_ID && this.mCpuId < 0) {
                throw new ConfigException.BadValue(ThreadAffinityConfigure.CPU_ID_KEY, "CPU identifier not configured");
            }
            if (this.mAffinityType == AffinityType.CPU_LAST_MINUS && this.mOffset == 0) {
                throw new ConfigException.BadValue(ThreadAffinityConfigure.CPU_OFFSET_KEY, "CPU offset not configured");
            }
            if (this.mAffinityType == AffinityType.CPU_STRATEGIES && this.mStrategies == null) {
                throw new ConfigException.BadValue(ThreadAffinityConfigure.STRATEGIES_KEY, "CPU offset not configured");
            }
        }
    }

    public static enum AffinityType {
        ANY_CORE,
        ANY_CPU,
        CPU_LAST_MINUS,
        CPU_ID,
        CPU_STRATEGIES;

    }
}

