/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.net.StandardProtocolFamily;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javafx.application.Platform;
import javax.net.ssl.SSLContext;
import javax.swing.SwingUtilities;
import net.sf.eBus.config.AddressFilter;
import net.sf.eBus.config.ENetConfigure;
import net.sf.eBus.config.InetSocketAddressComparator;
import net.sf.eBus.config.ThreadAffinityConfigure;
import net.sf.eBus.config.ThreadType;
import net.sf.eBus.util.ValidationException;
import net.sf.eBus.util.Validator;
import net.sf.eBus.util.regex.Pattern;

public final class EConfigure {
    public static final String JSON_FILE_ENV = "net.sf.eBus.config.jsonFile";
    public static final String TLS_PROTOCOL_NAME = "TLS";
    public static final String DTLS_PROTOCOL_NAME = "DTLS";
    public static final String EBUS_KEY = "eBus";
    public static final String NAME_KEY = "name";
    public static final String SERVICES_KEY = "services";
    public static final String SERVICE_PREFIX = "eBus.service.";
    public static final String CONNECTIONS_KEY = "connections";
    public static final String CONNECTION_PREFIX = "eBus.connection.";
    public static final String DISPATCHERS_KEY = "dispatchers";
    public static final String DISPATCHER_PREFIX = "dispatcher.";
    public static final String CONN_TYPE_KEY = "connectionType";
    public static final String PORT_KEY = "port";
    public static final String INBUFFER_SIZE_KEY = "inputBufferSize";
    public static final String OUTBUFFER_SIZE_KEY = "outputBufferSize";
    public static final String BYTE_ORDER_KEY = "byteOrder";
    public static final String MSG_QUEUE_SIZE_KEY = "messageQueueSize";
    public static final String SVC_SELECTOR_KEY = "serviceSelector";
    public static final String CONN_SELECTOR_KEY = "connectionSelector";
    public static final String SELECTOR_KEY = "selector";
    public static final String HOST_KEY = "host";
    public static final String BIND_PORT_KEY = "bindPort";
    public static final String RECONNECT_KEY = "reconnect";
    public static final String RECONNECT_DELAY_KEY = "reconnectTime";
    public static final String HB_DELAY_KEY = "heartbeatDelay";
    public static final String HB_REPLY_DELAY_KEY = "heartbeatReplyDelay";
    public static final String FILTER_KEY = "addressFilter";
    public static final String DEFAULT_KEY = "isDefault";
    public static final String DISPATCHER_TYPE_KEY = "dispatcherType";
    public static final String THREAD_TYPE_KEY = "runQueueType";
    public static final String SPIN_LIMIT_KEY = "spinLimit";
    public static final String PARK_TIME_KEY = "parkTime";
    public static final String PRIORITY_KEY = "priority";
    public static final String QUANTUM_KEY = "quantum";
    public static final String CLASSES_KEY = "classes";
    public static final String NUM_THREADS_KEY = "numberThreads";
    public static final String CAN_PAUSE_KEY = "canPause";
    public static final String PAUSE_KEY = "pause";
    public static final String PAUSE_DURATION_KEY = "pauseTime";
    public static final String MAX_BACKLOG_SIZE_KEY = "maxBacklogSize";
    public static final String DISCARD_POLICY_KEY = "discardPolicy";
    public static final String IDLE_TIME_KEY = "idleTime";
    public static final String MAX_CONNECT_TIME_KEY = "maxConnectTime";
    public static final String RESUME_ON_BACKLOG_SIZE_KEY = "resumeOnBacklogSize";
    public static final String MULTICAST_KEY = "multicast";
    public static final String MULTICAST_ROLE_KEY = "role";
    public static final String GROUP_KEY = "group";
    public static final String TARGET_PORT_KEY = "targetPort";
    public static final String NET_IF_KEY = " networkInterface";
    public static final String SOURCES_KEY = "sources";
    public static final String PROTOCOL_KEY = "protocolFamily";
    public static final String NOTIFICATION_KEY = "notifications";
    public static final String MULTIFEED_TYPE_KEY = "multifeedType";
    public static final String MESSAGE_CLASS_KEY = "messageClass";
    public static final String SUBJECT_QUERY_KEY = "subjectQuery";
    public static final String SUBJECT_LIST_KEY = "subjectList";
    public static final String IS_DYNAMIC_KEY = "isDynamic";
    private static final String SSL_CONTEXT_KEY = "sslContext";
    private static final String AFFINITIES_KEY = "threadAffinities";
    private static final String BIGENDIAN = "BIG_ENDIAN";
    private static final String LITTLEENDIAN = "LITTLE_ENDIAN";
    private static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final String DEFAULT_THREAD_TYPE = ThreadType.BLOCKING.textName();
    public static final int DEFAULT_SPIN_LIMIT = 2500000;
    public static final Duration DEFAULT_PARK_TIME = Duration.ofNanos(1000L);
    public static final int DEFAULT_PRIORITY = 5;
    public static final Duration DEFAULT_QUANTUM = Duration.ofNanos(500000L);
    public static final int DEFAULT_NUMBER_THREADS = 4;
    public static final int DEFAULT_QUEUE_SIZE = 0;
    public static final boolean DEFAULT_RECONNECT_FLAG = false;
    public static final long DEFAULT_RECONNECT_TIME = 5000L;
    public static final Duration DEFAULT_HEARTBEAT_DELAY = Duration.ZERO;
    public static final Duration DEFAULT_HEARTBEAT_REPLY_DELAY = Duration.ZERO;
    private static final String INVALID_ADDRESS = "is not a valid address";
    private static final String INVALID_NAME = "name is null or empty";
    private static final String INVALID_DURATION_NULL = "duration is null";
    private static final String INVALID_DURATION = "duration <= 0";
    private static final Logger sLogger = Logger.getLogger(EConfigure.class.getName());
    private final Map<String, Service> mServices;
    private final Map<String, RemoteConnection> mRemoteConnections;
    private final Map<String, MulticastConnection> mMulticastConnections;
    private final Map<String, Dispatcher> mDispatchers;

    private EConfigure(Map<String, Service> services, Map<String, RemoteConnection> conns, Map<String, MulticastConnection> mcastconns, Map<String, Dispatcher> dispatchers) {
        this.mServices = services;
        this.mRemoteConnections = conns;
        this.mMulticastConnections = mcastconns;
        this.mDispatchers = dispatchers;
    }

    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof EConfigure) {
            EConfigure config = (EConfigure)o;
            retcode = this.mServices.equals(config.mServices) && this.mRemoteConnections.equals(config.mRemoteConnections) && this.mDispatchers.equals(config.mDispatchers);
        }
        return retcode;
    }

    public int hashCode() {
        return Objects.hash(this.mServices, this.mRemoteConnections, this.mDispatchers);
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        retval.append("         services:");
        if (this.mServices.isEmpty()) {
            retval.append(" none\n");
        } else {
            this.mServices.values().stream().forEach(service -> retval.append("\n    ").append(service).append('\n'));
        }
        retval.append("       connections:");
        if (this.mRemoteConnections.isEmpty()) {
            retval.append(" none\n");
        } else {
            this.mRemoteConnections.values().stream().forEach(conn -> retval.append("%n    ").append(conn));
        }
        return retval.toString();
    }

    public boolean hasServices() {
        return !this.mServices.isEmpty();
    }

    public boolean hasService(String name) {
        return this.mServices.containsKey(name);
    }

    public Map<String, Service> services() {
        return this.mServices;
    }

    public Service service(String name) {
        return this.mServices.get(name);
    }

    public boolean hasRemoteConnections() {
        return !this.mRemoteConnections.isEmpty();
    }

    public boolean hasRemoteConnection(String name) {
        return this.mRemoteConnections.containsKey(name);
    }

    public Map<String, RemoteConnection> remoteConnections() {
        return this.mRemoteConnections;
    }

    public RemoteConnection connection(String name) {
        return this.mRemoteConnections.get(name);
    }

    public boolean hasMulticastConnections() {
        return !this.mMulticastConnections.isEmpty();
    }

    public boolean hasMulticastConnection(String name) {
        return this.mMulticastConnections.containsKey(name);
    }

    public Map<String, MulticastConnection> multicastConnections() {
        return this.mMulticastConnections;
    }

    public MulticastConnection multicastConnection(String name) {
        return this.mMulticastConnections.get(name);
    }

    public boolean hasDispatchers() {
        return !this.mDispatchers.isEmpty();
    }

    public boolean hasDispatcher(String name) {
        return this.mDispatchers.containsKey(name);
    }

    public Map<String, Dispatcher> dispatchers() {
        return this.mDispatchers;
    }

    public Dispatcher dispatcher(String name) {
        return this.mDispatchers.get(name);
    }

    public static EConfigure create(Map<String, Service> services, Map<String, RemoteConnection> connections, Map<String, MulticastConnection> mcastConnections, Map<String, Dispatcher> dispatchers) {
        return new EConfigure(services, connections, mcastConnections, dispatchers);
    }

    public static ServerBuilder serverBuilder() {
        return new ServerBuilder();
    }

    public static ConnectionBuilder connectionBuilder() {
        return new ConnectionBuilder();
    }

    public static MulticastBuilder multicastBuilder() {
        return new MulticastBuilder();
    }

    public static DispatcherBuilder dispatcherBuilder() {
        return new DispatcherBuilder();
    }

    public static PauseBuilder pauseBuilder(ConnectionRole role) {
        return new PauseBuilder(role);
    }

    public static McastNotifyBuilder notificationBuilder() {
        return new McastNotifyBuilder();
    }

    public static EConfigure load(Config config) {
        return new EConfigure(EConfigure.loadServices(config), EConfigure.loadConnections(config), EConfigure.loadMulticastConnections(config), EConfigure.loadDispatchers(config));
    }

    public static Map<String, Service> loadServices(Config config) {
        HashMap<String, Service> retval = new HashMap<String, Service>();
        if (config.hasPath(SERVICES_KEY)) {
            for (ConfigObject co : config.getObjectList(SERVICES_KEY)) {
                Service service = EConfigure.loadService(co.toConfig());
                retval.put(service.name(), service);
            }
        }
        return retval;
    }

    public static Map<String, RemoteConnection> loadConnections(Config config) {
        HashMap<String, RemoteConnection> retval = new HashMap<String, RemoteConnection>();
        if (config.hasPath(CONNECTIONS_KEY)) {
            for (ConfigObject co : config.getObjectList(CONNECTIONS_KEY)) {
                RemoteConnection connection = EConfigure.loadConnection(co.toConfig());
                retval.put(connection.name(), connection);
            }
        }
        return retval;
    }

    public static Map<String, MulticastConnection> loadMulticastConnections(Config config) {
        HashMap<String, MulticastConnection> retval = new HashMap<String, MulticastConnection>();
        if (config.hasPath(MULTICAST_KEY)) {
            for (ConfigObject co : config.getObjectList(MULTICAST_KEY)) {
                MulticastConnection mcastConnection = EConfigure.loadMulticastConnection(co.toConfig());
                retval.put(mcastConnection.name(), mcastConnection);
            }
        }
        return retval;
    }

    public static Map<String, Dispatcher> loadDispatchers(Config config) {
        HashMap<String, Dispatcher> retval = new HashMap<String, Dispatcher>();
        if (config.hasPath(DISPATCHERS_KEY)) {
            for (ConfigObject co : config.getObjectList(DISPATCHERS_KEY)) {
                Dispatcher dispatcher = EConfigure.loadDispatcher(co.toConfig());
                retval.put(dispatcher.name(), dispatcher);
            }
        }
        return retval;
    }

    private static Service loadService(Config config) {
        ConnectionType connType = config.hasPath(CONN_TYPE_KEY) ? (ConnectionType)config.getEnum(ConnectionType.class, CONN_TYPE_KEY) : ConnectionType.TCP;
        ServerBuilder builder = new ServerBuilder();
        ((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)builder.loaderFlag(true)).name(config.getString(NAME_KEY))).connectionType(connType)).port(config.getInt(PORT_KEY)).addressFilter(AddressFilter.load(config, FILTER_KEY)).inputBufferSize(config.hasPath(INBUFFER_SIZE_KEY) ? config.getInt(INBUFFER_SIZE_KEY) : 2048)).outputBufferSize(config.hasPath(OUTBUFFER_SIZE_KEY) ? config.getInt(OUTBUFFER_SIZE_KEY) : 2048)).byteOrder(EConfigure.loadByteOrder(config, BYTE_ORDER_KEY))).messageQueueSize(config.hasPath(MSG_QUEUE_SIZE_KEY) ? config.getInt(MSG_QUEUE_SIZE_KEY) : 0)).serviceSelector(config.hasPath(SVC_SELECTOR_KEY) ? config.getString(SVC_SELECTOR_KEY) : ENetConfigure.defaultSelector().name()).connectionSelector(config.hasPath(CONN_SELECTOR_KEY) ? config.getString(CONN_SELECTOR_KEY) : ENetConfigure.defaultSelector().name()).heartbeatDelay(config.hasPath(HB_DELAY_KEY) ? config.getDuration(HB_DELAY_KEY) : Duration.ZERO)).heartbeatReplyDelay(config.hasPath(HB_REPLY_DELAY_KEY) ? config.getDuration(HB_REPLY_DELAY_KEY) : Duration.ZERO)).canPause(config.hasPath(CAN_PAUSE_KEY) && config.getBoolean(CAN_PAUSE_KEY));
        if (builder.mCanPause) {
            Config pauseConfig = config.getConfig(PAUSE_KEY);
            PauseBuilder pauseBuilder = new PauseBuilder(ConnectionRole.ACCEPTOR);
            pauseBuilder.duration(pauseConfig.getDuration(PAUSE_DURATION_KEY)).maxBacklogSize(pauseConfig.getInt(MAX_BACKLOG_SIZE_KEY));
            builder.pauseConfig(pauseBuilder.build());
        }
        return builder.build();
    }

    private static RemoteConnection loadConnection(Config config) {
        ConnectionType connType = config.hasPath(CONN_TYPE_KEY) ? (ConnectionType)config.getEnum(ConnectionType.class, CONN_TYPE_KEY) : ConnectionType.TCP;
        ConnectionBuilder builder = new ConnectionBuilder();
        ((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)builder.loaderFlag(true)).name(config.getString(NAME_KEY))).connectionType(connType)).address(EConfigure.loadAddress(config)).bindPort(config.hasPath(BIND_PORT_KEY) ? config.getInt(BIND_PORT_KEY) : 0).inputBufferSize(config.hasPath(INBUFFER_SIZE_KEY) ? config.getInt(INBUFFER_SIZE_KEY) : 2048)).outputBufferSize(config.hasPath(OUTBUFFER_SIZE_KEY) ? config.getInt(OUTBUFFER_SIZE_KEY) : 2048)).byteOrder(EConfigure.loadByteOrder(config, BYTE_ORDER_KEY))).messageQueueSize(config.hasPath(MSG_QUEUE_SIZE_KEY) ? config.getInt(MSG_QUEUE_SIZE_KEY) : 0)).selector(config.hasPath(SELECTOR_KEY) ? config.getString(SELECTOR_KEY) : ENetConfigure.defaultSelector().name()).reconnect(config.hasPath(RECONNECT_KEY) && config.getBoolean(RECONNECT_KEY)).reconnectDelay(builder.mReconnectFlag ? config.getDuration(RECONNECT_DELAY_KEY) : Duration.ZERO).heartbeatDelay(config.hasPath(HB_DELAY_KEY) ? config.getDuration(HB_DELAY_KEY) : DEFAULT_HEARTBEAT_DELAY)).heartbeatReplyDelay(config.hasPath(HB_REPLY_DELAY_KEY) ? config.getDuration(HB_REPLY_DELAY_KEY) : DEFAULT_HEARTBEAT_REPLY_DELAY)).canPause(config.hasPath(CAN_PAUSE_KEY) && config.getBoolean(CAN_PAUSE_KEY));
        if (builder.mCanPause) {
            Config pauseConfig = config.getConfig(PAUSE_KEY);
            PauseBuilder pauseBuilder = new PauseBuilder(ConnectionRole.INITIATOR);
            pauseBuilder.duration(pauseConfig.getDuration(PAUSE_DURATION_KEY)).maxBacklogSize(pauseConfig.getInt(MAX_BACKLOG_SIZE_KEY)).discardPolicy((DiscardPolicy)pauseConfig.getEnum(DiscardPolicy.class, DISCARD_POLICY_KEY)).idleTime(pauseConfig.getDuration(IDLE_TIME_KEY)).maxConnectionTime(pauseConfig.getDuration(MAX_CONNECT_TIME_KEY));
            if (pauseConfig.hasPath(RESUME_ON_BACKLOG_SIZE_KEY)) {
                pauseBuilder.resumeOnBacklogSize(pauseConfig.getInt(RESUME_ON_BACKLOG_SIZE_KEY));
            }
            builder.pauseConfig(pauseBuilder.build());
        }
        return builder.build();
    }

    private static MulticastConnection loadMulticastConnection(Config config) {
        NetworkInterface netIf = EConfigure.loadNetworkInterface(config);
        List<McastNotifyConfig> notifications = EConfigure.loadMcastNotifications(config);
        MulticastBuilder builder = new MulticastBuilder();
        builder.name(config.getString(NAME_KEY)).role((MulticastRole)config.getEnum(MulticastRole.class, MULTICAST_ROLE_KEY)).group(EConfigure.parseAddress(GROUP_KEY, config)).targetPort(config.getInt(TARGET_PORT_KEY)).networkInterface(netIf).sources(EConfigure.loadSources(config)).bindPort(config.hasPath(BIND_PORT_KEY) ? config.getInt(BIND_PORT_KEY) : 0).protocolFamily((ProtocolFamily)((Object)config.getEnum(StandardProtocolFamily.class, PROTOCOL_KEY))).byteOrder(EConfigure.loadByteOrder(config, BYTE_ORDER_KEY)).selector(config.hasPath(SELECTOR_KEY) ? config.getString(SELECTOR_KEY) : ENetConfigure.defaultSelector().name()).inputBufferSize(config.hasPath(INBUFFER_SIZE_KEY) ? config.getInt(INBUFFER_SIZE_KEY) : 2048).outputBufferSize(config.hasPath(OUTBUFFER_SIZE_KEY) ? config.getInt(OUTBUFFER_SIZE_KEY) : 2048).notifications(notifications);
        return builder.build();
    }

    @VisibleForTesting
    public static Dispatcher loadDispatcher(Config config) {
        DispatcherBuilder builder = new DispatcherBuilder();
        builder.name(config.getString(NAME_KEY)).dispatcherType(DispatcherType.findType(builder.mName));
        if (builder.mType.isSpecial()) {
            EConfigure.loadSpecialDispatcher(builder, config);
        } else {
            EConfigure.loadDispatcher(builder, config);
        }
        return builder.build();
    }

    private static void loadDispatcher(DispatcherBuilder builder, Config config) throws ConfigException {
        builder.threadType(config.hasPath(THREAD_TYPE_KEY) ? ThreadType.find(config.getString(THREAD_TYPE_KEY)) : ThreadType.find(DEFAULT_THREAD_TYPE));
        switch (builder.mRunQueueType) {
            case SPINPARK: {
                builder.parkTime(config.hasPath(PARK_TIME_KEY) ? config.getDuration(PARK_TIME_KEY) : DEFAULT_PARK_TIME);
            }
            case SPINYIELD: {
                builder.spinLimit(config.hasPath(SPIN_LIMIT_KEY) ? config.getLong(SPIN_LIMIT_KEY) : 2500000L);
                break;
            }
        }
        builder.priority(config.hasPath(PRIORITY_KEY) ? config.getInt(PRIORITY_KEY) : 5).quantum(config.hasPath(QUANTUM_KEY) ? config.getDuration(QUANTUM_KEY) : DEFAULT_QUANTUM).numberThreads(config.hasPath(NUM_THREADS_KEY) ? config.getInt(NUM_THREADS_KEY) : 4).isDefault(config.hasPath(DEFAULT_KEY) && config.getBoolean(DEFAULT_KEY)).classes(builder.mIsDefault ? new Class[]{} : EConfigure.loadClasses(config)).threadAffinity(ThreadAffinityConfigure.loadAffinities(AFFINITIES_KEY, config));
    }

    private static void loadSpecialDispatcher(DispatcherBuilder builder, Config config) throws ConfigException {
        builder.isDefault(config.hasPath(DEFAULT_KEY) ? config.getBoolean(DEFAULT_KEY) : false).classes(builder.mIsDefault ? new Class[]{} : EConfigure.loadClasses(config)).threadType(ThreadType.BLOCKING).spinLimit(0L).parkTime(Duration.ZERO).priority(0).quantum(Duration.ZERO).numberThreads(0);
    }

    private static InetSocketAddress loadAddress(Config config) {
        InetSocketAddress retval;
        String host = config.getString(HOST_KEY);
        int port = config.getInt(PORT_KEY);
        try {
            retval = new InetSocketAddress(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException hostex) {
            throw new ConfigException.BadValue(HOST_KEY, "\"" + host + "\" is not a valid address", (Throwable)hostex);
        }
        return retval;
    }

    private static InetAddress parseAddress(String key, Config config) {
        String s = config.getString(key);
        InetAddress retval = null;
        if (!Strings.isNullOrEmpty((String)s)) {
            try {
                retval = InetAddress.getByName(s);
            }
            catch (UnknownHostException hostex) {
                throw new ConfigException.BadValue(key, "\"" + s + "\" is not a valid address", (Throwable)hostex);
            }
        }
        return retval;
    }

    private static NetworkInterface loadNetworkInterface(Config config) {
        NetworkInterface retval;
        String s = config.getString(NET_IF_KEY);
        try {
            retval = NetworkInterface.getByName(s);
        }
        catch (SocketException sockex) {
            throw new ConfigException.BadValue(NET_IF_KEY, "\"" + s + "\" is not a valid network interface", (Throwable)sockex);
        }
        return retval;
    }

    private static ByteOrder loadByteOrder(Config config, String key) throws ConfigException {
        ByteOrder retval;
        if (!config.hasPathOrNull(BYTE_ORDER_KEY)) {
            retval = DEFAULT_BYTE_ORDER;
        } else {
            String value;
            switch (value = config.getString(key)) {
                case "BIG_ENDIAN": {
                    retval = ByteOrder.BIG_ENDIAN;
                    break;
                }
                case "LITTLE_ENDIAN": {
                    retval = ByteOrder.LITTLE_ENDIAN;
                    break;
                }
                default: {
                    throw new ConfigException.BadValue(key, "\"" + value + "\" is not a valid java.nio.ByteOrder");
                }
            }
        }
        return retval;
    }

    private static Class<?>[] loadClasses(Config config) {
        List classNames = config.getStringList(CLASSES_KEY);
        int index = 0;
        Class[] retval = new Class[classNames.size()];
        if (classNames.isEmpty()) {
            throw new ConfigException.BadValue(CLASSES_KEY, "classes are missing or empty");
        }
        for (String className : classNames) {
            try {
                retval[index] = Class.forName(className);
            }
            catch (ClassNotFoundException classex) {
                throw new ConfigException.BadValue(CLASSES_KEY, "\"" + className + "\" is an unknown class", (Throwable)classex);
            }
            ++index;
        }
        return retval;
    }

    private static List<InetAddress> loadSources(Config config) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (config.hasPath(SOURCES_KEY)) {
            config.getStringList(SOURCES_KEY).forEach(host -> {
                try {
                    builder.add((Object)InetAddress.getByName(host));
                }
                catch (UnknownHostException hostex) {
                    throw new ConfigException.BadValue(SOURCES_KEY, "\"" + host + "\" is not a valid address", (Throwable)hostex);
                }
            });
        }
        return builder.build();
    }

    private static List<McastNotifyConfig> loadMcastNotifications(Config config) {
        if (!config.hasPath(NOTIFICATION_KEY)) {
            throw new ConfigException.Generic("notifications property is missing");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        config.getObjectList(NOTIFICATION_KEY).forEach(co -> builder.add((Object)EConfigure.loadNotification(co.toConfig())));
        return builder.build();
    }

    private static McastNotifyConfig loadNotification(Config config) {
        MultifeedType type = (MultifeedType)config.getEnum(MultifeedType.class, MULTIFEED_TYPE_KEY);
        McastNotifyBuilder builder = new McastNotifyBuilder();
        builder.feedType(type).messageClass(config.getString(MESSAGE_CLASS_KEY));
        if (type == MultifeedType.LIST) {
            builder.subjectList(config.getStringList(SUBJECT_LIST_KEY));
        } else {
            builder.subjectQuery(config.getString(SUBJECT_QUERY_KEY)).isDynamic(config.getBoolean(IS_DYNAMIC_KEY));
        }
        return builder.build();
    }

    public static final class McastNotifyBuilder {
        private MultifeedType mType;
        private String mMessageClass;
        private List<String> mSubjectList = null;
        private Pattern mSubjectQuery = null;
        private boolean mIsDynamic = false;

        private McastNotifyBuilder() {
        }

        public McastNotifyBuilder feedType(MultifeedType type) {
            if (type == null) {
                throw new ConfigException.BadValue(EConfigure.MULTIFEED_TYPE_KEY, "multi-feed type is null");
            }
            this.mType = type;
            return this;
        }

        public McastNotifyBuilder messageClass(String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                throw new ConfigException.BadValue(EConfigure.MESSAGE_CLASS_KEY, "message class name is either null or an empty string");
            }
            this.mMessageClass = name;
            return this;
        }

        public McastNotifyBuilder subjectList(List<String> subjects) {
            if (subjects == null || subjects.isEmpty()) {
                throw new ConfigException.BadValue(EConfigure.MESSAGE_CLASS_KEY, "subjects is either null or an empty list");
            }
            this.mSubjectList = new ArrayList<String>(subjects);
            return this;
        }

        public McastNotifyBuilder subjectQuery(String query) {
            try {
                this.mSubjectQuery = Pattern.compile((String)query);
            }
            catch (IllegalArgumentException argex) {
                throw new ConfigException.BadValue(EConfigure.SUBJECT_QUERY_KEY, "\"" + query + "\" is not a valid subject query", (Throwable)argex);
            }
            return this;
        }

        public McastNotifyBuilder isDynamic(boolean flag) {
            this.mIsDynamic = flag;
            return this;
        }

        public McastNotifyConfig build() {
            Validator problems = this.validate(new Validator());
            if (!problems.isEmpty()) {
                throw new ConfigException.Generic("invalid service configuration", (Throwable)new ValidationException(McastNotifyConfig.class, problems.errors()));
            }
            if (this.mType == MultifeedType.LIST) {
                this.mSubjectQuery = null;
                this.mIsDynamic = false;
            } else {
                this.mSubjectList = null;
            }
            return new McastNotifyConfig(this);
        }

        private Validator validate(Validator problems) {
            return problems.requireNotNull((Object)this.mMessageClass, EConfigure.MESSAGE_CLASS_KEY).requireTrue(this.mType != MultifeedType.LIST || this.mSubjectList != null, EConfigure.SUBJECT_LIST_KEY, "subject list not set").requireTrue(this.mType != MultifeedType.QUERY || this.mSubjectQuery != null, EConfigure.SUBJECT_QUERY_KEY, "subject query not set");
        }
    }

    public static final class MulticastBuilder {
        private String mName;
        private MulticastRole mRole;
        private InetAddress mGroup;
        private int mTargetPort = -1;
        private NetworkInterface mNetworkIF;
        private List<InetAddress> mSources;
        private InetAddress mBindAddress;
        private int mBindPort = 0;
        private ProtocolFamily mFamily;
        private ByteOrder mByteOrder = DEFAULT_BYTE_ORDER;
        private String mSelector = ENetConfigure.defaultSelector().name();
        private int mInputBufferSize = 0;
        private int mOutputBufferSize = 0;
        private List<McastNotifyConfig> mNotifications;

        private MulticastBuilder() {
        }

        public MulticastBuilder name(String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                throw new ConfigException.BadValue(EConfigure.NAME_KEY, EConfigure.INVALID_NAME);
            }
            this.mName = name;
            return this;
        }

        public MulticastBuilder role(MulticastRole role) {
            if (role == null) {
                throw new ConfigException.BadValue(EConfigure.MULTICAST_ROLE_KEY, "role is null");
            }
            this.mRole = role;
            return this;
        }

        public MulticastBuilder group(InetAddress group) {
            if (group == null) {
                throw new ConfigException.BadValue(EConfigure.GROUP_KEY, "group is null");
            }
            if (!group.isMulticastAddress()) {
                throw new ConfigException.BadValue(EConfigure.GROUP_KEY, String.format("\"%s\" is not a multicast address", group));
            }
            this.mGroup = group;
            return this;
        }

        public MulticastBuilder targetPort(int port) {
            if (port < 0 || port > 65535) {
                throw new ConfigException.BadValue(EConfigure.BIND_PORT_KEY, "invalid target port (" + port + ")");
            }
            this.mTargetPort = port;
            return this;
        }

        public MulticastBuilder networkInterface(NetworkInterface netIf) {
            if (netIf == null) {
                throw new ConfigException.BadValue(EConfigure.NET_IF_KEY, "networkInterface is null");
            }
            this.mNetworkIF = netIf;
            return this;
        }

        public MulticastBuilder sources(List<InetAddress> sources) {
            this.mSources = sources == null || sources.isEmpty() ? ImmutableList.of() : ImmutableList.copyOf(sources);
            return this;
        }

        public MulticastBuilder bindAddress(InetAddress address) {
            this.mBindAddress = address;
            return this;
        }

        public MulticastBuilder bindPort(int port) {
            if (port < 0 || port > 65535) {
                throw new ConfigException.BadValue(EConfigure.BIND_PORT_KEY, "invalid bind port (" + port + ")");
            }
            this.mBindPort = port;
            return this;
        }

        public MulticastBuilder protocolFamily(ProtocolFamily family) {
            if (family == null) {
                throw new ConfigException.BadValue(EConfigure.PROTOCOL_KEY, "protocolFamily is null");
            }
            this.mFamily = family;
            return this;
        }

        public MulticastBuilder byteOrder(ByteOrder byteOrder) {
            if (byteOrder == null) {
                throw new ConfigException.BadValue(EConfigure.BYTE_ORDER_KEY, "byteOrder is null");
            }
            this.mByteOrder = byteOrder;
            return this;
        }

        public MulticastBuilder selector(String selector) {
            if (Strings.isNullOrEmpty((String)selector)) {
                throw new ConfigException.BadValue(EConfigure.SELECTOR_KEY, "selector is null or empty");
            }
            if (!ENetConfigure.isKnownSelector(selector)) {
                throw new ConfigException.BadValue(EConfigure.SELECTOR_KEY, "\"" + selector + "\" unknown selector");
            }
            this.mSelector = selector;
            return this;
        }

        public MulticastBuilder inputBufferSize(int size) {
            if (size < 0) {
                throw new ConfigException.BadValue(EConfigure.INBUFFER_SIZE_KEY, "input buffer size < 0");
            }
            this.mInputBufferSize = size;
            return this;
        }

        public MulticastBuilder outputBufferSize(int size) {
            if (size < 0) {
                throw new ConfigException.BadValue(EConfigure.OUTBUFFER_SIZE_KEY, "output buffer size < 0");
            }
            this.mOutputBufferSize = size;
            return this;
        }

        public MulticastBuilder notifications(List<McastNotifyConfig> notifications) {
            if (notifications == null) {
                throw new ConfigException.BadValue(EConfigure.NOTIFICATION_KEY, "notifications is null");
            }
            if (notifications.isEmpty()) {
                throw new ConfigException.BadValue(EConfigure.NOTIFICATION_KEY, "notifications is empty");
            }
            this.mNotifications = ImmutableList.copyOf(notifications);
            return this;
        }

        public MulticastConnection build() {
            Validator problems = this.validate(new Validator());
            if (!problems.isEmpty()) {
                throw new ConfigException.Generic("invalid service configuration", (Throwable)new ValidationException(MulticastConnection.class, problems.errors()));
            }
            return new MulticastConnection(this);
        }

        private Validator validate(Validator problems) {
            return problems.requireNotNull((Object)this.mName, EConfigure.NAME_KEY).requireNotNull((Object)this.mRole, EConfigure.MULTICAST_ROLE_KEY).requireNotNull((Object)this.mGroup, EConfigure.GROUP_KEY).requireTrue(this.mTargetPort >= 0, EConfigure.TARGET_PORT_KEY, "multicast target port not set").requireNotNull((Object)this.mNetworkIF, EConfigure.NET_IF_KEY).requireNotNull((Object)this.mFamily, EConfigure.PROTOCOL_KEY).requireNotNull(this.mNotifications, EConfigure.NOTIFICATION_KEY);
        }
    }

    public static final class PauseBuilder {
        private final ConnectionRole mRole;
        private Duration mDuration;
        private int mMaxBacklogSize;
        private DiscardPolicy mDiscardPolicy;
        private Duration mIdleTime;
        private Duration mMaxConnectTime;
        private int mResumeOnBacklogSize;

        private PauseBuilder(ConnectionRole role) {
            this.mRole = role;
            this.mDuration = Duration.ZERO;
            this.mMaxBacklogSize = 0;
            this.mIdleTime = Duration.ZERO;
            this.mMaxConnectTime = Duration.ZERO;
            this.mResumeOnBacklogSize = 0;
        }

        public PauseBuilder duration(Duration duration) {
            if (duration == null) {
                throw new ConfigException.BadValue(EConfigure.PAUSE_DURATION_KEY, EConfigure.INVALID_DURATION_NULL);
            }
            if (duration.compareTo(Duration.ZERO) <= 0) {
                throw new ConfigException.BadValue(EConfigure.PAUSE_DURATION_KEY, EConfigure.INVALID_DURATION);
            }
            this.mDuration = duration;
            return this;
        }

        public PauseBuilder maxBacklogSize(int size) {
            if (size < 0) {
                throw new ConfigException.BadValue(EConfigure.MAX_BACKLOG_SIZE_KEY, "size < 0");
            }
            this.mMaxBacklogSize = size;
            return this;
        }

        public PauseBuilder discardPolicy(DiscardPolicy policy) {
            if (this.mRole == ConnectionRole.ACCEPTOR) {
                throw new ConfigException.Generic("cannot set discard policy for acceptor connection");
            }
            if (policy == null) {
                throw new ConfigException.BadValue(EConfigure.DISCARD_POLICY_KEY, "policy is null");
            }
            this.mDiscardPolicy = policy;
            return this;
        }

        public PauseBuilder idleTime(Duration duration) {
            if (this.mRole == ConnectionRole.ACCEPTOR) {
                throw new ConfigException.Generic("cannot set idle time for acceptor connection");
            }
            if (duration == null) {
                throw new ConfigException.BadValue(EConfigure.IDLE_TIME_KEY, EConfigure.INVALID_DURATION_NULL);
            }
            if (duration.compareTo(Duration.ZERO) <= 0) {
                throw new ConfigException.BadValue(EConfigure.IDLE_TIME_KEY, EConfigure.INVALID_DURATION);
            }
            this.mIdleTime = duration;
            return this;
        }

        public PauseBuilder maxConnectionTime(Duration duration) {
            if (this.mRole == ConnectionRole.ACCEPTOR) {
                throw new ConfigException.Generic("cannot set max connection time for acceptor connection");
            }
            if (duration == null) {
                throw new ConfigException.BadValue(EConfigure.MAX_CONNECT_TIME_KEY, EConfigure.INVALID_DURATION_NULL);
            }
            if (duration.compareTo(Duration.ZERO) <= 0) {
                throw new ConfigException.BadValue(EConfigure.MAX_CONNECT_TIME_KEY, EConfigure.INVALID_DURATION);
            }
            this.mMaxConnectTime = duration;
            if (this.mIdleTime.equals(Duration.ZERO)) {
                this.mIdleTime = duration;
            }
            return this;
        }

        public PauseBuilder resumeOnBacklogSize(int size) {
            if (this.mRole == ConnectionRole.ACCEPTOR) {
                throw new ConfigException.Generic("cannot set max connection time for acceptor connection");
            }
            if (size < 0) {
                throw new ConfigException.BadValue(EConfigure.RESUME_ON_BACKLOG_SIZE_KEY, "size < 0");
            }
            this.mResumeOnBacklogSize = size;
            return this;
        }

        public PauseConfig build() {
            Validator problems = this.validate(new Validator());
            if (!problems.isEmpty()) {
                throw new ConfigException.Generic("invalid service configuration", (Throwable)new ValidationException(PauseConfig.class, problems.errors()));
            }
            return new PauseConfig(this);
        }

        private Validator validate(Validator problems) {
            return problems.requireTrue(!this.mDuration.isZero(), EConfigure.PAUSE_DURATION_KEY, "pause duration not set").requireTrue(this.mRole != ConnectionRole.INITIATOR || !this.mMaxConnectTime.isZero(), EConfigure.MAX_CONNECT_TIME_KEY, "maximum connect time not set");
        }
    }

    public static final class DispatcherBuilder {
        private String mName = null;
        private DispatcherType mType = null;
        private ThreadType mRunQueueType = null;
        private long mSpinLimit = 0L;
        private Duration mParkTime = Duration.ZERO;
        private int mPriority = 5;
        private Duration mQuantum = DEFAULT_QUANTUM;
        private int mNumThreads = 4;
        private boolean mIsDefault = false;
        private Class<?>[] mClasses = new Class[0];
        private ThreadAffinityConfigure[] mAffinity;

        private DispatcherBuilder() {
        }

        public DispatcherBuilder configuration(Dispatcher config) {
            if (config != null) {
                this.mName = config.name();
                this.mType = config.dispatchType();
                this.mRunQueueType = config.runQueueType();
                this.mSpinLimit = config.spinLimit();
                this.mParkTime = config.parkTime();
                this.mPriority = config.priority();
                this.mQuantum = config.quantum();
                this.mNumThreads = config.numberThreads();
                this.mIsDefault = config.isDefault();
                this.mClasses = config.classes();
            }
            return this;
        }

        public DispatcherBuilder name(String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                throw new ConfigException.BadValue(EConfigure.NAME_KEY, EConfigure.INVALID_NAME);
            }
            this.mName = name;
            return this;
        }

        public DispatcherBuilder dispatcherType(DispatcherType type) {
            if (type == null) {
                throw new ConfigException.BadValue(EConfigure.DISPATCHER_TYPE_KEY, "type is null or unknown");
            }
            this.mType = type;
            return this;
        }

        public DispatcherBuilder threadType(ThreadType type) {
            if (type == null) {
                throw new ConfigException.BadValue(EConfigure.THREAD_TYPE_KEY, "type is null or unknown");
            }
            this.mRunQueueType = type;
            return this;
        }

        public DispatcherBuilder spinLimit(long limit) {
            if (limit < 0L) {
                throw new ConfigException.BadValue(EConfigure.SPIN_LIMIT_KEY, "limit < zero");
            }
            this.mSpinLimit = limit;
            return this;
        }

        public DispatcherBuilder parkTime(Duration time) {
            if (time == null) {
                throw new ConfigException.BadValue(EConfigure.PARK_TIME_KEY, "time is null");
            }
            if (time.isNegative()) {
                throw new ConfigException.BadValue(EConfigure.PARK_TIME_KEY, "time < zero");
            }
            this.mParkTime = time;
            return this;
        }

        public DispatcherBuilder priority(int priority) {
            if (priority < 0 || priority > 10) {
                throw new ConfigException.BadValue(EConfigure.PRIORITY_KEY, "priority out of bounds");
            }
            this.mPriority = priority;
            return this;
        }

        public DispatcherBuilder quantum(Duration quantum) {
            if (quantum == null) {
                throw new ConfigException.BadValue(EConfigure.QUANTUM_KEY, "quantum is null");
            }
            if (quantum.isNegative()) {
                throw new ConfigException.BadValue(EConfigure.QUANTUM_KEY, "quantum < zero");
            }
            this.mQuantum = quantum;
            return this;
        }

        public DispatcherBuilder numberThreads(int numThreads) {
            if (numThreads < 0) {
                throw new ConfigException.BadValue(EConfigure.NUM_THREADS_KEY, "numThreads < zero");
            }
            this.mNumThreads = numThreads;
            return this;
        }

        public DispatcherBuilder isDefault(boolean flag) {
            this.mIsDefault = flag;
            return this;
        }

        public DispatcherBuilder classes(Class<?>[] classes) {
            this.mClasses = classes == null ? new Class[0] : Arrays.copyOf(classes, classes.length);
            return this;
        }

        public DispatcherBuilder threadAffinity(List<ThreadAffinityConfigure> affinities) {
            return this.threadAffinity(affinities.toArray(new ThreadAffinityConfigure[affinities.size()]));
        }

        public DispatcherBuilder threadAffinity(ThreadAffinityConfigure[] affinities) {
            this.mAffinity = affinities;
            return this;
        }

        public Dispatcher build() {
            Validator problems = this.validate(new Validator());
            if (!problems.isEmpty()) {
                throw new ConfigException.Generic("invalid service configuration", (Throwable)new ValidationException(Dispatcher.class, problems.errors()));
            }
            return new Dispatcher(this);
        }

        private Validator validate(Validator problems) {
            problems.requireNotNull((Object)this.mName, EConfigure.NAME_KEY).requireNotNull((Object)this.mType, EConfigure.DISPATCHER_TYPE_KEY).requireNotNull((Object)this.mRunQueueType, EConfigure.THREAD_TYPE_KEY).requireTrue(this.mRunQueueType != ThreadType.SPINPARK || this.mSpinLimit > 0L, EConfigure.SPIN_LIMIT_KEY, "spin limit not set for spin+park thread type").requireTrue(this.mRunQueueType != ThreadType.SPINPARK || this.mParkTime != null && this.mParkTime.compareTo(Duration.ZERO) > 0, EConfigure.PARK_TIME_KEY, "park limit not set for spin+park thread type").requireTrue(this.mRunQueueType != ThreadType.SPINYIELD || this.mSpinLimit > 0L, EConfigure.SPIN_LIMIT_KEY, "spin limit not set for spin+yield thread type").requireTrue(this.mIsDefault || this.mClasses != null && this.mClasses.length > 0, EConfigure.CLASSES_KEY, "classes not set for non-default dispatcher");
            if (this.mAffinity != null && this.mAffinity.length > 0) {
                this.validateAffinities(problems);
            }
            return problems;
        }

        private Validator validateAffinities(Validator problems) {
            return problems.requireTrue(this.mAffinity[0].affinityType() != ThreadAffinityConfigure.AffinityType.CPU_STRATEGIES, EConfigure.CLASSES_KEY, "may not use strategy thread affinity first").requireTrue(this.mAffinity.length == this.mNumThreads || this.mAffinity[this.mAffinity.length - 1].affinityType() != ThreadAffinityConfigure.AffinityType.CPU_ID, EConfigure.CLASSES_KEY, "may not use CPU ID thread affinity last");
        }
    }

    public static final class ConnectionBuilder
    extends AbstractBuilder<ConnectionBuilder> {
        private InetSocketAddress mAddress = null;
        private int mBindPort = 0;
        private String mSelector = ENetConfigure.defaultSelector().name();
        private boolean mReconnectFlag = false;
        private Duration mReconnectTime = Duration.ZERO;

        private ConnectionBuilder() {
        }

        public ConnectionBuilder configuration(RemoteConnection config) {
            if (config != null) {
                super.configuration(config);
                this.mAddress = config.address();
                this.mBindPort = config.bindPort();
                this.mSelector = config.selector();
                this.mReconnectFlag = config.reconnectFlag();
                this.mReconnectTime = config.reconnectTime();
            }
            return this;
        }

        public ConnectionBuilder address(InetSocketAddress address) {
            if (address == null) {
                throw new ConfigException.BadValue(EConfigure.HOST_KEY, "address is null");
            }
            this.mAddress = address;
            return this;
        }

        public ConnectionBuilder bindPort(int port) {
            if (port < 0 || port > 65535) {
                throw new ConfigException.BadValue(EConfigure.BIND_PORT_KEY, "invalid bind port (" + port + ")");
            }
            this.mBindPort = port;
            return this;
        }

        public ConnectionBuilder selector(String selector) {
            if (Strings.isNullOrEmpty((String)selector)) {
                throw new ConfigException.BadValue(EConfigure.SELECTOR_KEY, "selector is null or empty");
            }
            if (!ENetConfigure.isKnownSelector(selector)) {
                throw new ConfigException.BadValue(EConfigure.SELECTOR_KEY, "\"" + selector + "\" unknown selector");
            }
            this.mSelector = selector;
            return this;
        }

        public ConnectionBuilder reconnect(boolean flag) {
            this.mReconnectFlag = flag;
            return this;
        }

        public ConnectionBuilder reconnectDelay(Duration time) {
            if (time == null) {
                throw new ConfigException.BadValue(EConfigure.RECONNECT_DELAY_KEY, "reconnect time is null");
            }
            if (time.isNegative()) {
                throw new ConfigException.BadValue(EConfigure.RECONNECT_DELAY_KEY, "reconnect time < 0");
            }
            this.mReconnectTime = time;
            return this;
        }

        public RemoteConnection build() {
            Validator problems = this.validate(new Validator());
            if (!problems.isEmpty()) {
                throw new ConfigException.Generic("invalid service configuration", (Throwable)new ValidationException(RemoteConnection.class, problems.errors()));
            }
            return new RemoteConnection(this);
        }

        @Override
        protected Validator validate(Validator problems) {
            return super.validate(problems).requireNotNullOrEmpty(this.mName, EConfigure.NAME_KEY).requireNotNull((Object)this.mAddress, EConfigure.HOST_KEY).requireTrue(!this.mReconnectFlag || this.mReconnectTime.compareTo(Duration.ZERO) > 0, EConfigure.RECONNECT_DELAY_KEY, "reconnect time not set");
        }
    }

    public static final class ServerBuilder
    extends AbstractBuilder<ServerBuilder> {
        private int mPort = 0;
        private AddressFilter mAddressFilter = null;
        private String mServiceSelector;
        private String mConnSelector = this.mServiceSelector = ENetConfigure.defaultSelector().name();

        private ServerBuilder() {
        }

        public ServerBuilder configuration(Service config) {
            if (config != null) {
                super.configuration(config);
                this.mPort = config.port();
                this.mAddressFilter = config.addressFilter();
                this.mServiceSelector = config.serviceSelector();
                this.mConnSelector = config.connectionSelector();
            }
            return this;
        }

        public ServerBuilder port(int port) {
            if (port < 0 || port > 65535) {
                throw new ConfigException.BadValue(EConfigure.PORT_KEY, "invalid port (" + port + ")");
            }
            this.mPort = port;
            return this;
        }

        public ServerBuilder addressFilter(AddressFilter filter) {
            this.mAddressFilter = filter;
            return this;
        }

        public ServerBuilder serviceSelector(String selector) {
            if (Strings.isNullOrEmpty((String)selector)) {
                throw new ConfigException.BadValue(EConfigure.SVC_SELECTOR_KEY, "service selector is null or empty");
            }
            if (!ENetConfigure.isKnownSelector(selector)) {
                throw new ConfigException.BadValue(EConfigure.SVC_SELECTOR_KEY, "\"" + selector + "\" unknown service selector");
            }
            this.mServiceSelector = selector;
            return this;
        }

        public ServerBuilder connectionSelector(String selector) {
            if (Strings.isNullOrEmpty((String)selector)) {
                throw new ConfigException.BadValue(EConfigure.CONN_SELECTOR_KEY, "connection selector is null or empty");
            }
            if (!ENetConfigure.isKnownSelector(selector)) {
                throw new ConfigException.BadValue(EConfigure.CONN_SELECTOR_KEY, "\"" + selector + "\" unknown connection selector");
            }
            this.mConnSelector = selector;
            return this;
        }

        public Service build() {
            Validator problems = this.validate(new Validator());
            if (!problems.isEmpty()) {
                throw new ConfigException.Generic("invalid service configuration", (Throwable)new ValidationException(Service.class, problems.errors()));
            }
            return new Service(this);
        }

        @Override
        protected Validator validate(Validator problems) {
            return super.validate(problems).requireTrue(this.mPort > 0, EConfigure.PORT_KEY, "service port not set");
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder> {
        protected String mName = null;
        private ConnectionType mConnectionType = ConnectionType.TCP;
        protected int mInputBufferSize = 0;
        protected int mOutputBufferSize = 0;
        protected ByteOrder mByteOrder = DEFAULT_BYTE_ORDER;
        protected int mMsgQueueSize = 0;
        protected Duration mHbDelay = DEFAULT_HEARTBEAT_DELAY;
        protected Duration mHbReplyDelay = DEFAULT_HEARTBEAT_REPLY_DELAY;
        protected SSLContext mSSLContext = null;
        protected boolean mCanPause = false;
        protected PauseConfig mPauseConfig = null;
        protected boolean mLoaderFlag = false;

        protected AbstractBuilder() {
        }

        public final T name(String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                throw new ConfigException.BadValue(EConfigure.NAME_KEY, EConfigure.INVALID_NAME);
            }
            this.mName = name;
            return (T)this;
        }

        public final T connectionType(ConnectionType connType) {
            if (connType == null) {
                throw new ConfigException.BadValue(EConfigure.CONN_TYPE_KEY, "connType is null");
            }
            this.mConnectionType = connType;
            return (T)this;
        }

        public final T inputBufferSize(int size) {
            if (size < 0) {
                throw new ConfigException.BadValue(EConfigure.INBUFFER_SIZE_KEY, "input buffer size < 0");
            }
            this.mInputBufferSize = size;
            return (T)this;
        }

        public final T outputBufferSize(int size) {
            if (size < 0) {
                throw new ConfigException.BadValue(EConfigure.OUTBUFFER_SIZE_KEY, "output buffer size < 0");
            }
            this.mOutputBufferSize = size;
            return (T)this;
        }

        public final T byteOrder(ByteOrder byteOrder) {
            if (byteOrder == null) {
                throw new ConfigException.BadValue(EConfigure.BYTE_ORDER_KEY, "byteOrder is null");
            }
            this.mByteOrder = byteOrder;
            return (T)this;
        }

        public final T messageQueueSize(int size) {
            if (size < 0) {
                throw new ConfigException.BadValue(EConfigure.MSG_QUEUE_SIZE_KEY, "message queue size < 0");
            }
            this.mMsgQueueSize = size;
            return (T)this;
        }

        public final T heartbeatDelay(Duration delay) {
            if (delay == null) {
                throw new ConfigException.BadValue(EConfigure.HB_DELAY_KEY, "heartbeat delay is null");
            }
            if (delay.isNegative()) {
                throw new ConfigException.BadValue(EConfigure.HB_DELAY_KEY, "heartbeat delay < 0");
            }
            this.mHbDelay = delay;
            return (T)this;
        }

        public final T heartbeatReplyDelay(Duration delay) {
            if (delay == null) {
                throw new ConfigException.BadValue(EConfigure.HB_REPLY_DELAY_KEY, "heartbeat reply delay is null");
            }
            if (delay.isNegative()) {
                throw new ConfigException.BadValue(EConfigure.HB_REPLY_DELAY_KEY, "heartbeat reply delay < 0");
            }
            this.mHbReplyDelay = delay;
            return (T)this;
        }

        public final T sslContext(SSLContext context) {
            if (context == null) {
                throw new ConfigException.BadValue(EConfigure.SSL_CONTEXT_KEY, "context is null");
            }
            this.mSSLContext = context;
            return (T)this;
        }

        public final T canPause(boolean flag) {
            this.mCanPause = flag;
            return (T)this;
        }

        public final T pauseConfig(PauseConfig pc) {
            if (!this.mCanPause) {
                throw new ConfigException.Generic("connection cannot be paused");
            }
            if (pc == null) {
                throw new ConfigException.BadValue(EConfigure.PAUSE_KEY, "pause config is null");
            }
            this.mPauseConfig = pc;
            return (T)this;
        }

        protected T configuration(AbstractConfig config) {
            this.mName = config.name();
            this.mConnectionType = config.connectionType();
            this.mInputBufferSize = config.inputBufferSize();
            this.mOutputBufferSize = config.outputBufferSize();
            this.mByteOrder = config.byteOrder();
            this.mMsgQueueSize = config.messageQueueSize();
            this.mHbDelay = config.heartbeatDelay();
            this.mHbReplyDelay = config.heartbeatReplyDelay();
            this.mSSLContext = config.sslContext();
            this.mCanPause = config.canPause();
            this.mPauseConfig = config.pauseConfiguration();
            return (T)this;
        }

        protected final T loaderFlag(boolean flag) {
            this.mLoaderFlag = flag;
            return (T)this;
        }

        protected Validator validate(Validator problems) {
            return problems.requireNotNull((Object)this.mName, EConfigure.NAME_KEY).requireTrue(!this.mConnectionType.isSecure() || this.mLoaderFlag || this.mSSLContext != null, EConfigure.SSL_CONTEXT_KEY, "SSL context not provided for secure connection").requireTrue(this.mConnectionType.mIsSecure || this.mSSLContext == null, EConfigure.SSL_CONTEXT_KEY, "SSL context provided for non-secure connection").requireTrue(!this.mCanPause || this.mPauseConfig != null, EConfigure.PAUSE_KEY, "pause configuration not set");
        }
    }

    public static final class McastNotifyConfig
    implements Comparable<McastNotifyConfig> {
        private final MultifeedType mType;
        private final String mMessageClass;
        private final List<String> mSubjectList;
        private final Pattern mSubjectQuery;
        private final boolean mIsDynamic;

        private McastNotifyConfig(McastNotifyBuilder builder) {
            this.mType = builder.mType;
            this.mMessageClass = builder.mMessageClass;
            this.mSubjectList = builder.mSubjectList;
            this.mSubjectQuery = builder.mSubjectQuery;
            this.mIsDynamic = builder.mIsDynamic;
        }

        @Override
        public int compareTo(McastNotifyConfig o) {
            return this.mMessageClass.compareTo(o.mMessageClass);
        }

        public String toString() {
            StringBuilder retval = new StringBuilder();
            retval.append("[class=").append(this.mMessageClass).append(", type=").append((Object)this.mType);
            if (this.mType == MultifeedType.LIST) {
                String sep = "";
                retval.append(", list={");
                for (String subject : this.mSubjectList) {
                    retval.append(sep).append(subject);
                    sep = ", ";
                }
                retval.append("}");
            } else {
                retval.append(", query=").append(this.mSubjectQuery.pattern());
            }
            return retval.append("]").toString();
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode && o instanceof McastNotifyConfig) {
                McastNotifyConfig config = (McastNotifyConfig)o;
                retcode = this.mMessageClass.equals(config.mMessageClass);
            }
            return retcode;
        }

        public int hashCode() {
            return this.mMessageClass.hashCode();
        }

        public MultifeedType feedType() {
            return this.mType;
        }

        public String messageClass() {
            return this.mMessageClass;
        }

        public List<String> subjectList() {
            return this.mSubjectList;
        }

        public Pattern subjectQuery() {
            return this.mSubjectQuery;
        }

        public boolean isDynamic() {
            return this.mIsDynamic;
        }
    }

    public static final class MulticastConnection {
        private final String mName;
        private final MulticastRole mRole;
        private final InetAddress mGroup;
        private final int mTargetPort;
        private final NetworkInterface mNetworkIF;
        private final List<InetAddress> mSources;
        private final InetAddress mBindAddress;
        private final int mBindPort;
        private final ProtocolFamily mFamily;
        private final ByteOrder mByteOrder;
        private final String mSelector;
        private final int mInputBufferSize;
        private final int mOutputBufferSize;
        private final List<McastNotifyConfig> mNotifications;

        private MulticastConnection(MulticastBuilder builder) {
            this.mName = builder.mName;
            this.mRole = builder.mRole;
            this.mGroup = builder.mGroup;
            this.mTargetPort = builder.mTargetPort;
            this.mNetworkIF = builder.mNetworkIF;
            this.mSources = builder.mSources;
            this.mBindAddress = builder.mBindAddress;
            this.mBindPort = builder.mBindPort;
            this.mFamily = builder.mFamily;
            this.mByteOrder = builder.mByteOrder;
            this.mSelector = builder.mSelector;
            this.mInputBufferSize = builder.mInputBufferSize;
            this.mOutputBufferSize = builder.mOutputBufferSize;
            this.mNotifications = builder.mNotifications;
        }

        public String toString() {
            String sep = "";
            StringBuilder retval = new StringBuilder();
            retval.append("[name=").append(this.mName).append(", role=").append((Object)this.mRole).append(", group=").append(this.mGroup).append(':').append(this.mTargetPort).append(", net I/F=").append(this.mNetworkIF).append(", bind address=").append(this.mBindAddress).append(", bind port=").append(this.mBindPort).append(", byte order=").append(this.mByteOrder).append(", selector=").append(this.mSelector).append(", in buffer size=").append(this.mInputBufferSize).append(", out buffer size=").append(this.mOutputBufferSize).append(", notifications={");
            for (McastNotifyConfig config : this.mNotifications) {
                retval.append(sep).append(config);
                sep = ", ";
            }
            return retval.append("}]").toString();
        }

        public String name() {
            return this.mName;
        }

        public MulticastRole role() {
            return this.mRole;
        }

        public InetAddress group() {
            return this.mGroup;
        }

        public int targetPort() {
            return this.mTargetPort;
        }

        public InetSocketAddress groupAddress() {
            return new InetSocketAddress(this.mGroup, this.mTargetPort);
        }

        public NetworkInterface networkInterface() {
            return this.mNetworkIF;
        }

        public List<InetAddress> sources() {
            return this.mSources;
        }

        public InetAddress bindAddress() {
            return this.mBindAddress;
        }

        public int bindPort() {
            return this.mBindPort;
        }

        public ProtocolFamily protocolFamily() {
            return this.mFamily;
        }

        public ByteOrder byteOrder() {
            return this.mByteOrder;
        }

        public String selector() {
            return this.mSelector;
        }

        public int inputBufferSize() {
            return this.mInputBufferSize;
        }

        public int outputBufferSize() {
            return this.mOutputBufferSize;
        }

        public List<McastNotifyConfig> notifications() {
            return this.mNotifications;
        }
    }

    public static final class PauseConfig {
        private final Duration mDuration;
        private final int mMaxBacklogSize;
        private final DiscardPolicy mDiscardPolicy;
        private final Duration mIdleTime;
        private final Duration mMaxConnectTime;
        private final int mResumeOnQueueLimit;

        private PauseConfig(PauseBuilder builder) {
            this.mDuration = builder.mDuration;
            this.mMaxBacklogSize = builder.mMaxBacklogSize;
            this.mDiscardPolicy = builder.mDiscardPolicy;
            this.mIdleTime = builder.mIdleTime;
            this.mMaxConnectTime = builder.mMaxConnectTime;
            this.mResumeOnQueueLimit = builder.mResumeOnBacklogSize;
        }

        public String toString() {
            StringBuilder retval = new StringBuilder();
            retval.append("[duration=").append(this.mDuration).append(", backlog size=").append(this.mMaxBacklogSize);
            if (this.mDiscardPolicy != null) {
                retval.append(", discard policy=").append((Object)this.mDiscardPolicy);
            }
            retval.append(", idle time=").append(this.mIdleTime).append(", max connect time=").append(this.mMaxConnectTime).append(", resume-on-send=").append(this.mResumeOnQueueLimit).append("]");
            return retval.toString();
        }

        public Duration duration() {
            return this.mDuration;
        }

        public int maxBacklogSize() {
            return this.mMaxBacklogSize;
        }

        public DiscardPolicy discardPolicy() {
            return this.mDiscardPolicy;
        }

        public Duration idleTime() {
            return this.mIdleTime;
        }

        public Duration maxConnectTime() {
            return this.mMaxConnectTime;
        }

        public int resumeOnQueueLimit() {
            return this.mResumeOnQueueLimit;
        }
    }

    public static final class Dispatcher
    implements Comparable<Dispatcher> {
        private final String mName;
        private final DispatcherType mType;
        private final ThreadType mRunQueueType;
        private final long mSpinLimit;
        private final Duration mParkTime;
        private final int mPriority;
        private final Duration mQuantum;
        private final int mNumThreads;
        private final boolean mIsDefault;
        private final Class<?>[] mClasses;
        private final ThreadAffinityConfigure[] mAffinity;

        Dispatcher(DispatcherBuilder builder) {
            this.mName = builder.mName;
            this.mType = builder.mType;
            this.mRunQueueType = builder.mRunQueueType;
            this.mSpinLimit = builder.mSpinLimit;
            this.mParkTime = builder.mParkTime;
            this.mPriority = builder.mPriority;
            this.mQuantum = builder.mQuantum;
            this.mNumThreads = builder.mNumThreads;
            this.mIsDefault = builder.mIsDefault;
            this.mClasses = builder.mClasses;
            this.mAffinity = builder.mAffinity;
        }

        @Override
        public int compareTo(Dispatcher o) {
            return this.mName.compareTo(o.mName);
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode && o instanceof Dispatcher) {
                retcode = this.mName.equals(((Dispatcher)o).mName);
            }
            return retcode;
        }

        public int hashCode() {
            return this.mName.hashCode();
        }

        public String toString() {
            StringBuilder retval = new StringBuilder();
            retval.append('[').append(this.mName).append("]\n       priority: ").append(this.mPriority).append("\n     is default: ").append(this.mIsDefault);
            return retval.toString();
        }

        public String name() {
            return this.mName;
        }

        public DispatcherType dispatchType() {
            return this.mType;
        }

        public ThreadType runQueueType() {
            return this.mRunQueueType;
        }

        public long spinLimit() {
            return this.mSpinLimit;
        }

        public Duration parkTime() {
            return this.mParkTime;
        }

        public boolean isDefault() {
            return this.mIsDefault;
        }

        public Class<?>[] classes() {
            return Arrays.copyOf(this.mClasses, this.mClasses.length);
        }

        public int priority() {
            return this.mPriority;
        }

        public Duration quantum() {
            return this.mQuantum;
        }

        public int numberThreads() {
            return this.mNumThreads;
        }

        public ThreadAffinityConfigure[] affinity() {
            return this.mAffinity;
        }
    }

    public static final class RemoteConnection
    extends AbstractConfig
    implements Comparable<RemoteConnection> {
        private final InetSocketAddress mAddress;
        private final int mBindPort;
        private final String mSelector;
        private final boolean mReconnectFlag;
        private final Duration mReconnectTime;

        RemoteConnection(ConnectionBuilder builder) {
            super(builder);
            this.mAddress = builder.mAddress;
            this.mBindPort = builder.mBindPort;
            this.mSelector = builder.mSelector;
            this.mReconnectFlag = builder.mReconnectFlag;
            this.mReconnectTime = builder.mReconnectTime;
        }

        @Override
        public int compareTo(RemoteConnection conn) {
            InetSocketAddressComparator comparator = new InetSocketAddressComparator();
            return comparator.compare(this.mAddress, conn.mAddress);
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode && o instanceof RemoteConnection) {
                retcode = this.mAddress.equals(((RemoteConnection)o).mAddress);
            }
            return retcode;
        }

        public int hashCode() {
            return this.mAddress.hashCode();
        }

        public String toString() {
            StringBuilder retval = new StringBuilder();
            retval.append('[').append(this.mName).append("] address: ").append(this.mAddress).append("\n     connection type: ").append((Object)this.mConnectionType).append("\n           bind port: ").append(this.mBindPort).append("\n   input buffer size: ").append(this.mInputBufferSize).append("\n  output buffer size: ").append(this.mOutputBufferSize).append("\n   buffer byte order: ").append(this.mByteOrder).append("\n          queue size: ").append(this.mMsgQueueSize).append("\n            selector: ").append(this.mSelector).append("\n           reconnect: ").append(this.mReconnectFlag);
            if (this.mReconnectFlag) {
                retval.append("\n      reconnect time: ").append(this.mReconnectTime);
            }
            if (this.mConnectionType == ConnectionType.SECURE_TCP) {
                retval.append("\n       SSL context: ").append(this.mSSLContext);
            }
            return retval.toString();
        }

        public InetSocketAddress address() {
            return this.mAddress;
        }

        public int bindPort() {
            return this.mBindPort;
        }

        public String selector() {
            return this.mSelector;
        }

        public boolean reconnectFlag() {
            return this.mReconnectFlag;
        }

        public Duration reconnectTime() {
            return this.mReconnectTime;
        }
    }

    public static final class Service
    extends AbstractConfig
    implements Comparable<Service> {
        private final int mPort;
        private final AddressFilter mAddressFilter;
        private final String mServiceSelector;
        private final String mConnSelector;

        Service(ServerBuilder builder) {
            super(builder);
            this.mPort = builder.mPort;
            this.mAddressFilter = builder.mAddressFilter;
            this.mServiceSelector = builder.mServiceSelector;
            this.mConnSelector = builder.mConnSelector;
        }

        @Override
        public int compareTo(Service service) {
            return this.mPort - service.mPort;
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode && o instanceof Service) {
                Service svc = (Service)o;
                retcode = this.mConnectionType == svc.mConnectionType && this.mPort == svc.mPort;
            }
            return retcode;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mConnectionType, this.mPort});
        }

        public String toString() {
            StringBuilder retval = new StringBuilder();
            retval.append('[').append((Object)this.mConnectionType).append(' ').append(this.mPort).append("]\n").append("   address filter: ").append(this.mAddressFilter).append("\n socket input size: ").append(this.mInputBufferSize).append("\nsocket output size: ").append(this.mOutputBufferSize).append("\n socket byte order: ").append(this.mByteOrder).append("\n    max queue size: ").append(this.mMsgQueueSize).append("\n          selector: ").append(this.mConnSelector);
            if (this.mConnectionType == ConnectionType.SECURE_TCP) {
                retval.append("\n       SSL context: ").append(this.mSSLContext);
            }
            retval.append("\n         can pause: ").append(this.mCanPause);
            if (this.mCanPause) {
                retval.append("\n      pause config: ").append(this.mPauseConfig);
            }
            return retval.toString();
        }

        public int port() {
            return this.mPort;
        }

        public AddressFilter addressFilter() {
            return this.mAddressFilter;
        }

        public String serviceSelector() {
            return this.mServiceSelector;
        }

        public String connectionSelector() {
            return this.mConnSelector;
        }
    }

    public static abstract class AbstractConfig {
        protected final String mName;
        protected final ConnectionType mConnectionType;
        protected final int mInputBufferSize;
        protected final int mOutputBufferSize;
        protected final ByteOrder mByteOrder;
        protected final int mMsgQueueSize;
        protected final Duration mHbDelay;
        protected final Duration mHbReplyDelay;
        protected final SSLContext mSSLContext;
        protected final boolean mCanPause;
        protected final PauseConfig mPauseConfig;

        protected AbstractConfig(AbstractBuilder<?> builder) {
            this.mName = builder.mName;
            this.mConnectionType = builder.mConnectionType;
            this.mInputBufferSize = builder.mInputBufferSize;
            this.mOutputBufferSize = builder.mOutputBufferSize;
            this.mByteOrder = builder.mByteOrder;
            this.mMsgQueueSize = builder.mMsgQueueSize;
            this.mHbDelay = builder.mHbDelay;
            this.mHbReplyDelay = builder.mHbReplyDelay;
            this.mSSLContext = builder.mSSLContext;
            this.mCanPause = builder.mCanPause;
            this.mPauseConfig = builder.mPauseConfig;
        }

        public final String name() {
            return this.mName;
        }

        public final ConnectionType connectionType() {
            return this.mConnectionType;
        }

        public final int inputBufferSize() {
            return this.mInputBufferSize;
        }

        public final int outputBufferSize() {
            return this.mOutputBufferSize;
        }

        public final ByteOrder byteOrder() {
            return this.mByteOrder;
        }

        public final int messageQueueSize() {
            return this.mMsgQueueSize;
        }

        public final Duration heartbeatDelay() {
            return this.mHbDelay;
        }

        public final Duration heartbeatReplyDelay() {
            return this.mHbReplyDelay;
        }

        public final SSLContext sslContext() {
            return this.mSSLContext;
        }

        public final boolean canPause() {
            return this.mCanPause;
        }

        public final PauseConfig pauseConfiguration() {
            return this.mPauseConfig;
        }
    }

    public static enum MultifeedType {
        LIST,
        QUERY;

    }

    public static enum MulticastRole {
        PUBLISHER,
        SUBSCRIBER;

    }

    public static enum ConnectionRole {
        INITIATOR,
        ACCEPTOR;

    }

    public static enum DiscardPolicy {
        OLDEST_FIRST,
        YOUNGEST_FIRST;

    }

    public static enum DispatcherType {
        EBUS(false, null),
        JAVAFX(true, task -> {
            if (Platform.isFxApplicationThread()) {
                try {
                    task.run();
                }
                catch (Exception jex) {
                    sLogger.warning(jex.getLocalizedMessage());
                }
            } else {
                Platform.runLater((Runnable)task);
            }
        }),
        SWING(true, task -> {
            if (SwingUtilities.isEventDispatchThread()) {
                try {
                    task.run();
                }
                catch (Exception jex) {
                    sLogger.warning(jex.getLocalizedMessage());
                }
            } else {
                SwingUtilities.invokeLater(task);
            }
        });

        private final boolean mSpecial;
        private final Consumer<Runnable> mDispatchHandle;

        private DispatcherType(boolean special, Consumer<Runnable> handle) {
            this.mSpecial = special;
            this.mDispatchHandle = handle;
        }

        public boolean isSpecial() {
            return this.mSpecial;
        }

        public Consumer<Runnable> dispatchHandle() {
            return this.mDispatchHandle;
        }

        public static DispatcherType findType(String name) {
            DispatcherType[] types = DispatcherType.values();
            int numTypes = types.length;
            DispatcherType retval = null;
            for (int index = 0; index < numTypes && retval == null; ++index) {
                if (!name.equalsIgnoreCase(types[index].name())) continue;
                retval = types[index];
            }
            if (retval == null) {
                retval = EBUS;
            }
            return retval;
        }
    }

    public static enum ConnectionType {
        TCP(true, false, null),
        SECURE_TCP(true, true, "TLS"),
        UDP(false, false, null),
        SECURE_UDP(false, true, "DTLS");

        private final boolean mIsTcp;
        private final boolean mIsSecure;
        private final String mSSLProtocol;

        private ConnectionType(boolean tcpFlag, boolean secureFlag, String sslProtocol) {
            this.mIsTcp = tcpFlag;
            this.mIsSecure = secureFlag;
            this.mSSLProtocol = sslProtocol;
        }

        public boolean isTcp() {
            return this.mIsTcp;
        }

        public boolean isSecure() {
            return this.mIsSecure;
        }

        public String sslProtocol() {
            return this.mSSLProtocol;
        }
    }
}

