/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sf.eBus.config.InetSocketAddressComparator;

public final class AddressFilter
implements Serializable {
    private static final String IFS0 = ",";
    private static final String IFS1 = ":";
    private static final int HOST_INDEX = 0;
    private static final int PORT_INDEX = 1;
    private static final long serialVersionUID = 328192L;
    private final Set<InetSocketAddress> mFilter = new TreeSet<InetSocketAddress>(new InetSocketAddressComparator());

    public AddressFilter() {
    }

    public AddressFilter(Collection<InetSocketAddress> c) {
        this.mFilter.addAll(c);
    }

    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof AddressFilter) {
            retcode = this.mFilter.equals(((AddressFilter)o).mFilter);
        }
        return retcode;
    }

    public int hashCode() {
        return this.mFilter.hashCode();
    }

    public String toString() {
        String retval;
        String sep = "";
        try (Formatter output = new Formatter();){
            for (InetSocketAddress address : this.mFilter) {
                int port = address.getPort();
                output.format("%s%s", sep, address.getHostName());
                if (port != 0) {
                    output.format("%s%d", IFS1, port);
                }
                sep = IFS0;
            }
            retval = output.toString();
        }
        return retval;
    }

    public boolean isEmpty() {
        return this.mFilter.isEmpty();
    }

    public int size() {
        return this.mFilter.size();
    }

    public boolean contains(InetSocketAddress address) {
        return this.mFilter.contains(address);
    }

    public List<String> getAllowedRemoteAddresses() {
        ArrayList<String> retval = new ArrayList<String>(this.mFilter.size());
        for (InetSocketAddress address : this.mFilter) {
            String host = address.getHostString();
            int port = address.getPort();
            retval.add((String)(port == 0 ? host : host + IFS1 + port));
        }
        return retval;
    }

    public void setAllowedRemoteAddresses(List<String> addresses) throws ParseException {
        this.mFilter.clear();
        for (String address : addresses) {
            this.mFilter.add(AddressFilter.parseAddress(address));
        }
    }

    public boolean add(InetSocketAddress address) {
        return this.mFilter.add(address);
    }

    public boolean addAll(Collection<InetSocketAddress> c) {
        return this.mFilter.addAll(c);
    }

    public boolean remove(InetSocketAddress address) {
        return this.mFilter.remove(address);
    }

    public boolean removeAll(Collection<InetSocketAddress> c) {
        return this.mFilter.removeAll(c);
    }

    public void clear() {
        this.mFilter.clear();
    }

    public boolean passes(InetSocketAddress iAddress) {
        InetSocketAddress anyAddress = new InetSocketAddress(iAddress.getAddress(), 0);
        return this.mFilter.isEmpty() || this.mFilter.contains(iAddress) || this.mFilter.contains(anyAddress);
    }

    public static AddressFilter parse(String s) throws ParseException {
        AddressFilter retval = new AddressFilter();
        if (s != null && !s.isEmpty()) {
            for (String filter : s.split(IFS0)) {
                retval.add(AddressFilter.parseAddress(filter));
            }
        }
        return retval;
    }

    public static InetSocketAddress parseAddress(String s) throws ParseException {
        InetAddress host;
        String[] tokens = s.split(IFS1);
        int port = 0;
        if (tokens.length > 2) {
            throw new ParseException("invalid address filter", 0);
        }
        try {
            host = InetAddress.getByName(tokens[0]);
        }
        catch (UnknownHostException hostex) {
            ParseException parsex = new ParseException(String.format("unknown host %s", tokens[0]), 0);
            parsex.initCause(hostex);
            throw parsex;
        }
        if (tokens.length == 2) {
            try {
                port = Integer.parseInt(tokens[1]);
                if (port < 0 || port > 65535) {
                    throw new ParseException(String.format("invalid port %s", tokens[1]), 0);
                }
            }
            catch (NumberFormatException formex) {
                ParseException parsex = new ParseException(String.format("invalid port %s", tokens[1]), 0);
                parsex.initCause(formex);
                throw parsex;
            }
        }
        return new InetSocketAddress(host, port);
    }

    public static AddressFilter load(Config config, String key) {
        AddressFilter retval = null;
        if (config.hasPath(key)) {
            AddressFilter filterList = new AddressFilter();
            config.getStringList(key).forEach(filter -> {
                try {
                    filterList.add(AddressFilter.parseAddress(filter));
                }
                catch (ParseException parsex) {
                    throw new ConfigException.BadValue(key, "invalid address filter", (Throwable)parsex);
                }
            });
            retval = filterList;
        }
        return retval;
    }
}

