/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.config;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.openhft.affinity.AffinityLock;
import net.openhft.affinity.AffinityStrategies;
import net.openhft.affinity.AffinityStrategy;
import net.sf.eBus.config.ThreadAffinityConfigure;

public final class ThreadAffinity {
    private static final Lock sAcquisitionLock = new ReentrantLock();

    private ThreadAffinity() {
    }

    public static AffinityLock acquireLock(ThreadAffinityConfigure config) {
        AffinityLock retval;
        ThreadAffinityConfigure.AffinityType type = config.affinityType();
        if (type == ThreadAffinityConfigure.AffinityType.CPU_STRATEGIES) {
            throw new IllegalStateException("affinity lock acquisition using strategies requires an existing lock");
        }
        sAcquisitionLock.lock();
        try {
            switch (type) {
                case ANY_CORE: {
                    retval = AffinityLock.acquireCore();
                    break;
                }
                case ANY_CPU: {
                    retval = AffinityLock.acquireLock();
                    break;
                }
                case CPU_ID: {
                    retval = AffinityLock.acquireLock((int)config.cpuId());
                    break;
                }
                default: {
                    retval = AffinityLock.acquireLockLastMinus((int)config.cpuOffset());
                }
            }
            if (config.bindFlag()) {
                retval.bind(config.wholeCoreFlag());
            }
        }
        finally {
            sAcquisitionLock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AffinityLock acquireLock(AffinityLock lock, ThreadAffinityConfigure config) {
        AffinityLock retval;
        ThreadAffinityConfigure.AffinityType type = config.affinityType();
        Objects.requireNonNull(lock, "lock is null");
        if (type != ThreadAffinityConfigure.AffinityType.CPU_STRATEGIES) {
            throw new IllegalArgumentException(String.format("invalid affinity type %s, must be %s", new Object[]{type, ThreadAffinityConfigure.AffinityType.CPU_STRATEGIES}));
        }
        sAcquisitionLock.lock();
        try {
            List<AffinityStrategies> strategies = config.strategies();
            retval = lock.acquireLock((AffinityStrategy[])strategies.toArray(new AffinityStrategies[strategies.size()]));
            if (config.bindFlag()) {
                retval.bind(config.wholeCoreFlag());
            }
        }
        finally {
            sAcquisitionLock.unlock();
        }
        return retval;
    }
}

