/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.config;

import com.google.common.base.Strings;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import java.io.File;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sf.eBus.config.ThreadAffinityConfigure;
import net.sf.eBus.config.ThreadType;

public final class ENetConfigure {
    public static final int MIN_PORT = 0;
    public static final int MAX_PORT = 65535;
    public static final int ANY_PORT = 0;
    public static final String SELECTORS_KEY = "selectors";
    public static final String SELECTOR_PREFIX = "eBus.net.selector";
    public static final String NAME_KEY = "name";
    public static final String TYPE_KEY = "type";
    public static final String DEFAULT_KEY = "isDefault";
    public static final String PRIORITY_KEY = "priority";
    public static final String SPIN_LIMIT_KEY = "spinLimit";
    public static final String PARK_TIME_KEY = "parkTime";
    public static final String AFFINITY_KEY = "threadAffinity";
    public static final int DEFAULT_PRIORITY = 5;
    public static final int DEFAULT_SPIN_LIMIT = 2500000;
    public static final Duration DEFAULT_PARK_TIME = Duration.ofNanos(1000L);
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    public static final ThreadType DEFAULT_SELECTOR_TYPE = ThreadType.BLOCKING;
    private static final String DEFAULT_SELECTOR = "eBus:selectorThread:__DEFAULT__";
    private static SelectorInfo sDefaultSelector;
    private static Map<String, SelectorInfo> sSelectors;

    private ENetConfigure() {
    }

    public static SelectorInfo defaultSelector() {
        return sDefaultSelector;
    }

    public static boolean isKnownSelector(String name) {
        return sSelectors.containsKey(name);
    }

    public static SelectorInfo selector(String name) {
        return sSelectors.get(name);
    }

    public static Map<String, SelectorInfo> selectors() {
        return sSelectors;
    }

    public static String asText() {
        String sep = "";
        StringBuilder retval = new StringBuilder();
        for (SelectorInfo info : sSelectors.values()) {
            retval.append(sep).append(info);
            sep = "\n";
        }
        return retval.toString();
    }

    public static void load(Config config) {
        HashMap<String, SelectorInfo> selectors = new HashMap<String, SelectorInfo>();
        if (config.hasPath(SELECTORS_KEY)) {
            for (ConfigObject co : config.getObjectList(SELECTORS_KEY)) {
                SelectorInfo selector = ENetConfigure.loadInfo(co.toConfig());
                selectors.put(selector.name(), selector);
            }
        }
        sSelectors = Collections.unmodifiableMap(selectors);
    }

    public static SelectorInfoBuilder selectorBuilder() {
        return new SelectorInfoBuilder();
    }

    static void load(Map<String, SelectorInfo> selectors) {
        if (selectors == null || selectors.isEmpty()) {
            throw new IllegalArgumentException("selectors is null or empty");
        }
        sSelectors = Collections.unmodifiableMap(selectors);
        selectors.values().stream().filter(selector -> selector.isDefault()).forEachOrdered(selector -> {
            sDefaultSelector = selector;
        });
    }

    private static void loadJsonFile(String jsonFileName) {
        File jsonFile = new File(jsonFileName);
        Config netConfig = ConfigFactory.parseFile((File)jsonFile);
        ENetConfigure.load(netConfig);
    }

    private static SelectorInfo loadInfo(Config config) {
        String value = config.getString(TYPE_KEY);
        ThreadType type = ThreadType.find(value);
        SelectorInfoBuilder builder = new SelectorInfoBuilder();
        if (type == null) {
            throw new ConfigException.BadValue(TYPE_KEY, "\"" + value + "\" is not a valid selector type");
        }
        builder.name(config.getString(NAME_KEY)).type(type).isDefault(config.getBoolean(DEFAULT_KEY)).priority(config.hasPath(PRIORITY_KEY) ? config.getInt(PRIORITY_KEY) : 5).threadAffinity(ThreadAffinityConfigure.loadAffinity(AFFINITY_KEY, config));
        if (builder.mType == ThreadType.SPINPARK || builder.mType == ThreadType.SPINYIELD) {
            builder.spinLimit(config.hasPath(SPIN_LIMIT_KEY) ? config.getLong(SPIN_LIMIT_KEY) : 2500000L);
        }
        if (builder.mType == ThreadType.SPINPARK) {
            builder.parkTime(config.hasPath(PARK_TIME_KEY) ? config.getDuration(PARK_TIME_KEY) : DEFAULT_PARK_TIME);
        }
        return builder.build();
    }

    static {
        String jsonFile = System.getProperty("net.sf.eBus.config.jsonFile");
        sDefaultSelector = null;
        if (!Strings.isNullOrEmpty((String)jsonFile)) {
            ENetConfigure.loadJsonFile(jsonFile);
        }
        if (sDefaultSelector == null) {
            SelectorInfoBuilder builder = new SelectorInfoBuilder();
            sDefaultSelector = builder.name(DEFAULT_SELECTOR).type(DEFAULT_SELECTOR_TYPE).isDefault(true).priority(5).build();
        }
        if (sSelectors == null) {
            HashMap<String, SelectorInfo> selectors = new HashMap<String, SelectorInfo>(1);
            selectors.put(sDefaultSelector.name(), sDefaultSelector);
            sSelectors = Collections.unmodifiableMap(selectors);
        }
    }

    public static final class SelectorInfo
    implements Comparable<SelectorInfo> {
        private final String mName;
        private final ThreadType mType;
        private final boolean mIsDefault;
        private final int mPriority;
        private final long mSpinLimit;
        private final Duration mParkTime;
        private final ThreadAffinityConfigure mAffinity;

        private SelectorInfo(SelectorInfoBuilder builder) {
            this.mName = builder.mName;
            this.mType = builder.mType;
            this.mIsDefault = builder.mIsDefault;
            this.mPriority = builder.mPriority;
            this.mSpinLimit = builder.mSpinLimit;
            this.mParkTime = builder.mParkTime;
            this.mAffinity = builder.mAffinity;
        }

        @Override
        public int compareTo(SelectorInfo selector) {
            return this.mName.compareTo(selector.mName);
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode && o instanceof SelectorInfo) {
                SelectorInfo si = (SelectorInfo)o;
                retcode = this.mName.equals(si.name()) && this.mType == si.type() && this.mIsDefault == si.isDefault() && this.mPriority == si.priority() && this.mSpinLimit == si.spinLimit() && Objects.equals(this.mParkTime, si.mParkTime) && Objects.equals(this.mAffinity, si.mAffinity);
            }
            return retcode;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mName, this.mType, this.mIsDefault, this.mPriority, this.mSpinLimit, this.mParkTime, this.mAffinity});
        }

        public String toString() {
            StringBuilder retval = new StringBuilder();
            retval.append('[').append(this.mName).append("]\nselector type: ").append((Object)this.mType).append("\n     priority: ").append(this.mPriority).append("\n   is default: ").append(this.mIsDefault);
            if (this.mType == ThreadType.SPINPARK) {
                retval.append("\n   spin limit: ").append(String.format("%,d", this.mSpinLimit)).append("\n    park time: ").append(this.mParkTime);
            }
            if (this.mAffinity != null) {
                retval.append("\n     affinity: ").append(this.mAffinity);
            }
            return retval.toString();
        }

        public String name() {
            return this.mName;
        }

        public ThreadType type() {
            return this.mType;
        }

        public boolean isDefault() {
            return this.mIsDefault;
        }

        public int priority() {
            return this.mPriority;
        }

        public long spinLimit() {
            return this.mSpinLimit;
        }

        public Duration parkTime() {
            return this.mParkTime;
        }

        public ThreadAffinityConfigure affinity() {
            return this.mAffinity;
        }
    }

    public static final class SelectorInfoBuilder {
        private String mName = null;
        private ThreadType mType = null;
        private boolean mIsDefault = false;
        private int mPriority = 5;
        private long mSpinLimit = 0L;
        private Duration mParkTime = Duration.ZERO;
        private ThreadAffinityConfigure mAffinity;

        private SelectorInfoBuilder() {
        }

        public SelectorInfoBuilder name(String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                throw new ConfigException.BadValue(ENetConfigure.NAME_KEY, "\"" + name + "\" is null or empty");
            }
            this.mName = name;
            return this;
        }

        public SelectorInfoBuilder type(ThreadType type) {
            if (type == null) {
                throw new ConfigException.BadValue("runQueueType", "type is null");
            }
            this.mType = type;
            return this;
        }

        public SelectorInfoBuilder isDefault(boolean flag) {
            this.mIsDefault = flag;
            return this;
        }

        public SelectorInfoBuilder priority(int priority) {
            if (priority < 1 || priority > 10) {
                throw new ConfigException.BadValue(ENetConfigure.PRIORITY_KEY, String.format("%d is not valid; must be >= %d and <= %d", priority, 1, 10));
            }
            this.mPriority = priority;
            return this;
        }

        public SelectorInfoBuilder spinLimit(long limit) {
            if (limit < 0L) {
                throw new ConfigException.BadValue(ENetConfigure.SPIN_LIMIT_KEY, limit + " < zero");
            }
            this.mSpinLimit = limit == 0L ? 2500000L : limit;
            return this;
        }

        public SelectorInfoBuilder parkTime(Duration time) {
            if (time == null) {
                throw new ConfigException.BadValue(ENetConfigure.PARK_TIME_KEY, time + " is null");
            }
            if (time.isNegative()) {
                throw new ConfigException.BadValue(ENetConfigure.PARK_TIME_KEY, time + " < zero");
            }
            this.mParkTime = time.isZero() ? DEFAULT_PARK_TIME : time;
            return this;
        }

        public SelectorInfoBuilder threadAffinity(ThreadAffinityConfigure affinity) {
            this.mAffinity = affinity;
            return this;
        }

        public SelectorInfo build() {
            this.validate();
            if ((this.mType == ThreadType.SPINPARK || this.mType == ThreadType.SPINYIELD) && this.mSpinLimit == 0L) {
                this.mSpinLimit = 2500000L;
            }
            if (this.mType == ThreadType.SPINPARK && this.mParkTime.isZero()) {
                this.mParkTime = DEFAULT_PARK_TIME;
            }
            return new SelectorInfo(this);
        }

        private void validate() {
            if (this.mName == null) {
                throw new ConfigException.BadValue(ENetConfigure.NAME_KEY, "selector name not configured");
            }
            if (this.mType == null) {
                throw new ConfigException.BadValue(ENetConfigure.TYPE_KEY, "selector type not configured");
            }
        }
    }
}

